
#import "ViewController.h"
#import <GamePotChannel/GamePotChannel.h>
#import <GamePot/GamePot.h>
#import <StoreKit/StoreKit.h>

@interface ViewController () <GamePotPurchaseDelegate>
{
    int n;
}

@end

@implementation ViewController

- (void)GamePotPurchaseSuccess:(GamePotPurchaseInfo *)_info
{
    [self showResult:[_info toString] setName:@"GamePotPurchaseSuccess"];
    
    NSLog(@"JsonData = %@", [_info toJsonString]);
}

- (void)GamePotPurchaseFail:(NSError *)_error
{
    [self showResult:[_error localizedDescription] setName:@"GamePotPurchaseFail"];
}

- (void)GamePotPurchaseCancel
{
    [self showResult:@"" setName:@"GamePotPurchaseCancel"];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [[GamePot getInstance] setPurchaseDelegate:self];
    
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

- (NSString*) getCurrentTime
{
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateFormat:@"HH:mm:ss"];
    
    NSDate *currentDate = [NSDate date];
    NSString *dateString = [formatter stringFromDate:currentDate];
    
    return dateString;
}

- (void) showResult:(id)_message setName:(NSString*)_name
{
    dispatch_async(dispatch_get_main_queue(), ^{
        [self->_textResult setText:[NSString stringWithFormat:@"\n%@\n=== %@ ===\n%@\n%@\n", [self getCurrentTime], _name, _message, [self->_textResult text]]];
    });
    
    NSLog(@"Result = %@", _message);
}

- (IBAction)clear:(id)sender
{
    [self->_textResult setText:@""];
}

- (IBAction)invokeGetMemberID:(id)sender
{
    [self showResult:[[GamePot getInstance] getMemberId] setName:@"MemberID"];
}

- (IBAction)invokeLinking:(id)sender
{
    UIAlertController* popup = [UIAlertController alertControllerWithTitle:@"Linking" message:@"연동할 계정을 선택해 주세요." preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction* googleLinking = [UIAlertAction actionWithTitle:@"Google Linking" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        [[GamePotChannel getInstance] CreateLinking:GOOGLE viewController:self success:^(GamePotUserInfo *userInfo) {
            [self showResult:[userInfo toString] setName:@"Google Linking Success"];
        } cancel:^{
            [self showResult:@"" setName:@"Google Linking Canceled"];
        } fail:^(NSError *error) {
            [self showResult:[NSString stringWithFormat:@"Code = %ld\nMessage = %@", [error code], [error localizedDescription]] setName:@"Google Linking Error"];
        }];
    }];
    
    UIAlertAction* facebookLinking = [UIAlertAction actionWithTitle:@"Facebook Linking" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [[GamePotChannel getInstance] CreateLinking:FACEBOOK viewController:self success:^(GamePotUserInfo* userInfo) {
            [self showResult:[userInfo toString] setName:@"Facebook Linking Success"];
        } cancel:^{
            [self showResult:@"" setName:@"Facebook Linking Canceled"];
        } fail:^(NSError *error) {
            [self showResult:[NSString stringWithFormat:@"Code = %ld\nMessage = %@", [error code], [error localizedDescription]] setName:@"Facebook Linking Error"];
        }];
    }];
            
    UIAlertAction* appleLinking = [UIAlertAction actionWithTitle:@"AppleID Linking" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [[GamePotChannel getInstance] CreateLinking:APPLE viewController:self success:^(GamePotUserInfo* userInfo) {
            [self showResult:[userInfo toString] setName:@"AppleID Linking Success"];
        } cancel:^{
            [self showResult:@"" setName:@"AppleID Linking Canceled"];
        } fail:^(NSError *error) {
            [self showResult:[NSString stringWithFormat:@"Code = %ld\nMessage = %@", [error code], [error localizedDescription]] setName:@"AppleID Linking Error"];
        }];
    }];
    
    UIAlertAction* googleDeleteLinking = [UIAlertAction actionWithTitle:@"Google Delete Linking" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        [[GamePotChannel getInstance] DeleteLinking:GOOGLE success:^{
            [self showResult:@"" setName:@"Google Delete Linking Success"];
        } fail:^(NSError *error) {
            [self showResult:[NSString stringWithFormat:@"Code = %ld\nMessage = %@", [error code], [error localizedDescription]] setName:@"Google Delete Linking Error"];
        }];
        
    }];
    
    UIAlertAction* facebookDeleteLinking = [UIAlertAction actionWithTitle:@"Facebook Delete Linking" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [[GamePotChannel getInstance] DeleteLinking:FACEBOOK success:^{
            [self showResult:@"" setName:@"Facebook Delete Linking Success"];
        } fail:^(NSError *error) {
            [self showResult:[NSString stringWithFormat:@"Code = %ld\nMessage = %@", [error code], [error localizedDescription]] setName:@"Facebook Delete Linking Error"];
        }];
    }];
            
    UIAlertAction* appleDeleteLinking = [UIAlertAction actionWithTitle:@"AppleID Delete Linking" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [[GamePotChannel getInstance] DeleteLinking:APPLE success:^{
            [self showResult:@"" setName:@"AppleID Delete Linking Success"];
        } fail:^(NSError *error) {
            [self showResult:[NSString stringWithFormat:@"Code = %ld\nMessage = %@", [error code], [error localizedDescription]] setName:@"AppleID Delete Linking Error"];
        }];
    }];
    
    UIAlertAction* linkingStatus = [UIAlertAction actionWithTitle:@"Linking Status" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        NSString* google = [[GamePotChannel getInstance] isLinked:GOOGLE] ? @"연동됨" : @"연동되지않음";
        NSString* facebook = [[GamePotChannel getInstance] isLinked:FACEBOOK] ? @"연동됨" : @"연동되지않음";
        NSString* apple = [[GamePotChannel getInstance] isLinked:APPLE] ? @"연동됨" : @"연동되지않음";
        
        NSString* message = [NSString stringWithFormat:@"계정 연동 상태는 다음과 같습니다.\n\nGoogle : %@\nFacebook : %@\n AppleID : %@ ", google, facebook, apple];
        UIAlertController* popup = [UIAlertController alertControllerWithTitle:@"Linking Status" message:message preferredStyle:UIAlertControllerStyleAlert];
        
        UIAlertAction* ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            
        }];
        
        [popup addAction:ok];
        
        if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
        {
            [popup setModalPresentationStyle:UIModalPresentationPopover];
            UIPopoverPresentationController *popPresenter = [popup popoverPresentationController];
            popPresenter.sourceView = self.view;
            [popPresenter setPermittedArrowDirections: 0];
            popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
            [self presentViewController:popup animated:YES completion:nil];
        }
        else
        {
            [self presentViewController:popup animated:YES completion:nil];
        }
    }];
    
    UIAlertAction* linkingStatusJson = [UIAlertAction actionWithTitle:@"Linking Status Json" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self showResult:[[GamePotChannel getInstance] getLinkedListJsonString] setName:@"Linking Status Json"];
    }];
    
    UIAlertAction* cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    
    [popup addAction:googleLinking];
    [popup addAction:facebookLinking];
    [popup addAction:appleLinking];
    
    [popup addAction:googleDeleteLinking];
    [popup addAction:facebookDeleteLinking];
    [popup addAction:appleDeleteLinking];
    
    [popup addAction:linkingStatus];
    [popup addAction:linkingStatusJson];
    
    [popup addAction:cancel];
    
    if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
    {
        [popup setModalPresentationStyle:UIModalPresentationPopover];
        UIPopoverPresentationController *popPresenter = [popup popoverPresentationController];
        popPresenter.sourceView = self.view;
        [popPresenter setPermittedArrowDirections: 0];
        popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
        [self presentViewController:popup animated:YES completion:nil];
    }
    else
    {
        [self presentViewController:popup animated:YES completion:nil];
    }
}


- (IBAction)invokeGetConfigs:(id)sender
{
    [self showResult:[[GamePot getInstance] getConfigs] setName:@"Configs"];
}

- (IBAction)invokeSignOut:(id)sender
{
    [[GamePotChannel getInstance] LogoutWithSuccess:^{
        [self dismissViewControllerAnimated:YES completion:nil];
    } fail:^(NSError *error) {
        [self showResult:[NSString stringWithFormat:@"Code = %ld\nMessage = %@", [error code], [error localizedDescription]] setName:@"SignOut Error"];
    }];
}

- (IBAction)invokeRemoveMember:(id)sender
{
    UIAlertController* popup = [UIAlertController alertControllerWithTitle:@"회원탈퇴"
                                                                   message:@"정말로 회원탈퇴를 하시겠습니까?\n 회원탈퇴시 더이상 해당 계정으로 접속이 불가능 합니다."
                                                            preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction* ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        [[GamePotChannel getInstance] DeleteMemberWithSuccess:^{
             [self dismissViewControllerAnimated:YES completion:nil];
        } fail:^(NSError *error) {
            [self showResult:[NSString stringWithFormat:@"Code = %ld\nMessage = %@", [error code], [error localizedDescription]] setName:@"Remove Member Error"];
        }];
    }];
    UIAlertAction* cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    
    [popup addAction:ok];
    [popup addAction:cancel];
    
    if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
    {
        [popup setModalPresentationStyle:UIModalPresentationPopover];
        UIPopoverPresentationController *popPresenter = [popup popoverPresentationController];
        popPresenter.sourceView = self.view;
        [popPresenter setPermittedArrowDirections: 0];
        popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
        [self presentViewController:popup animated:YES completion:nil];
    }
    else
    {
        [self presentViewController:popup animated:YES completion:nil];
    }
}


static NSString* lastChannelName = @"lodasdsasadbby";
//static NSString* lastChannelName = @"lobby";
- (IBAction)invokeChatJoin:(id)sender
{
    UIAlertController* popup = [UIAlertController alertControllerWithTitle:@"Chatting" message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
    
    UIAlertAction* join = [UIAlertAction actionWithTitle:@"Join Channel" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        UIAlertController* joinPopup = [UIAlertController alertControllerWithTitle:@"Join" message:@"접속할 채널명을 입력해주세요." preferredStyle:UIAlertControllerStyleAlert];
        
        [joinPopup addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
            [textField setPlaceholder:@"Channel"];
            [textField setText:lastChannelName];
        }];
        
        UIAlertAction* ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
            NSArray* textFields = joinPopup.textFields;
            
            NSString* channel = ((UITextField*)textFields[0]).text;
            
            if([[GamePotChat getInstance] join:channel])
            {
                lastChannelName = channel;
                [self showResult:[NSString stringWithFormat:@"Channel Name = %@", lastChannelName] setName:@"Chat Join Success"];
            }
            else
            {
                [self showResult:@"" setName:@"Chat Join Fail"];
            }
        }];
        
        UIAlertAction* cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            
        }];
        
        [joinPopup addAction:ok];
        [joinPopup addAction:cancel];
        
        if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
        {
            [joinPopup setModalPresentationStyle:UIModalPresentationPopover];
            UIPopoverPresentationController *popPresenter = [joinPopup popoverPresentationController];
            popPresenter.sourceView = self.view;
            [popPresenter setPermittedArrowDirections: 0];
            popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
            [self presentViewController:joinPopup animated:YES completion:nil];
        }
        else
        {
            [self presentViewController:joinPopup animated:YES completion:nil];
        }
    }];
    
    UIAlertAction* send = [UIAlertAction actionWithTitle:@"Send Message" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        UIAlertController* sendPopup = [UIAlertController alertControllerWithTitle:@"Send Message" message:@"전송할 메세지를 입력하세요." preferredStyle:UIAlertControllerStyleAlert];
        
        [sendPopup addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
            [textField setPlaceholder:@"Message"];
            [textField setText:[self randomStringWithLength:10]];
        }];
        
        UIAlertAction* ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
            NSArray* textFields = sendPopup.textFields;
            
            NSString* message = ((UITextField*)textFields[0]).text;
            
            GamePotChatMessage* messageInfo = [[GamePotChatMessage alloc] initWithMessage:message channel:lastChannelName];
            
            [[GamePotChat getInstance] send:messageInfo];
        }];
        
        UIAlertAction* cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            
        }];
        
        [sendPopup addAction:ok];
        [sendPopup addAction:cancel];
        
        if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
        {
            [sendPopup setModalPresentationStyle:UIModalPresentationPopover];
            UIPopoverPresentationController *popPresenter = [sendPopup popoverPresentationController];
            popPresenter.sourceView = self.view;
            [popPresenter setPermittedArrowDirections: 0];
            popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
            [self presentViewController:sendPopup animated:YES completion:nil];
        }
        else
        {
            [self presentViewController:sendPopup animated:YES completion:nil];
        }
    }];
    
    UIAlertAction* leave = [UIAlertAction actionWithTitle:@"Leave Channel" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        UIAlertController* leavePopup = [UIAlertController alertControllerWithTitle:@"Leave" message:@"접속 해제할 채널명을 입력해주세요." preferredStyle:UIAlertControllerStyleAlert];
        
        [leavePopup addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
            [textField setPlaceholder:@"Channel"];
            [textField setText:lastChannelName];
        }];
        
        UIAlertAction* ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            
            NSArray* textFields = leavePopup.textFields;
            
            NSString* channel = ((UITextField*)textFields[0]).text;
            
            if([[GamePotChat getInstance] leave:channel])
            {
                [self showResult:[NSString stringWithFormat:@"Channel Name = %@", lastChannelName] setName:@"Chat Leave Success"];
            }
            else
            {
                [self showResult:@"" setName:@"Chat Leave Fail"];
            }
        }];
        
        UIAlertAction* cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            
        }];
        
        [leavePopup addAction:ok];
        [leavePopup addAction:cancel];
        
        if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
        {
            [leavePopup setModalPresentationStyle:UIModalPresentationPopover];
            UIPopoverPresentationController *popPresenter = [leavePopup popoverPresentationController];
            popPresenter.sourceView = self.view;
            [popPresenter setPermittedArrowDirections: 0];
            popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
            [self presentViewController:leavePopup animated:YES completion:nil];
        }
        else
        {
            [self presentViewController:leavePopup animated:YES completion:nil];
        }
    }];
    
    UIAlertAction* cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    
    [popup addAction:join];
    [popup addAction:send];
    [popup addAction:leave];
    [popup addAction:cancel];
    
    if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
    {
        [popup setModalPresentationStyle:UIModalPresentationPopover];
        UIPopoverPresentationController *popPresenter = [popup popoverPresentationController];
        popPresenter.sourceView = self.view;
        [popPresenter setPermittedArrowDirections: 0];
        popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
        [self presentViewController:popup animated:YES completion:nil];
    }
    else
    {
        [self presentViewController:popup animated:YES completion:nil];
    }

    [[GamePotChat getInstance] setHandler:^(GamePotChatMessage *message) {
        [self showResult:[NSString stringWithFormat:@"Channel = %@\nMessage= %@", [message channel], [message message]] setName:@"Chat Message"];
    }];

    // 테스트로 채널을 임의로 만든다.
//    lastChannelName = [self randomStringWithLength:5];
}

- (IBAction)invokeCharge:(id)sender
{
    UIAlertController* popup = [UIAlertController alertControllerWithTitle:@"Charge" message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
    
    UIAlertAction* charge = [UIAlertAction actionWithTitle:@"Charge" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        UIAlertController* chargePopup = [UIAlertController alertControllerWithTitle:@"Charge" message:@"결제할 아이템 정보를 입력하세요." preferredStyle:UIAlertControllerStyleAlert];
        
        [chargePopup addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
            [textField setPlaceholder:@"productId"];
            [textField setText:@"gamepot001"];
        }];
        
        [chargePopup addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
            [textField setPlaceholder:@"UniqueId"];
            [textField setText:@""];
        }];
        
        UIAlertAction* ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            NSArray* textFields = chargePopup.textFields;
            
            NSString* productid = ((UITextField*)textFields[0]).text;
            NSString* uniqueid = ((UITextField*)textFields[1]).text;

//            [[GamePot getInstance] purchase:productid uniqueId:uniqueid];
            [[GamePot getInstance] purchase:productid uniqueId:uniqueid serverId:@"s002" playerId:@"p002" etc:@"e0t0c"];
        }];
        
        UIAlertAction* cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            
        }];
        
        [chargePopup addAction:ok];
        [chargePopup addAction:cancel];
        
        if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
        {
            [chargePopup setModalPresentationStyle:UIModalPresentationPopover];
            UIPopoverPresentationController *popPresenter = [chargePopup popoverPresentationController];
            popPresenter.sourceView = self.view;
            [popPresenter setPermittedArrowDirections: 0];
            popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
            [self presentViewController:chargePopup animated:YES completion:nil];
        }
        else
        {
            [self presentViewController:chargePopup animated:YES completion:nil];
        }
    }];
    
    UIAlertAction* productInfo = [UIAlertAction actionWithTitle:@"Product Info & Price" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        [self showResult:[[GamePot getInstance] getPurchaseItemsJsonString] setName:@"Product List & Price JSON"];
    }];
   
    
    UIAlertAction* cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    
    [popup addAction:charge];
    [popup addAction:productInfo];
    [popup addAction:cancel];
    
    if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
    {
        [popup setModalPresentationStyle:UIModalPresentationPopover];
        UIPopoverPresentationController *popPresenter = [popup popoverPresentationController];
        popPresenter.sourceView = self.view;
        [popPresenter setPermittedArrowDirections: 0];
        popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
        [self presentViewController:popup animated:YES completion:nil];
    }
    else
    {
        [self presentViewController:popup animated:YES completion:nil];
    }
    
}


- (IBAction)invokePushStatus:(id)sender
{
    BOOL pushEnable = [[GamePot getInstance] getPushEnable];
    BOOL pushNightEnable = [[GamePot getInstance] getNightPushEnable];
    
    UIAlertController* popup = [UIAlertController alertControllerWithTitle:@"Push Status" message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
    
    UIAlertAction* push = [UIAlertAction actionWithTitle:[NSString stringWithFormat:@"PushEnable : %@", pushEnable?@"YES":@"NO"] style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        [[GamePot getInstance] setPushEnable:!pushEnable success:^{
             [self showResult:[NSString stringWithFormat:@"Push Enable = %@, Night Enable = %@", [[GamePot getInstance] getPushEnable]?@"YES":@"NO", [[GamePot getInstance] getNightPushEnable]?@"YES":@"NO"] setName:@"Push Status"];
        } fail:^(NSError *error) {
            [self showResult:[NSString stringWithFormat:@"Error = %@", [error localizedDescription]] setName:@"Push Status"];
        }];
    }];
    
    UIAlertAction* night = [UIAlertAction actionWithTitle:[NSString stringWithFormat:@"NightEnable : %@", pushNightEnable?@"YES":@"NO"] style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        [[GamePot getInstance] setNightPushEnable:!pushNightEnable success:^{
             [self showResult:[NSString stringWithFormat:@"Push Enable = %@, Night Enable = %@", [[GamePot getInstance] getPushEnable]?@"YES":@"NO", [[GamePot getInstance] getNightPushEnable]?@"YES":@"NO"] setName:@"Push Status"];
        } fail:^(NSError *error) {
            [self showResult:[NSString stringWithFormat:@"Error = %@", [error localizedDescription]] setName:@"Push Status"];
        }];
    }];
    
    
    UIAlertAction* localPush = [UIAlertAction actionWithTitle:@"Local Push After 30sec" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        
        NSDateFormatter* formatter = [[NSDateFormatter alloc] init];
        [formatter setDateFormat:@"yyyy-MM-dd HH:mm:ss"];
        
        NSString* strDate = [formatter stringFromDate:[[NSDate date] dateByAddingTimeInterval:30]];
        
        self->n  = [[GamePot getInstance] sendLocalPush:@"" setMessage:@"LocalPushTest" setDateString:strDate];
        
        
        NSLog(@"push id = %d", self->n);
    }];
    
    UIAlertAction* cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        [[GamePot getInstance] cancelLocalPush:self->n];
    }];
    
    [popup addAction:push];
    [popup addAction:night];
    [popup addAction:localPush];
    [popup addAction:cancel];
    
    if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
    {
        [popup setModalPresentationStyle:UIModalPresentationPopover];
        UIPopoverPresentationController *popPresenter = [popup popoverPresentationController];
        popPresenter.sourceView = self.view;
        [popPresenter setPermittedArrowDirections: 0];
        popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
        [self presentViewController:popup animated:YES completion:nil];
    }
    else
    {
        [self presentViewController:popup animated:YES completion:nil];
    }

}

- (IBAction)invokeCoupon:(id)sender
{
    UIAlertController* popup = [UIAlertController alertControllerWithTitle:@"Coupon" message:@"쿠폰 번호를 입력하세요." preferredStyle:UIAlertControllerStyleAlert];
    
    [popup addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
        [textField setPlaceholder:@"Coupon Number"];
        [textField setText:@""];
    }];
    
    UIAlertAction* ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        NSArray* textFields = popup.textFields;
        
        NSString* couponNumber = ((UITextField*)textFields[0]).text;
        
        [[GamePot getInstance] coupon:couponNumber userData:nil handler:^(BOOL _success, NSError *_error) {
            if(_success)
            {
                [self showResult:@"" setName:@"Coupon Success"];
            }
            else
            {
                [self showResult:[NSString stringWithFormat:@"Code = %ld\nMessage = %@", [_error code], [_error localizedDescription]] setName:@"Coupon Error"];
            }
        }];
    }];
    
    UIAlertAction* cancel = [UIAlertAction actionWithTitle:@"Cancel" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    
    [popup addAction:ok];
    [popup addAction:cancel];
    
    if([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPad)
    {
        [popup setModalPresentationStyle:UIModalPresentationPopover];
        UIPopoverPresentationController *popPresenter = [popup popoverPresentationController];
        popPresenter.sourceView = self.view;
        [popPresenter setPermittedArrowDirections: 0];
        popPresenter.sourceRect = CGRectMake(self.view.bounds.size.width/2, self.view.bounds.size.height/2, 0, 0);
        [self presentViewController:popup animated:YES completion:nil];
    }
    else
    {
        [self presentViewController:popup animated:YES completion:nil];
    }

}

- (IBAction)invokeNoticeWebView:(id)sender
{
    [[GamePot getInstance] showNotice:self setSchemeHandler:^(NSString *scheme) {
        
    }];
}

- (IBAction)invokeWebView:(id)sender
{
    [[GamePot getInstance] showWebView:self setType:WEBVIEW_NORMALWITHBACK setURL:@"http://www.naver.com"];
}

- (IBAction)invokeHelpWebView:(id)sender
{
    [[GamePot getInstance] showHelpWebView:self];
}

- (IBAction)invokeAgreeView:(id)sender
{
    [[GamePot getInstance] showAgreeView:self option:nil handler:^(GamePotAgreeInfo *result) {
        
    }];
}

- (IBAction)invokeFAQView:(id)sender
{
    [[GamePot getInstance] showFAQWebView:self];
}
- (IBAction)invokeTermsView:(id)sender
{
    [[GamePot getInstance] showTerms:self];
}
- (IBAction)invokePrivacyView:(id)sender
{
    [[GamePot getInstance] showPrivacy:self];
}
- (IBAction)invokeRefundView:(id)sender
{
    [[GamePot getInstance] showRefund:self];
}



- (NSString *) randomStringWithLength: (int) len {
    NSString *letters = @"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    NSMutableString *randomString = [NSMutableString stringWithCapacity: len];
    
    for (int i=0; i<len; i++) {
        [randomString appendFormat: @"%C", [letters characterAtIndex: arc4random_uniform([letters length])]];
    }
    
    return randomString;
}
- (void)viewDidDisappear:(BOOL)animated
{
}
@end
