#import "LoginViewController.h"

#import <GamePotChannel/GamePotChannel.h>
#import <GamePot/GamePot.h>
#import "ViewController.h"

@interface LoginViewController () {
    UIActivityIndicatorView *activityIndicator;
}
@end

@implementation LoginViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    
    if (self) {
        
    }
    
    return self;
}

- (void) showPopup:(NSString*)_message
{
    [self showPopup:_message handler:nil];
}

- (void) showPopup:(NSString*)_message handler:(void (^)(void))_handler
{
    UIAlertController* popup = [UIAlertController alertControllerWithTitle:nil message:_message preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction* ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
        if(_handler)
        {
            _handler();
        }
    }];
    
    [popup addAction:ok];
    
    [self presentViewController:popup animated:YES completion:nil];
}

- (void) showErrorPopup:(NSError*)_error
{
    UIAlertController* popup = [UIAlertController alertControllerWithTitle:@"Error" message:[_error localizedDescription] preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction* ok = [UIAlertAction actionWithTitle:@"OK" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
        
    }];
    
    [popup addAction:ok];
    
    [self presentViewController:popup animated:YES completion:nil];
}

- (void)viewDidLoad {
    [super viewDidLoad];

    activityIndicator = [[UIActivityIndicatorView alloc]initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleGray];
    activityIndicator.center = CGPointMake(self.view.frame.size.width / 2.0, self.view.frame.size.height / 2.0);

    [self.view addSubview: activityIndicator];

    [activityIndicator setHidesWhenStopped:YES];
    
    GamePotChannelType type = [[GamePotChannel getInstance] lastLoginType];
    
    if(type != NONE && type != THIRDPARTYSDK)
    {
        [[GamePotChannel getInstance] Login:type viewController:self success:^(GamePotUserInfo *userInfo) {

            [[GamePot getInstance] getMemberId];
            // 로그인 성공
            // userInfo 정보를 확인하여 로그인 처리 진행
            NSLog(@"JsonData = %@", [userInfo toJsonString]);

            [self->activityIndicator stopAnimating];

            [self showPopup:[userInfo toString] handler:^{
                [self performSegueWithIdentifier:@"main" sender:self];
            }];

        } cancel:^{
            // 사용자 로그인 취소
//            NSLog(@"Cancel");
//            [self->activityIndicator stopAnimating];
//            [self showPopup:@"Cancel"];

        } fail:^(NSError *error) {
            // 로그인 중 Error 발생
            // [error localizedDescription] 내용을 팝업으로 노출

            NSLog(@"Error = %@", [error description]);
            [self->activityIndicator stopAnimating];
            [self showErrorPopup:error];

        } update:^(GamePotAppStatus *appStatus) {

            // Dashboard 업데이트 설정 시 노출
            //
            NSLog(@"update = %@", [appStatus toString]);

            [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
                exit(0);
            } setNextHandler:^(NSObject* resultPayload) {

                [self->activityIndicator stopAnimating];

                [self showPopup:[(GamePotUserInfo*)resultPayload toString] handler:^{
                    [self performSegueWithIdentifier:@"main" sender:self];
                }];
            }];

        } maintenance:^(GamePotAppStatus *appStatus) {

            NSLog(@"Maintenance = %@", [appStatus toString]);

            [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
                exit(0);
            }];

        }];
    }

}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)invokeAppleIDLogin:(id)sender
{
    [self->activityIndicator startAnimating];
       
       [[GamePotChannel getInstance] Login:APPLE viewController:self success:^(GamePotUserInfo* userInfo) {
           
           NSLog(@"GameCenter MemberID = %@", [userInfo memberid]);
           
           NSLog(@"JsonData = %@", [userInfo toJsonString]);
           
           dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
               
               [self->activityIndicator stopAnimating];
               
               [self showPopup:[userInfo toString] handler:^{
                   [self performSegueWithIdentifier:@"main" sender:nil];
               }];
           });

       } cancel:^{
           NSLog(@"Cancel");
           
           [self->activityIndicator stopAnimating];
           
           [self showPopup:@"Cancel"];
       } fail:^(NSError *error) {
           NSLog(@"Error = %@", [error description]);
           
           dispatch_async(dispatch_get_main_queue(), ^{
               [self->activityIndicator stopAnimating];
               [self showErrorPopup:error];
           });
           
       } update:^(GamePotAppStatus *appStatus) {
           
           [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
               exit(0);
           } setNextHandler:^(NSObject *resultPayload) {
               dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
                   
                   [self->activityIndicator stopAnimating];
                   
                   [self showPopup:[(GamePotUserInfo*)resultPayload toString] handler:^{
                       [self performSegueWithIdentifier:@"main" sender:nil];
                   }];
               });
           }];
       } maintenance:^(GamePotAppStatus *appStatus) {
           [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
               exit(0);
           }];
       }];
}

- (IBAction)invokeGoogleLogin:(id)sender
{
    
    [activityIndicator startAnimating];

    [[GamePotChannel getInstance] Login:GOOGLE viewController:self success:^(GamePotUserInfo* userInfo) {
        NSLog(@"Google MemberID = %@", [userInfo memberid]);


        NSLog(@"JsonData = %@", [userInfo toJsonString]);

        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
            [self->activityIndicator stopAnimating];
            [self showPopup:[userInfo toString] handler:^{
                [self performSegueWithIdentifier:@"main" sender:nil];
            }];
        });

    } cancel:^{
        NSLog(@"Cancel");

        [self->activityIndicator stopAnimating];

        [self showPopup:@"Cancel"];
    } fail:^(NSError *error) {
        NSLog(@"Error = %@", [error description]);

        [self->activityIndicator stopAnimating];

        [self showErrorPopup:error];
    } update:^(GamePotAppStatus *appStatus) {

        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        } setNextHandler:^(NSObject *resultPayload) {

            GamePotUserInfo* userInfo = (GamePotUserInfo*) resultPayload;

            NSLog(@"Google MemberID = %@", [userInfo memberid]);

            [[GamePot getInstance] setPushStatus:YES night:YES ad:YES success:^{

            } fail:^(NSError *error) {

            }];

            NSLog(@"JsonData = %@", [userInfo toJsonString]);

            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
                [self->activityIndicator stopAnimating];
                [self showPopup:[userInfo toString] handler:^{
                    [self performSegueWithIdentifier:@"main" sender:nil];
                }];
            });
        }];
    } maintenance:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        }];
    }];
}

- (IBAction)invokeNaverLogin:(id)sender
{
    [activityIndicator startAnimating];

    [[GamePotChannel getInstance] Login:NAVER viewController:self success:^(GamePotUserInfo* userInfo) {
        NSLog(@"Naver MemberID = %@", [userInfo memberid]);
        
        NSLog(@"JsonData = %@", [userInfo toJsonString]);

        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
            [self->activityIndicator stopAnimating];
            [self showPopup:[userInfo toString] handler:^{
                [self performSegueWithIdentifier:@"main" sender:nil];
            }];
        });
    } cancel:^{
        NSLog(@"Cancel");

        [self->activityIndicator stopAnimating];

        [self showPopup:@"Cancel"];
    } fail:^(NSError *error) {
        NSLog(@"Error = %@", [error description]);

        [self->activityIndicator stopAnimating];

        [self showErrorPopup:error];
    } update:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        } setNextHandler:^(NSObject *resultPayload) {
            
            GamePotUserInfo* userInfo = (GamePotUserInfo*) resultPayload;
            
            NSLog(@"Google MemberID = %@", [userInfo memberid]);
            
            [[GamePot getInstance] setPushStatus:YES night:YES ad:YES success:^{
                
            } fail:^(NSError *error) {
                
            }];
            
            NSLog(@"JsonData = %@", [userInfo toJsonString]);
            
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
                [self->activityIndicator stopAnimating];
                [self showPopup:[userInfo toString] handler:^{
                    [self performSegueWithIdentifier:@"main" sender:nil];
                }];
            });
        }];
    } maintenance:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        }];
    }];
}

- (IBAction)invokeFacebookLogin:(id)sender
{
    
    [activityIndicator startAnimating];

    [[GamePotChannel getInstance] Login:FACEBOOK viewController:self success:^(GamePotUserInfo* userInfo) {
        NSLog(@"Facebook MemberID = %@", [userInfo memberid]);

//        [[GamePotNaverCafe getInstance] setUserId:[userInfo memberid]];

        NSLog(@"JsonData = %@", [userInfo toJsonString]);

        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
            [self->activityIndicator stopAnimating];
            [self showPopup:[userInfo toString] handler:^{
                [self performSegueWithIdentifier:@"main" sender:nil];
            }];

        });
    } cancel:^{
        NSLog(@"Cancel");

        [self->activityIndicator stopAnimating];

        [self showPopup:@"Cancel"];
    } fail:^(NSError *error) {
        NSLog(@"Error = %@", [error description]);

        [self->activityIndicator stopAnimating];

        [self showErrorPopup:error];
    } update:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        } setNextHandler:^(NSObject *resultPayload) {

            GamePotUserInfo* userInfo = (GamePotUserInfo*) resultPayload;

            NSLog(@"Google MemberID = %@", [userInfo memberid]);

            [[GamePot getInstance] setPushStatus:YES night:YES ad:YES success:^{

            } fail:^(NSError *error) {

            }];

            NSLog(@"JsonData = %@", [userInfo toJsonString]);

            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
                [self->activityIndicator stopAnimating];
                [self showPopup:[userInfo toString] handler:^{
                    [self performSegueWithIdentifier:@"main" sender:nil];
                }];
            });
        }];
    } maintenance:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        }];
    }];
}

- (IBAction)invokeTwitterLogin:(id)sender
{
    
    [activityIndicator startAnimating];

    [[GamePotChannel getInstance] Login:TWITTER viewController:self success:^(GamePotUserInfo* userInfo) {
        NSLog(@"Twitter MemberID = %@", [userInfo memberid]);

//        [[GamePotNaverCafe getInstance] setUserId:[userInfo memberid]];

        NSLog(@"JsonData = %@", [userInfo toJsonString]);

        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
            [self->activityIndicator stopAnimating];
            [self showPopup:[userInfo toString] handler:^{
                [self performSegueWithIdentifier:@"main" sender:nil];
            }];

        });
    } cancel:^{
        NSLog(@"Cancel");

        [self->activityIndicator stopAnimating];

        [self showPopup:@"Cancel"];
    } fail:^(NSError *error) {
        NSLog(@"Error = %@", [error description]);

        [self->activityIndicator stopAnimating];

        [self showErrorPopup:error];
    } update:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        } setNextHandler:^(NSObject *resultPayload) {

            GamePotUserInfo* userInfo = (GamePotUserInfo*) resultPayload;

            NSLog(@"Twitter MemberID = %@", [userInfo memberid]);

            [[GamePot getInstance] setPushStatus:YES night:YES ad:YES success:^{

            } fail:^(NSError *error) {

            }];

            NSLog(@"JsonData = %@", [userInfo toJsonString]);

            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
                [self->activityIndicator stopAnimating];
                [self showPopup:[userInfo toString] handler:^{
                    [self performSegueWithIdentifier:@"main" sender:nil];
                }];
            });
        }];
    } maintenance:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        }];
    }];
}

- (IBAction)invokeLineLogin:(id)sender
{
    
    [activityIndicator startAnimating];

    [[GamePotChannel getInstance] Login:LINE viewController:self success:^(GamePotUserInfo* userInfo) {
        NSLog(@"Line MemberID = %@", [userInfo memberid]);

//        [[GamePotNaverCafe getInstance] setUserId:[userInfo memberid]];

        NSLog(@"JsonData = %@", [userInfo toJsonString]);

        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
            [self->activityIndicator stopAnimating];
            [self showPopup:[userInfo toString] handler:^{
                [self performSegueWithIdentifier:@"main" sender:nil];
            }];

        });
    } cancel:^{
        NSLog(@"Cancel");

        [self->activityIndicator stopAnimating];

        [self showPopup:@"Cancel"];
    } fail:^(NSError *error) {
        NSLog(@"Error = %@", [error description]);

        [self->activityIndicator stopAnimating];

        [self showErrorPopup:error];
    } update:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        } setNextHandler:^(NSObject *resultPayload) {

            GamePotUserInfo* userInfo = (GamePotUserInfo*) resultPayload;

            NSLog(@"Line MemberID = %@", [userInfo memberid]);

            [[GamePot getInstance] setPushStatus:YES night:YES ad:YES success:^{

            } fail:^(NSError *error) {

            }];

            NSLog(@"JsonData = %@", [userInfo toJsonString]);

            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
                [self->activityIndicator stopAnimating];
                [self showPopup:[userInfo toString] handler:^{
                    [self performSegueWithIdentifier:@"main" sender:nil];
                }];
            });
        }];
    } maintenance:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        }];
    }];
}

- (IBAction)invokeGuestLogin:(id)sender
{
    
    [activityIndicator startAnimating];

    [[GamePotChannel getInstance] Login:GUEST viewController:self success:^(GamePotUserInfo* userInfo) {
        NSLog(@"Guest MemberID = %@", [userInfo memberid]);

        NSLog(@"JsonData = %@", [userInfo toJsonString]);

        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
            [self->activityIndicator stopAnimating];
            [self showPopup:[userInfo toString] handler:^{
                [self performSegueWithIdentifier:@"main" sender:nil];
            }];

        });
    } cancel:^{
        NSLog(@"Cancel");

        [self->activityIndicator stopAnimating];

        [self showPopup:@"Cancel"];
    } fail:^(NSError *error) {
        NSLog(@"Error = %@", [error description]);

        dispatch_async(dispatch_get_main_queue(), ^{
            [self->activityIndicator stopAnimating];
        });


        [self showErrorPopup:error];
    } update:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        } setNextHandler:^(NSObject *resultPayload) {
            
            GamePotUserInfo* userInfo = (GamePotUserInfo*) resultPayload;
            
            NSLog(@"Google MemberID = %@", [userInfo memberid]);
            
            [[GamePot getInstance] setPushStatus:YES night:YES ad:YES success:^{
                
            } fail:^(NSError *error) {
                
            }];
            
            NSLog(@"JsonData = %@", [userInfo toJsonString]);
            
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
                [self->activityIndicator stopAnimating];
                [self showPopup:[userInfo toString] handler:^{
                    [self performSegueWithIdentifier:@"main" sender:nil];
                }];
            });
        }];
    } maintenance:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        }];
    }];
}

- (IBAction)invokeThirdpartySDKLogin:(id)sender
{
    [activityIndicator startAnimating];
    
    [[GamePotChannel getInstance] loginByThirdPartySDK:self uId:@"apqwer1234" success:^(GamePotUserInfo *userInfo) {
        NSLog(@"MemberID = %@", [userInfo memberid]);

        [[GamePot getInstance] setPushStatus:YES night:YES ad:YES success:^{

        } fail:^(NSError *error) {

        }];

        NSLog(@"JsonData = %@", [userInfo toJsonString]);

        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
            [self->activityIndicator stopAnimating];
            [self showPopup:[userInfo toString] handler:^{
                [self performSegueWithIdentifier:@"main" sender:nil];
            }];
        });
    } fail:^(NSError *error) {
        NSLog(@"Error = %@", [error description]);

        dispatch_async(dispatch_get_main_queue(), ^{
            [self->activityIndicator stopAnimating];
        });


        [self showErrorPopup:error];
    } update:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        } setNextHandler:^(NSObject *resultPayload) {
            
            GamePotUserInfo* userInfo = (GamePotUserInfo*) resultPayload;
            
            NSLog(@"Google MemberID = %@", [userInfo memberid]);
            
            [[GamePot getInstance] setPushStatus:YES night:YES ad:YES success:^{
                
            } fail:^(NSError *error) {
                
            }];
            
            NSLog(@"JsonData = %@", [userInfo toJsonString]);
            
            dispatch_after(dispatch_time(DISPATCH_TIME_NOW, 0.3 * NSEC_PER_SEC), dispatch_get_main_queue(), ^{
                [self->activityIndicator stopAnimating];
                [self showPopup:[userInfo toString] handler:^{
                    [self performSegueWithIdentifier:@"main" sender:nil];
                }];
            });
        }];
    } maintenance:^(GamePotAppStatus *appStatus) {
        [[GamePot getInstance] showAppStatusPopup:self setAppStatus:appStatus setCloseHandler:^{
            exit(0);
        }];
    }];
}
@end
