/*
 * Copyright 2018 Google
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "Firestore/core/test/unit/util/async_queue_test.h"

#include "Firestore/core/src/util/executor_std.h"

#include "absl/memory/memory.h"
#include "gtest/gtest.h"

namespace firebase {
namespace firestore {
namespace util {

namespace {

std::unique_ptr<Executor> ExecutorFactory() {
  return absl::make_unique<ExecutorStd>(/*threads=*/1);
}

}  // namespace

INSTANTIATE_TEST_SUITE_P(AsyncQueueStd,
                         AsyncQueueTest,
                         ::testing::Values(ExecutorFactory));
}  // namespace util
}  // namespace firestore
}  // namespace firebase
