/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* Automatically generated nanopb constant definitions */
/* Generated by nanopb-0.3.9.8 */

#include "firestore.nanopb.h"

#include "Firestore/core/src/nanopb/pretty_printing.h"

namespace firebase {
namespace firestore {

using nanopb::PrintEnumField;
using nanopb::PrintHeader;
using nanopb::PrintMessageField;
using nanopb::PrintPrimitiveField;
using nanopb::PrintTail;

/* @@protoc_insertion_point(includes) */
#if PB_PROTO_HEADER_VERSION != 30
#error Regenerate this file with the current version of nanopb generator.
#endif



const pb_field_t google_firestore_v1_GetDocumentRequest_fields[5] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_GetDocumentRequest, name, name, 0),
    PB_FIELD(  2, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_GetDocumentRequest, mask, name, &google_firestore_v1_DocumentMask_fields),
    PB_ANONYMOUS_ONEOF_FIELD(consistency_selector,   3, BYTES   , ONEOF, POINTER , OTHER, google_firestore_v1_GetDocumentRequest, transaction, mask, 0),
    PB_ANONYMOUS_ONEOF_FIELD(consistency_selector,   5, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_GetDocumentRequest, read_time, mask, &google_protobuf_Timestamp_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_ListDocumentsRequest_fields[10] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_ListDocumentsRequest, parent, parent, 0),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_ListDocumentsRequest, collection_id, parent, 0),
    PB_FIELD(  3, INT32   , SINGULAR, STATIC  , OTHER, google_firestore_v1_ListDocumentsRequest, page_size, collection_id, 0),
    PB_FIELD(  4, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_ListDocumentsRequest, page_token, page_size, 0),
    PB_FIELD(  6, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_ListDocumentsRequest, order_by, page_token, 0),
    PB_FIELD(  7, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_ListDocumentsRequest, mask, order_by, &google_firestore_v1_DocumentMask_fields),
    PB_ANONYMOUS_ONEOF_FIELD(consistency_selector,   8, BYTES   , ONEOF, POINTER , OTHER, google_firestore_v1_ListDocumentsRequest, transaction, mask, 0),
    PB_ANONYMOUS_ONEOF_FIELD(consistency_selector,  10, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_ListDocumentsRequest, read_time, mask, &google_protobuf_Timestamp_fields),
    PB_FIELD( 12, BOOL    , SINGULAR, STATIC  , OTHER, google_firestore_v1_ListDocumentsRequest, show_missing, read_time, 0),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_ListDocumentsResponse_fields[3] = {
    PB_FIELD(  1, MESSAGE , REPEATED, POINTER , FIRST, google_firestore_v1_ListDocumentsResponse, documents, documents, &google_firestore_v1_Document_fields),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_ListDocumentsResponse, next_page_token, documents, 0),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_CreateDocumentRequest_fields[6] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_CreateDocumentRequest, parent, parent, 0),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_CreateDocumentRequest, collection_id, parent, 0),
    PB_FIELD(  3, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_CreateDocumentRequest, document_id, collection_id, 0),
    PB_FIELD(  4, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_CreateDocumentRequest, document, document_id, &google_firestore_v1_Document_fields),
    PB_FIELD(  5, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_CreateDocumentRequest, mask, document, &google_firestore_v1_DocumentMask_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_UpdateDocumentRequest_fields[5] = {
    PB_FIELD(  1, MESSAGE , SINGULAR, STATIC  , FIRST, google_firestore_v1_UpdateDocumentRequest, document, document, &google_firestore_v1_Document_fields),
    PB_FIELD(  2, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_UpdateDocumentRequest, update_mask, document, &google_firestore_v1_DocumentMask_fields),
    PB_FIELD(  3, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_UpdateDocumentRequest, mask, update_mask, &google_firestore_v1_DocumentMask_fields),
    PB_FIELD(  4, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_UpdateDocumentRequest, current_document, mask, &google_firestore_v1_Precondition_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_DeleteDocumentRequest_fields[3] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_DeleteDocumentRequest, name, name, 0),
    PB_FIELD(  2, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_DeleteDocumentRequest, current_document, name, &google_firestore_v1_Precondition_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_BatchGetDocumentsRequest_fields[7] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_BatchGetDocumentsRequest, database, database, 0),
    PB_FIELD(  2, BYTES   , REPEATED, POINTER , OTHER, google_firestore_v1_BatchGetDocumentsRequest, documents, database, 0),
    PB_FIELD(  3, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_BatchGetDocumentsRequest, mask, documents, &google_firestore_v1_DocumentMask_fields),
    PB_ANONYMOUS_ONEOF_FIELD(consistency_selector,   4, BYTES   , ONEOF, POINTER , OTHER, google_firestore_v1_BatchGetDocumentsRequest, transaction, mask, 0),
    PB_ANONYMOUS_ONEOF_FIELD(consistency_selector,   5, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_BatchGetDocumentsRequest, new_transaction, mask, &google_firestore_v1_TransactionOptions_fields),
    PB_ANONYMOUS_ONEOF_FIELD(consistency_selector,   7, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_BatchGetDocumentsRequest, read_time, mask, &google_protobuf_Timestamp_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_BatchGetDocumentsResponse_fields[5] = {
    PB_ANONYMOUS_ONEOF_FIELD(result,   1, MESSAGE , ONEOF, STATIC  , FIRST, google_firestore_v1_BatchGetDocumentsResponse, found, found, &google_firestore_v1_Document_fields),
    PB_ANONYMOUS_ONEOF_FIELD(result,   2, BYTES   , ONEOF, POINTER , UNION, google_firestore_v1_BatchGetDocumentsResponse, missing, missing, 0),
    PB_FIELD(  3, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_BatchGetDocumentsResponse, transaction, missing, 0),
    PB_FIELD(  4, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_BatchGetDocumentsResponse, read_time, transaction, &google_protobuf_Timestamp_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_BeginTransactionRequest_fields[3] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_BeginTransactionRequest, database, database, 0),
    PB_FIELD(  2, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_BeginTransactionRequest, options, database, &google_firestore_v1_TransactionOptions_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_BeginTransactionResponse_fields[2] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_BeginTransactionResponse, transaction, transaction, 0),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_CommitRequest_fields[4] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_CommitRequest, database, database, 0),
    PB_FIELD(  2, MESSAGE , REPEATED, POINTER , OTHER, google_firestore_v1_CommitRequest, writes, database, &google_firestore_v1_Write_fields),
    PB_FIELD(  3, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_CommitRequest, transaction, writes, 0),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_CommitResponse_fields[3] = {
    PB_FIELD(  1, MESSAGE , REPEATED, POINTER , FIRST, google_firestore_v1_CommitResponse, write_results, write_results, &google_firestore_v1_WriteResult_fields),
    PB_FIELD(  2, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_CommitResponse, commit_time, write_results, &google_protobuf_Timestamp_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_RollbackRequest_fields[3] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_RollbackRequest, database, database, 0),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_RollbackRequest, transaction, database, 0),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_RunQueryRequest_fields[6] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_RunQueryRequest, parent, parent, 0),
    PB_ONEOF_FIELD(query_type,   2, MESSAGE , ONEOF, STATIC  , OTHER, google_firestore_v1_RunQueryRequest, structured_query, parent, &google_firestore_v1_StructuredQuery_fields),
    PB_ONEOF_FIELD(consistency_selector,   5, BYTES   , ONEOF, POINTER , OTHER, google_firestore_v1_RunQueryRequest, transaction, query_type.structured_query, 0),
    PB_ONEOF_FIELD(consistency_selector,   6, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_RunQueryRequest, new_transaction, query_type.structured_query, &google_firestore_v1_TransactionOptions_fields),
    PB_ONEOF_FIELD(consistency_selector,   7, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_RunQueryRequest, read_time, query_type.structured_query, &google_protobuf_Timestamp_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_RunQueryResponse_fields[5] = {
    PB_FIELD(  1, MESSAGE , SINGULAR, STATIC  , FIRST, google_firestore_v1_RunQueryResponse, document, document, &google_firestore_v1_Document_fields),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_RunQueryResponse, transaction, document, 0),
    PB_FIELD(  3, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_RunQueryResponse, read_time, transaction, &google_protobuf_Timestamp_fields),
    PB_FIELD(  4, INT32   , SINGULAR, STATIC  , OTHER, google_firestore_v1_RunQueryResponse, skipped_results, read_time, 0),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_RunAggregationQueryRequest_fields[6] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_RunAggregationQueryRequest, parent, parent, 0),
    PB_ONEOF_FIELD(query_type,   2, MESSAGE , ONEOF, STATIC  , OTHER, google_firestore_v1_RunAggregationQueryRequest, structured_aggregation_query, parent, &google_firestore_v1_StructuredAggregationQuery_fields),
    PB_ONEOF_FIELD(consistency_selector,   4, BYTES   , ONEOF, POINTER , OTHER, google_firestore_v1_RunAggregationQueryRequest, transaction, query_type.structured_aggregation_query, 0),
    PB_ONEOF_FIELD(consistency_selector,   5, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_RunAggregationQueryRequest, new_transaction, query_type.structured_aggregation_query, &google_firestore_v1_TransactionOptions_fields),
    PB_ONEOF_FIELD(consistency_selector,   6, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_RunAggregationQueryRequest, read_time, query_type.structured_aggregation_query, &google_protobuf_Timestamp_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_RunAggregationQueryResponse_fields[4] = {
    PB_FIELD(  1, MESSAGE , SINGULAR, STATIC  , FIRST, google_firestore_v1_RunAggregationQueryResponse, result, result, &google_firestore_v1_AggregationResult_fields),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_RunAggregationQueryResponse, transaction, result, 0),
    PB_FIELD(  3, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_RunAggregationQueryResponse, read_time, transaction, &google_protobuf_Timestamp_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_WriteRequest_fields[6] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_WriteRequest, database, database, 0),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_WriteRequest, stream_id, database, 0),
    PB_FIELD(  3, MESSAGE , REPEATED, POINTER , OTHER, google_firestore_v1_WriteRequest, writes, stream_id, &google_firestore_v1_Write_fields),
    PB_FIELD(  4, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_WriteRequest, stream_token, writes, 0),
    PB_FIELD(  5, MESSAGE , REPEATED, POINTER , OTHER, google_firestore_v1_WriteRequest, labels, stream_token, &google_firestore_v1_WriteRequest_LabelsEntry_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_WriteRequest_LabelsEntry_fields[3] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_WriteRequest_LabelsEntry, key, key, 0),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_WriteRequest_LabelsEntry, value, key, 0),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_WriteResponse_fields[5] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_WriteResponse, stream_id, stream_id, 0),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_WriteResponse, stream_token, stream_id, 0),
    PB_FIELD(  3, MESSAGE , REPEATED, POINTER , OTHER, google_firestore_v1_WriteResponse, write_results, stream_token, &google_firestore_v1_WriteResult_fields),
    PB_FIELD(  4, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_WriteResponse, commit_time, write_results, &google_protobuf_Timestamp_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_ListenRequest_fields[5] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_ListenRequest, database, database, 0),
    PB_ANONYMOUS_ONEOF_FIELD(target_change,   2, MESSAGE , ONEOF, STATIC  , OTHER, google_firestore_v1_ListenRequest, add_target, database, &google_firestore_v1_Target_fields),
    PB_ANONYMOUS_ONEOF_FIELD(target_change,   3, INT32   , ONEOF, STATIC  , UNION, google_firestore_v1_ListenRequest, remove_target, database, 0),
    PB_FIELD(  4, MESSAGE , REPEATED, POINTER , OTHER, google_firestore_v1_ListenRequest, labels, remove_target, &google_firestore_v1_ListenRequest_LabelsEntry_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_ListenRequest_LabelsEntry_fields[3] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_ListenRequest_LabelsEntry, key, key, 0),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_ListenRequest_LabelsEntry, value, key, 0),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_ListenResponse_fields[6] = {
    PB_ANONYMOUS_ONEOF_FIELD(response_type,   2, MESSAGE , ONEOF, STATIC  , FIRST, google_firestore_v1_ListenResponse, target_change, target_change, &google_firestore_v1_TargetChange_fields),
    PB_ANONYMOUS_ONEOF_FIELD(response_type,   3, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_ListenResponse, document_change, document_change, &google_firestore_v1_DocumentChange_fields),
    PB_ANONYMOUS_ONEOF_FIELD(response_type,   4, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_ListenResponse, document_delete, document_delete, &google_firestore_v1_DocumentDelete_fields),
    PB_ANONYMOUS_ONEOF_FIELD(response_type,   5, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_ListenResponse, filter, filter, &google_firestore_v1_ExistenceFilter_fields),
    PB_ANONYMOUS_ONEOF_FIELD(response_type,   6, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_ListenResponse, document_remove, document_remove, &google_firestore_v1_DocumentRemove_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_Target_fields[8] = {
    PB_ONEOF_FIELD(target_type,   2, MESSAGE , ONEOF, STATIC  , FIRST, google_firestore_v1_Target, query, query, &google_firestore_v1_Target_QueryTarget_fields),
    PB_ONEOF_FIELD(target_type,   3, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_Target, documents, documents, &google_firestore_v1_Target_DocumentsTarget_fields),
    PB_ONEOF_FIELD(resume_type,   4, BYTES   , ONEOF, POINTER , OTHER, google_firestore_v1_Target, resume_token, target_type.documents, 0),
    PB_ONEOF_FIELD(resume_type,  11, MESSAGE , ONEOF, STATIC  , UNION, google_firestore_v1_Target, read_time, target_type.documents, &google_protobuf_Timestamp_fields),
    PB_FIELD(  5, INT32   , SINGULAR, STATIC  , OTHER, google_firestore_v1_Target, target_id, resume_type.read_time, 0),
    PB_FIELD(  6, BOOL    , SINGULAR, STATIC  , OTHER, google_firestore_v1_Target, once, target_id, 0),
    PB_FIELD( 12, MESSAGE , OPTIONAL, STATIC  , OTHER, google_firestore_v1_Target, expected_count, once, &google_protobuf_Int32Value_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_Target_DocumentsTarget_fields[2] = {
    PB_FIELD(  2, BYTES   , REPEATED, POINTER , FIRST, google_firestore_v1_Target_DocumentsTarget, documents, documents, 0),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_Target_QueryTarget_fields[3] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_Target_QueryTarget, parent, parent, 0),
    PB_ANONYMOUS_ONEOF_FIELD(query_type,   2, MESSAGE , ONEOF, STATIC  , OTHER, google_firestore_v1_Target_QueryTarget, structured_query, parent, &google_firestore_v1_StructuredQuery_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_TargetChange_fields[6] = {
    PB_FIELD(  1, UENUM   , SINGULAR, STATIC  , FIRST, google_firestore_v1_TargetChange, target_change_type, target_change_type, 0),
    PB_FIELD(  2, INT32   , REPEATED, POINTER , OTHER, google_firestore_v1_TargetChange, target_ids, target_change_type, 0),
    PB_FIELD(  3, MESSAGE , OPTIONAL, STATIC  , OTHER, google_firestore_v1_TargetChange, cause, target_ids, &google_rpc_Status_fields),
    PB_FIELD(  4, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_TargetChange, resume_token, cause, 0),
    PB_FIELD(  6, MESSAGE , SINGULAR, STATIC  , OTHER, google_firestore_v1_TargetChange, read_time, resume_token, &google_protobuf_Timestamp_fields),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_ListCollectionIdsRequest_fields[4] = {
    PB_FIELD(  1, BYTES   , SINGULAR, POINTER , FIRST, google_firestore_v1_ListCollectionIdsRequest, parent, parent, 0),
    PB_FIELD(  2, INT32   , SINGULAR, STATIC  , OTHER, google_firestore_v1_ListCollectionIdsRequest, page_size, parent, 0),
    PB_FIELD(  3, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_ListCollectionIdsRequest, page_token, page_size, 0),
    PB_LAST_FIELD
};

const pb_field_t google_firestore_v1_ListCollectionIdsResponse_fields[3] = {
    PB_FIELD(  1, BYTES   , REPEATED, POINTER , FIRST, google_firestore_v1_ListCollectionIdsResponse, collection_ids, collection_ids, 0),
    PB_FIELD(  2, BYTES   , SINGULAR, POINTER , OTHER, google_firestore_v1_ListCollectionIdsResponse, next_page_token, collection_ids, 0),
    PB_LAST_FIELD
};



/* Check that field information fits in pb_field_t */
#if !defined(PB_FIELD_32BIT)
/* If you get an error here, it means that you need to define PB_FIELD_32BIT
 * compile-time option. You can do that in pb.h or on compiler command line.
 *
 * The reason you need to do this is that some of your messages contain tag
 * numbers or field sizes that are larger than what can fit in 8 or 16 bit
 * field descriptors.
 */
PB_STATIC_ASSERT((pb_membersize(google_firestore_v1_GetDocumentRequest, read_time) < 65536 && pb_membersize(google_firestore_v1_GetDocumentRequest, mask) < 65536 && pb_membersize(google_firestore_v1_ListDocumentsRequest, read_time) < 65536 && pb_membersize(google_firestore_v1_ListDocumentsRequest, mask) < 65536 && pb_membersize(google_firestore_v1_CreateDocumentRequest, document) < 65536 && pb_membersize(google_firestore_v1_CreateDocumentRequest, mask) < 65536 && pb_membersize(google_firestore_v1_UpdateDocumentRequest, document) < 65536 && pb_membersize(google_firestore_v1_UpdateDocumentRequest, update_mask) < 65536 && pb_membersize(google_firestore_v1_UpdateDocumentRequest, mask) < 65536 && pb_membersize(google_firestore_v1_UpdateDocumentRequest, current_document) < 65536 && pb_membersize(google_firestore_v1_DeleteDocumentRequest, current_document) < 65536 && pb_membersize(google_firestore_v1_BatchGetDocumentsRequest, new_transaction) < 65536 && pb_membersize(google_firestore_v1_BatchGetDocumentsRequest, read_time) < 65536 && pb_membersize(google_firestore_v1_BatchGetDocumentsRequest, mask) < 65536 && pb_membersize(google_firestore_v1_BatchGetDocumentsResponse, found) < 65536 && pb_membersize(google_firestore_v1_BatchGetDocumentsResponse, read_time) < 65536 && pb_membersize(google_firestore_v1_BeginTransactionRequest, options) < 65536 && pb_membersize(google_firestore_v1_CommitResponse, commit_time) < 65536 && pb_membersize(google_firestore_v1_RunQueryRequest, query_type.structured_query) < 65536 && pb_membersize(google_firestore_v1_RunQueryRequest, consistency_selector.new_transaction) < 65536 && pb_membersize(google_firestore_v1_RunQueryRequest, consistency_selector.read_time) < 65536 && pb_membersize(google_firestore_v1_RunQueryResponse, document) < 65536 && pb_membersize(google_firestore_v1_RunQueryResponse, read_time) < 65536 && pb_membersize(google_firestore_v1_RunAggregationQueryRequest, query_type.structured_aggregation_query) < 65536 && pb_membersize(google_firestore_v1_RunAggregationQueryRequest, consistency_selector.new_transaction) < 65536 && pb_membersize(google_firestore_v1_RunAggregationQueryRequest, consistency_selector.read_time) < 65536 && pb_membersize(google_firestore_v1_RunAggregationQueryResponse, result) < 65536 && pb_membersize(google_firestore_v1_RunAggregationQueryResponse, read_time) < 65536 && pb_membersize(google_firestore_v1_WriteResponse, commit_time) < 65536 && pb_membersize(google_firestore_v1_ListenRequest, add_target) < 65536 && pb_membersize(google_firestore_v1_ListenResponse, target_change) < 65536 && pb_membersize(google_firestore_v1_ListenResponse, document_change) < 65536 && pb_membersize(google_firestore_v1_ListenResponse, document_delete) < 65536 && pb_membersize(google_firestore_v1_ListenResponse, filter) < 65536 && pb_membersize(google_firestore_v1_ListenResponse, document_remove) < 65536 && pb_membersize(google_firestore_v1_Target, target_type.query) < 65536 && pb_membersize(google_firestore_v1_Target, target_type.documents) < 65536 && pb_membersize(google_firestore_v1_Target, resume_type.read_time) < 65536 && pb_membersize(google_firestore_v1_Target, expected_count) < 65536 && pb_membersize(google_firestore_v1_Target_QueryTarget, structured_query) < 65536 && pb_membersize(google_firestore_v1_TargetChange, cause) < 65536 && pb_membersize(google_firestore_v1_TargetChange, read_time) < 65536), YOU_MUST_DEFINE_PB_FIELD_32BIT_FOR_MESSAGES_google_firestore_v1_GetDocumentRequest_google_firestore_v1_ListDocumentsRequest_google_firestore_v1_ListDocumentsResponse_google_firestore_v1_CreateDocumentRequest_google_firestore_v1_UpdateDocumentRequest_google_firestore_v1_DeleteDocumentRequest_google_firestore_v1_BatchGetDocumentsRequest_google_firestore_v1_BatchGetDocumentsResponse_google_firestore_v1_BeginTransactionRequest_google_firestore_v1_BeginTransactionResponse_google_firestore_v1_CommitRequest_google_firestore_v1_CommitResponse_google_firestore_v1_RollbackRequest_google_firestore_v1_RunQueryRequest_google_firestore_v1_RunQueryResponse_google_firestore_v1_RunAggregationQueryRequest_google_firestore_v1_RunAggregationQueryResponse_google_firestore_v1_WriteRequest_google_firestore_v1_WriteRequest_LabelsEntry_google_firestore_v1_WriteResponse_google_firestore_v1_ListenRequest_google_firestore_v1_ListenRequest_LabelsEntry_google_firestore_v1_ListenResponse_google_firestore_v1_Target_google_firestore_v1_Target_DocumentsTarget_google_firestore_v1_Target_QueryTarget_google_firestore_v1_TargetChange_google_firestore_v1_ListCollectionIdsRequest_google_firestore_v1_ListCollectionIdsResponse)
#endif

#if !defined(PB_FIELD_16BIT) && !defined(PB_FIELD_32BIT)
/* If you get an error here, it means that you need to define PB_FIELD_16BIT
 * compile-time option. You can do that in pb.h or on compiler command line.
 *
 * The reason you need to do this is that some of your messages contain tag
 * numbers or field sizes that are larger than what can fit in the default
 * 8 bit descriptors.
 */
PB_STATIC_ASSERT((pb_membersize(google_firestore_v1_GetDocumentRequest, read_time) < 256 && pb_membersize(google_firestore_v1_GetDocumentRequest, mask) < 256 && pb_membersize(google_firestore_v1_ListDocumentsRequest, read_time) < 256 && pb_membersize(google_firestore_v1_ListDocumentsRequest, mask) < 256 && pb_membersize(google_firestore_v1_CreateDocumentRequest, document) < 256 && pb_membersize(google_firestore_v1_CreateDocumentRequest, mask) < 256 && pb_membersize(google_firestore_v1_UpdateDocumentRequest, document) < 256 && pb_membersize(google_firestore_v1_UpdateDocumentRequest, update_mask) < 256 && pb_membersize(google_firestore_v1_UpdateDocumentRequest, mask) < 256 && pb_membersize(google_firestore_v1_UpdateDocumentRequest, current_document) < 256 && pb_membersize(google_firestore_v1_DeleteDocumentRequest, current_document) < 256 && pb_membersize(google_firestore_v1_BatchGetDocumentsRequest, new_transaction) < 256 && pb_membersize(google_firestore_v1_BatchGetDocumentsRequest, read_time) < 256 && pb_membersize(google_firestore_v1_BatchGetDocumentsRequest, mask) < 256 && pb_membersize(google_firestore_v1_BatchGetDocumentsResponse, found) < 256 && pb_membersize(google_firestore_v1_BatchGetDocumentsResponse, read_time) < 256 && pb_membersize(google_firestore_v1_BeginTransactionRequest, options) < 256 && pb_membersize(google_firestore_v1_CommitResponse, commit_time) < 256 && pb_membersize(google_firestore_v1_RunQueryRequest, query_type.structured_query) < 256 && pb_membersize(google_firestore_v1_RunQueryRequest, consistency_selector.new_transaction) < 256 && pb_membersize(google_firestore_v1_RunQueryRequest, consistency_selector.read_time) < 256 && pb_membersize(google_firestore_v1_RunQueryResponse, document) < 256 && pb_membersize(google_firestore_v1_RunQueryResponse, read_time) < 256 && pb_membersize(google_firestore_v1_RunAggregationQueryRequest, query_type.structured_aggregation_query) < 256 && pb_membersize(google_firestore_v1_RunAggregationQueryRequest, consistency_selector.new_transaction) < 256 && pb_membersize(google_firestore_v1_RunAggregationQueryRequest, consistency_selector.read_time) < 256 && pb_membersize(google_firestore_v1_RunAggregationQueryResponse, result) < 256 && pb_membersize(google_firestore_v1_RunAggregationQueryResponse, read_time) < 256 && pb_membersize(google_firestore_v1_WriteResponse, commit_time) < 256 && pb_membersize(google_firestore_v1_ListenRequest, add_target) < 256 && pb_membersize(google_firestore_v1_ListenResponse, target_change) < 256 && pb_membersize(google_firestore_v1_ListenResponse, document_change) < 256 && pb_membersize(google_firestore_v1_ListenResponse, document_delete) < 256 && pb_membersize(google_firestore_v1_ListenResponse, filter) < 256 && pb_membersize(google_firestore_v1_ListenResponse, document_remove) < 256 && pb_membersize(google_firestore_v1_Target, target_type.query) < 256 && pb_membersize(google_firestore_v1_Target, target_type.documents) < 256 && pb_membersize(google_firestore_v1_Target, resume_type.read_time) < 256 && pb_membersize(google_firestore_v1_Target, expected_count) < 256 && pb_membersize(google_firestore_v1_Target_QueryTarget, structured_query) < 256 && pb_membersize(google_firestore_v1_TargetChange, cause) < 256 && pb_membersize(google_firestore_v1_TargetChange, read_time) < 256), YOU_MUST_DEFINE_PB_FIELD_16BIT_FOR_MESSAGES_google_firestore_v1_GetDocumentRequest_google_firestore_v1_ListDocumentsRequest_google_firestore_v1_ListDocumentsResponse_google_firestore_v1_CreateDocumentRequest_google_firestore_v1_UpdateDocumentRequest_google_firestore_v1_DeleteDocumentRequest_google_firestore_v1_BatchGetDocumentsRequest_google_firestore_v1_BatchGetDocumentsResponse_google_firestore_v1_BeginTransactionRequest_google_firestore_v1_BeginTransactionResponse_google_firestore_v1_CommitRequest_google_firestore_v1_CommitResponse_google_firestore_v1_RollbackRequest_google_firestore_v1_RunQueryRequest_google_firestore_v1_RunQueryResponse_google_firestore_v1_RunAggregationQueryRequest_google_firestore_v1_RunAggregationQueryResponse_google_firestore_v1_WriteRequest_google_firestore_v1_WriteRequest_LabelsEntry_google_firestore_v1_WriteResponse_google_firestore_v1_ListenRequest_google_firestore_v1_ListenRequest_LabelsEntry_google_firestore_v1_ListenResponse_google_firestore_v1_Target_google_firestore_v1_Target_DocumentsTarget_google_firestore_v1_Target_QueryTarget_google_firestore_v1_TargetChange_google_firestore_v1_ListCollectionIdsRequest_google_firestore_v1_ListCollectionIdsResponse)
#endif


const char* EnumToString(
  google_firestore_v1_TargetChange_TargetChangeType value) {
    switch (value) {
    case google_firestore_v1_TargetChange_TargetChangeType_NO_CHANGE:
        return "NO_CHANGE";
    case google_firestore_v1_TargetChange_TargetChangeType_ADD:
        return "ADD";
    case google_firestore_v1_TargetChange_TargetChangeType_REMOVE:
        return "REMOVE";
    case google_firestore_v1_TargetChange_TargetChangeType_CURRENT:
        return "CURRENT";
    case google_firestore_v1_TargetChange_TargetChangeType_RESET:
        return "RESET";
    }
    return "<unknown enum value>";
}

std::string google_firestore_v1_GetDocumentRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "GetDocumentRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("name: ", name, indent + 1, false);
    tostring_result += PrintMessageField("mask ", mask, indent + 1, false);
    switch (which_consistency_selector) {
    case google_firestore_v1_GetDocumentRequest_transaction_tag:
        tostring_result += PrintPrimitiveField("transaction: ",
            transaction, indent + 1, true);
        break;
    case google_firestore_v1_GetDocumentRequest_read_time_tag:
        tostring_result += PrintMessageField("read_time ",
            read_time, indent + 1, true);
        break;
    }

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_ListDocumentsRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "ListDocumentsRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("parent: ",
        parent, indent + 1, false);
    tostring_result += PrintPrimitiveField("collection_id: ",
        collection_id, indent + 1, false);
    tostring_result += PrintPrimitiveField("page_size: ",
        page_size, indent + 1, false);
    tostring_result += PrintPrimitiveField("page_token: ",
        page_token, indent + 1, false);
    tostring_result += PrintPrimitiveField("order_by: ",
        order_by, indent + 1, false);
    tostring_result += PrintMessageField("mask ", mask, indent + 1, false);
    switch (which_consistency_selector) {
    case google_firestore_v1_ListDocumentsRequest_transaction_tag:
        tostring_result += PrintPrimitiveField("transaction: ",
            transaction, indent + 1, true);
        break;
    case google_firestore_v1_ListDocumentsRequest_read_time_tag:
        tostring_result += PrintMessageField("read_time ",
            read_time, indent + 1, true);
        break;
    }
    tostring_result += PrintPrimitiveField("show_missing: ",
        show_missing, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_ListDocumentsResponse::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "ListDocumentsResponse", this);
    std::string tostring_result;

    for (pb_size_t i = 0; i != documents_count; ++i) {
        tostring_result += PrintMessageField("documents ",
            documents[i], indent + 1, true);
    }
    tostring_result += PrintPrimitiveField("next_page_token: ",
        next_page_token, indent + 1, false);

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_CreateDocumentRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "CreateDocumentRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("parent: ",
        parent, indent + 1, false);
    tostring_result += PrintPrimitiveField("collection_id: ",
        collection_id, indent + 1, false);
    tostring_result += PrintPrimitiveField("document_id: ",
        document_id, indent + 1, false);
    tostring_result += PrintMessageField("document ",
        document, indent + 1, false);
    tostring_result += PrintMessageField("mask ", mask, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_UpdateDocumentRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "UpdateDocumentRequest", this);
    std::string tostring_result;

    tostring_result += PrintMessageField("document ",
        document, indent + 1, false);
    tostring_result += PrintMessageField("update_mask ",
        update_mask, indent + 1, false);
    tostring_result += PrintMessageField("mask ", mask, indent + 1, false);
    tostring_result += PrintMessageField("current_document ",
        current_document, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_DeleteDocumentRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "DeleteDocumentRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("name: ", name, indent + 1, false);
    tostring_result += PrintMessageField("current_document ",
        current_document, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_BatchGetDocumentsRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "BatchGetDocumentsRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("database: ",
        database, indent + 1, false);
    for (pb_size_t i = 0; i != documents_count; ++i) {
        tostring_result += PrintPrimitiveField("documents: ",
            documents[i], indent + 1, true);
    }
    tostring_result += PrintMessageField("mask ", mask, indent + 1, false);
    switch (which_consistency_selector) {
    case google_firestore_v1_BatchGetDocumentsRequest_transaction_tag:
        tostring_result += PrintPrimitiveField("transaction: ",
            transaction, indent + 1, true);
        break;
    case google_firestore_v1_BatchGetDocumentsRequest_new_transaction_tag:
        tostring_result += PrintMessageField("new_transaction ",
            new_transaction, indent + 1, true);
        break;
    case google_firestore_v1_BatchGetDocumentsRequest_read_time_tag:
        tostring_result += PrintMessageField("read_time ",
            read_time, indent + 1, true);
        break;
    }

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_BatchGetDocumentsResponse::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "BatchGetDocumentsResponse", this);
    std::string tostring_result;

    switch (which_result) {
    case google_firestore_v1_BatchGetDocumentsResponse_found_tag:
        tostring_result += PrintMessageField("found ",
            found, indent + 1, true);
        break;
    case google_firestore_v1_BatchGetDocumentsResponse_missing_tag:
        tostring_result += PrintPrimitiveField("missing: ",
            missing, indent + 1, true);
        break;
    }
    tostring_result += PrintPrimitiveField("transaction: ",
        transaction, indent + 1, false);
    tostring_result += PrintMessageField("read_time ",
        read_time, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_BeginTransactionRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "BeginTransactionRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("database: ",
        database, indent + 1, false);
    tostring_result += PrintMessageField("options ",
        options, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_BeginTransactionResponse::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "BeginTransactionResponse", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("transaction: ",
        transaction, indent + 1, false);

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_CommitRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "CommitRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("database: ",
        database, indent + 1, false);
    for (pb_size_t i = 0; i != writes_count; ++i) {
        tostring_result += PrintMessageField("writes ",
            writes[i], indent + 1, true);
    }
    tostring_result += PrintPrimitiveField("transaction: ",
        transaction, indent + 1, false);

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_CommitResponse::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "CommitResponse", this);
    std::string tostring_result;

    for (pb_size_t i = 0; i != write_results_count; ++i) {
        tostring_result += PrintMessageField("write_results ",
            write_results[i], indent + 1, true);
    }
    tostring_result += PrintMessageField("commit_time ",
        commit_time, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_RollbackRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "RollbackRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("database: ",
        database, indent + 1, false);
    tostring_result += PrintPrimitiveField("transaction: ",
        transaction, indent + 1, false);

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_RunQueryRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "RunQueryRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("parent: ",
        parent, indent + 1, false);
    switch (which_query_type) {
    case google_firestore_v1_RunQueryRequest_structured_query_tag:
        tostring_result += PrintMessageField("structured_query ",
            query_type.structured_query, indent + 1, true);
        break;
    }
    switch (which_consistency_selector) {
    case google_firestore_v1_RunQueryRequest_transaction_tag:
        tostring_result += PrintPrimitiveField("transaction: ",
            consistency_selector.transaction, indent + 1, true);
        break;
    case google_firestore_v1_RunQueryRequest_new_transaction_tag:
        tostring_result += PrintMessageField("new_transaction ",
            consistency_selector.new_transaction, indent + 1, true);
        break;
    case google_firestore_v1_RunQueryRequest_read_time_tag:
        tostring_result += PrintMessageField("read_time ",
            consistency_selector.read_time, indent + 1, true);
        break;
    }

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_RunQueryResponse::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "RunQueryResponse", this);
    std::string tostring_result;

    tostring_result += PrintMessageField("document ",
        document, indent + 1, false);
    tostring_result += PrintPrimitiveField("transaction: ",
        transaction, indent + 1, false);
    tostring_result += PrintMessageField("read_time ",
        read_time, indent + 1, false);
    tostring_result += PrintPrimitiveField("skipped_results: ",
        skipped_results, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_RunAggregationQueryRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "RunAggregationQueryRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("parent: ",
        parent, indent + 1, false);
    switch (which_query_type) {
    case google_firestore_v1_RunAggregationQueryRequest_structured_aggregation_query_tag:
        tostring_result += PrintMessageField("structured_aggregation_query ",
            query_type.structured_aggregation_query, indent + 1, true);
        break;
    }
    switch (which_consistency_selector) {
    case google_firestore_v1_RunAggregationQueryRequest_transaction_tag:
        tostring_result += PrintPrimitiveField("transaction: ",
            consistency_selector.transaction, indent + 1, true);
        break;
    case google_firestore_v1_RunAggregationQueryRequest_new_transaction_tag:
        tostring_result += PrintMessageField("new_transaction ",
            consistency_selector.new_transaction, indent + 1, true);
        break;
    case google_firestore_v1_RunAggregationQueryRequest_read_time_tag:
        tostring_result += PrintMessageField("read_time ",
            consistency_selector.read_time, indent + 1, true);
        break;
    }

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_RunAggregationQueryResponse::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "RunAggregationQueryResponse", this);
    std::string tostring_result;

    tostring_result += PrintMessageField("result ", result, indent + 1, false);
    tostring_result += PrintPrimitiveField("transaction: ",
        transaction, indent + 1, false);
    tostring_result += PrintMessageField("read_time ",
        read_time, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_WriteRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "WriteRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("database: ",
        database, indent + 1, false);
    tostring_result += PrintPrimitiveField("stream_id: ",
        stream_id, indent + 1, false);
    for (pb_size_t i = 0; i != writes_count; ++i) {
        tostring_result += PrintMessageField("writes ",
            writes[i], indent + 1, true);
    }
    tostring_result += PrintPrimitiveField("stream_token: ",
        stream_token, indent + 1, false);
    for (pb_size_t i = 0; i != labels_count; ++i) {
        tostring_result += PrintMessageField("labels ",
            labels[i], indent + 1, true);
    }

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_WriteRequest_LabelsEntry::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "LabelsEntry", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("key: ", key, indent + 1, false);
    tostring_result += PrintPrimitiveField("value: ",
        value, indent + 1, false);

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_WriteResponse::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "WriteResponse", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("stream_id: ",
        stream_id, indent + 1, false);
    tostring_result += PrintPrimitiveField("stream_token: ",
        stream_token, indent + 1, false);
    for (pb_size_t i = 0; i != write_results_count; ++i) {
        tostring_result += PrintMessageField("write_results ",
            write_results[i], indent + 1, true);
    }
    tostring_result += PrintMessageField("commit_time ",
        commit_time, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_ListenRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "ListenRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("database: ",
        database, indent + 1, false);
    switch (which_target_change) {
    case google_firestore_v1_ListenRequest_add_target_tag:
        tostring_result += PrintMessageField("add_target ",
            add_target, indent + 1, true);
        break;
    case google_firestore_v1_ListenRequest_remove_target_tag:
        tostring_result += PrintPrimitiveField("remove_target: ",
            remove_target, indent + 1, true);
        break;
    }
    for (pb_size_t i = 0; i != labels_count; ++i) {
        tostring_result += PrintMessageField("labels ",
            labels[i], indent + 1, true);
    }

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_ListenRequest_LabelsEntry::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "LabelsEntry", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("key: ", key, indent + 1, false);
    tostring_result += PrintPrimitiveField("value: ",
        value, indent + 1, false);

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_ListenResponse::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "ListenResponse", this);
    std::string tostring_result;

    switch (which_response_type) {
    case google_firestore_v1_ListenResponse_target_change_tag:
        tostring_result += PrintMessageField("target_change ",
            target_change, indent + 1, true);
        break;
    case google_firestore_v1_ListenResponse_document_change_tag:
        tostring_result += PrintMessageField("document_change ",
            document_change, indent + 1, true);
        break;
    case google_firestore_v1_ListenResponse_document_delete_tag:
        tostring_result += PrintMessageField("document_delete ",
            document_delete, indent + 1, true);
        break;
    case google_firestore_v1_ListenResponse_filter_tag:
        tostring_result += PrintMessageField("filter ",
            filter, indent + 1, true);
        break;
    case google_firestore_v1_ListenResponse_document_remove_tag:
        tostring_result += PrintMessageField("document_remove ",
            document_remove, indent + 1, true);
        break;
    }

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_Target::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "Target", this);
    std::string tostring_result;

    switch (which_target_type) {
    case google_firestore_v1_Target_query_tag:
        tostring_result += PrintMessageField("query ",
            target_type.query, indent + 1, true);
        break;
    case google_firestore_v1_Target_documents_tag:
        tostring_result += PrintMessageField("documents ",
            target_type.documents, indent + 1, true);
        break;
    }
    switch (which_resume_type) {
    case google_firestore_v1_Target_resume_token_tag:
        tostring_result += PrintPrimitiveField("resume_token: ",
            resume_type.resume_token, indent + 1, true);
        break;
    case google_firestore_v1_Target_read_time_tag:
        tostring_result += PrintMessageField("read_time ",
            resume_type.read_time, indent + 1, true);
        break;
    }
    tostring_result += PrintPrimitiveField("target_id: ",
        target_id, indent + 1, false);
    tostring_result += PrintPrimitiveField("once: ", once, indent + 1, false);
    if (has_expected_count) {
        tostring_result += PrintMessageField("expected_count ",
            expected_count, indent + 1, true);
    }

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_Target_DocumentsTarget::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "DocumentsTarget", this);
    std::string tostring_result;

    for (pb_size_t i = 0; i != documents_count; ++i) {
        tostring_result += PrintPrimitiveField("documents: ",
            documents[i], indent + 1, true);
    }

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_Target_QueryTarget::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "QueryTarget", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("parent: ",
        parent, indent + 1, false);
    switch (which_query_type) {
    case google_firestore_v1_Target_QueryTarget_structured_query_tag:
        tostring_result += PrintMessageField("structured_query ",
            structured_query, indent + 1, true);
        break;
    }

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_TargetChange::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "TargetChange", this);
    std::string tostring_result;

    tostring_result += PrintEnumField("target_change_type: ",
        target_change_type, indent + 1, false);
    for (pb_size_t i = 0; i != target_ids_count; ++i) {
        tostring_result += PrintPrimitiveField("target_ids: ",
            target_ids[i], indent + 1, true);
    }
    if (has_cause) {
        tostring_result += PrintMessageField("cause ",
            cause, indent + 1, true);
    }
    tostring_result += PrintPrimitiveField("resume_token: ",
        resume_token, indent + 1, false);
    tostring_result += PrintMessageField("read_time ",
        read_time, indent + 1, false);

    std::string tostring_tail = PrintTail(indent);
    return tostring_header + tostring_result + tostring_tail;
}

std::string google_firestore_v1_ListCollectionIdsRequest::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "ListCollectionIdsRequest", this);
    std::string tostring_result;

    tostring_result += PrintPrimitiveField("parent: ",
        parent, indent + 1, false);
    tostring_result += PrintPrimitiveField("page_size: ",
        page_size, indent + 1, false);
    tostring_result += PrintPrimitiveField("page_token: ",
        page_token, indent + 1, false);

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

std::string google_firestore_v1_ListCollectionIdsResponse::ToString(int indent) const {
    std::string tostring_header = PrintHeader(indent, "ListCollectionIdsResponse", this);
    std::string tostring_result;

    for (pb_size_t i = 0; i != collection_ids_count; ++i) {
        tostring_result += PrintPrimitiveField("collection_ids: ",
            collection_ids[i], indent + 1, true);
    }
    tostring_result += PrintPrimitiveField("next_page_token: ",
        next_page_token, indent + 1, false);

    bool is_root = indent == 0;
    if (!tostring_result.empty() || is_root) {
      std::string tostring_tail = PrintTail(indent);
      return tostring_header + tostring_result + tostring_tail;
    } else {
      return "";
    }
}

}  // namespace firestore
}  // namespace firebase

/* @@protoc_insertion_point(eof) */
