/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* Automatically generated nanopb header */
/* Generated by nanopb-0.3.9.8 */

#ifndef PB_FIRESTORE_CLIENT_TARGET_NANOPB_H_INCLUDED
#define PB_FIRESTORE_CLIENT_TARGET_NANOPB_H_INCLUDED
#include <pb.h>

#include "google/firestore/v1/firestore.nanopb.h"

#include "google/protobuf/timestamp.nanopb.h"

#include <string>

namespace firebase {
namespace firestore {

/* @@protoc_insertion_point(includes) */
#if PB_PROTO_HEADER_VERSION != 30
#error Regenerate this file with the current version of nanopb generator.
#endif


/* Struct definitions */
typedef struct _firestore_client_Target {
    int32_t target_id;
    google_protobuf_Timestamp snapshot_version;
    pb_bytes_array_t *resume_token;
    int64_t last_listen_sequence_number;
    pb_size_t which_target_type;
    union {
        google_firestore_v1_Target_QueryTarget query;
        google_firestore_v1_Target_DocumentsTarget documents;
    };
    google_protobuf_Timestamp last_limbo_free_snapshot_version;

    std::string ToString(int indent = 0) const;
/* @@protoc_insertion_point(struct:firestore_client_Target) */
} firestore_client_Target;

typedef struct _firestore_client_TargetGlobal {
    int32_t highest_target_id;
    int64_t highest_listen_sequence_number;
    google_protobuf_Timestamp last_remote_snapshot_version;
    int32_t target_count;

    std::string ToString(int indent = 0) const;
/* @@protoc_insertion_point(struct:firestore_client_TargetGlobal) */
} firestore_client_TargetGlobal;

/* Default values for struct fields */

/* Initializer values for message structs */
#define firestore_client_Target_init_default     {0, google_protobuf_Timestamp_init_default, NULL, 0, 0, {google_firestore_v1_Target_QueryTarget_init_default}, google_protobuf_Timestamp_init_default}
#define firestore_client_TargetGlobal_init_default {0, 0, google_protobuf_Timestamp_init_default, 0}
#define firestore_client_Target_init_zero        {0, google_protobuf_Timestamp_init_zero, NULL, 0, 0, {google_firestore_v1_Target_QueryTarget_init_zero}, google_protobuf_Timestamp_init_zero}
#define firestore_client_TargetGlobal_init_zero  {0, 0, google_protobuf_Timestamp_init_zero, 0}

/* Field tags (for use in manual encoding/decoding) */
#define firestore_client_Target_query_tag        5
#define firestore_client_Target_documents_tag    6
#define firestore_client_Target_target_id_tag    1
#define firestore_client_Target_snapshot_version_tag 2
#define firestore_client_Target_resume_token_tag 3
#define firestore_client_Target_last_listen_sequence_number_tag 4
#define firestore_client_Target_last_limbo_free_snapshot_version_tag 7
#define firestore_client_TargetGlobal_highest_target_id_tag 1
#define firestore_client_TargetGlobal_highest_listen_sequence_number_tag 2
#define firestore_client_TargetGlobal_last_remote_snapshot_version_tag 3
#define firestore_client_TargetGlobal_target_count_tag 4

/* Struct field encoding specification for nanopb */
extern const pb_field_t firestore_client_Target_fields[8];
extern const pb_field_t firestore_client_TargetGlobal_fields[5];

/* Maximum encoded size of messages (where known) */
/* firestore_client_Target_size depends on runtime parameters */
#define firestore_client_TargetGlobal_size       57

/* Message IDs (where set with "msgid" option) */
#ifdef PB_MSGID

#define TARGET_MESSAGES \


#endif

}  // namespace firestore
}  // namespace firebase

/* @@protoc_insertion_point(eof) */

#endif
