/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/firestore/v1/write.proto

#include "google/firestore/v1/write.pb.h"

#include <algorithm>
#include "google/protobuf/io/coded_stream.h"
#include "google/protobuf/extension_set.h"
#include "google/protobuf/wire_format_lite.h"
#include "google/protobuf/descriptor.h"
#include "google/protobuf/generated_message_reflection.h"
#include "google/protobuf/reflection_ops.h"
#include "google/protobuf/wire_format.h"
#include "google/protobuf/generated_message_tctable_impl.h"
// @@protoc_insertion_point(includes)

// Must be included last.
#include "google/protobuf/port_def.inc"
PROTOBUF_PRAGMA_INIT_SEG
namespace _pb = ::google::protobuf;
namespace _pbi = ::google::protobuf::internal;
namespace _fl = ::google::protobuf::internal::field_layout;
namespace google {
namespace firestore {
namespace v1 {

inline constexpr DocumentRemove::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : _cached_size_{0},
        removed_target_ids_{},
        _removed_target_ids_cached_byte_size_{0},
        document_(
            &::google::protobuf::internal::fixed_address_empty_string,
            ::_pbi::ConstantInitialized()),
        read_time_{nullptr} {}

template <typename>
PROTOBUF_CONSTEXPR DocumentRemove::DocumentRemove(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct DocumentRemoveDefaultTypeInternal {
  PROTOBUF_CONSTEXPR DocumentRemoveDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~DocumentRemoveDefaultTypeInternal() {}
  union {
    DocumentRemove _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 DocumentRemoveDefaultTypeInternal _DocumentRemove_default_instance_;

inline constexpr DocumentDelete::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : _cached_size_{0},
        removed_target_ids_{},
        _removed_target_ids_cached_byte_size_{0},
        document_(
            &::google::protobuf::internal::fixed_address_empty_string,
            ::_pbi::ConstantInitialized()),
        read_time_{nullptr} {}

template <typename>
PROTOBUF_CONSTEXPR DocumentDelete::DocumentDelete(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct DocumentDeleteDefaultTypeInternal {
  PROTOBUF_CONSTEXPR DocumentDeleteDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~DocumentDeleteDefaultTypeInternal() {}
  union {
    DocumentDelete _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 DocumentDeleteDefaultTypeInternal _DocumentDelete_default_instance_;

inline constexpr WriteResult::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : _cached_size_{0},
        transform_results_{},
        update_time_{nullptr} {}

template <typename>
PROTOBUF_CONSTEXPR WriteResult::WriteResult(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct WriteResultDefaultTypeInternal {
  PROTOBUF_CONSTEXPR WriteResultDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~WriteResultDefaultTypeInternal() {}
  union {
    WriteResult _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 WriteResultDefaultTypeInternal _WriteResult_default_instance_;

inline constexpr ExistenceFilter::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : _cached_size_{0},
        unchanged_names_{nullptr},
        target_id_{0},
        count_{0} {}

template <typename>
PROTOBUF_CONSTEXPR ExistenceFilter::ExistenceFilter(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct ExistenceFilterDefaultTypeInternal {
  PROTOBUF_CONSTEXPR ExistenceFilterDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~ExistenceFilterDefaultTypeInternal() {}
  union {
    ExistenceFilter _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 ExistenceFilterDefaultTypeInternal _ExistenceFilter_default_instance_;

inline constexpr DocumentTransform_FieldTransform::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : field_path_(
            &::google::protobuf::internal::fixed_address_empty_string,
            ::_pbi::ConstantInitialized()),
        transform_type_{},
        _cached_size_{0},
        _oneof_case_{} {}

template <typename>
PROTOBUF_CONSTEXPR DocumentTransform_FieldTransform::DocumentTransform_FieldTransform(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct DocumentTransform_FieldTransformDefaultTypeInternal {
  PROTOBUF_CONSTEXPR DocumentTransform_FieldTransformDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~DocumentTransform_FieldTransformDefaultTypeInternal() {}
  union {
    DocumentTransform_FieldTransform _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 DocumentTransform_FieldTransformDefaultTypeInternal _DocumentTransform_FieldTransform_default_instance_;

inline constexpr DocumentTransform::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : field_transforms_{},
        document_(
            &::google::protobuf::internal::fixed_address_empty_string,
            ::_pbi::ConstantInitialized()),
        _cached_size_{0} {}

template <typename>
PROTOBUF_CONSTEXPR DocumentTransform::DocumentTransform(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct DocumentTransformDefaultTypeInternal {
  PROTOBUF_CONSTEXPR DocumentTransformDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~DocumentTransformDefaultTypeInternal() {}
  union {
    DocumentTransform _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 DocumentTransformDefaultTypeInternal _DocumentTransform_default_instance_;

inline constexpr Write::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : _cached_size_{0},
        update_transforms_{},
        update_mask_{nullptr},
        current_document_{nullptr},
        operation_{},
        _oneof_case_{} {}

template <typename>
PROTOBUF_CONSTEXPR Write::Write(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct WriteDefaultTypeInternal {
  PROTOBUF_CONSTEXPR WriteDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~WriteDefaultTypeInternal() {}
  union {
    Write _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 WriteDefaultTypeInternal _Write_default_instance_;

inline constexpr DocumentChange::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : _cached_size_{0},
        target_ids_{},
        _target_ids_cached_byte_size_{0},
        removed_target_ids_{},
        _removed_target_ids_cached_byte_size_{0},
        document_{nullptr} {}

template <typename>
PROTOBUF_CONSTEXPR DocumentChange::DocumentChange(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct DocumentChangeDefaultTypeInternal {
  PROTOBUF_CONSTEXPR DocumentChangeDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~DocumentChangeDefaultTypeInternal() {}
  union {
    DocumentChange _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 DocumentChangeDefaultTypeInternal _DocumentChange_default_instance_;
}  // namespace v1
}  // namespace firestore
}  // namespace google
static ::_pb::Metadata file_level_metadata_google_2ffirestore_2fv1_2fwrite_2eproto[8];
static const ::_pb::EnumDescriptor* file_level_enum_descriptors_google_2ffirestore_2fv1_2fwrite_2eproto[1];
static constexpr const ::_pb::ServiceDescriptor**
    file_level_service_descriptors_google_2ffirestore_2fv1_2fwrite_2eproto = nullptr;
const ::uint32_t TableStruct_google_2ffirestore_2fv1_2fwrite_2eproto::offsets[] PROTOBUF_SECTION_VARIABLE(
    protodesc_cold) = {
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::Write, _impl_._has_bits_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::Write, _internal_metadata_),
    ~0u,  // no _extensions_
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::Write, _impl_._oneof_case_[0]),
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::Write, _impl_.update_mask_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::Write, _impl_.update_transforms_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::Write, _impl_.current_document_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::Write, _impl_.operation_),
    ~0u,
    ~0u,
    ~0u,
    ~0u,
    0,
    ~0u,
    1,
    ~0u,  // no _has_bits_
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentTransform_FieldTransform, _internal_metadata_),
    ~0u,  // no _extensions_
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentTransform_FieldTransform, _impl_._oneof_case_[0]),
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentTransform_FieldTransform, _impl_.field_path_),
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentTransform_FieldTransform, _impl_.transform_type_),
    ~0u,  // no _has_bits_
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentTransform, _internal_metadata_),
    ~0u,  // no _extensions_
    ~0u,  // no _oneof_case_
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentTransform, _impl_.document_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentTransform, _impl_.field_transforms_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::WriteResult, _impl_._has_bits_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::WriteResult, _internal_metadata_),
    ~0u,  // no _extensions_
    ~0u,  // no _oneof_case_
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::WriteResult, _impl_.update_time_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::WriteResult, _impl_.transform_results_),
    0,
    ~0u,
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentChange, _impl_._has_bits_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentChange, _internal_metadata_),
    ~0u,  // no _extensions_
    ~0u,  // no _oneof_case_
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentChange, _impl_.document_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentChange, _impl_.target_ids_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentChange, _impl_.removed_target_ids_),
    0,
    ~0u,
    ~0u,
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentDelete, _impl_._has_bits_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentDelete, _internal_metadata_),
    ~0u,  // no _extensions_
    ~0u,  // no _oneof_case_
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentDelete, _impl_.document_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentDelete, _impl_.removed_target_ids_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentDelete, _impl_.read_time_),
    ~0u,
    ~0u,
    0,
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentRemove, _impl_._has_bits_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentRemove, _internal_metadata_),
    ~0u,  // no _extensions_
    ~0u,  // no _oneof_case_
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentRemove, _impl_.document_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentRemove, _impl_.removed_target_ids_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentRemove, _impl_.read_time_),
    ~0u,
    ~0u,
    0,
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::ExistenceFilter, _impl_._has_bits_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::ExistenceFilter, _internal_metadata_),
    ~0u,  // no _extensions_
    ~0u,  // no _oneof_case_
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::ExistenceFilter, _impl_.target_id_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::ExistenceFilter, _impl_.count_),
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::ExistenceFilter, _impl_.unchanged_names_),
    ~0u,
    ~0u,
    0,
};

static const ::_pbi::MigrationSchema
    schemas[] PROTOBUF_SECTION_VARIABLE(protodesc_cold) = {
        {0, 16, -1, sizeof(::google::firestore::v1::Write)},
        {23, -1, -1, sizeof(::google::firestore::v1::DocumentTransform_FieldTransform)},
        {39, -1, -1, sizeof(::google::firestore::v1::DocumentTransform)},
        {49, 59, -1, sizeof(::google::firestore::v1::WriteResult)},
        {61, 72, -1, sizeof(::google::firestore::v1::DocumentChange)},
        {75, 86, -1, sizeof(::google::firestore::v1::DocumentDelete)},
        {89, 100, -1, sizeof(::google::firestore::v1::DocumentRemove)},
        {103, 114, -1, sizeof(::google::firestore::v1::ExistenceFilter)},
};

static const ::_pb::Message* const file_default_instances[] = {
    &::google::firestore::v1::_Write_default_instance_._instance,
    &::google::firestore::v1::_DocumentTransform_FieldTransform_default_instance_._instance,
    &::google::firestore::v1::_DocumentTransform_default_instance_._instance,
    &::google::firestore::v1::_WriteResult_default_instance_._instance,
    &::google::firestore::v1::_DocumentChange_default_instance_._instance,
    &::google::firestore::v1::_DocumentDelete_default_instance_._instance,
    &::google::firestore::v1::_DocumentRemove_default_instance_._instance,
    &::google::firestore::v1::_ExistenceFilter_default_instance_._instance,
};
const char descriptor_table_protodef_google_2ffirestore_2fv1_2fwrite_2eproto[] PROTOBUF_SECTION_VARIABLE(protodesc_cold) = {
    "\n\037google/firestore/v1/write.proto\022\023googl"
    "e.firestore.v1\032&google/firestore/v1/bloo"
    "m_filter.proto\032 google/firestore/v1/comm"
    "on.proto\032\"google/firestore/v1/document.p"
    "roto\032\037google/protobuf/timestamp.proto\"\355\002"
    "\n\005Write\022/\n\006update\030\001 \001(\0132\035.google.firesto"
    "re.v1.DocumentH\000\022\020\n\006delete\030\002 \001(\tH\000\022\020\n\006ve"
    "rify\030\005 \001(\tH\000\022;\n\ttransform\030\006 \001(\0132&.google"
    ".firestore.v1.DocumentTransformH\000\0226\n\013upd"
    "ate_mask\030\003 \001(\0132!.google.firestore.v1.Doc"
    "umentMask\022P\n\021update_transforms\030\007 \003(\01325.g"
    "oogle.firestore.v1.DocumentTransform.Fie"
    "ldTransform\022;\n\020current_document\030\004 \001(\0132!."
    "google.firestore.v1.PreconditionB\013\n\toper"
    "ation\"\345\004\n\021DocumentTransform\022\020\n\010document\030"
    "\001 \001(\t\022O\n\020field_transforms\030\002 \003(\01325.google"
    ".firestore.v1.DocumentTransform.FieldTra"
    "nsform\032\354\003\n\016FieldTransform\022\022\n\nfield_path\030"
    "\001 \001(\t\022`\n\023set_to_server_value\030\002 \001(\0162A.goo"
    "gle.firestore.v1.DocumentTransform.Field"
    "Transform.ServerValueH\000\022/\n\tincrement\030\003 \001"
    "(\0132\032.google.firestore.v1.ValueH\000\022-\n\007maxi"
    "mum\030\004 \001(\0132\032.google.firestore.v1.ValueH\000\022"
    "-\n\007minimum\030\005 \001(\0132\032.google.firestore.v1.V"
    "alueH\000\022B\n\027append_missing_elements\030\006 \001(\0132"
    "\037.google.firestore.v1.ArrayValueH\000\022@\n\025re"
    "move_all_from_array\030\007 \001(\0132\037.google.fires"
    "tore.v1.ArrayValueH\000\"=\n\013ServerValue\022\034\n\030S"
    "ERVER_VALUE_UNSPECIFIED\020\000\022\020\n\014REQUEST_TIM"
    "E\020\001B\020\n\016transform_type\"u\n\013WriteResult\022/\n\013"
    "update_time\030\001 \001(\0132\032.google.protobuf.Time"
    "stamp\0225\n\021transform_results\030\002 \003(\0132\032.googl"
    "e.firestore.v1.Value\"q\n\016DocumentChange\022/"
    "\n\010document\030\001 \001(\0132\035.google.firestore.v1.D"
    "ocument\022\022\n\ntarget_ids\030\005 \003(\005\022\032\n\022removed_t"
    "arget_ids\030\006 \003(\005\"m\n\016DocumentDelete\022\020\n\010doc"
    "ument\030\001 \001(\t\022\032\n\022removed_target_ids\030\006 \003(\005\022"
    "-\n\tread_time\030\004 \001(\0132\032.google.protobuf.Tim"
    "estamp\"m\n\016DocumentRemove\022\020\n\010document\030\001 \001"
    "(\t\022\032\n\022removed_target_ids\030\002 \003(\005\022-\n\tread_t"
    "ime\030\004 \001(\0132\032.google.protobuf.Timestamp\"n\n"
    "\017ExistenceFilter\022\021\n\ttarget_id\030\001 \001(\005\022\r\n\005c"
    "ount\030\002 \001(\005\0229\n\017unchanged_names\030\003 \001(\0132 .go"
    "ogle.firestore.v1.BloomFilterB\256\001\n\027com.go"
    "ogle.firestore.v1B\nWriteProtoP\001Z<google."
    "golang.org/genproto/googleapis/firestore"
    "/v1;firestore\242\002\004GCFS\252\002\036Google.Cloud.Fire"
    "store.V1Beta1\312\002\036Google\\Cloud\\Firestore\\V"
    "1beta1b\006proto3"
};
static const ::_pbi::DescriptorTable* const descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_deps[4] =
    {
        &::descriptor_table_google_2ffirestore_2fv1_2fbloom_5ffilter_2eproto,
        &::descriptor_table_google_2ffirestore_2fv1_2fcommon_2eproto,
        &::descriptor_table_google_2ffirestore_2fv1_2fdocument_2eproto,
        &::descriptor_table_google_2fprotobuf_2ftimestamp_2eproto,
};
static ::absl::once_flag descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_once;
const ::_pbi::DescriptorTable descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto = {
    false,
    false,
    1934,
    descriptor_table_protodef_google_2ffirestore_2fv1_2fwrite_2eproto,
    "google/firestore/v1/write.proto",
    &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_once,
    descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_deps,
    4,
    8,
    schemas,
    file_default_instances,
    TableStruct_google_2ffirestore_2fv1_2fwrite_2eproto::offsets,
    file_level_metadata_google_2ffirestore_2fv1_2fwrite_2eproto,
    file_level_enum_descriptors_google_2ffirestore_2fv1_2fwrite_2eproto,
    file_level_service_descriptors_google_2ffirestore_2fv1_2fwrite_2eproto,
};

// This function exists to be marked as weak.
// It can significantly speed up compilation by breaking up LLVM's SCC
// in the .pb.cc translation units. Large translation units see a
// reduction of more than 35% of walltime for optimized builds. Without
// the weak attribute all the messages in the file, including all the
// vtables and everything they use become part of the same SCC through
// a cycle like:
// GetMetadata -> descriptor table -> default instances ->
//   vtables -> GetMetadata
// By adding a weak function here we break the connection from the
// individual vtables back into the descriptor table.
PROTOBUF_ATTRIBUTE_WEAK const ::_pbi::DescriptorTable* descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_getter() {
  return &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto;
}
// Force running AddDescriptors() at dynamic initialization time.
PROTOBUF_ATTRIBUTE_INIT_PRIORITY2
static ::_pbi::AddDescriptorsRunner dynamic_init_dummy_google_2ffirestore_2fv1_2fwrite_2eproto(&descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto);
namespace google {
namespace firestore {
namespace v1 {
const ::google::protobuf::EnumDescriptor* DocumentTransform_FieldTransform_ServerValue_descriptor() {
  ::google::protobuf::internal::AssignDescriptors(&descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto);
  return file_level_enum_descriptors_google_2ffirestore_2fv1_2fwrite_2eproto[0];
}
PROTOBUF_CONSTINIT const uint32_t DocumentTransform_FieldTransform_ServerValue_internal_data_[] = {
    131072u, 0u, };
bool DocumentTransform_FieldTransform_ServerValue_IsValid(int value) {
  return 0 <= value && value <= 1;
}
#if (__cplusplus < 201703) && \
  (!defined(_MSC_VER) || (_MSC_VER >= 1900 && _MSC_VER < 1912))

constexpr DocumentTransform_FieldTransform_ServerValue DocumentTransform_FieldTransform::SERVER_VALUE_UNSPECIFIED;
constexpr DocumentTransform_FieldTransform_ServerValue DocumentTransform_FieldTransform::REQUEST_TIME;
constexpr DocumentTransform_FieldTransform_ServerValue DocumentTransform_FieldTransform::ServerValue_MIN;
constexpr DocumentTransform_FieldTransform_ServerValue DocumentTransform_FieldTransform::ServerValue_MAX;
constexpr int DocumentTransform_FieldTransform::ServerValue_ARRAYSIZE;

#endif  // (__cplusplus < 201703) &&
        // (!defined(_MSC_VER) || (_MSC_VER >= 1900 && _MSC_VER < 1912))
// ===================================================================

class Write::_Internal {
 public:
  using HasBits = decltype(std::declval<Write>()._impl_._has_bits_);
  static constexpr ::int32_t kHasBitsOffset =
    8 * PROTOBUF_FIELD_OFFSET(Write, _impl_._has_bits_);
  static constexpr ::int32_t kOneofCaseOffset =
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::Write, _impl_._oneof_case_);
  static const ::google::firestore::v1::Document& update(const Write* msg);
  static const ::google::firestore::v1::DocumentTransform& transform(const Write* msg);
  static const ::google::firestore::v1::DocumentMask& update_mask(const Write* msg);
  static void set_has_update_mask(HasBits* has_bits) {
    (*has_bits)[0] |= 1u;
  }
  static const ::google::firestore::v1::Precondition& current_document(const Write* msg);
  static void set_has_current_document(HasBits* has_bits) {
    (*has_bits)[0] |= 2u;
  }
};

const ::google::firestore::v1::Document& Write::_Internal::update(const Write* msg) {
  return *msg->_impl_.operation_.update_;
}
const ::google::firestore::v1::DocumentTransform& Write::_Internal::transform(const Write* msg) {
  return *msg->_impl_.operation_.transform_;
}
const ::google::firestore::v1::DocumentMask& Write::_Internal::update_mask(const Write* msg) {
  return *msg->_impl_.update_mask_;
}
const ::google::firestore::v1::Precondition& Write::_Internal::current_document(const Write* msg) {
  return *msg->_impl_.current_document_;
}
void Write::set_allocated_update(::google::firestore::v1::Document* update) {
  ::google::protobuf::Arena* message_arena = GetArena();
  clear_operation();
  if (update) {
    ::google::protobuf::Arena* submessage_arena = reinterpret_cast<::google::protobuf::MessageLite*>(update)->GetArena();
    if (message_arena != submessage_arena) {
      update = ::google::protobuf::internal::GetOwnedMessage(message_arena, update, submessage_arena);
    }
    set_has_update();
    _impl_.operation_.update_ = update;
  }
  // @@protoc_insertion_point(field_set_allocated:google.firestore.v1.Write.update)
}
void Write::clear_update() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (operation_case() == kUpdate) {
    if (GetArena() == nullptr) {
      delete _impl_.operation_.update_;
    }
    clear_has_operation();
  }
}
void Write::set_allocated_transform(::google::firestore::v1::DocumentTransform* transform) {
  ::google::protobuf::Arena* message_arena = GetArena();
  clear_operation();
  if (transform) {
    ::google::protobuf::Arena* submessage_arena = transform->GetArena();
    if (message_arena != submessage_arena) {
      transform = ::google::protobuf::internal::GetOwnedMessage(message_arena, transform, submessage_arena);
    }
    set_has_transform();
    _impl_.operation_.transform_ = transform;
  }
  // @@protoc_insertion_point(field_set_allocated:google.firestore.v1.Write.transform)
}
void Write::clear_update_mask() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (_impl_.update_mask_ != nullptr) _impl_.update_mask_->Clear();
  _impl_._has_bits_[0] &= ~0x00000001u;
}
void Write::clear_current_document() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (_impl_.current_document_ != nullptr) _impl_.current_document_->Clear();
  _impl_._has_bits_[0] &= ~0x00000002u;
}
Write::Write(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.firestore.v1.Write)
}
inline PROTOBUF_NDEBUG_INLINE Write::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : _has_bits_{from._has_bits_},
        _cached_size_{0},
        update_transforms_{visibility, arena, from.update_transforms_},
        operation_{},
        _oneof_case_{from._oneof_case_[0]} {}

Write::Write(
    ::google::protobuf::Arena* arena,
    const Write& from)
    : ::google::protobuf::Message(arena) {
  Write* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);
  ::uint32_t cached_has_bits = _impl_._has_bits_[0];
  _impl_.update_mask_ = (cached_has_bits & 0x00000001u)
                ? CreateMaybeMessage<::google::firestore::v1::DocumentMask>(arena, *from._impl_.update_mask_)
                : nullptr;
  _impl_.current_document_ = (cached_has_bits & 0x00000002u)
                ? CreateMaybeMessage<::google::firestore::v1::Precondition>(arena, *from._impl_.current_document_)
                : nullptr;
  switch (operation_case()) {
    case OPERATION_NOT_SET:
      break;
      case kUpdate:
        _impl_.operation_.update_ = CreateMaybeMessage<::google::firestore::v1::Document>(arena, *from._impl_.operation_.update_);
        break;
      case kDelete:
        new (&_impl_.operation_.delete__) decltype(_impl_.operation_.delete__){arena, from._impl_.operation_.delete__};
        break;
      case kVerify:
        new (&_impl_.operation_.verify_) decltype(_impl_.operation_.verify_){arena, from._impl_.operation_.verify_};
        break;
      case kTransform:
        _impl_.operation_.transform_ = CreateMaybeMessage<::google::firestore::v1::DocumentTransform>(arena, *from._impl_.operation_.transform_);
        break;
  }

  // @@protoc_insertion_point(copy_constructor:google.firestore.v1.Write)
}
inline PROTOBUF_NDEBUG_INLINE Write::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : _cached_size_{0},
        update_transforms_{visibility, arena},
        operation_{},
        _oneof_case_{} {}

inline void Write::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
  ::memset(reinterpret_cast<char *>(&_impl_) +
               offsetof(Impl_, update_mask_),
           0,
           offsetof(Impl_, current_document_) -
               offsetof(Impl_, update_mask_) +
               sizeof(Impl_::current_document_));
}
Write::~Write() {
  // @@protoc_insertion_point(destructor:google.firestore.v1.Write)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void Write::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  delete _impl_.update_mask_;
  delete _impl_.current_document_;
  if (has_operation()) {
    clear_operation();
  }
  _impl_.~Impl_();
}

void Write::clear_operation() {
// @@protoc_insertion_point(one_of_clear_start:google.firestore.v1.Write)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  switch (operation_case()) {
    case kUpdate: {
      if (GetArena() == nullptr) {
        delete _impl_.operation_.update_;
      }
      break;
    }
    case kDelete: {
      _impl_.operation_.delete__.Destroy();
      break;
    }
    case kVerify: {
      _impl_.operation_.verify_.Destroy();
      break;
    }
    case kTransform: {
      if (GetArena() == nullptr) {
        delete _impl_.operation_.transform_;
      }
      break;
    }
    case OPERATION_NOT_SET: {
      break;
    }
  }
  _impl_._oneof_case_[0] = OPERATION_NOT_SET;
}


PROTOBUF_NOINLINE void Write::Clear() {
// @@protoc_insertion_point(message_clear_start:google.firestore.v1.Write)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  _impl_.update_transforms_.Clear();
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000003u) {
    if (cached_has_bits & 0x00000001u) {
      ABSL_DCHECK(_impl_.update_mask_ != nullptr);
      _impl_.update_mask_->Clear();
    }
    if (cached_has_bits & 0x00000002u) {
      ABSL_DCHECK(_impl_.current_document_ != nullptr);
      _impl_.current_document_->Clear();
    }
  }
  clear_operation();
  _impl_._has_bits_.Clear();
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* Write::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<3, 7, 5, 46, 2> Write::_table_ = {
  {
    PROTOBUF_FIELD_OFFSET(Write, _impl_._has_bits_),
    0, // no _extensions_
    7, 56,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294967168,  // skipmap
    offsetof(decltype(_table_), field_entries),
    7,  // num_field_entries
    5,  // num_aux_entries
    offsetof(decltype(_table_), aux_entries),
    &_Write_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    {::_pbi::TcParser::MiniParse, {}},
    {::_pbi::TcParser::MiniParse, {}},
    {::_pbi::TcParser::MiniParse, {}},
    // .google.firestore.v1.DocumentMask update_mask = 3;
    {::_pbi::TcParser::FastMtS1,
     {26, 0, 1, PROTOBUF_FIELD_OFFSET(Write, _impl_.update_mask_)}},
    // .google.firestore.v1.Precondition current_document = 4;
    {::_pbi::TcParser::FastMtS1,
     {34, 1, 2, PROTOBUF_FIELD_OFFSET(Write, _impl_.current_document_)}},
    {::_pbi::TcParser::MiniParse, {}},
    {::_pbi::TcParser::MiniParse, {}},
    // repeated .google.firestore.v1.DocumentTransform.FieldTransform update_transforms = 7;
    {::_pbi::TcParser::FastMtR1,
     {58, 63, 4, PROTOBUF_FIELD_OFFSET(Write, _impl_.update_transforms_)}},
  }}, {{
    65535, 65535
  }}, {{
    // .google.firestore.v1.Document update = 1;
    {PROTOBUF_FIELD_OFFSET(Write, _impl_.operation_.update_), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kMessage | ::_fl::kTvTable)},
    // string delete = 2;
    {PROTOBUF_FIELD_OFFSET(Write, _impl_.operation_.delete__), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // .google.firestore.v1.DocumentMask update_mask = 3;
    {PROTOBUF_FIELD_OFFSET(Write, _impl_.update_mask_), _Internal::kHasBitsOffset + 0, 1,
    (0 | ::_fl::kFcOptional | ::_fl::kMessage | ::_fl::kTvTable)},
    // .google.firestore.v1.Precondition current_document = 4;
    {PROTOBUF_FIELD_OFFSET(Write, _impl_.current_document_), _Internal::kHasBitsOffset + 1, 2,
    (0 | ::_fl::kFcOptional | ::_fl::kMessage | ::_fl::kTvTable)},
    // string verify = 5;
    {PROTOBUF_FIELD_OFFSET(Write, _impl_.operation_.verify_), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // .google.firestore.v1.DocumentTransform transform = 6;
    {PROTOBUF_FIELD_OFFSET(Write, _impl_.operation_.transform_), _Internal::kOneofCaseOffset + 0, 3,
    (0 | ::_fl::kFcOneof | ::_fl::kMessage | ::_fl::kTvTable)},
    // repeated .google.firestore.v1.DocumentTransform.FieldTransform update_transforms = 7;
    {PROTOBUF_FIELD_OFFSET(Write, _impl_.update_transforms_), -1, 4,
    (0 | ::_fl::kFcRepeated | ::_fl::kMessage | ::_fl::kTvTable)},
  }}, {{
    {::_pbi::TcParser::GetTable<::google::firestore::v1::Document>()},
    {::_pbi::TcParser::GetTable<::google::firestore::v1::DocumentMask>()},
    {::_pbi::TcParser::GetTable<::google::firestore::v1::Precondition>()},
    {::_pbi::TcParser::GetTable<::google::firestore::v1::DocumentTransform>()},
    {::_pbi::TcParser::GetTable<::google::firestore::v1::DocumentTransform_FieldTransform>()},
  }}, {{
    "\31\0\6\0\0\6\0\0"
    "google.firestore.v1.Write"
    "delete"
    "verify"
  }},
};

::uint8_t* Write::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.firestore.v1.Write)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  switch (operation_case()) {
    case kUpdate: {
      target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
          1, _Internal::update(this),
          _Internal::update(this).GetCachedSize(), target, stream);
      break;
    }
    case kDelete: {
      const std::string& _s = this->_internal_delete_();
      ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
          _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.firestore.v1.Write.delete");
      target = stream->WriteStringMaybeAliased(2, _s, target);
      break;
    }
    default:
      break;
  }
  cached_has_bits = _impl_._has_bits_[0];
  // .google.firestore.v1.DocumentMask update_mask = 3;
  if (cached_has_bits & 0x00000001u) {
    target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
        3, _Internal::update_mask(this),
        _Internal::update_mask(this).GetCachedSize(), target, stream);
  }

  // .google.firestore.v1.Precondition current_document = 4;
  if (cached_has_bits & 0x00000002u) {
    target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
        4, _Internal::current_document(this),
        _Internal::current_document(this).GetCachedSize(), target, stream);
  }

  switch (operation_case()) {
    case kVerify: {
      const std::string& _s = this->_internal_verify();
      ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
          _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.firestore.v1.Write.verify");
      target = stream->WriteStringMaybeAliased(5, _s, target);
      break;
    }
    case kTransform: {
      target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
          6, _Internal::transform(this),
          _Internal::transform(this).GetCachedSize(), target, stream);
      break;
    }
    default:
      break;
  }
  // repeated .google.firestore.v1.DocumentTransform.FieldTransform update_transforms = 7;
  for (unsigned i = 0,
      n = static_cast<unsigned>(this->_internal_update_transforms_size()); i < n; i++) {
    const auto& repfield = this->_internal_update_transforms().Get(i);
    target = ::google::protobuf::internal::WireFormatLite::
        InternalWriteMessage(7, repfield, repfield.GetCachedSize(), target, stream);
  }

  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.firestore.v1.Write)
  return target;
}

::size_t Write::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.firestore.v1.Write)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // repeated .google.firestore.v1.DocumentTransform.FieldTransform update_transforms = 7;
  total_size += 1UL * this->_internal_update_transforms_size();
  for (const auto& msg : this->_internal_update_transforms()) {
    total_size +=
      ::google::protobuf::internal::WireFormatLite::MessageSize(msg);
  }
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000003u) {
    // .google.firestore.v1.DocumentMask update_mask = 3;
    if (cached_has_bits & 0x00000001u) {
      total_size +=
          1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.update_mask_);
    }

    // .google.firestore.v1.Precondition current_document = 4;
    if (cached_has_bits & 0x00000002u) {
      total_size +=
          1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.current_document_);
    }

  }
  switch (operation_case()) {
    // .google.firestore.v1.Document update = 1;
    case kUpdate: {
      total_size +=
          1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.operation_.update_);
      break;
    }
    // string delete = 2;
    case kDelete: {
      total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                      this->_internal_delete_());
      break;
    }
    // string verify = 5;
    case kVerify: {
      total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                      this->_internal_verify());
      break;
    }
    // .google.firestore.v1.DocumentTransform transform = 6;
    case kTransform: {
      total_size +=
          1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.operation_.transform_);
      break;
    }
    case OPERATION_NOT_SET: {
      break;
    }
  }
  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData Write::_class_data_ = {
    Write::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* Write::GetClassData() const {
  return &_class_data_;
}

void Write::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<Write*>(&to_msg);
  auto& from = static_cast<const Write&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.firestore.v1.Write)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  _this->_internal_mutable_update_transforms()->MergeFrom(
      from._internal_update_transforms());
  cached_has_bits = from._impl_._has_bits_[0];
  if (cached_has_bits & 0x00000003u) {
    if (cached_has_bits & 0x00000001u) {
      _this->_internal_mutable_update_mask()->::google::firestore::v1::DocumentMask::MergeFrom(
          from._internal_update_mask());
    }
    if (cached_has_bits & 0x00000002u) {
      _this->_internal_mutable_current_document()->::google::firestore::v1::Precondition::MergeFrom(
          from._internal_current_document());
    }
  }
  switch (from.operation_case()) {
    case kUpdate: {
      _this->_internal_mutable_update()->::google::firestore::v1::Document::MergeFrom(
          from._internal_update());
      break;
    }
    case kDelete: {
      _this->_internal_set_delete_(from._internal_delete_());
      break;
    }
    case kVerify: {
      _this->_internal_set_verify(from._internal_verify());
      break;
    }
    case kTransform: {
      _this->_internal_mutable_transform()->::google::firestore::v1::DocumentTransform::MergeFrom(
          from._internal_transform());
      break;
    }
    case OPERATION_NOT_SET: {
      break;
    }
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void Write::CopyFrom(const Write& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.firestore.v1.Write)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool Write::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* Write::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void Write::InternalSwap(Write* PROTOBUF_RESTRICT other) {
  using std::swap;
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  swap(_impl_._has_bits_[0], other->_impl_._has_bits_[0]);
  _impl_.update_transforms_.InternalSwap(&other->_impl_.update_transforms_);
  ::google::protobuf::internal::memswap<
      PROTOBUF_FIELD_OFFSET(Write, _impl_.current_document_)
      + sizeof(Write::_impl_.current_document_)
      - PROTOBUF_FIELD_OFFSET(Write, _impl_.update_mask_)>(
          reinterpret_cast<char*>(&_impl_.update_mask_),
          reinterpret_cast<char*>(&other->_impl_.update_mask_));
  swap(_impl_.operation_, other->_impl_.operation_);
  swap(_impl_._oneof_case_[0], other->_impl_._oneof_case_[0]);
}

::google::protobuf::Metadata Write::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_getter, &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_once,
      file_level_metadata_google_2ffirestore_2fv1_2fwrite_2eproto[0]);
}
// ===================================================================

class DocumentTransform_FieldTransform::_Internal {
 public:
  static constexpr ::int32_t kOneofCaseOffset =
    PROTOBUF_FIELD_OFFSET(::google::firestore::v1::DocumentTransform_FieldTransform, _impl_._oneof_case_);
  static const ::google::firestore::v1::Value& increment(const DocumentTransform_FieldTransform* msg);
  static const ::google::firestore::v1::Value& maximum(const DocumentTransform_FieldTransform* msg);
  static const ::google::firestore::v1::Value& minimum(const DocumentTransform_FieldTransform* msg);
  static const ::google::firestore::v1::ArrayValue& append_missing_elements(const DocumentTransform_FieldTransform* msg);
  static const ::google::firestore::v1::ArrayValue& remove_all_from_array(const DocumentTransform_FieldTransform* msg);
};

const ::google::firestore::v1::Value& DocumentTransform_FieldTransform::_Internal::increment(const DocumentTransform_FieldTransform* msg) {
  return *msg->_impl_.transform_type_.increment_;
}
const ::google::firestore::v1::Value& DocumentTransform_FieldTransform::_Internal::maximum(const DocumentTransform_FieldTransform* msg) {
  return *msg->_impl_.transform_type_.maximum_;
}
const ::google::firestore::v1::Value& DocumentTransform_FieldTransform::_Internal::minimum(const DocumentTransform_FieldTransform* msg) {
  return *msg->_impl_.transform_type_.minimum_;
}
const ::google::firestore::v1::ArrayValue& DocumentTransform_FieldTransform::_Internal::append_missing_elements(const DocumentTransform_FieldTransform* msg) {
  return *msg->_impl_.transform_type_.append_missing_elements_;
}
const ::google::firestore::v1::ArrayValue& DocumentTransform_FieldTransform::_Internal::remove_all_from_array(const DocumentTransform_FieldTransform* msg) {
  return *msg->_impl_.transform_type_.remove_all_from_array_;
}
void DocumentTransform_FieldTransform::set_allocated_increment(::google::firestore::v1::Value* increment) {
  ::google::protobuf::Arena* message_arena = GetArena();
  clear_transform_type();
  if (increment) {
    ::google::protobuf::Arena* submessage_arena = reinterpret_cast<::google::protobuf::MessageLite*>(increment)->GetArena();
    if (message_arena != submessage_arena) {
      increment = ::google::protobuf::internal::GetOwnedMessage(message_arena, increment, submessage_arena);
    }
    set_has_increment();
    _impl_.transform_type_.increment_ = increment;
  }
  // @@protoc_insertion_point(field_set_allocated:google.firestore.v1.DocumentTransform.FieldTransform.increment)
}
void DocumentTransform_FieldTransform::clear_increment() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (transform_type_case() == kIncrement) {
    if (GetArena() == nullptr) {
      delete _impl_.transform_type_.increment_;
    }
    clear_has_transform_type();
  }
}
void DocumentTransform_FieldTransform::set_allocated_maximum(::google::firestore::v1::Value* maximum) {
  ::google::protobuf::Arena* message_arena = GetArena();
  clear_transform_type();
  if (maximum) {
    ::google::protobuf::Arena* submessage_arena = reinterpret_cast<::google::protobuf::MessageLite*>(maximum)->GetArena();
    if (message_arena != submessage_arena) {
      maximum = ::google::protobuf::internal::GetOwnedMessage(message_arena, maximum, submessage_arena);
    }
    set_has_maximum();
    _impl_.transform_type_.maximum_ = maximum;
  }
  // @@protoc_insertion_point(field_set_allocated:google.firestore.v1.DocumentTransform.FieldTransform.maximum)
}
void DocumentTransform_FieldTransform::clear_maximum() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (transform_type_case() == kMaximum) {
    if (GetArena() == nullptr) {
      delete _impl_.transform_type_.maximum_;
    }
    clear_has_transform_type();
  }
}
void DocumentTransform_FieldTransform::set_allocated_minimum(::google::firestore::v1::Value* minimum) {
  ::google::protobuf::Arena* message_arena = GetArena();
  clear_transform_type();
  if (minimum) {
    ::google::protobuf::Arena* submessage_arena = reinterpret_cast<::google::protobuf::MessageLite*>(minimum)->GetArena();
    if (message_arena != submessage_arena) {
      minimum = ::google::protobuf::internal::GetOwnedMessage(message_arena, minimum, submessage_arena);
    }
    set_has_minimum();
    _impl_.transform_type_.minimum_ = minimum;
  }
  // @@protoc_insertion_point(field_set_allocated:google.firestore.v1.DocumentTransform.FieldTransform.minimum)
}
void DocumentTransform_FieldTransform::clear_minimum() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (transform_type_case() == kMinimum) {
    if (GetArena() == nullptr) {
      delete _impl_.transform_type_.minimum_;
    }
    clear_has_transform_type();
  }
}
void DocumentTransform_FieldTransform::set_allocated_append_missing_elements(::google::firestore::v1::ArrayValue* append_missing_elements) {
  ::google::protobuf::Arena* message_arena = GetArena();
  clear_transform_type();
  if (append_missing_elements) {
    ::google::protobuf::Arena* submessage_arena = reinterpret_cast<::google::protobuf::MessageLite*>(append_missing_elements)->GetArena();
    if (message_arena != submessage_arena) {
      append_missing_elements = ::google::protobuf::internal::GetOwnedMessage(message_arena, append_missing_elements, submessage_arena);
    }
    set_has_append_missing_elements();
    _impl_.transform_type_.append_missing_elements_ = append_missing_elements;
  }
  // @@protoc_insertion_point(field_set_allocated:google.firestore.v1.DocumentTransform.FieldTransform.append_missing_elements)
}
void DocumentTransform_FieldTransform::clear_append_missing_elements() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (transform_type_case() == kAppendMissingElements) {
    if (GetArena() == nullptr) {
      delete _impl_.transform_type_.append_missing_elements_;
    }
    clear_has_transform_type();
  }
}
void DocumentTransform_FieldTransform::set_allocated_remove_all_from_array(::google::firestore::v1::ArrayValue* remove_all_from_array) {
  ::google::protobuf::Arena* message_arena = GetArena();
  clear_transform_type();
  if (remove_all_from_array) {
    ::google::protobuf::Arena* submessage_arena = reinterpret_cast<::google::protobuf::MessageLite*>(remove_all_from_array)->GetArena();
    if (message_arena != submessage_arena) {
      remove_all_from_array = ::google::protobuf::internal::GetOwnedMessage(message_arena, remove_all_from_array, submessage_arena);
    }
    set_has_remove_all_from_array();
    _impl_.transform_type_.remove_all_from_array_ = remove_all_from_array;
  }
  // @@protoc_insertion_point(field_set_allocated:google.firestore.v1.DocumentTransform.FieldTransform.remove_all_from_array)
}
void DocumentTransform_FieldTransform::clear_remove_all_from_array() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (transform_type_case() == kRemoveAllFromArray) {
    if (GetArena() == nullptr) {
      delete _impl_.transform_type_.remove_all_from_array_;
    }
    clear_has_transform_type();
  }
}
DocumentTransform_FieldTransform::DocumentTransform_FieldTransform(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.firestore.v1.DocumentTransform.FieldTransform)
}
inline PROTOBUF_NDEBUG_INLINE DocumentTransform_FieldTransform::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : field_path_(arena, from.field_path_),
        transform_type_{},
        _cached_size_{0},
        _oneof_case_{from._oneof_case_[0]} {}

DocumentTransform_FieldTransform::DocumentTransform_FieldTransform(
    ::google::protobuf::Arena* arena,
    const DocumentTransform_FieldTransform& from)
    : ::google::protobuf::Message(arena) {
  DocumentTransform_FieldTransform* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);
  switch (transform_type_case()) {
    case TRANSFORM_TYPE_NOT_SET:
      break;
      case kSetToServerValue:
        _impl_.transform_type_.set_to_server_value_ = from._impl_.transform_type_.set_to_server_value_;
        break;
      case kIncrement:
        _impl_.transform_type_.increment_ = CreateMaybeMessage<::google::firestore::v1::Value>(arena, *from._impl_.transform_type_.increment_);
        break;
      case kMaximum:
        _impl_.transform_type_.maximum_ = CreateMaybeMessage<::google::firestore::v1::Value>(arena, *from._impl_.transform_type_.maximum_);
        break;
      case kMinimum:
        _impl_.transform_type_.minimum_ = CreateMaybeMessage<::google::firestore::v1::Value>(arena, *from._impl_.transform_type_.minimum_);
        break;
      case kAppendMissingElements:
        _impl_.transform_type_.append_missing_elements_ = CreateMaybeMessage<::google::firestore::v1::ArrayValue>(arena, *from._impl_.transform_type_.append_missing_elements_);
        break;
      case kRemoveAllFromArray:
        _impl_.transform_type_.remove_all_from_array_ = CreateMaybeMessage<::google::firestore::v1::ArrayValue>(arena, *from._impl_.transform_type_.remove_all_from_array_);
        break;
  }

  // @@protoc_insertion_point(copy_constructor:google.firestore.v1.DocumentTransform.FieldTransform)
}
inline PROTOBUF_NDEBUG_INLINE DocumentTransform_FieldTransform::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : field_path_(arena),
        transform_type_{},
        _cached_size_{0},
        _oneof_case_{} {}

inline void DocumentTransform_FieldTransform::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
}
DocumentTransform_FieldTransform::~DocumentTransform_FieldTransform() {
  // @@protoc_insertion_point(destructor:google.firestore.v1.DocumentTransform.FieldTransform)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void DocumentTransform_FieldTransform::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  _impl_.field_path_.Destroy();
  if (has_transform_type()) {
    clear_transform_type();
  }
  _impl_.~Impl_();
}

void DocumentTransform_FieldTransform::clear_transform_type() {
// @@protoc_insertion_point(one_of_clear_start:google.firestore.v1.DocumentTransform.FieldTransform)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  switch (transform_type_case()) {
    case kSetToServerValue: {
      // No need to clear
      break;
    }
    case kIncrement: {
      if (GetArena() == nullptr) {
        delete _impl_.transform_type_.increment_;
      }
      break;
    }
    case kMaximum: {
      if (GetArena() == nullptr) {
        delete _impl_.transform_type_.maximum_;
      }
      break;
    }
    case kMinimum: {
      if (GetArena() == nullptr) {
        delete _impl_.transform_type_.minimum_;
      }
      break;
    }
    case kAppendMissingElements: {
      if (GetArena() == nullptr) {
        delete _impl_.transform_type_.append_missing_elements_;
      }
      break;
    }
    case kRemoveAllFromArray: {
      if (GetArena() == nullptr) {
        delete _impl_.transform_type_.remove_all_from_array_;
      }
      break;
    }
    case TRANSFORM_TYPE_NOT_SET: {
      break;
    }
  }
  _impl_._oneof_case_[0] = TRANSFORM_TYPE_NOT_SET;
}


PROTOBUF_NOINLINE void DocumentTransform_FieldTransform::Clear() {
// @@protoc_insertion_point(message_clear_start:google.firestore.v1.DocumentTransform.FieldTransform)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  _impl_.field_path_.ClearToEmpty();
  clear_transform_type();
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* DocumentTransform_FieldTransform::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<0, 7, 5, 71, 2> DocumentTransform_FieldTransform::_table_ = {
  {
    0,  // no _has_bits_
    0, // no _extensions_
    7, 0,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294967168,  // skipmap
    offsetof(decltype(_table_), field_entries),
    7,  // num_field_entries
    5,  // num_aux_entries
    offsetof(decltype(_table_), aux_entries),
    &_DocumentTransform_FieldTransform_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    // string field_path = 1;
    {::_pbi::TcParser::FastUS1,
     {10, 63, 0, PROTOBUF_FIELD_OFFSET(DocumentTransform_FieldTransform, _impl_.field_path_)}},
  }}, {{
    65535, 65535
  }}, {{
    // string field_path = 1;
    {PROTOBUF_FIELD_OFFSET(DocumentTransform_FieldTransform, _impl_.field_path_), 0, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // .google.firestore.v1.DocumentTransform.FieldTransform.ServerValue set_to_server_value = 2;
    {PROTOBUF_FIELD_OFFSET(DocumentTransform_FieldTransform, _impl_.transform_type_.set_to_server_value_), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kOpenEnum)},
    // .google.firestore.v1.Value increment = 3;
    {PROTOBUF_FIELD_OFFSET(DocumentTransform_FieldTransform, _impl_.transform_type_.increment_), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kMessage | ::_fl::kTvTable)},
    // .google.firestore.v1.Value maximum = 4;
    {PROTOBUF_FIELD_OFFSET(DocumentTransform_FieldTransform, _impl_.transform_type_.maximum_), _Internal::kOneofCaseOffset + 0, 1,
    (0 | ::_fl::kFcOneof | ::_fl::kMessage | ::_fl::kTvTable)},
    // .google.firestore.v1.Value minimum = 5;
    {PROTOBUF_FIELD_OFFSET(DocumentTransform_FieldTransform, _impl_.transform_type_.minimum_), _Internal::kOneofCaseOffset + 0, 2,
    (0 | ::_fl::kFcOneof | ::_fl::kMessage | ::_fl::kTvTable)},
    // .google.firestore.v1.ArrayValue append_missing_elements = 6;
    {PROTOBUF_FIELD_OFFSET(DocumentTransform_FieldTransform, _impl_.transform_type_.append_missing_elements_), _Internal::kOneofCaseOffset + 0, 3,
    (0 | ::_fl::kFcOneof | ::_fl::kMessage | ::_fl::kTvTable)},
    // .google.firestore.v1.ArrayValue remove_all_from_array = 7;
    {PROTOBUF_FIELD_OFFSET(DocumentTransform_FieldTransform, _impl_.transform_type_.remove_all_from_array_), _Internal::kOneofCaseOffset + 0, 4,
    (0 | ::_fl::kFcOneof | ::_fl::kMessage | ::_fl::kTvTable)},
  }}, {{
    {::_pbi::TcParser::GetTable<::google::firestore::v1::Value>()},
    {::_pbi::TcParser::GetTable<::google::firestore::v1::Value>()},
    {::_pbi::TcParser::GetTable<::google::firestore::v1::Value>()},
    {::_pbi::TcParser::GetTable<::google::firestore::v1::ArrayValue>()},
    {::_pbi::TcParser::GetTable<::google::firestore::v1::ArrayValue>()},
  }}, {{
    "\64\12\0\0\0\0\0\0"
    "google.firestore.v1.DocumentTransform.FieldTransform"
    "field_path"
  }},
};

::uint8_t* DocumentTransform_FieldTransform::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.firestore.v1.DocumentTransform.FieldTransform)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  // string field_path = 1;
  if (!this->_internal_field_path().empty()) {
    const std::string& _s = this->_internal_field_path();
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
        _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.firestore.v1.DocumentTransform.FieldTransform.field_path");
    target = stream->WriteStringMaybeAliased(1, _s, target);
  }

  switch (transform_type_case()) {
    case kSetToServerValue: {
      target = stream->EnsureSpace(target);
      target = ::_pbi::WireFormatLite::WriteEnumToArray(
          2, this->_internal_set_to_server_value(), target);
      break;
    }
    case kIncrement: {
      target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
          3, _Internal::increment(this),
          _Internal::increment(this).GetCachedSize(), target, stream);
      break;
    }
    case kMaximum: {
      target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
          4, _Internal::maximum(this),
          _Internal::maximum(this).GetCachedSize(), target, stream);
      break;
    }
    case kMinimum: {
      target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
          5, _Internal::minimum(this),
          _Internal::minimum(this).GetCachedSize(), target, stream);
      break;
    }
    case kAppendMissingElements: {
      target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
          6, _Internal::append_missing_elements(this),
          _Internal::append_missing_elements(this).GetCachedSize(), target, stream);
      break;
    }
    case kRemoveAllFromArray: {
      target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
          7, _Internal::remove_all_from_array(this),
          _Internal::remove_all_from_array(this).GetCachedSize(), target, stream);
      break;
    }
    default:
      break;
  }
  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.firestore.v1.DocumentTransform.FieldTransform)
  return target;
}

::size_t DocumentTransform_FieldTransform::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.firestore.v1.DocumentTransform.FieldTransform)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // string field_path = 1;
  if (!this->_internal_field_path().empty()) {
    total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                    this->_internal_field_path());
  }

  switch (transform_type_case()) {
    // .google.firestore.v1.DocumentTransform.FieldTransform.ServerValue set_to_server_value = 2;
    case kSetToServerValue: {
      total_size += 1 +
                    ::_pbi::WireFormatLite::EnumSize(this->_internal_set_to_server_value());
      break;
    }
    // .google.firestore.v1.Value increment = 3;
    case kIncrement: {
      total_size +=
          1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.transform_type_.increment_);
      break;
    }
    // .google.firestore.v1.Value maximum = 4;
    case kMaximum: {
      total_size +=
          1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.transform_type_.maximum_);
      break;
    }
    // .google.firestore.v1.Value minimum = 5;
    case kMinimum: {
      total_size +=
          1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.transform_type_.minimum_);
      break;
    }
    // .google.firestore.v1.ArrayValue append_missing_elements = 6;
    case kAppendMissingElements: {
      total_size +=
          1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.transform_type_.append_missing_elements_);
      break;
    }
    // .google.firestore.v1.ArrayValue remove_all_from_array = 7;
    case kRemoveAllFromArray: {
      total_size +=
          1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.transform_type_.remove_all_from_array_);
      break;
    }
    case TRANSFORM_TYPE_NOT_SET: {
      break;
    }
  }
  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData DocumentTransform_FieldTransform::_class_data_ = {
    DocumentTransform_FieldTransform::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* DocumentTransform_FieldTransform::GetClassData() const {
  return &_class_data_;
}

void DocumentTransform_FieldTransform::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<DocumentTransform_FieldTransform*>(&to_msg);
  auto& from = static_cast<const DocumentTransform_FieldTransform&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.firestore.v1.DocumentTransform.FieldTransform)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  if (!from._internal_field_path().empty()) {
    _this->_internal_set_field_path(from._internal_field_path());
  }
  switch (from.transform_type_case()) {
    case kSetToServerValue: {
      _this->_internal_set_set_to_server_value(from._internal_set_to_server_value());
      break;
    }
    case kIncrement: {
      _this->_internal_mutable_increment()->::google::firestore::v1::Value::MergeFrom(
          from._internal_increment());
      break;
    }
    case kMaximum: {
      _this->_internal_mutable_maximum()->::google::firestore::v1::Value::MergeFrom(
          from._internal_maximum());
      break;
    }
    case kMinimum: {
      _this->_internal_mutable_minimum()->::google::firestore::v1::Value::MergeFrom(
          from._internal_minimum());
      break;
    }
    case kAppendMissingElements: {
      _this->_internal_mutable_append_missing_elements()->::google::firestore::v1::ArrayValue::MergeFrom(
          from._internal_append_missing_elements());
      break;
    }
    case kRemoveAllFromArray: {
      _this->_internal_mutable_remove_all_from_array()->::google::firestore::v1::ArrayValue::MergeFrom(
          from._internal_remove_all_from_array());
      break;
    }
    case TRANSFORM_TYPE_NOT_SET: {
      break;
    }
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void DocumentTransform_FieldTransform::CopyFrom(const DocumentTransform_FieldTransform& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.firestore.v1.DocumentTransform.FieldTransform)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool DocumentTransform_FieldTransform::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* DocumentTransform_FieldTransform::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void DocumentTransform_FieldTransform::InternalSwap(DocumentTransform_FieldTransform* PROTOBUF_RESTRICT other) {
  using std::swap;
  auto* arena = GetArena();
  ABSL_DCHECK_EQ(arena, other->GetArena());
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  ::_pbi::ArenaStringPtr::InternalSwap(&_impl_.field_path_, &other->_impl_.field_path_, arena);
  swap(_impl_.transform_type_, other->_impl_.transform_type_);
  swap(_impl_._oneof_case_[0], other->_impl_._oneof_case_[0]);
}

::google::protobuf::Metadata DocumentTransform_FieldTransform::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_getter, &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_once,
      file_level_metadata_google_2ffirestore_2fv1_2fwrite_2eproto[1]);
}
// ===================================================================

class DocumentTransform::_Internal {
 public:
};

DocumentTransform::DocumentTransform(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.firestore.v1.DocumentTransform)
}
inline PROTOBUF_NDEBUG_INLINE DocumentTransform::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : field_transforms_{visibility, arena, from.field_transforms_},
        document_(arena, from.document_),
        _cached_size_{0} {}

DocumentTransform::DocumentTransform(
    ::google::protobuf::Arena* arena,
    const DocumentTransform& from)
    : ::google::protobuf::Message(arena) {
  DocumentTransform* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);

  // @@protoc_insertion_point(copy_constructor:google.firestore.v1.DocumentTransform)
}
inline PROTOBUF_NDEBUG_INLINE DocumentTransform::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : field_transforms_{visibility, arena},
        document_(arena),
        _cached_size_{0} {}

inline void DocumentTransform::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
}
DocumentTransform::~DocumentTransform() {
  // @@protoc_insertion_point(destructor:google.firestore.v1.DocumentTransform)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void DocumentTransform::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  _impl_.document_.Destroy();
  _impl_.~Impl_();
}

PROTOBUF_NOINLINE void DocumentTransform::Clear() {
// @@protoc_insertion_point(message_clear_start:google.firestore.v1.DocumentTransform)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  _impl_.field_transforms_.Clear();
  _impl_.document_.ClearToEmpty();
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* DocumentTransform::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<1, 2, 1, 54, 2> DocumentTransform::_table_ = {
  {
    0,  // no _has_bits_
    0, // no _extensions_
    2, 8,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294967292,  // skipmap
    offsetof(decltype(_table_), field_entries),
    2,  // num_field_entries
    1,  // num_aux_entries
    offsetof(decltype(_table_), aux_entries),
    &_DocumentTransform_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    // repeated .google.firestore.v1.DocumentTransform.FieldTransform field_transforms = 2;
    {::_pbi::TcParser::FastMtR1,
     {18, 63, 0, PROTOBUF_FIELD_OFFSET(DocumentTransform, _impl_.field_transforms_)}},
    // string document = 1;
    {::_pbi::TcParser::FastUS1,
     {10, 63, 0, PROTOBUF_FIELD_OFFSET(DocumentTransform, _impl_.document_)}},
  }}, {{
    65535, 65535
  }}, {{
    // string document = 1;
    {PROTOBUF_FIELD_OFFSET(DocumentTransform, _impl_.document_), 0, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // repeated .google.firestore.v1.DocumentTransform.FieldTransform field_transforms = 2;
    {PROTOBUF_FIELD_OFFSET(DocumentTransform, _impl_.field_transforms_), 0, 0,
    (0 | ::_fl::kFcRepeated | ::_fl::kMessage | ::_fl::kTvTable)},
  }}, {{
    {::_pbi::TcParser::GetTable<::google::firestore::v1::DocumentTransform_FieldTransform>()},
  }}, {{
    "\45\10\0\0\0\0\0\0"
    "google.firestore.v1.DocumentTransform"
    "document"
  }},
};

::uint8_t* DocumentTransform::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.firestore.v1.DocumentTransform)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  // string document = 1;
  if (!this->_internal_document().empty()) {
    const std::string& _s = this->_internal_document();
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
        _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.firestore.v1.DocumentTransform.document");
    target = stream->WriteStringMaybeAliased(1, _s, target);
  }

  // repeated .google.firestore.v1.DocumentTransform.FieldTransform field_transforms = 2;
  for (unsigned i = 0,
      n = static_cast<unsigned>(this->_internal_field_transforms_size()); i < n; i++) {
    const auto& repfield = this->_internal_field_transforms().Get(i);
    target = ::google::protobuf::internal::WireFormatLite::
        InternalWriteMessage(2, repfield, repfield.GetCachedSize(), target, stream);
  }

  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.firestore.v1.DocumentTransform)
  return target;
}

::size_t DocumentTransform::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.firestore.v1.DocumentTransform)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // repeated .google.firestore.v1.DocumentTransform.FieldTransform field_transforms = 2;
  total_size += 1UL * this->_internal_field_transforms_size();
  for (const auto& msg : this->_internal_field_transforms()) {
    total_size +=
      ::google::protobuf::internal::WireFormatLite::MessageSize(msg);
  }
  // string document = 1;
  if (!this->_internal_document().empty()) {
    total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                    this->_internal_document());
  }

  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData DocumentTransform::_class_data_ = {
    DocumentTransform::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* DocumentTransform::GetClassData() const {
  return &_class_data_;
}

void DocumentTransform::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<DocumentTransform*>(&to_msg);
  auto& from = static_cast<const DocumentTransform&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.firestore.v1.DocumentTransform)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  _this->_internal_mutable_field_transforms()->MergeFrom(
      from._internal_field_transforms());
  if (!from._internal_document().empty()) {
    _this->_internal_set_document(from._internal_document());
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void DocumentTransform::CopyFrom(const DocumentTransform& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.firestore.v1.DocumentTransform)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool DocumentTransform::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* DocumentTransform::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void DocumentTransform::InternalSwap(DocumentTransform* PROTOBUF_RESTRICT other) {
  using std::swap;
  auto* arena = GetArena();
  ABSL_DCHECK_EQ(arena, other->GetArena());
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  _impl_.field_transforms_.InternalSwap(&other->_impl_.field_transforms_);
  ::_pbi::ArenaStringPtr::InternalSwap(&_impl_.document_, &other->_impl_.document_, arena);
}

::google::protobuf::Metadata DocumentTransform::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_getter, &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_once,
      file_level_metadata_google_2ffirestore_2fv1_2fwrite_2eproto[2]);
}
// ===================================================================

class WriteResult::_Internal {
 public:
  using HasBits = decltype(std::declval<WriteResult>()._impl_._has_bits_);
  static constexpr ::int32_t kHasBitsOffset =
    8 * PROTOBUF_FIELD_OFFSET(WriteResult, _impl_._has_bits_);
  static const ::google::protobuf::Timestamp& update_time(const WriteResult* msg);
  static void set_has_update_time(HasBits* has_bits) {
    (*has_bits)[0] |= 1u;
  }
};

const ::google::protobuf::Timestamp& WriteResult::_Internal::update_time(const WriteResult* msg) {
  return *msg->_impl_.update_time_;
}
void WriteResult::clear_update_time() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (_impl_.update_time_ != nullptr) _impl_.update_time_->Clear();
  _impl_._has_bits_[0] &= ~0x00000001u;
}
void WriteResult::clear_transform_results() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  _impl_.transform_results_.Clear();
}
WriteResult::WriteResult(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.firestore.v1.WriteResult)
}
inline PROTOBUF_NDEBUG_INLINE WriteResult::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : _has_bits_{from._has_bits_},
        _cached_size_{0},
        transform_results_{visibility, arena, from.transform_results_} {}

WriteResult::WriteResult(
    ::google::protobuf::Arena* arena,
    const WriteResult& from)
    : ::google::protobuf::Message(arena) {
  WriteResult* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);
  ::uint32_t cached_has_bits = _impl_._has_bits_[0];
  _impl_.update_time_ = (cached_has_bits & 0x00000001u)
                ? CreateMaybeMessage<::google::protobuf::Timestamp>(arena, *from._impl_.update_time_)
                : nullptr;

  // @@protoc_insertion_point(copy_constructor:google.firestore.v1.WriteResult)
}
inline PROTOBUF_NDEBUG_INLINE WriteResult::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : _cached_size_{0},
        transform_results_{visibility, arena} {}

inline void WriteResult::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
  _impl_.update_time_ = {};
}
WriteResult::~WriteResult() {
  // @@protoc_insertion_point(destructor:google.firestore.v1.WriteResult)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void WriteResult::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  delete _impl_.update_time_;
  _impl_.~Impl_();
}

PROTOBUF_NOINLINE void WriteResult::Clear() {
// @@protoc_insertion_point(message_clear_start:google.firestore.v1.WriteResult)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  _impl_.transform_results_.Clear();
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000001u) {
    ABSL_DCHECK(_impl_.update_time_ != nullptr);
    _impl_.update_time_->Clear();
  }
  _impl_._has_bits_.Clear();
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* WriteResult::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<1, 2, 2, 0, 2> WriteResult::_table_ = {
  {
    PROTOBUF_FIELD_OFFSET(WriteResult, _impl_._has_bits_),
    0, // no _extensions_
    2, 8,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294967292,  // skipmap
    offsetof(decltype(_table_), field_entries),
    2,  // num_field_entries
    2,  // num_aux_entries
    offsetof(decltype(_table_), aux_entries),
    &_WriteResult_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    // repeated .google.firestore.v1.Value transform_results = 2;
    {::_pbi::TcParser::FastMtR1,
     {18, 63, 1, PROTOBUF_FIELD_OFFSET(WriteResult, _impl_.transform_results_)}},
    // .google.protobuf.Timestamp update_time = 1;
    {::_pbi::TcParser::FastMtS1,
     {10, 0, 0, PROTOBUF_FIELD_OFFSET(WriteResult, _impl_.update_time_)}},
  }}, {{
    65535, 65535
  }}, {{
    // .google.protobuf.Timestamp update_time = 1;
    {PROTOBUF_FIELD_OFFSET(WriteResult, _impl_.update_time_), _Internal::kHasBitsOffset + 0, 0,
    (0 | ::_fl::kFcOptional | ::_fl::kMessage | ::_fl::kTvTable)},
    // repeated .google.firestore.v1.Value transform_results = 2;
    {PROTOBUF_FIELD_OFFSET(WriteResult, _impl_.transform_results_), -1, 1,
    (0 | ::_fl::kFcRepeated | ::_fl::kMessage | ::_fl::kTvTable)},
  }}, {{
    {::_pbi::TcParser::GetTable<::google::protobuf::Timestamp>()},
    {::_pbi::TcParser::GetTable<::google::firestore::v1::Value>()},
  }}, {{
  }},
};

::uint8_t* WriteResult::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.firestore.v1.WriteResult)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  cached_has_bits = _impl_._has_bits_[0];
  // .google.protobuf.Timestamp update_time = 1;
  if (cached_has_bits & 0x00000001u) {
    target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
        1, _Internal::update_time(this),
        _Internal::update_time(this).GetCachedSize(), target, stream);
  }

  // repeated .google.firestore.v1.Value transform_results = 2;
  for (unsigned i = 0,
      n = static_cast<unsigned>(this->_internal_transform_results_size()); i < n; i++) {
    const auto& repfield = this->_internal_transform_results().Get(i);
    target = ::google::protobuf::internal::WireFormatLite::
        InternalWriteMessage(2, repfield, repfield.GetCachedSize(), target, stream);
  }

  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.firestore.v1.WriteResult)
  return target;
}

::size_t WriteResult::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.firestore.v1.WriteResult)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // repeated .google.firestore.v1.Value transform_results = 2;
  total_size += 1UL * this->_internal_transform_results_size();
  for (const auto& msg : this->_internal_transform_results()) {
    total_size +=
      ::google::protobuf::internal::WireFormatLite::MessageSize(msg);
  }
  // .google.protobuf.Timestamp update_time = 1;
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000001u) {
    total_size +=
        1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.update_time_);
  }

  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData WriteResult::_class_data_ = {
    WriteResult::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* WriteResult::GetClassData() const {
  return &_class_data_;
}

void WriteResult::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<WriteResult*>(&to_msg);
  auto& from = static_cast<const WriteResult&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.firestore.v1.WriteResult)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  _this->_internal_mutable_transform_results()->MergeFrom(
      from._internal_transform_results());
  if ((from._impl_._has_bits_[0] & 0x00000001u) != 0) {
    _this->_internal_mutable_update_time()->::google::protobuf::Timestamp::MergeFrom(
        from._internal_update_time());
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void WriteResult::CopyFrom(const WriteResult& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.firestore.v1.WriteResult)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool WriteResult::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* WriteResult::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void WriteResult::InternalSwap(WriteResult* PROTOBUF_RESTRICT other) {
  using std::swap;
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  swap(_impl_._has_bits_[0], other->_impl_._has_bits_[0]);
  _impl_.transform_results_.InternalSwap(&other->_impl_.transform_results_);
  swap(_impl_.update_time_, other->_impl_.update_time_);
}

::google::protobuf::Metadata WriteResult::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_getter, &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_once,
      file_level_metadata_google_2ffirestore_2fv1_2fwrite_2eproto[3]);
}
// ===================================================================

class DocumentChange::_Internal {
 public:
  using HasBits = decltype(std::declval<DocumentChange>()._impl_._has_bits_);
  static constexpr ::int32_t kHasBitsOffset =
    8 * PROTOBUF_FIELD_OFFSET(DocumentChange, _impl_._has_bits_);
  static const ::google::firestore::v1::Document& document(const DocumentChange* msg);
  static void set_has_document(HasBits* has_bits) {
    (*has_bits)[0] |= 1u;
  }
};

const ::google::firestore::v1::Document& DocumentChange::_Internal::document(const DocumentChange* msg) {
  return *msg->_impl_.document_;
}
void DocumentChange::clear_document() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (_impl_.document_ != nullptr) _impl_.document_->Clear();
  _impl_._has_bits_[0] &= ~0x00000001u;
}
DocumentChange::DocumentChange(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.firestore.v1.DocumentChange)
}
inline PROTOBUF_NDEBUG_INLINE DocumentChange::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : _has_bits_{from._has_bits_},
        _cached_size_{0},
        target_ids_{visibility, arena, from.target_ids_},
        _target_ids_cached_byte_size_{0},
        removed_target_ids_{visibility, arena, from.removed_target_ids_},
        _removed_target_ids_cached_byte_size_{0} {}

DocumentChange::DocumentChange(
    ::google::protobuf::Arena* arena,
    const DocumentChange& from)
    : ::google::protobuf::Message(arena) {
  DocumentChange* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);
  ::uint32_t cached_has_bits = _impl_._has_bits_[0];
  _impl_.document_ = (cached_has_bits & 0x00000001u)
                ? CreateMaybeMessage<::google::firestore::v1::Document>(arena, *from._impl_.document_)
                : nullptr;

  // @@protoc_insertion_point(copy_constructor:google.firestore.v1.DocumentChange)
}
inline PROTOBUF_NDEBUG_INLINE DocumentChange::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : _cached_size_{0},
        target_ids_{visibility, arena},
        _target_ids_cached_byte_size_{0},
        removed_target_ids_{visibility, arena},
        _removed_target_ids_cached_byte_size_{0} {}

inline void DocumentChange::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
  _impl_.document_ = {};
}
DocumentChange::~DocumentChange() {
  // @@protoc_insertion_point(destructor:google.firestore.v1.DocumentChange)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void DocumentChange::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  delete _impl_.document_;
  _impl_.~Impl_();
}

PROTOBUF_NOINLINE void DocumentChange::Clear() {
// @@protoc_insertion_point(message_clear_start:google.firestore.v1.DocumentChange)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  _impl_.target_ids_.Clear();
  _impl_.removed_target_ids_.Clear();
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000001u) {
    ABSL_DCHECK(_impl_.document_ != nullptr);
    _impl_.document_->Clear();
  }
  _impl_._has_bits_.Clear();
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* DocumentChange::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<1, 3, 1, 0, 2> DocumentChange::_table_ = {
  {
    PROTOBUF_FIELD_OFFSET(DocumentChange, _impl_._has_bits_),
    0, // no _extensions_
    6, 8,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294967246,  // skipmap
    offsetof(decltype(_table_), field_entries),
    3,  // num_field_entries
    1,  // num_aux_entries
    offsetof(decltype(_table_), aux_entries),
    &_DocumentChange_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    // repeated int32 removed_target_ids = 6;
    {::_pbi::TcParser::FastV32P1,
     {50, 63, 0, PROTOBUF_FIELD_OFFSET(DocumentChange, _impl_.removed_target_ids_)}},
    // .google.firestore.v1.Document document = 1;
    {::_pbi::TcParser::FastMtS1,
     {10, 0, 0, PROTOBUF_FIELD_OFFSET(DocumentChange, _impl_.document_)}},
  }}, {{
    65535, 65535
  }}, {{
    // .google.firestore.v1.Document document = 1;
    {PROTOBUF_FIELD_OFFSET(DocumentChange, _impl_.document_), _Internal::kHasBitsOffset + 0, 0,
    (0 | ::_fl::kFcOptional | ::_fl::kMessage | ::_fl::kTvTable)},
    // repeated int32 target_ids = 5;
    {PROTOBUF_FIELD_OFFSET(DocumentChange, _impl_.target_ids_), -1, 0,
    (0 | ::_fl::kFcRepeated | ::_fl::kPackedInt32)},
    // repeated int32 removed_target_ids = 6;
    {PROTOBUF_FIELD_OFFSET(DocumentChange, _impl_.removed_target_ids_), -1, 0,
    (0 | ::_fl::kFcRepeated | ::_fl::kPackedInt32)},
  }}, {{
    {::_pbi::TcParser::GetTable<::google::firestore::v1::Document>()},
  }}, {{
  }},
};

::uint8_t* DocumentChange::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.firestore.v1.DocumentChange)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  cached_has_bits = _impl_._has_bits_[0];
  // .google.firestore.v1.Document document = 1;
  if (cached_has_bits & 0x00000001u) {
    target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
        1, _Internal::document(this),
        _Internal::document(this).GetCachedSize(), target, stream);
  }

  // repeated int32 target_ids = 5;
  {
    int byte_size = _impl_._target_ids_cached_byte_size_.Get();
    if (byte_size > 0) {
      target = stream->WriteInt32Packed(
          5, _internal_target_ids(), byte_size, target);
    }
  }

  // repeated int32 removed_target_ids = 6;
  {
    int byte_size = _impl_._removed_target_ids_cached_byte_size_.Get();
    if (byte_size > 0) {
      target = stream->WriteInt32Packed(
          6, _internal_removed_target_ids(), byte_size, target);
    }
  }

  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.firestore.v1.DocumentChange)
  return target;
}

::size_t DocumentChange::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.firestore.v1.DocumentChange)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // repeated int32 target_ids = 5;
  {
    std::size_t data_size = ::_pbi::WireFormatLite::Int32Size(
        this->_internal_target_ids())
    ;
    _impl_._target_ids_cached_byte_size_.Set(::_pbi::ToCachedSize(data_size));
    std::size_t tag_size = data_size == 0
        ? 0
        : 1 + ::_pbi::WireFormatLite::Int32Size(
                            static_cast<int32_t>(data_size))
    ;
    total_size += tag_size + data_size;
  }
  // repeated int32 removed_target_ids = 6;
  {
    std::size_t data_size = ::_pbi::WireFormatLite::Int32Size(
        this->_internal_removed_target_ids())
    ;
    _impl_._removed_target_ids_cached_byte_size_.Set(::_pbi::ToCachedSize(data_size));
    std::size_t tag_size = data_size == 0
        ? 0
        : 1 + ::_pbi::WireFormatLite::Int32Size(
                            static_cast<int32_t>(data_size))
    ;
    total_size += tag_size + data_size;
  }
  // .google.firestore.v1.Document document = 1;
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000001u) {
    total_size +=
        1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.document_);
  }

  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData DocumentChange::_class_data_ = {
    DocumentChange::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* DocumentChange::GetClassData() const {
  return &_class_data_;
}

void DocumentChange::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<DocumentChange*>(&to_msg);
  auto& from = static_cast<const DocumentChange&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.firestore.v1.DocumentChange)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  _this->_internal_mutable_target_ids()->MergeFrom(from._internal_target_ids());
  _this->_internal_mutable_removed_target_ids()->MergeFrom(from._internal_removed_target_ids());
  if ((from._impl_._has_bits_[0] & 0x00000001u) != 0) {
    _this->_internal_mutable_document()->::google::firestore::v1::Document::MergeFrom(
        from._internal_document());
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void DocumentChange::CopyFrom(const DocumentChange& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.firestore.v1.DocumentChange)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool DocumentChange::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* DocumentChange::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void DocumentChange::InternalSwap(DocumentChange* PROTOBUF_RESTRICT other) {
  using std::swap;
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  swap(_impl_._has_bits_[0], other->_impl_._has_bits_[0]);
  _impl_.target_ids_.InternalSwap(&other->_impl_.target_ids_);
  _impl_.removed_target_ids_.InternalSwap(&other->_impl_.removed_target_ids_);
  swap(_impl_.document_, other->_impl_.document_);
}

::google::protobuf::Metadata DocumentChange::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_getter, &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_once,
      file_level_metadata_google_2ffirestore_2fv1_2fwrite_2eproto[4]);
}
// ===================================================================

class DocumentDelete::_Internal {
 public:
  using HasBits = decltype(std::declval<DocumentDelete>()._impl_._has_bits_);
  static constexpr ::int32_t kHasBitsOffset =
    8 * PROTOBUF_FIELD_OFFSET(DocumentDelete, _impl_._has_bits_);
  static const ::google::protobuf::Timestamp& read_time(const DocumentDelete* msg);
  static void set_has_read_time(HasBits* has_bits) {
    (*has_bits)[0] |= 1u;
  }
};

const ::google::protobuf::Timestamp& DocumentDelete::_Internal::read_time(const DocumentDelete* msg) {
  return *msg->_impl_.read_time_;
}
void DocumentDelete::clear_read_time() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (_impl_.read_time_ != nullptr) _impl_.read_time_->Clear();
  _impl_._has_bits_[0] &= ~0x00000001u;
}
DocumentDelete::DocumentDelete(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.firestore.v1.DocumentDelete)
}
inline PROTOBUF_NDEBUG_INLINE DocumentDelete::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : _has_bits_{from._has_bits_},
        _cached_size_{0},
        removed_target_ids_{visibility, arena, from.removed_target_ids_},
        _removed_target_ids_cached_byte_size_{0},
        document_(arena, from.document_) {}

DocumentDelete::DocumentDelete(
    ::google::protobuf::Arena* arena,
    const DocumentDelete& from)
    : ::google::protobuf::Message(arena) {
  DocumentDelete* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);
  ::uint32_t cached_has_bits = _impl_._has_bits_[0];
  _impl_.read_time_ = (cached_has_bits & 0x00000001u)
                ? CreateMaybeMessage<::google::protobuf::Timestamp>(arena, *from._impl_.read_time_)
                : nullptr;

  // @@protoc_insertion_point(copy_constructor:google.firestore.v1.DocumentDelete)
}
inline PROTOBUF_NDEBUG_INLINE DocumentDelete::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : _cached_size_{0},
        removed_target_ids_{visibility, arena},
        _removed_target_ids_cached_byte_size_{0},
        document_(arena) {}

inline void DocumentDelete::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
  _impl_.read_time_ = {};
}
DocumentDelete::~DocumentDelete() {
  // @@protoc_insertion_point(destructor:google.firestore.v1.DocumentDelete)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void DocumentDelete::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  _impl_.document_.Destroy();
  delete _impl_.read_time_;
  _impl_.~Impl_();
}

PROTOBUF_NOINLINE void DocumentDelete::Clear() {
// @@protoc_insertion_point(message_clear_start:google.firestore.v1.DocumentDelete)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  _impl_.removed_target_ids_.Clear();
  _impl_.document_.ClearToEmpty();
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000001u) {
    ABSL_DCHECK(_impl_.read_time_ != nullptr);
    _impl_.read_time_->Clear();
  }
  _impl_._has_bits_.Clear();
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* DocumentDelete::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<2, 3, 1, 51, 2> DocumentDelete::_table_ = {
  {
    PROTOBUF_FIELD_OFFSET(DocumentDelete, _impl_._has_bits_),
    0, // no _extensions_
    6, 24,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294967254,  // skipmap
    offsetof(decltype(_table_), field_entries),
    3,  // num_field_entries
    1,  // num_aux_entries
    offsetof(decltype(_table_), aux_entries),
    &_DocumentDelete_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    // .google.protobuf.Timestamp read_time = 4;
    {::_pbi::TcParser::FastMtS1,
     {34, 0, 0, PROTOBUF_FIELD_OFFSET(DocumentDelete, _impl_.read_time_)}},
    // string document = 1;
    {::_pbi::TcParser::FastUS1,
     {10, 63, 0, PROTOBUF_FIELD_OFFSET(DocumentDelete, _impl_.document_)}},
    // repeated int32 removed_target_ids = 6;
    {::_pbi::TcParser::FastV32P1,
     {50, 63, 0, PROTOBUF_FIELD_OFFSET(DocumentDelete, _impl_.removed_target_ids_)}},
    {::_pbi::TcParser::MiniParse, {}},
  }}, {{
    65535, 65535
  }}, {{
    // string document = 1;
    {PROTOBUF_FIELD_OFFSET(DocumentDelete, _impl_.document_), -1, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // .google.protobuf.Timestamp read_time = 4;
    {PROTOBUF_FIELD_OFFSET(DocumentDelete, _impl_.read_time_), _Internal::kHasBitsOffset + 0, 0,
    (0 | ::_fl::kFcOptional | ::_fl::kMessage | ::_fl::kTvTable)},
    // repeated int32 removed_target_ids = 6;
    {PROTOBUF_FIELD_OFFSET(DocumentDelete, _impl_.removed_target_ids_), -1, 0,
    (0 | ::_fl::kFcRepeated | ::_fl::kPackedInt32)},
  }}, {{
    {::_pbi::TcParser::GetTable<::google::protobuf::Timestamp>()},
  }}, {{
    "\42\10\0\0\0\0\0\0"
    "google.firestore.v1.DocumentDelete"
    "document"
  }},
};

::uint8_t* DocumentDelete::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.firestore.v1.DocumentDelete)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  // string document = 1;
  if (!this->_internal_document().empty()) {
    const std::string& _s = this->_internal_document();
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
        _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.firestore.v1.DocumentDelete.document");
    target = stream->WriteStringMaybeAliased(1, _s, target);
  }

  cached_has_bits = _impl_._has_bits_[0];
  // .google.protobuf.Timestamp read_time = 4;
  if (cached_has_bits & 0x00000001u) {
    target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
        4, _Internal::read_time(this),
        _Internal::read_time(this).GetCachedSize(), target, stream);
  }

  // repeated int32 removed_target_ids = 6;
  {
    int byte_size = _impl_._removed_target_ids_cached_byte_size_.Get();
    if (byte_size > 0) {
      target = stream->WriteInt32Packed(
          6, _internal_removed_target_ids(), byte_size, target);
    }
  }

  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.firestore.v1.DocumentDelete)
  return target;
}

::size_t DocumentDelete::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.firestore.v1.DocumentDelete)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // repeated int32 removed_target_ids = 6;
  {
    std::size_t data_size = ::_pbi::WireFormatLite::Int32Size(
        this->_internal_removed_target_ids())
    ;
    _impl_._removed_target_ids_cached_byte_size_.Set(::_pbi::ToCachedSize(data_size));
    std::size_t tag_size = data_size == 0
        ? 0
        : 1 + ::_pbi::WireFormatLite::Int32Size(
                            static_cast<int32_t>(data_size))
    ;
    total_size += tag_size + data_size;
  }
  // string document = 1;
  if (!this->_internal_document().empty()) {
    total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                    this->_internal_document());
  }

  // .google.protobuf.Timestamp read_time = 4;
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000001u) {
    total_size +=
        1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.read_time_);
  }

  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData DocumentDelete::_class_data_ = {
    DocumentDelete::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* DocumentDelete::GetClassData() const {
  return &_class_data_;
}

void DocumentDelete::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<DocumentDelete*>(&to_msg);
  auto& from = static_cast<const DocumentDelete&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.firestore.v1.DocumentDelete)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  _this->_internal_mutable_removed_target_ids()->MergeFrom(from._internal_removed_target_ids());
  if (!from._internal_document().empty()) {
    _this->_internal_set_document(from._internal_document());
  }
  if ((from._impl_._has_bits_[0] & 0x00000001u) != 0) {
    _this->_internal_mutable_read_time()->::google::protobuf::Timestamp::MergeFrom(
        from._internal_read_time());
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void DocumentDelete::CopyFrom(const DocumentDelete& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.firestore.v1.DocumentDelete)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool DocumentDelete::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* DocumentDelete::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void DocumentDelete::InternalSwap(DocumentDelete* PROTOBUF_RESTRICT other) {
  using std::swap;
  auto* arena = GetArena();
  ABSL_DCHECK_EQ(arena, other->GetArena());
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  swap(_impl_._has_bits_[0], other->_impl_._has_bits_[0]);
  _impl_.removed_target_ids_.InternalSwap(&other->_impl_.removed_target_ids_);
  ::_pbi::ArenaStringPtr::InternalSwap(&_impl_.document_, &other->_impl_.document_, arena);
  swap(_impl_.read_time_, other->_impl_.read_time_);
}

::google::protobuf::Metadata DocumentDelete::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_getter, &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_once,
      file_level_metadata_google_2ffirestore_2fv1_2fwrite_2eproto[5]);
}
// ===================================================================

class DocumentRemove::_Internal {
 public:
  using HasBits = decltype(std::declval<DocumentRemove>()._impl_._has_bits_);
  static constexpr ::int32_t kHasBitsOffset =
    8 * PROTOBUF_FIELD_OFFSET(DocumentRemove, _impl_._has_bits_);
  static const ::google::protobuf::Timestamp& read_time(const DocumentRemove* msg);
  static void set_has_read_time(HasBits* has_bits) {
    (*has_bits)[0] |= 1u;
  }
};

const ::google::protobuf::Timestamp& DocumentRemove::_Internal::read_time(const DocumentRemove* msg) {
  return *msg->_impl_.read_time_;
}
void DocumentRemove::clear_read_time() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (_impl_.read_time_ != nullptr) _impl_.read_time_->Clear();
  _impl_._has_bits_[0] &= ~0x00000001u;
}
DocumentRemove::DocumentRemove(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.firestore.v1.DocumentRemove)
}
inline PROTOBUF_NDEBUG_INLINE DocumentRemove::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : _has_bits_{from._has_bits_},
        _cached_size_{0},
        removed_target_ids_{visibility, arena, from.removed_target_ids_},
        _removed_target_ids_cached_byte_size_{0},
        document_(arena, from.document_) {}

DocumentRemove::DocumentRemove(
    ::google::protobuf::Arena* arena,
    const DocumentRemove& from)
    : ::google::protobuf::Message(arena) {
  DocumentRemove* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);
  ::uint32_t cached_has_bits = _impl_._has_bits_[0];
  _impl_.read_time_ = (cached_has_bits & 0x00000001u)
                ? CreateMaybeMessage<::google::protobuf::Timestamp>(arena, *from._impl_.read_time_)
                : nullptr;

  // @@protoc_insertion_point(copy_constructor:google.firestore.v1.DocumentRemove)
}
inline PROTOBUF_NDEBUG_INLINE DocumentRemove::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : _cached_size_{0},
        removed_target_ids_{visibility, arena},
        _removed_target_ids_cached_byte_size_{0},
        document_(arena) {}

inline void DocumentRemove::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
  _impl_.read_time_ = {};
}
DocumentRemove::~DocumentRemove() {
  // @@protoc_insertion_point(destructor:google.firestore.v1.DocumentRemove)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void DocumentRemove::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  _impl_.document_.Destroy();
  delete _impl_.read_time_;
  _impl_.~Impl_();
}

PROTOBUF_NOINLINE void DocumentRemove::Clear() {
// @@protoc_insertion_point(message_clear_start:google.firestore.v1.DocumentRemove)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  _impl_.removed_target_ids_.Clear();
  _impl_.document_.ClearToEmpty();
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000001u) {
    ABSL_DCHECK(_impl_.read_time_ != nullptr);
    _impl_.read_time_->Clear();
  }
  _impl_._has_bits_.Clear();
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* DocumentRemove::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<2, 3, 1, 51, 2> DocumentRemove::_table_ = {
  {
    PROTOBUF_FIELD_OFFSET(DocumentRemove, _impl_._has_bits_),
    0, // no _extensions_
    4, 24,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294967284,  // skipmap
    offsetof(decltype(_table_), field_entries),
    3,  // num_field_entries
    1,  // num_aux_entries
    offsetof(decltype(_table_), aux_entries),
    &_DocumentRemove_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    // .google.protobuf.Timestamp read_time = 4;
    {::_pbi::TcParser::FastMtS1,
     {34, 0, 0, PROTOBUF_FIELD_OFFSET(DocumentRemove, _impl_.read_time_)}},
    // string document = 1;
    {::_pbi::TcParser::FastUS1,
     {10, 63, 0, PROTOBUF_FIELD_OFFSET(DocumentRemove, _impl_.document_)}},
    // repeated int32 removed_target_ids = 2;
    {::_pbi::TcParser::FastV32P1,
     {18, 63, 0, PROTOBUF_FIELD_OFFSET(DocumentRemove, _impl_.removed_target_ids_)}},
    {::_pbi::TcParser::MiniParse, {}},
  }}, {{
    65535, 65535
  }}, {{
    // string document = 1;
    {PROTOBUF_FIELD_OFFSET(DocumentRemove, _impl_.document_), -1, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // repeated int32 removed_target_ids = 2;
    {PROTOBUF_FIELD_OFFSET(DocumentRemove, _impl_.removed_target_ids_), -1, 0,
    (0 | ::_fl::kFcRepeated | ::_fl::kPackedInt32)},
    // .google.protobuf.Timestamp read_time = 4;
    {PROTOBUF_FIELD_OFFSET(DocumentRemove, _impl_.read_time_), _Internal::kHasBitsOffset + 0, 0,
    (0 | ::_fl::kFcOptional | ::_fl::kMessage | ::_fl::kTvTable)},
  }}, {{
    {::_pbi::TcParser::GetTable<::google::protobuf::Timestamp>()},
  }}, {{
    "\42\10\0\0\0\0\0\0"
    "google.firestore.v1.DocumentRemove"
    "document"
  }},
};

::uint8_t* DocumentRemove::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.firestore.v1.DocumentRemove)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  // string document = 1;
  if (!this->_internal_document().empty()) {
    const std::string& _s = this->_internal_document();
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
        _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.firestore.v1.DocumentRemove.document");
    target = stream->WriteStringMaybeAliased(1, _s, target);
  }

  // repeated int32 removed_target_ids = 2;
  {
    int byte_size = _impl_._removed_target_ids_cached_byte_size_.Get();
    if (byte_size > 0) {
      target = stream->WriteInt32Packed(
          2, _internal_removed_target_ids(), byte_size, target);
    }
  }

  cached_has_bits = _impl_._has_bits_[0];
  // .google.protobuf.Timestamp read_time = 4;
  if (cached_has_bits & 0x00000001u) {
    target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
        4, _Internal::read_time(this),
        _Internal::read_time(this).GetCachedSize(), target, stream);
  }

  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.firestore.v1.DocumentRemove)
  return target;
}

::size_t DocumentRemove::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.firestore.v1.DocumentRemove)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // repeated int32 removed_target_ids = 2;
  {
    std::size_t data_size = ::_pbi::WireFormatLite::Int32Size(
        this->_internal_removed_target_ids())
    ;
    _impl_._removed_target_ids_cached_byte_size_.Set(::_pbi::ToCachedSize(data_size));
    std::size_t tag_size = data_size == 0
        ? 0
        : 1 + ::_pbi::WireFormatLite::Int32Size(
                            static_cast<int32_t>(data_size))
    ;
    total_size += tag_size + data_size;
  }
  // string document = 1;
  if (!this->_internal_document().empty()) {
    total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                    this->_internal_document());
  }

  // .google.protobuf.Timestamp read_time = 4;
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000001u) {
    total_size +=
        1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.read_time_);
  }

  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData DocumentRemove::_class_data_ = {
    DocumentRemove::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* DocumentRemove::GetClassData() const {
  return &_class_data_;
}

void DocumentRemove::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<DocumentRemove*>(&to_msg);
  auto& from = static_cast<const DocumentRemove&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.firestore.v1.DocumentRemove)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  _this->_internal_mutable_removed_target_ids()->MergeFrom(from._internal_removed_target_ids());
  if (!from._internal_document().empty()) {
    _this->_internal_set_document(from._internal_document());
  }
  if ((from._impl_._has_bits_[0] & 0x00000001u) != 0) {
    _this->_internal_mutable_read_time()->::google::protobuf::Timestamp::MergeFrom(
        from._internal_read_time());
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void DocumentRemove::CopyFrom(const DocumentRemove& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.firestore.v1.DocumentRemove)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool DocumentRemove::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* DocumentRemove::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void DocumentRemove::InternalSwap(DocumentRemove* PROTOBUF_RESTRICT other) {
  using std::swap;
  auto* arena = GetArena();
  ABSL_DCHECK_EQ(arena, other->GetArena());
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  swap(_impl_._has_bits_[0], other->_impl_._has_bits_[0]);
  _impl_.removed_target_ids_.InternalSwap(&other->_impl_.removed_target_ids_);
  ::_pbi::ArenaStringPtr::InternalSwap(&_impl_.document_, &other->_impl_.document_, arena);
  swap(_impl_.read_time_, other->_impl_.read_time_);
}

::google::protobuf::Metadata DocumentRemove::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_getter, &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_once,
      file_level_metadata_google_2ffirestore_2fv1_2fwrite_2eproto[6]);
}
// ===================================================================

class ExistenceFilter::_Internal {
 public:
  using HasBits = decltype(std::declval<ExistenceFilter>()._impl_._has_bits_);
  static constexpr ::int32_t kHasBitsOffset =
    8 * PROTOBUF_FIELD_OFFSET(ExistenceFilter, _impl_._has_bits_);
  static const ::google::firestore::v1::BloomFilter& unchanged_names(const ExistenceFilter* msg);
  static void set_has_unchanged_names(HasBits* has_bits) {
    (*has_bits)[0] |= 1u;
  }
};

const ::google::firestore::v1::BloomFilter& ExistenceFilter::_Internal::unchanged_names(const ExistenceFilter* msg) {
  return *msg->_impl_.unchanged_names_;
}
void ExistenceFilter::clear_unchanged_names() {
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  if (_impl_.unchanged_names_ != nullptr) _impl_.unchanged_names_->Clear();
  _impl_._has_bits_[0] &= ~0x00000001u;
}
ExistenceFilter::ExistenceFilter(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.firestore.v1.ExistenceFilter)
}
inline PROTOBUF_NDEBUG_INLINE ExistenceFilter::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : _has_bits_{from._has_bits_},
        _cached_size_{0} {}

ExistenceFilter::ExistenceFilter(
    ::google::protobuf::Arena* arena,
    const ExistenceFilter& from)
    : ::google::protobuf::Message(arena) {
  ExistenceFilter* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);
  ::uint32_t cached_has_bits = _impl_._has_bits_[0];
  _impl_.unchanged_names_ = (cached_has_bits & 0x00000001u)
                ? CreateMaybeMessage<::google::firestore::v1::BloomFilter>(arena, *from._impl_.unchanged_names_)
                : nullptr;
  ::memcpy(reinterpret_cast<char *>(&_impl_) +
               offsetof(Impl_, target_id_),
           reinterpret_cast<const char *>(&from._impl_) +
               offsetof(Impl_, target_id_),
           offsetof(Impl_, count_) -
               offsetof(Impl_, target_id_) +
               sizeof(Impl_::count_));

  // @@protoc_insertion_point(copy_constructor:google.firestore.v1.ExistenceFilter)
}
inline PROTOBUF_NDEBUG_INLINE ExistenceFilter::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : _cached_size_{0} {}

inline void ExistenceFilter::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
  ::memset(reinterpret_cast<char *>(&_impl_) +
               offsetof(Impl_, unchanged_names_),
           0,
           offsetof(Impl_, count_) -
               offsetof(Impl_, unchanged_names_) +
               sizeof(Impl_::count_));
}
ExistenceFilter::~ExistenceFilter() {
  // @@protoc_insertion_point(destructor:google.firestore.v1.ExistenceFilter)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void ExistenceFilter::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  delete _impl_.unchanged_names_;
  _impl_.~Impl_();
}

PROTOBUF_NOINLINE void ExistenceFilter::Clear() {
// @@protoc_insertion_point(message_clear_start:google.firestore.v1.ExistenceFilter)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000001u) {
    ABSL_DCHECK(_impl_.unchanged_names_ != nullptr);
    _impl_.unchanged_names_->Clear();
  }
  ::memset(&_impl_.target_id_, 0, static_cast<::size_t>(
      reinterpret_cast<char*>(&_impl_.count_) -
      reinterpret_cast<char*>(&_impl_.target_id_)) + sizeof(_impl_.count_));
  _impl_._has_bits_.Clear();
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* ExistenceFilter::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<2, 3, 1, 0, 2> ExistenceFilter::_table_ = {
  {
    PROTOBUF_FIELD_OFFSET(ExistenceFilter, _impl_._has_bits_),
    0, // no _extensions_
    3, 24,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294967288,  // skipmap
    offsetof(decltype(_table_), field_entries),
    3,  // num_field_entries
    1,  // num_aux_entries
    offsetof(decltype(_table_), aux_entries),
    &_ExistenceFilter_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    {::_pbi::TcParser::MiniParse, {}},
    // int32 target_id = 1;
    {::_pbi::TcParser::SingularVarintNoZag1<::uint32_t, offsetof(ExistenceFilter, _impl_.target_id_), 63>(),
     {8, 63, 0, PROTOBUF_FIELD_OFFSET(ExistenceFilter, _impl_.target_id_)}},
    // int32 count = 2;
    {::_pbi::TcParser::SingularVarintNoZag1<::uint32_t, offsetof(ExistenceFilter, _impl_.count_), 63>(),
     {16, 63, 0, PROTOBUF_FIELD_OFFSET(ExistenceFilter, _impl_.count_)}},
    // .google.firestore.v1.BloomFilter unchanged_names = 3;
    {::_pbi::TcParser::FastMtS1,
     {26, 0, 0, PROTOBUF_FIELD_OFFSET(ExistenceFilter, _impl_.unchanged_names_)}},
  }}, {{
    65535, 65535
  }}, {{
    // int32 target_id = 1;
    {PROTOBUF_FIELD_OFFSET(ExistenceFilter, _impl_.target_id_), -1, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kInt32)},
    // int32 count = 2;
    {PROTOBUF_FIELD_OFFSET(ExistenceFilter, _impl_.count_), -1, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kInt32)},
    // .google.firestore.v1.BloomFilter unchanged_names = 3;
    {PROTOBUF_FIELD_OFFSET(ExistenceFilter, _impl_.unchanged_names_), _Internal::kHasBitsOffset + 0, 0,
    (0 | ::_fl::kFcOptional | ::_fl::kMessage | ::_fl::kTvTable)},
  }}, {{
    {::_pbi::TcParser::GetTable<::google::firestore::v1::BloomFilter>()},
  }}, {{
  }},
};

::uint8_t* ExistenceFilter::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.firestore.v1.ExistenceFilter)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  // int32 target_id = 1;
  if (this->_internal_target_id() != 0) {
    target = ::google::protobuf::internal::WireFormatLite::
        WriteInt32ToArrayWithField<1>(
            stream, this->_internal_target_id(), target);
  }

  // int32 count = 2;
  if (this->_internal_count() != 0) {
    target = ::google::protobuf::internal::WireFormatLite::
        WriteInt32ToArrayWithField<2>(
            stream, this->_internal_count(), target);
  }

  cached_has_bits = _impl_._has_bits_[0];
  // .google.firestore.v1.BloomFilter unchanged_names = 3;
  if (cached_has_bits & 0x00000001u) {
    target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
        3, _Internal::unchanged_names(this),
        _Internal::unchanged_names(this).GetCachedSize(), target, stream);
  }

  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.firestore.v1.ExistenceFilter)
  return target;
}

::size_t ExistenceFilter::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.firestore.v1.ExistenceFilter)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // .google.firestore.v1.BloomFilter unchanged_names = 3;
  cached_has_bits = _impl_._has_bits_[0];
  if (cached_has_bits & 0x00000001u) {
    total_size +=
        1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.unchanged_names_);
  }

  // int32 target_id = 1;
  if (this->_internal_target_id() != 0) {
    total_size += ::_pbi::WireFormatLite::Int32SizePlusOne(
        this->_internal_target_id());
  }

  // int32 count = 2;
  if (this->_internal_count() != 0) {
    total_size += ::_pbi::WireFormatLite::Int32SizePlusOne(
        this->_internal_count());
  }

  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData ExistenceFilter::_class_data_ = {
    ExistenceFilter::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* ExistenceFilter::GetClassData() const {
  return &_class_data_;
}

void ExistenceFilter::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<ExistenceFilter*>(&to_msg);
  auto& from = static_cast<const ExistenceFilter&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.firestore.v1.ExistenceFilter)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  if ((from._impl_._has_bits_[0] & 0x00000001u) != 0) {
    _this->_internal_mutable_unchanged_names()->::google::firestore::v1::BloomFilter::MergeFrom(
        from._internal_unchanged_names());
  }
  if (from._internal_target_id() != 0) {
    _this->_internal_set_target_id(from._internal_target_id());
  }
  if (from._internal_count() != 0) {
    _this->_internal_set_count(from._internal_count());
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void ExistenceFilter::CopyFrom(const ExistenceFilter& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.firestore.v1.ExistenceFilter)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool ExistenceFilter::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* ExistenceFilter::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void ExistenceFilter::InternalSwap(ExistenceFilter* PROTOBUF_RESTRICT other) {
  using std::swap;
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  swap(_impl_._has_bits_[0], other->_impl_._has_bits_[0]);
  ::google::protobuf::internal::memswap<
      PROTOBUF_FIELD_OFFSET(ExistenceFilter, _impl_.count_)
      + sizeof(ExistenceFilter::_impl_.count_)
      - PROTOBUF_FIELD_OFFSET(ExistenceFilter, _impl_.unchanged_names_)>(
          reinterpret_cast<char*>(&_impl_.unchanged_names_),
          reinterpret_cast<char*>(&other->_impl_.unchanged_names_));
}

::google::protobuf::Metadata ExistenceFilter::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_getter, &descriptor_table_google_2ffirestore_2fv1_2fwrite_2eproto_once,
      file_level_metadata_google_2ffirestore_2fv1_2fwrite_2eproto[7]);
}
// @@protoc_insertion_point(namespace_scope)
}  // namespace v1
}  // namespace firestore
}  // namespace google
namespace google {
namespace protobuf {
}  // namespace protobuf
}  // namespace google
// @@protoc_insertion_point(global_scope)
#include "google/protobuf/port_undef.inc"
