/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/http.proto

#include "google/api/http.pb.h"

#include <algorithm>
#include "google/protobuf/io/coded_stream.h"
#include "google/protobuf/extension_set.h"
#include "google/protobuf/wire_format_lite.h"
#include "google/protobuf/descriptor.h"
#include "google/protobuf/generated_message_reflection.h"
#include "google/protobuf/reflection_ops.h"
#include "google/protobuf/wire_format.h"
#include "google/protobuf/generated_message_tctable_impl.h"
// @@protoc_insertion_point(includes)

// Must be included last.
#include "google/protobuf/port_def.inc"
PROTOBUF_PRAGMA_INIT_SEG
namespace _pb = ::google::protobuf;
namespace _pbi = ::google::protobuf::internal;
namespace _fl = ::google::protobuf::internal::field_layout;
namespace google {
namespace api {

inline constexpr CustomHttpPattern::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : kind_(
            &::google::protobuf::internal::fixed_address_empty_string,
            ::_pbi::ConstantInitialized()),
        path_(
            &::google::protobuf::internal::fixed_address_empty_string,
            ::_pbi::ConstantInitialized()),
        _cached_size_{0} {}

template <typename>
PROTOBUF_CONSTEXPR CustomHttpPattern::CustomHttpPattern(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct CustomHttpPatternDefaultTypeInternal {
  PROTOBUF_CONSTEXPR CustomHttpPatternDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~CustomHttpPatternDefaultTypeInternal() {}
  union {
    CustomHttpPattern _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 CustomHttpPatternDefaultTypeInternal _CustomHttpPattern_default_instance_;

inline constexpr HttpRule::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : additional_bindings_{},
        selector_(
            &::google::protobuf::internal::fixed_address_empty_string,
            ::_pbi::ConstantInitialized()),
        body_(
            &::google::protobuf::internal::fixed_address_empty_string,
            ::_pbi::ConstantInitialized()),
        pattern_{},
        _cached_size_{0},
        _oneof_case_{} {}

template <typename>
PROTOBUF_CONSTEXPR HttpRule::HttpRule(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct HttpRuleDefaultTypeInternal {
  PROTOBUF_CONSTEXPR HttpRuleDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~HttpRuleDefaultTypeInternal() {}
  union {
    HttpRule _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 HttpRuleDefaultTypeInternal _HttpRule_default_instance_;

inline constexpr Http::Impl_::Impl_(
    ::_pbi::ConstantInitialized) noexcept
      : rules_{},
        fully_decode_reserved_expansion_{false},
        _cached_size_{0} {}

template <typename>
PROTOBUF_CONSTEXPR Http::Http(::_pbi::ConstantInitialized)
    : _impl_(::_pbi::ConstantInitialized()) {}
struct HttpDefaultTypeInternal {
  PROTOBUF_CONSTEXPR HttpDefaultTypeInternal() : _instance(::_pbi::ConstantInitialized{}) {}
  ~HttpDefaultTypeInternal() {}
  union {
    Http _instance;
  };
};

PROTOBUF_ATTRIBUTE_NO_DESTROY PROTOBUF_CONSTINIT
    PROTOBUF_ATTRIBUTE_INIT_PRIORITY1 HttpDefaultTypeInternal _Http_default_instance_;
}  // namespace api
}  // namespace google
static ::_pb::Metadata file_level_metadata_google_2fapi_2fhttp_2eproto[3];
static constexpr const ::_pb::EnumDescriptor**
    file_level_enum_descriptors_google_2fapi_2fhttp_2eproto = nullptr;
static constexpr const ::_pb::ServiceDescriptor**
    file_level_service_descriptors_google_2fapi_2fhttp_2eproto = nullptr;
const ::uint32_t TableStruct_google_2fapi_2fhttp_2eproto::offsets[] PROTOBUF_SECTION_VARIABLE(
    protodesc_cold) = {
    ~0u,  // no _has_bits_
    PROTOBUF_FIELD_OFFSET(::google::api::Http, _internal_metadata_),
    ~0u,  // no _extensions_
    ~0u,  // no _oneof_case_
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    PROTOBUF_FIELD_OFFSET(::google::api::Http, _impl_.rules_),
    PROTOBUF_FIELD_OFFSET(::google::api::Http, _impl_.fully_decode_reserved_expansion_),
    ~0u,  // no _has_bits_
    PROTOBUF_FIELD_OFFSET(::google::api::HttpRule, _internal_metadata_),
    ~0u,  // no _extensions_
    PROTOBUF_FIELD_OFFSET(::google::api::HttpRule, _impl_._oneof_case_[0]),
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    PROTOBUF_FIELD_OFFSET(::google::api::HttpRule, _impl_.selector_),
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    ::_pbi::kInvalidFieldOffsetTag,
    PROTOBUF_FIELD_OFFSET(::google::api::HttpRule, _impl_.body_),
    PROTOBUF_FIELD_OFFSET(::google::api::HttpRule, _impl_.additional_bindings_),
    PROTOBUF_FIELD_OFFSET(::google::api::HttpRule, _impl_.pattern_),
    ~0u,  // no _has_bits_
    PROTOBUF_FIELD_OFFSET(::google::api::CustomHttpPattern, _internal_metadata_),
    ~0u,  // no _extensions_
    ~0u,  // no _oneof_case_
    ~0u,  // no _weak_field_map_
    ~0u,  // no _inlined_string_donated_
    ~0u,  // no _split_
    ~0u,  // no sizeof(Split)
    PROTOBUF_FIELD_OFFSET(::google::api::CustomHttpPattern, _impl_.kind_),
    PROTOBUF_FIELD_OFFSET(::google::api::CustomHttpPattern, _impl_.path_),
};

static const ::_pbi::MigrationSchema
    schemas[] PROTOBUF_SECTION_VARIABLE(protodesc_cold) = {
        {0, -1, -1, sizeof(::google::api::Http)},
        {10, -1, -1, sizeof(::google::api::HttpRule)},
        {28, -1, -1, sizeof(::google::api::CustomHttpPattern)},
};

static const ::_pb::Message* const file_default_instances[] = {
    &::google::api::_Http_default_instance_._instance,
    &::google::api::_HttpRule_default_instance_._instance,
    &::google::api::_CustomHttpPattern_default_instance_._instance,
};
const char descriptor_table_protodef_google_2fapi_2fhttp_2eproto[] PROTOBUF_SECTION_VARIABLE(protodesc_cold) = {
    "\n\025google/api/http.proto\022\ngoogle.api\"T\n\004H"
    "ttp\022#\n\005rules\030\001 \003(\0132\024.google.api.HttpRule"
    "\022\'\n\037fully_decode_reserved_expansion\030\002 \001("
    "\010\"\352\001\n\010HttpRule\022\020\n\010selector\030\001 \001(\t\022\r\n\003get\030"
    "\002 \001(\tH\000\022\r\n\003put\030\003 \001(\tH\000\022\016\n\004post\030\004 \001(\tH\000\022\020"
    "\n\006delete\030\005 \001(\tH\000\022\017\n\005patch\030\006 \001(\tH\000\022/\n\006cus"
    "tom\030\010 \001(\0132\035.google.api.CustomHttpPattern"
    "H\000\022\014\n\004body\030\007 \001(\t\0221\n\023additional_bindings\030"
    "\013 \003(\0132\024.google.api.HttpRuleB\t\n\007pattern\"/"
    "\n\021CustomHttpPattern\022\014\n\004kind\030\001 \001(\t\022\014\n\004pat"
    "h\030\002 \001(\tBj\n\016com.google.apiB\tHttpProtoP\001ZA"
    "google.golang.org/genproto/googleapis/ap"
    "i/annotations;annotations\370\001\001\242\002\004GAPIb\006pro"
    "to3"
};
static ::absl::once_flag descriptor_table_google_2fapi_2fhttp_2eproto_once;
const ::_pbi::DescriptorTable descriptor_table_google_2fapi_2fhttp_2eproto = {
    false,
    false,
    523,
    descriptor_table_protodef_google_2fapi_2fhttp_2eproto,
    "google/api/http.proto",
    &descriptor_table_google_2fapi_2fhttp_2eproto_once,
    nullptr,
    0,
    3,
    schemas,
    file_default_instances,
    TableStruct_google_2fapi_2fhttp_2eproto::offsets,
    file_level_metadata_google_2fapi_2fhttp_2eproto,
    file_level_enum_descriptors_google_2fapi_2fhttp_2eproto,
    file_level_service_descriptors_google_2fapi_2fhttp_2eproto,
};

// This function exists to be marked as weak.
// It can significantly speed up compilation by breaking up LLVM's SCC
// in the .pb.cc translation units. Large translation units see a
// reduction of more than 35% of walltime for optimized builds. Without
// the weak attribute all the messages in the file, including all the
// vtables and everything they use become part of the same SCC through
// a cycle like:
// GetMetadata -> descriptor table -> default instances ->
//   vtables -> GetMetadata
// By adding a weak function here we break the connection from the
// individual vtables back into the descriptor table.
PROTOBUF_ATTRIBUTE_WEAK const ::_pbi::DescriptorTable* descriptor_table_google_2fapi_2fhttp_2eproto_getter() {
  return &descriptor_table_google_2fapi_2fhttp_2eproto;
}
// Force running AddDescriptors() at dynamic initialization time.
PROTOBUF_ATTRIBUTE_INIT_PRIORITY2
static ::_pbi::AddDescriptorsRunner dynamic_init_dummy_google_2fapi_2fhttp_2eproto(&descriptor_table_google_2fapi_2fhttp_2eproto);
namespace google {
namespace api {
// ===================================================================

class Http::_Internal {
 public:
};

Http::Http(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.api.Http)
}
inline PROTOBUF_NDEBUG_INLINE Http::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : rules_{visibility, arena, from.rules_},
        _cached_size_{0} {}

Http::Http(
    ::google::protobuf::Arena* arena,
    const Http& from)
    : ::google::protobuf::Message(arena) {
  Http* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);
  _impl_.fully_decode_reserved_expansion_ = from._impl_.fully_decode_reserved_expansion_;

  // @@protoc_insertion_point(copy_constructor:google.api.Http)
}
inline PROTOBUF_NDEBUG_INLINE Http::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : rules_{visibility, arena},
        _cached_size_{0} {}

inline void Http::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
  _impl_.fully_decode_reserved_expansion_ = {};
}
Http::~Http() {
  // @@protoc_insertion_point(destructor:google.api.Http)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void Http::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  _impl_.~Impl_();
}

PROTOBUF_NOINLINE void Http::Clear() {
// @@protoc_insertion_point(message_clear_start:google.api.Http)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  _impl_.rules_.Clear();
  _impl_.fully_decode_reserved_expansion_ = false;
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* Http::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<1, 2, 1, 0, 2> Http::_table_ = {
  {
    0,  // no _has_bits_
    0, // no _extensions_
    2, 8,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294967292,  // skipmap
    offsetof(decltype(_table_), field_entries),
    2,  // num_field_entries
    1,  // num_aux_entries
    offsetof(decltype(_table_), aux_entries),
    &_Http_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    // bool fully_decode_reserved_expansion = 2;
    {::_pbi::TcParser::SingularVarintNoZag1<bool, offsetof(Http, _impl_.fully_decode_reserved_expansion_), 63>(),
     {16, 63, 0, PROTOBUF_FIELD_OFFSET(Http, _impl_.fully_decode_reserved_expansion_)}},
    // repeated .google.api.HttpRule rules = 1;
    {::_pbi::TcParser::FastMtR1,
     {10, 63, 0, PROTOBUF_FIELD_OFFSET(Http, _impl_.rules_)}},
  }}, {{
    65535, 65535
  }}, {{
    // repeated .google.api.HttpRule rules = 1;
    {PROTOBUF_FIELD_OFFSET(Http, _impl_.rules_), 0, 0,
    (0 | ::_fl::kFcRepeated | ::_fl::kMessage | ::_fl::kTvTable)},
    // bool fully_decode_reserved_expansion = 2;
    {PROTOBUF_FIELD_OFFSET(Http, _impl_.fully_decode_reserved_expansion_), 0, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kBool)},
  }}, {{
    {::_pbi::TcParser::GetTable<::google::api::HttpRule>()},
  }}, {{
  }},
};

::uint8_t* Http::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.api.Http)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  // repeated .google.api.HttpRule rules = 1;
  for (unsigned i = 0,
      n = static_cast<unsigned>(this->_internal_rules_size()); i < n; i++) {
    const auto& repfield = this->_internal_rules().Get(i);
    target = ::google::protobuf::internal::WireFormatLite::
        InternalWriteMessage(1, repfield, repfield.GetCachedSize(), target, stream);
  }

  // bool fully_decode_reserved_expansion = 2;
  if (this->_internal_fully_decode_reserved_expansion() != 0) {
    target = stream->EnsureSpace(target);
    target = ::_pbi::WireFormatLite::WriteBoolToArray(
        2, this->_internal_fully_decode_reserved_expansion(), target);
  }

  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.api.Http)
  return target;
}

::size_t Http::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.api.Http)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // repeated .google.api.HttpRule rules = 1;
  total_size += 1UL * this->_internal_rules_size();
  for (const auto& msg : this->_internal_rules()) {
    total_size +=
      ::google::protobuf::internal::WireFormatLite::MessageSize(msg);
  }
  // bool fully_decode_reserved_expansion = 2;
  if (this->_internal_fully_decode_reserved_expansion() != 0) {
    total_size += 2;
  }

  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData Http::_class_data_ = {
    Http::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* Http::GetClassData() const {
  return &_class_data_;
}

void Http::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<Http*>(&to_msg);
  auto& from = static_cast<const Http&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.api.Http)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  _this->_internal_mutable_rules()->MergeFrom(
      from._internal_rules());
  if (from._internal_fully_decode_reserved_expansion() != 0) {
    _this->_internal_set_fully_decode_reserved_expansion(from._internal_fully_decode_reserved_expansion());
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void Http::CopyFrom(const Http& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.api.Http)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool Http::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* Http::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void Http::InternalSwap(Http* PROTOBUF_RESTRICT other) {
  using std::swap;
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  _impl_.rules_.InternalSwap(&other->_impl_.rules_);
        swap(_impl_.fully_decode_reserved_expansion_, other->_impl_.fully_decode_reserved_expansion_);
}

::google::protobuf::Metadata Http::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2fapi_2fhttp_2eproto_getter, &descriptor_table_google_2fapi_2fhttp_2eproto_once,
      file_level_metadata_google_2fapi_2fhttp_2eproto[0]);
}
// ===================================================================

class HttpRule::_Internal {
 public:
  static constexpr ::int32_t kOneofCaseOffset =
    PROTOBUF_FIELD_OFFSET(::google::api::HttpRule, _impl_._oneof_case_);
  static const ::google::api::CustomHttpPattern& custom(const HttpRule* msg);
};

const ::google::api::CustomHttpPattern& HttpRule::_Internal::custom(const HttpRule* msg) {
  return *msg->_impl_.pattern_.custom_;
}
void HttpRule::set_allocated_custom(::google::api::CustomHttpPattern* custom) {
  ::google::protobuf::Arena* message_arena = GetArena();
  clear_pattern();
  if (custom) {
    ::google::protobuf::Arena* submessage_arena = custom->GetArena();
    if (message_arena != submessage_arena) {
      custom = ::google::protobuf::internal::GetOwnedMessage(message_arena, custom, submessage_arena);
    }
    set_has_custom();
    _impl_.pattern_.custom_ = custom;
  }
  // @@protoc_insertion_point(field_set_allocated:google.api.HttpRule.custom)
}
HttpRule::HttpRule(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.api.HttpRule)
}
inline PROTOBUF_NDEBUG_INLINE HttpRule::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : additional_bindings_{visibility, arena, from.additional_bindings_},
        selector_(arena, from.selector_),
        body_(arena, from.body_),
        pattern_{},
        _cached_size_{0},
        _oneof_case_{from._oneof_case_[0]} {}

HttpRule::HttpRule(
    ::google::protobuf::Arena* arena,
    const HttpRule& from)
    : ::google::protobuf::Message(arena) {
  HttpRule* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);
  switch (pattern_case()) {
    case PATTERN_NOT_SET:
      break;
      case kGet:
        new (&_impl_.pattern_.get_) decltype(_impl_.pattern_.get_){arena, from._impl_.pattern_.get_};
        break;
      case kPut:
        new (&_impl_.pattern_.put_) decltype(_impl_.pattern_.put_){arena, from._impl_.pattern_.put_};
        break;
      case kPost:
        new (&_impl_.pattern_.post_) decltype(_impl_.pattern_.post_){arena, from._impl_.pattern_.post_};
        break;
      case kDelete:
        new (&_impl_.pattern_.delete__) decltype(_impl_.pattern_.delete__){arena, from._impl_.pattern_.delete__};
        break;
      case kPatch:
        new (&_impl_.pattern_.patch_) decltype(_impl_.pattern_.patch_){arena, from._impl_.pattern_.patch_};
        break;
      case kCustom:
        _impl_.pattern_.custom_ = CreateMaybeMessage<::google::api::CustomHttpPattern>(arena, *from._impl_.pattern_.custom_);
        break;
  }

  // @@protoc_insertion_point(copy_constructor:google.api.HttpRule)
}
inline PROTOBUF_NDEBUG_INLINE HttpRule::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : additional_bindings_{visibility, arena},
        selector_(arena),
        body_(arena),
        pattern_{},
        _cached_size_{0},
        _oneof_case_{} {}

inline void HttpRule::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
}
HttpRule::~HttpRule() {
  // @@protoc_insertion_point(destructor:google.api.HttpRule)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void HttpRule::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  _impl_.selector_.Destroy();
  _impl_.body_.Destroy();
  if (has_pattern()) {
    clear_pattern();
  }
  _impl_.~Impl_();
}

void HttpRule::clear_pattern() {
// @@protoc_insertion_point(one_of_clear_start:google.api.HttpRule)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  switch (pattern_case()) {
    case kGet: {
      _impl_.pattern_.get_.Destroy();
      break;
    }
    case kPut: {
      _impl_.pattern_.put_.Destroy();
      break;
    }
    case kPost: {
      _impl_.pattern_.post_.Destroy();
      break;
    }
    case kDelete: {
      _impl_.pattern_.delete__.Destroy();
      break;
    }
    case kPatch: {
      _impl_.pattern_.patch_.Destroy();
      break;
    }
    case kCustom: {
      if (GetArena() == nullptr) {
        delete _impl_.pattern_.custom_;
      }
      break;
    }
    case PATTERN_NOT_SET: {
      break;
    }
  }
  _impl_._oneof_case_[0] = PATTERN_NOT_SET;
}


PROTOBUF_NOINLINE void HttpRule::Clear() {
// @@protoc_insertion_point(message_clear_start:google.api.HttpRule)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  _impl_.additional_bindings_.Clear();
  _impl_.selector_.ClearToEmpty();
  _impl_.body_.ClearToEmpty();
  clear_pattern();
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* HttpRule::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<3, 9, 2, 69, 2> HttpRule::_table_ = {
  {
    0,  // no _has_bits_
    0, // no _extensions_
    11, 56,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294966016,  // skipmap
    offsetof(decltype(_table_), field_entries),
    9,  // num_field_entries
    2,  // num_aux_entries
    offsetof(decltype(_table_), aux_entries),
    &_HttpRule_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    {::_pbi::TcParser::MiniParse, {}},
    // string selector = 1;
    {::_pbi::TcParser::FastUS1,
     {10, 63, 0, PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.selector_)}},
    {::_pbi::TcParser::MiniParse, {}},
    // repeated .google.api.HttpRule additional_bindings = 11;
    {::_pbi::TcParser::FastMtR1,
     {90, 63, 1, PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.additional_bindings_)}},
    {::_pbi::TcParser::MiniParse, {}},
    {::_pbi::TcParser::MiniParse, {}},
    {::_pbi::TcParser::MiniParse, {}},
    // string body = 7;
    {::_pbi::TcParser::FastUS1,
     {58, 63, 0, PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.body_)}},
  }}, {{
    65535, 65535
  }}, {{
    // string selector = 1;
    {PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.selector_), 0, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // string get = 2;
    {PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.pattern_.get_), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // string put = 3;
    {PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.pattern_.put_), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // string post = 4;
    {PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.pattern_.post_), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // string delete = 5;
    {PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.pattern_.delete__), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // string patch = 6;
    {PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.pattern_.patch_), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // string body = 7;
    {PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.body_), 0, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // .google.api.CustomHttpPattern custom = 8;
    {PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.pattern_.custom_), _Internal::kOneofCaseOffset + 0, 0,
    (0 | ::_fl::kFcOneof | ::_fl::kMessage | ::_fl::kTvTable)},
    // repeated .google.api.HttpRule additional_bindings = 11;
    {PROTOBUF_FIELD_OFFSET(HttpRule, _impl_.additional_bindings_), 0, 1,
    (0 | ::_fl::kFcRepeated | ::_fl::kMessage | ::_fl::kTvTable)},
  }}, {{
    {::_pbi::TcParser::GetTable<::google::api::CustomHttpPattern>()},
    {::_pbi::TcParser::GetTable<::google::api::HttpRule>()},
  }}, {{
    "\23\10\3\3\4\6\5\4\0\0\0\0\0\0\0\0"
    "google.api.HttpRule"
    "selector"
    "get"
    "put"
    "post"
    "delete"
    "patch"
    "body"
  }},
};

::uint8_t* HttpRule::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.api.HttpRule)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  // string selector = 1;
  if (!this->_internal_selector().empty()) {
    const std::string& _s = this->_internal_selector();
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
        _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.api.HttpRule.selector");
    target = stream->WriteStringMaybeAliased(1, _s, target);
  }

  switch (pattern_case()) {
    case kGet: {
      const std::string& _s = this->_internal_get();
      ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
          _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.api.HttpRule.get");
      target = stream->WriteStringMaybeAliased(2, _s, target);
      break;
    }
    case kPut: {
      const std::string& _s = this->_internal_put();
      ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
          _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.api.HttpRule.put");
      target = stream->WriteStringMaybeAliased(3, _s, target);
      break;
    }
    case kPost: {
      const std::string& _s = this->_internal_post();
      ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
          _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.api.HttpRule.post");
      target = stream->WriteStringMaybeAliased(4, _s, target);
      break;
    }
    case kDelete: {
      const std::string& _s = this->_internal_delete_();
      ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
          _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.api.HttpRule.delete");
      target = stream->WriteStringMaybeAliased(5, _s, target);
      break;
    }
    case kPatch: {
      const std::string& _s = this->_internal_patch();
      ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
          _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.api.HttpRule.patch");
      target = stream->WriteStringMaybeAliased(6, _s, target);
      break;
    }
    default:
      break;
  }
  // string body = 7;
  if (!this->_internal_body().empty()) {
    const std::string& _s = this->_internal_body();
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
        _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.api.HttpRule.body");
    target = stream->WriteStringMaybeAliased(7, _s, target);
  }

  // .google.api.CustomHttpPattern custom = 8;
  if (pattern_case() == kCustom) {
    target = ::google::protobuf::internal::WireFormatLite::InternalWriteMessage(
        8, _Internal::custom(this),
        _Internal::custom(this).GetCachedSize(), target, stream);
  }

  // repeated .google.api.HttpRule additional_bindings = 11;
  for (unsigned i = 0,
      n = static_cast<unsigned>(this->_internal_additional_bindings_size()); i < n; i++) {
    const auto& repfield = this->_internal_additional_bindings().Get(i);
    target = ::google::protobuf::internal::WireFormatLite::
        InternalWriteMessage(11, repfield, repfield.GetCachedSize(), target, stream);
  }

  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.api.HttpRule)
  return target;
}

::size_t HttpRule::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.api.HttpRule)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // repeated .google.api.HttpRule additional_bindings = 11;
  total_size += 1UL * this->_internal_additional_bindings_size();
  for (const auto& msg : this->_internal_additional_bindings()) {
    total_size +=
      ::google::protobuf::internal::WireFormatLite::MessageSize(msg);
  }
  // string selector = 1;
  if (!this->_internal_selector().empty()) {
    total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                    this->_internal_selector());
  }

  // string body = 7;
  if (!this->_internal_body().empty()) {
    total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                    this->_internal_body());
  }

  switch (pattern_case()) {
    // string get = 2;
    case kGet: {
      total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                      this->_internal_get());
      break;
    }
    // string put = 3;
    case kPut: {
      total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                      this->_internal_put());
      break;
    }
    // string post = 4;
    case kPost: {
      total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                      this->_internal_post());
      break;
    }
    // string delete = 5;
    case kDelete: {
      total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                      this->_internal_delete_());
      break;
    }
    // string patch = 6;
    case kPatch: {
      total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                      this->_internal_patch());
      break;
    }
    // .google.api.CustomHttpPattern custom = 8;
    case kCustom: {
      total_size +=
          1 + ::google::protobuf::internal::WireFormatLite::MessageSize(*_impl_.pattern_.custom_);
      break;
    }
    case PATTERN_NOT_SET: {
      break;
    }
  }
  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData HttpRule::_class_data_ = {
    HttpRule::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* HttpRule::GetClassData() const {
  return &_class_data_;
}

void HttpRule::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<HttpRule*>(&to_msg);
  auto& from = static_cast<const HttpRule&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.api.HttpRule)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  _this->_internal_mutable_additional_bindings()->MergeFrom(
      from._internal_additional_bindings());
  if (!from._internal_selector().empty()) {
    _this->_internal_set_selector(from._internal_selector());
  }
  if (!from._internal_body().empty()) {
    _this->_internal_set_body(from._internal_body());
  }
  switch (from.pattern_case()) {
    case kGet: {
      _this->_internal_set_get(from._internal_get());
      break;
    }
    case kPut: {
      _this->_internal_set_put(from._internal_put());
      break;
    }
    case kPost: {
      _this->_internal_set_post(from._internal_post());
      break;
    }
    case kDelete: {
      _this->_internal_set_delete_(from._internal_delete_());
      break;
    }
    case kPatch: {
      _this->_internal_set_patch(from._internal_patch());
      break;
    }
    case kCustom: {
      _this->_internal_mutable_custom()->::google::api::CustomHttpPattern::MergeFrom(
          from._internal_custom());
      break;
    }
    case PATTERN_NOT_SET: {
      break;
    }
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void HttpRule::CopyFrom(const HttpRule& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.api.HttpRule)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool HttpRule::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* HttpRule::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void HttpRule::InternalSwap(HttpRule* PROTOBUF_RESTRICT other) {
  using std::swap;
  auto* arena = GetArena();
  ABSL_DCHECK_EQ(arena, other->GetArena());
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  _impl_.additional_bindings_.InternalSwap(&other->_impl_.additional_bindings_);
  ::_pbi::ArenaStringPtr::InternalSwap(&_impl_.selector_, &other->_impl_.selector_, arena);
  ::_pbi::ArenaStringPtr::InternalSwap(&_impl_.body_, &other->_impl_.body_, arena);
  swap(_impl_.pattern_, other->_impl_.pattern_);
  swap(_impl_._oneof_case_[0], other->_impl_._oneof_case_[0]);
}

::google::protobuf::Metadata HttpRule::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2fapi_2fhttp_2eproto_getter, &descriptor_table_google_2fapi_2fhttp_2eproto_once,
      file_level_metadata_google_2fapi_2fhttp_2eproto[1]);
}
// ===================================================================

class CustomHttpPattern::_Internal {
 public:
};

CustomHttpPattern::CustomHttpPattern(::google::protobuf::Arena* arena)
    : ::google::protobuf::Message(arena) {
  SharedCtor(arena);
  // @@protoc_insertion_point(arena_constructor:google.api.CustomHttpPattern)
}
inline PROTOBUF_NDEBUG_INLINE CustomHttpPattern::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility, ::google::protobuf::Arena* arena,
    const Impl_& from)
      : kind_(arena, from.kind_),
        path_(arena, from.path_),
        _cached_size_{0} {}

CustomHttpPattern::CustomHttpPattern(
    ::google::protobuf::Arena* arena,
    const CustomHttpPattern& from)
    : ::google::protobuf::Message(arena) {
  CustomHttpPattern* const _this = this;
  (void)_this;
  _internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(
      from._internal_metadata_);
  new (&_impl_) Impl_(internal_visibility(), arena, from._impl_);

  // @@protoc_insertion_point(copy_constructor:google.api.CustomHttpPattern)
}
inline PROTOBUF_NDEBUG_INLINE CustomHttpPattern::Impl_::Impl_(
    ::google::protobuf::internal::InternalVisibility visibility,
    ::google::protobuf::Arena* arena)
      : kind_(arena),
        path_(arena),
        _cached_size_{0} {}

inline void CustomHttpPattern::SharedCtor(::_pb::Arena* arena) {
  new (&_impl_) Impl_(internal_visibility(), arena);
}
CustomHttpPattern::~CustomHttpPattern() {
  // @@protoc_insertion_point(destructor:google.api.CustomHttpPattern)
  _internal_metadata_.Delete<::google::protobuf::UnknownFieldSet>();
  SharedDtor();
}
inline void CustomHttpPattern::SharedDtor() {
  ABSL_DCHECK(GetArena() == nullptr);
  _impl_.kind_.Destroy();
  _impl_.path_.Destroy();
  _impl_.~Impl_();
}

PROTOBUF_NOINLINE void CustomHttpPattern::Clear() {
// @@protoc_insertion_point(message_clear_start:google.api.CustomHttpPattern)
  PROTOBUF_TSAN_WRITE(&_impl_._tsan_detect_race);
  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  _impl_.kind_.ClearToEmpty();
  _impl_.path_.ClearToEmpty();
  _internal_metadata_.Clear<::google::protobuf::UnknownFieldSet>();
}

const char* CustomHttpPattern::_InternalParse(
    const char* ptr, ::_pbi::ParseContext* ctx) {
  ptr = ::_pbi::TcParser::ParseLoop(this, ptr, ctx, &_table_.header);
  return ptr;
}


PROTOBUF_CONSTINIT PROTOBUF_ATTRIBUTE_INIT_PRIORITY1
const ::_pbi::TcParseTable<1, 2, 0, 45, 2> CustomHttpPattern::_table_ = {
  {
    0,  // no _has_bits_
    0, // no _extensions_
    2, 8,  // max_field_number, fast_idx_mask
    offsetof(decltype(_table_), field_lookup_table),
    4294967292,  // skipmap
    offsetof(decltype(_table_), field_entries),
    2,  // num_field_entries
    0,  // num_aux_entries
    offsetof(decltype(_table_), field_names),  // no aux_entries
    &_CustomHttpPattern_default_instance_._instance,
    ::_pbi::TcParser::GenericFallback,  // fallback
  }, {{
    // string path = 2;
    {::_pbi::TcParser::FastUS1,
     {18, 63, 0, PROTOBUF_FIELD_OFFSET(CustomHttpPattern, _impl_.path_)}},
    // string kind = 1;
    {::_pbi::TcParser::FastUS1,
     {10, 63, 0, PROTOBUF_FIELD_OFFSET(CustomHttpPattern, _impl_.kind_)}},
  }}, {{
    65535, 65535
  }}, {{
    // string kind = 1;
    {PROTOBUF_FIELD_OFFSET(CustomHttpPattern, _impl_.kind_), 0, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kUtf8String | ::_fl::kRepAString)},
    // string path = 2;
    {PROTOBUF_FIELD_OFFSET(CustomHttpPattern, _impl_.path_), 0, 0,
    (0 | ::_fl::kFcSingular | ::_fl::kUtf8String | ::_fl::kRepAString)},
  }},
  // no aux_entries
  {{
    "\34\4\4\0\0\0\0\0"
    "google.api.CustomHttpPattern"
    "kind"
    "path"
  }},
};

::uint8_t* CustomHttpPattern::_InternalSerialize(
    ::uint8_t* target,
    ::google::protobuf::io::EpsCopyOutputStream* stream) const {
  // @@protoc_insertion_point(serialize_to_array_start:google.api.CustomHttpPattern)
  ::uint32_t cached_has_bits = 0;
  (void)cached_has_bits;

  // string kind = 1;
  if (!this->_internal_kind().empty()) {
    const std::string& _s = this->_internal_kind();
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
        _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.api.CustomHttpPattern.kind");
    target = stream->WriteStringMaybeAliased(1, _s, target);
  }

  // string path = 2;
  if (!this->_internal_path().empty()) {
    const std::string& _s = this->_internal_path();
    ::google::protobuf::internal::WireFormatLite::VerifyUtf8String(
        _s.data(), static_cast<int>(_s.length()), ::google::protobuf::internal::WireFormatLite::SERIALIZE, "google.api.CustomHttpPattern.path");
    target = stream->WriteStringMaybeAliased(2, _s, target);
  }

  if (PROTOBUF_PREDICT_FALSE(_internal_metadata_.have_unknown_fields())) {
    target =
        ::_pbi::WireFormat::InternalSerializeUnknownFieldsToArray(
            _internal_metadata_.unknown_fields<::google::protobuf::UnknownFieldSet>(::google::protobuf::UnknownFieldSet::default_instance), target, stream);
  }
  // @@protoc_insertion_point(serialize_to_array_end:google.api.CustomHttpPattern)
  return target;
}

::size_t CustomHttpPattern::ByteSizeLong() const {
// @@protoc_insertion_point(message_byte_size_start:google.api.CustomHttpPattern)
  ::size_t total_size = 0;

  ::uint32_t cached_has_bits = 0;
  // Prevent compiler warnings about cached_has_bits being unused
  (void) cached_has_bits;

  // string kind = 1;
  if (!this->_internal_kind().empty()) {
    total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                    this->_internal_kind());
  }

  // string path = 2;
  if (!this->_internal_path().empty()) {
    total_size += 1 + ::google::protobuf::internal::WireFormatLite::StringSize(
                                    this->_internal_path());
  }

  return MaybeComputeUnknownFieldsSize(total_size, &_impl_._cached_size_);
}

const ::google::protobuf::Message::ClassData CustomHttpPattern::_class_data_ = {
    CustomHttpPattern::MergeImpl,
    nullptr,  // OnDemandRegisterArenaDtor
};
const ::google::protobuf::Message::ClassData* CustomHttpPattern::GetClassData() const {
  return &_class_data_;
}

void CustomHttpPattern::MergeImpl(::google::protobuf::Message& to_msg, const ::google::protobuf::Message& from_msg) {
  auto* const _this = static_cast<CustomHttpPattern*>(&to_msg);
  auto& from = static_cast<const CustomHttpPattern&>(from_msg);
  // @@protoc_insertion_point(class_specific_merge_from_start:google.api.CustomHttpPattern)
  ABSL_DCHECK_NE(&from, _this);
  ::uint32_t cached_has_bits = 0;
  (void) cached_has_bits;

  if (!from._internal_kind().empty()) {
    _this->_internal_set_kind(from._internal_kind());
  }
  if (!from._internal_path().empty()) {
    _this->_internal_set_path(from._internal_path());
  }
  _this->_internal_metadata_.MergeFrom<::google::protobuf::UnknownFieldSet>(from._internal_metadata_);
}

void CustomHttpPattern::CopyFrom(const CustomHttpPattern& from) {
// @@protoc_insertion_point(class_specific_copy_from_start:google.api.CustomHttpPattern)
  if (&from == this) return;
  Clear();
  MergeFrom(from);
}

PROTOBUF_NOINLINE bool CustomHttpPattern::IsInitialized() const {
  return true;
}

::_pbi::CachedSize* CustomHttpPattern::AccessCachedSize() const {
  return &_impl_._cached_size_;
}
void CustomHttpPattern::InternalSwap(CustomHttpPattern* PROTOBUF_RESTRICT other) {
  using std::swap;
  auto* arena = GetArena();
  ABSL_DCHECK_EQ(arena, other->GetArena());
  _internal_metadata_.InternalSwap(&other->_internal_metadata_);
  ::_pbi::ArenaStringPtr::InternalSwap(&_impl_.kind_, &other->_impl_.kind_, arena);
  ::_pbi::ArenaStringPtr::InternalSwap(&_impl_.path_, &other->_impl_.path_, arena);
}

::google::protobuf::Metadata CustomHttpPattern::GetMetadata() const {
  return ::_pbi::AssignDescriptors(
      &descriptor_table_google_2fapi_2fhttp_2eproto_getter, &descriptor_table_google_2fapi_2fhttp_2eproto_once,
      file_level_metadata_google_2fapi_2fhttp_2eproto[2]);
}
// @@protoc_insertion_point(namespace_scope)
}  // namespace api
}  // namespace google
namespace google {
namespace protobuf {
}  // namespace protobuf
}  // namespace google
// @@protoc_insertion_point(global_scope)
#include "google/protobuf/port_undef.inc"
