// DO NOT EDIT.
// swift-format-ignore-file
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: firebase_ml_log_sdk.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import Foundation
import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

enum EventName: SwiftProtobuf.Enum {
  typealias RawValue = Int
  case unknownEvent // = 0
  case modelDownload // = 100
  case modelUpdate // = 101
  case remoteModelDeleteOnDevice // = 252
  case UNRECOGNIZED(Int)

  init() {
    self = .unknownEvent
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unknownEvent
    case 100: self = .modelDownload
    case 101: self = .modelUpdate
    case 252: self = .remoteModelDeleteOnDevice
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unknownEvent: return 0
    case .modelDownload: return 100
    case .modelUpdate: return 101
    case .remoteModelDeleteOnDevice: return 252
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension EventName: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [EventName] = [
    .unknownEvent,
    .modelDownload,
    .modelUpdate,
    .remoteModelDeleteOnDevice,
  ]
}

#endif  // swift(>=4.2)

/// A list of error codes for various components of the system. For model downloading, the
/// range of error codes is 100 to 199.
enum ErrorCode: SwiftProtobuf.Enum {
  typealias RawValue = Int

  /// No error at all.
  case noError // = 0

  /// The temporary URI to download the model has expired.
  case uriExpired // = 101

  /// There is no network connection when trying to download the model file or
  /// the model info.
  case noNetworkConnection // = 102

  /// The download started on a valid condition but didn't finish successfully.
  case downloadFailed // = 104

  /// We received an unsuccessful http status code when trying to download the
  /// model info. An unsuccessful http status code is a code that's neither 200
  /// nor 304. See go/firebase-ml-model-hosting-design for a list of possible
  /// status codes while downloading the model info.
  case modelInfoDownloadUnsuccessfulHTTPStatus // = 105

  /// Didn't receive a model hash while trying to download the model info.
  case modelInfoDownloadNoHash // = 106

  /// Failed to connect to the Firebase Console while trying to download the
  /// model info.
  case modelInfoDownloadConnectionFailed // = 107

  /// Model hash mismatches the expected value.
  case modelHashMismatch // = 116

  /// An unknown error has occurred. This is for conditions that should never
  /// happen. But we log them anyways.  If there is a surge in UNKNOWN error
  /// codes, we need to check our code.
  case unknownError // = 9999
  case UNRECOGNIZED(Int)

  init() {
    self = .noError
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .noError
    case 101: self = .uriExpired
    case 102: self = .noNetworkConnection
    case 104: self = .downloadFailed
    case 105: self = .modelInfoDownloadUnsuccessfulHTTPStatus
    case 106: self = .modelInfoDownloadNoHash
    case 107: self = .modelInfoDownloadConnectionFailed
    case 116: self = .modelHashMismatch
    case 9999: self = .unknownError
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .noError: return 0
    case .uriExpired: return 101
    case .noNetworkConnection: return 102
    case .downloadFailed: return 104
    case .modelInfoDownloadUnsuccessfulHTTPStatus: return 105
    case .modelInfoDownloadNoHash: return 106
    case .modelInfoDownloadConnectionFailed: return 107
    case .modelHashMismatch: return 116
    case .unknownError: return 9999
    case .UNRECOGNIZED(let i): return i
    }
  }

}

#if swift(>=4.2)

extension ErrorCode: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [ErrorCode] = [
    .noError,
    .uriExpired,
    .noNetworkConnection,
    .downloadFailed,
    .modelInfoDownloadUnsuccessfulHTTPStatus,
    .modelInfoDownloadNoHash,
    .modelInfoDownloadConnectionFailed,
    .modelHashMismatch,
    .unknownError,
  ]
}

#endif  // swift(>=4.2)

/// Information about various parts of the system: app, Firebase, SDK.
struct SystemInfo {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The application's unique id. On iOS, this is the bundle ID.
  var appID: String = String()

  /// Application version string. On iOS, this is "version_number" + "#" + "build_number".
  var appVersion: String = String()

  /// Uniquely identifiable id associated with the Firebase project. Might be an
  /// empty string if the developer does not pass a correct FirebaseOptions with
  /// a valid Firebase Project ID.
  var firebaseProjectID: String = String()

  /// Firebase ML SDK version.
  var mlSdkVersion: String = String()

  /// The API key of the firebase project.
  var apiKey: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Information about models.
struct ModelInfo {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The name of the model defined by the model creator. This string should be
  /// meaningful to the creator and describes what the model does. For example,
  /// the name can be "mobile vision face recognition" or "speech to text".
  var name: String = String()

  /// The version of the model defined by the model creator.
  var version: String = String()

  /// The expected checksum (SHA256) of the model file. Only hash of models
  /// downloaded from cloud is logged.
  var hash: String = String()

  var modelType: ModelInfo.ModelType = .typeUnknown

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// The model type is currently envisioned to be used mainly for model
  /// download/update.
  enum ModelType: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case typeUnknown // = 0
    case custom // = 1
    case UNRECOGNIZED(Int)

    init() {
      self = .typeUnknown
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .typeUnknown
      case 1: self = .custom
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .typeUnknown: return 0
      case .custom: return 1
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}
}

#if swift(>=4.2)

extension ModelInfo.ModelType: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [ModelInfo.ModelType] = [
    .typeUnknown,
    .custom,
  ]
}

#endif  // swift(>=4.2)

/// Detailed information about a model.
/// The message used to be named "CustomModelOptions".
struct ModelOptions {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Inherent properties about the model: name, version, URI, source.
  var modelInfo: ModelInfo {
    get {return _modelInfo ?? ModelInfo()}
    set {_modelInfo = newValue}
  }
  /// Returns true if `modelInfo` has been explicitly set.
  var hasModelInfo: Bool {return self._modelInfo != nil}
  /// Clears the value of `modelInfo`. Subsequent reads from it will return its default value.
  mutating func clearModelInfo() {self._modelInfo = nil}

  /// True if models can be updated.
  var isModelUpdateEnabled: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _modelInfo: ModelInfo? = nil
}

/// Information about model downloading. A single model download request may
/// result in multiple log entries. "download_status" in the log entry indicates
/// during which stage it is logged.
/// This message used to be named "CustomModelDownloadLogEvent".
struct ModelDownloadLogEvent {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Model information and options for downloading.
  var options: ModelOptions {
    get {return _options ?? ModelOptions()}
    set {_options = newValue}
  }
  /// Returns true if `options` has been explicitly set.
  var hasOptions: Bool {return self._options != nil}
  /// Clears the value of `options`. Subsequent reads from it will return its default value.
  mutating func clearOptions() {self._options = nil}

  /// The rough duration of the download. This is not marked as
  /// ST_SENSITIVE_TIMESTAMP because it is a duration instead of a timestamp.
  /// We delegate the download to OS downloader. We may not be notified
  /// when the download completes, such as when the app is killed.
  var roughDownloadDurationMs: UInt64 = 0

  /// The error code for model download.
  var errorCode: ErrorCode = .noError

  /// The exact duration of the download. This is not marked as
  /// ST_SENSITIVE_TIMESTAMP because it is a duration instead of a timestamp.
  /// We know the exact duration when the download is completed while the app is
  /// still alive and receives the completed notification from OS downloader.
  var exactDownloadDurationMs: UInt64 = 0

  /// The download status.
  var downloadStatus: ModelDownloadLogEvent.DownloadStatus = .unknownStatus

  /// If this field is logged for DownloadStatus.MODEL_INFO_RETRIEVAL_FAILED, it
  /// is the http status code from the firebase console. See
  /// go/firebase-ml-model-hosting-design. Same on both Android and iOS.
  /// If this field is logged for DownloadStatus.FAILED, it is the http status
  /// code on iOS, and the DownloadManager's "COLUMN_REASON" value on Android. On
  /// iOS, the status code can be a negative integer.
  var downloadFailureStatus: Int64 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// The download status. The model download is made up of two major stages: the
  /// retrieval of the model info in Firebase backend, and then the download of
  /// the model file in GCS. Whether or not the download is requested implicitly
  /// or explicitly does not affect the later stages of the download. As a
  /// result, later stages (i.e. enum tag 3+) do not distinguish between explicit
  /// and implicit triggering.
  enum DownloadStatus: SwiftProtobuf.Enum {
    typealias RawValue = Int
    case unknownStatus // = 0

    /// The download is requested by the developer, i.e. ensureModelDownloaded()
    /// is called.
    case explicitlyRequested // = 1

    /// The download is requested by the SDK implicitly.
    case implicitlyRequested // = 2

    /// The retrieval of the model info succeeded.
    case modelInfoRetrievalSucceeded // = 3

    /// The retrieval of the model info failed. See error_code field for details.
    case modelInfoRetrievalFailed // = 4

    /// A new download with the OS downloader has been scheduled.
    case scheduled // = 5

    /// There is an existing downloading session. No new download is scheduled.
    case downloading // = 6

    /// The download of the model file succeeded.
    case succeeded // = 7

    /// The download of the model file failed.
    case failed // = 8

    /// Update is enabled and available while the existing model is downloaded or
    /// live.
    case updateAvailable // = 10
    case UNRECOGNIZED(Int)

    init() {
      self = .unknownStatus
    }

    init?(rawValue: Int) {
      switch rawValue {
      case 0: self = .unknownStatus
      case 1: self = .explicitlyRequested
      case 2: self = .implicitlyRequested
      case 3: self = .modelInfoRetrievalSucceeded
      case 4: self = .modelInfoRetrievalFailed
      case 5: self = .scheduled
      case 6: self = .downloading
      case 7: self = .succeeded
      case 8: self = .failed
      case 10: self = .updateAvailable
      default: self = .UNRECOGNIZED(rawValue)
      }
    }

    var rawValue: Int {
      switch self {
      case .unknownStatus: return 0
      case .explicitlyRequested: return 1
      case .implicitlyRequested: return 2
      case .modelInfoRetrievalSucceeded: return 3
      case .modelInfoRetrievalFailed: return 4
      case .scheduled: return 5
      case .downloading: return 6
      case .succeeded: return 7
      case .failed: return 8
      case .updateAvailable: return 10
      case .UNRECOGNIZED(let i): return i
      }
    }

  }

  init() {}

  fileprivate var _options: ModelOptions? = nil
}

#if swift(>=4.2)

extension ModelDownloadLogEvent.DownloadStatus: CaseIterable {
  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static var allCases: [ModelDownloadLogEvent.DownloadStatus] = [
    .unknownStatus,
    .explicitlyRequested,
    .implicitlyRequested,
    .modelInfoRetrievalSucceeded,
    .modelInfoRetrievalFailed,
    .scheduled,
    .downloading,
    .succeeded,
    .failed,
    .updateAvailable,
  ]
}

#endif  // swift(>=4.2)

/// Information about deleting a downloaded model on device.
struct DeleteModelLogEvent {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The type of the downloaded model requested to be deleted.
  var modelType: ModelInfo.ModelType = .typeUnknown

  /// Whether the downloaded model is deleted successfully.
  var isSuccessful: Bool = false

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// Main log event for FirebaseMl, that contains individual API events, like model
/// download.
/// NEXT ID: 44.
struct FirebaseMlLogEvent {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// Information about various parts of the system: app, Firebase, SDK.
  var systemInfo: SystemInfo {
    get {return _storage._systemInfo ?? SystemInfo()}
    set {_uniqueStorage()._systemInfo = newValue}
  }
  /// Returns true if `systemInfo` has been explicitly set.
  var hasSystemInfo: Bool {return _storage._systemInfo != nil}
  /// Clears the value of `systemInfo`. Subsequent reads from it will return its default value.
  mutating func clearSystemInfo() {_uniqueStorage()._systemInfo = nil}

  /// The event name.
  var eventName: EventName {
    get {return _storage._eventName}
    set {_uniqueStorage()._eventName = newValue}
  }

  /// Information about model download.
  var modelDownloadLogEvent: ModelDownloadLogEvent {
    get {return _storage._modelDownloadLogEvent ?? ModelDownloadLogEvent()}
    set {_uniqueStorage()._modelDownloadLogEvent = newValue}
  }
  /// Returns true if `modelDownloadLogEvent` has been explicitly set.
  var hasModelDownloadLogEvent: Bool {return _storage._modelDownloadLogEvent != nil}
  /// Clears the value of `modelDownloadLogEvent`. Subsequent reads from it will return its default value.
  mutating func clearModelDownloadLogEvent() {_uniqueStorage()._modelDownloadLogEvent = nil}

  /// Information about deleting a downloaded model.
  var deleteModelLogEvent: DeleteModelLogEvent {
    get {return _storage._deleteModelLogEvent ?? DeleteModelLogEvent()}
    set {_uniqueStorage()._deleteModelLogEvent = newValue}
  }
  /// Returns true if `deleteModelLogEvent` has been explicitly set.
  var hasDeleteModelLogEvent: Bool {return _storage._deleteModelLogEvent != nil}
  /// Clears the value of `deleteModelLogEvent`. Subsequent reads from it will return its default value.
  mutating func clearDeleteModelLogEvent() {_uniqueStorage()._deleteModelLogEvent = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _storage = _StorageClass.defaultInstance
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

extension EventName: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN_EVENT"),
    100: .same(proto: "MODEL_DOWNLOAD"),
    101: .same(proto: "MODEL_UPDATE"),
    252: .same(proto: "REMOTE_MODEL_DELETE_ON_DEVICE"),
  ]
}

extension ErrorCode: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "NO_ERROR"),
    101: .same(proto: "URI_EXPIRED"),
    102: .same(proto: "NO_NETWORK_CONNECTION"),
    104: .same(proto: "DOWNLOAD_FAILED"),
    105: .same(proto: "MODEL_INFO_DOWNLOAD_UNSUCCESSFUL_HTTP_STATUS"),
    106: .same(proto: "MODEL_INFO_DOWNLOAD_NO_HASH"),
    107: .same(proto: "MODEL_INFO_DOWNLOAD_CONNECTION_FAILED"),
    116: .same(proto: "MODEL_HASH_MISMATCH"),
    9999: .same(proto: "UNKNOWN_ERROR"),
  ]
}

extension SystemInfo: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "SystemInfo"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "app_id"),
    2: .standard(proto: "app_version"),
    3: .standard(proto: "firebase_project_id"),
    4: .standard(proto: "ml_sdk_version"),
    7: .standard(proto: "api_key"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.appID) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.appVersion) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self.firebaseProjectID) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self.mlSdkVersion) }()
      case 7: try { try decoder.decodeSingularStringField(value: &self.apiKey) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.appID.isEmpty {
      try visitor.visitSingularStringField(value: self.appID, fieldNumber: 1)
    }
    if !self.appVersion.isEmpty {
      try visitor.visitSingularStringField(value: self.appVersion, fieldNumber: 2)
    }
    if !self.firebaseProjectID.isEmpty {
      try visitor.visitSingularStringField(value: self.firebaseProjectID, fieldNumber: 3)
    }
    if !self.mlSdkVersion.isEmpty {
      try visitor.visitSingularStringField(value: self.mlSdkVersion, fieldNumber: 4)
    }
    if !self.apiKey.isEmpty {
      try visitor.visitSingularStringField(value: self.apiKey, fieldNumber: 7)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: SystemInfo, rhs: SystemInfo) -> Bool {
    if lhs.appID != rhs.appID {return false}
    if lhs.appVersion != rhs.appVersion {return false}
    if lhs.firebaseProjectID != rhs.firebaseProjectID {return false}
    if lhs.mlSdkVersion != rhs.mlSdkVersion {return false}
    if lhs.apiKey != rhs.apiKey {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension ModelInfo: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ModelInfo"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "version"),
    5: .same(proto: "hash"),
    6: .standard(proto: "model_type"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.version) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self.hash) }()
      case 6: try { try decoder.decodeSingularEnumField(value: &self.modelType) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    if !self.version.isEmpty {
      try visitor.visitSingularStringField(value: self.version, fieldNumber: 2)
    }
    if !self.hash.isEmpty {
      try visitor.visitSingularStringField(value: self.hash, fieldNumber: 5)
    }
    if self.modelType != .typeUnknown {
      try visitor.visitSingularEnumField(value: self.modelType, fieldNumber: 6)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: ModelInfo, rhs: ModelInfo) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs.version != rhs.version {return false}
    if lhs.hash != rhs.hash {return false}
    if lhs.modelType != rhs.modelType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension ModelInfo.ModelType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "TYPE_UNKNOWN"),
    1: .same(proto: "CUSTOM"),
  ]
}

extension ModelOptions: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ModelOptions"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "model_info"),
    4: .standard(proto: "is_model_update_enabled"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._modelInfo) }()
      case 4: try { try decoder.decodeSingularBoolField(value: &self.isModelUpdateEnabled) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if let v = self._modelInfo {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }
    if self.isModelUpdateEnabled != false {
      try visitor.visitSingularBoolField(value: self.isModelUpdateEnabled, fieldNumber: 4)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: ModelOptions, rhs: ModelOptions) -> Bool {
    if lhs._modelInfo != rhs._modelInfo {return false}
    if lhs.isModelUpdateEnabled != rhs.isModelUpdateEnabled {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension ModelDownloadLogEvent: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "ModelDownloadLogEvent"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "options"),
    2: .standard(proto: "rough_download_duration_ms"),
    3: .standard(proto: "error_code"),
    4: .standard(proto: "exact_download_duration_ms"),
    5: .standard(proto: "download_status"),
    6: .standard(proto: "download_failure_status"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._options) }()
      case 2: try { try decoder.decodeSingularUInt64Field(value: &self.roughDownloadDurationMs) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self.errorCode) }()
      case 4: try { try decoder.decodeSingularUInt64Field(value: &self.exactDownloadDurationMs) }()
      case 5: try { try decoder.decodeSingularEnumField(value: &self.downloadStatus) }()
      case 6: try { try decoder.decodeSingularInt64Field(value: &self.downloadFailureStatus) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if let v = self._options {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }
    if self.roughDownloadDurationMs != 0 {
      try visitor.visitSingularUInt64Field(value: self.roughDownloadDurationMs, fieldNumber: 2)
    }
    if self.errorCode != .noError {
      try visitor.visitSingularEnumField(value: self.errorCode, fieldNumber: 3)
    }
    if self.exactDownloadDurationMs != 0 {
      try visitor.visitSingularUInt64Field(value: self.exactDownloadDurationMs, fieldNumber: 4)
    }
    if self.downloadStatus != .unknownStatus {
      try visitor.visitSingularEnumField(value: self.downloadStatus, fieldNumber: 5)
    }
    if self.downloadFailureStatus != 0 {
      try visitor.visitSingularInt64Field(value: self.downloadFailureStatus, fieldNumber: 6)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: ModelDownloadLogEvent, rhs: ModelDownloadLogEvent) -> Bool {
    if lhs._options != rhs._options {return false}
    if lhs.roughDownloadDurationMs != rhs.roughDownloadDurationMs {return false}
    if lhs.errorCode != rhs.errorCode {return false}
    if lhs.exactDownloadDurationMs != rhs.exactDownloadDurationMs {return false}
    if lhs.downloadStatus != rhs.downloadStatus {return false}
    if lhs.downloadFailureStatus != rhs.downloadFailureStatus {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension ModelDownloadLogEvent.DownloadStatus: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "UNKNOWN_STATUS"),
    1: .same(proto: "EXPLICITLY_REQUESTED"),
    2: .same(proto: "IMPLICITLY_REQUESTED"),
    3: .same(proto: "MODEL_INFO_RETRIEVAL_SUCCEEDED"),
    4: .same(proto: "MODEL_INFO_RETRIEVAL_FAILED"),
    5: .same(proto: "SCHEDULED"),
    6: .same(proto: "DOWNLOADING"),
    7: .same(proto: "SUCCEEDED"),
    8: .same(proto: "FAILED"),
    10: .same(proto: "UPDATE_AVAILABLE"),
  ]
}

extension DeleteModelLogEvent: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "DeleteModelLogEvent"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "model_type"),
    2: .standard(proto: "is_successful"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularEnumField(value: &self.modelType) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.isSuccessful) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.modelType != .typeUnknown {
      try visitor.visitSingularEnumField(value: self.modelType, fieldNumber: 1)
    }
    if self.isSuccessful != false {
      try visitor.visitSingularBoolField(value: self.isSuccessful, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: DeleteModelLogEvent, rhs: DeleteModelLogEvent) -> Bool {
    if lhs.modelType != rhs.modelType {return false}
    if lhs.isSuccessful != rhs.isSuccessful {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension FirebaseMlLogEvent: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = "FirebaseMlLogEvent"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "system_info"),
    2: .standard(proto: "event_name"),
    3: .standard(proto: "model_download_log_event"),
    40: .standard(proto: "delete_model_log_event"),
  ]

  fileprivate class _StorageClass {
    var _systemInfo: SystemInfo? = nil
    var _eventName: EventName = .unknownEvent
    var _modelDownloadLogEvent: ModelDownloadLogEvent? = nil
    var _deleteModelLogEvent: DeleteModelLogEvent? = nil

    static let defaultInstance = _StorageClass()

    private init() {}

    init(copying source: _StorageClass) {
      _systemInfo = source._systemInfo
      _eventName = source._eventName
      _modelDownloadLogEvent = source._modelDownloadLogEvent
      _deleteModelLogEvent = source._deleteModelLogEvent
    }
  }

  fileprivate mutating func _uniqueStorage() -> _StorageClass {
    if !isKnownUniquelyReferenced(&_storage) {
      _storage = _StorageClass(copying: _storage)
    }
    return _storage
  }

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    _ = _uniqueStorage()
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      while let fieldNumber = try decoder.nextFieldNumber() {
        // The use of inline closures is to circumvent an issue where the compiler
        // allocates stack space for every case branch when no optimizations are
        // enabled. https://github.com/apple/swift-protobuf/issues/1034
        switch fieldNumber {
        case 1: try { try decoder.decodeSingularMessageField(value: &_storage._systemInfo) }()
        case 2: try { try decoder.decodeSingularEnumField(value: &_storage._eventName) }()
        case 3: try { try decoder.decodeSingularMessageField(value: &_storage._modelDownloadLogEvent) }()
        case 40: try { try decoder.decodeSingularMessageField(value: &_storage._deleteModelLogEvent) }()
        default: break
        }
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    try withExtendedLifetime(_storage) { (_storage: _StorageClass) in
      if let v = _storage._systemInfo {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
      }
      if _storage._eventName != .unknownEvent {
        try visitor.visitSingularEnumField(value: _storage._eventName, fieldNumber: 2)
      }
      if let v = _storage._modelDownloadLogEvent {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
      }
      if let v = _storage._deleteModelLogEvent {
        try visitor.visitSingularMessageField(value: v, fieldNumber: 40)
      }
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: FirebaseMlLogEvent, rhs: FirebaseMlLogEvent) -> Bool {
    if lhs._storage !== rhs._storage {
      let storagesAreEqual: Bool = withExtendedLifetime((lhs._storage, rhs._storage)) { (_args: (_StorageClass, _StorageClass)) in
        let _storage = _args.0
        let rhs_storage = _args.1
        if _storage._systemInfo != rhs_storage._systemInfo {return false}
        if _storage._eventName != rhs_storage._eventName {return false}
        if _storage._modelDownloadLogEvent != rhs_storage._modelDownloadLogEvent {return false}
        if _storage._deleteModelLogEvent != rhs_storage._deleteModelLogEvent {return false}
        return true
      }
      if !storagesAreEqual {return false}
    }
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
