/*
 * Copyright 2017 Google
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#import <TargetConditionals.h>
#if TARGET_OS_IOS || TARGET_OS_TV || TARGET_OS_VISION

#import "FirebaseInAppMessaging/Sources/Util/UIColor+FIRIAMHexString.h"

@implementation UIColor (HexString)
+ (UIColor *)firiam_colorWithHexString:(nullable NSString *)hexString {
  if (hexString.length < 7) {
    return nil;
  }

  unsigned rgbValue = 0;
  NSScanner *scanner = [NSScanner scannerWithString:hexString];
  [scanner setScanLocation:1];  // bypass '#' character

  if (![scanner scanHexInt:&rgbValue]) {
    // no valid heximal value is detected
    return nil;
  }

  return [UIColor colorWithRed:((rgbValue & 0xFF0000) >> 16) / 255.0
                         green:((rgbValue & 0xFF00) >> 8) / 255.0
                          blue:(rgbValue & 0xFF) / 255.0
                         alpha:1.0];
}
@end

/// Stub used to force the linker to include the categories in this file.
void FIRInclude_UIColor_HexString_Category(void) {
}

#endif  // TARGET_OS_IOS || TARGET_OS_TV || TARGET_OS_VISION
