/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#import "SceneDelegate.h"

#import <FirebaseDynamicLinks/FIRDynamicLinks.h>

@interface SceneDelegate ()

@end

@implementation SceneDelegate

- (void)scene:(UIScene *)scene
    willConnectToSession:(UISceneSession *)session
                 options:(UISceneConnectionOptions *)connectionOptions {
  // Use this method to optionally configure and attach the UIWindow `window` to the provided
  // UIWindowScene `scene`. If using a storyboard, the `window` property will automatically be
  // initialized and attached to the scene. This delegate does not imply the connecting scene or
  // session are new (see `application:configurationForConnectingSceneSession` instead).
  if (connectionOptions.userActivities && connectionOptions.userActivities.count > 0) {
    NSUserActivity *userActivity = connectionOptions.userActivities.allObjects.firstObject;
    [self handleDynamicLinkFromActivity:userActivity];
  }
}

- (void)sceneDidDisconnect:(UIScene *)scene {
  // Called as the scene is being released by the system.
  // This occurs shortly after the scene enters the background, or when its session is discarded.
  // Release any resources associated with this scene that can be re-created the next time the scene
  // connects. The scene may re-connect later, as its session was not necessarily discarded (see
  // `application:didDiscardSceneSessions` instead).
}

- (void)sceneDidBecomeActive:(UIScene *)scene {
  // Called when the scene has moved from an inactive state to an active state.
  // Use this method to restart any tasks that were paused (or not yet started) when the scene was
  // inactive.
}

- (void)sceneWillResignActive:(UIScene *)scene {
  // Called when the scene will move from an active state to an inactive state.
  // This may occur due to temporary interruptions (ex. an incoming phone call).
}

- (void)sceneWillEnterForeground:(UIScene *)scene {
  // Called as the scene transitions from the background to the foreground.
  // Use this method to undo the changes made on entering the background.
}

- (void)sceneDidEnterBackground:(UIScene *)scene {
  // Called as the scene transitions from the foreground to the background.
  // Use this method to save data, release shared resources, and store enough scene-specific state
  // information to restore the scene back to its current state.
}

- (void)scene:(UIScene *)scene continueUserActivity:(NSUserActivity *)userActivity {
  [self handleDynamicLinkFromActivity:userActivity];
}

- (void)handleDynamicLinkFromActivity:(NSUserActivity *)userActivity {
  if (!userActivity) {
    return;
  }
  BOOL handled = [[FIRDynamicLinks dynamicLinks]
      handleUniversalLink:userActivity.webpageURL
               completion:^(FIRDynamicLink *_Nullable dynamicLink, NSError *_Nullable error) {
                 [self _showDynamicLinkInfo:dynamicLink];
               }];

  if (!handled) {
    // Show the deep link URL from userActivity.
    NSLog(@"Unhandled link %@", userActivity.webpageURL);
  }
}

- (void)_showDynamicLinkInfo:(FIRDynamicLink *)dynamicLink {
  NSLog(@"Got dynamic link %@", dynamicLink);

  UIAlertController *alertVC = [UIAlertController
      alertControllerWithTitle:@"Got Dynamic Link!"
                       message:[NSString stringWithFormat:@"URL [%@], matchType [%ld], "
                                                          @"minimumAppVersion [%@], utmParams [%@]",
                                                          dynamicLink.url,
                                                          (unsigned long)dynamicLink.matchType,
                                                          dynamicLink.minimumAppVersion,
                                                          dynamicLink.utmParametersDictionary]
                preferredStyle:UIAlertControllerStyleAlert];
  [alertVC addAction:[UIAlertAction actionWithTitle:@"Dismiss"
                                              style:UIAlertActionStyleCancel
                                            handler:NULL]];
  [self.window.rootViewController presentViewController:alertVC animated:YES completion:NULL];
}

@end
