/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 * All rights reserved.
 *
 * This source code is licensed under the license found in the
 * LICENSE file in the root directory of this source tree.
 */

import TestTools

@available(iOS 12.2, *)
final class TestPaymentProductRequestorFactory: _PaymentProductRequestorCreating {
  struct Evidence {
    let requestor: TestPaymentProductRequestor
    let transaction: SKPaymentTransaction
  }

  // Dummy class to avoid polluting the shared test gatekeeper manager
  final class PaymentGateKeeperManager: _GateKeeperManaging {
    static func bool(forKey key: String, defaultValue: Bool) -> Bool {
      false
    }

    static func loadGateKeepers(_ completionBlock: @escaping _GKManagerBlock) {
      // noop
    }
  }

  let transaction = TestPaymentTransaction(state: .deferred)
  let settings = TestSettings()
  let eventLogger = TestEventLogger()
  let store = UserDefaultsSpy()
  let loggerFactory = TestLoggerFactory()
  let graphRequestFactory = TestProductsRequestFactory()
  let receiptProvider = TestAppStoreReceiptProvider()

  var evidence = [Evidence]()

  func createRequestor(transaction: SKPaymentTransaction) -> PaymentProductRequestor {
    let requestor = TestPaymentProductRequestor(
      transaction: transaction,
      settings: settings,
      eventLogger: eventLogger,
      gateKeeperManager: PaymentGateKeeperManager.self,
      store: store,
      loggerFactory: loggerFactory,
      productsRequestFactory: graphRequestFactory,
      appStoreReceiptProvider: receiptProvider
    )
    evidence.append(Evidence(requestor: requestor, transaction: transaction))

    return requestor
  }
}
