x020057_g_scriptId = 020057

x020057_g_MonsterId = {}
x020057_g_MonsterId[1] = { 480102, 480101, 480102 }
x020057_g_MonsterId[2] = { 480103 }

x020057_g_MonsterPos = {}
x020057_g_MonsterPos[1] = { { 59.12, 68.17, -1.57 }, { 64.92, 67.97, -1.57 }, { 71.14, 68.25, -1.57 } }
x020057_g_MonsterPos[2] = { { 64.92, 67.97, -1.57 } }

x020057_g_CSParamIdxStage = 0
x020057_g_CSParamIdxCurSubStage = 1           --小阶段

x020057_g_CSParamAnimationID = 1007           --mov动画ID

x020057_g_MovMaxTime1 = 15 --第一个mov时长


function x020057_OnCopySceneOpen(scene)
    SetCopySceneParam(scene, x020057_g_CSParamIdxStage, 1)
    SetCopySceneParam(scene, x020057_g_CSParamIdxCurSubStage, 0)
    x020057_CreateMonsterOnStage(scene, 1)
end

function x020057_OnCopySceneTick(scene, tickCount)
    local curStage = GetCopySceneParam(scene, x020057_g_CSParamIdxStage)

    local curStages = GetCopySceneParam(scene, x020057_g_CSParamIdxCurSubStage)
    SetCopySceneParam(scene, x020057_g_CSParamIdxCurSubStage, curStages + 1)

    if curStage == 3 and GetHostileMonsterCount(scene) == 0 and curStages == x020056_g_MovMaxTime1 then
        x020057_EndCopyScene(scene, true)
    end
end

function x020057_OnObjEnter(scene, objId)
    AutoCombat(scene, objId, true)
end

function x020057_OnObjDie(scene, objId, rolebaseId, killerId)
    if objId == GetUserObjIdByIdx(scene, 0) then
        x020057_EndCopyScene(scene, false)
    else
        local curStage = GetCopySceneParam(scene, x020057_g_CSParamIdxStage)
        local count = GetHostileMonsterCount(scene)
        if count == 0 then
            if curStage == 1 then
                x020057_CreateMonsterOnStage(scene, curStage + 1)
            elseif rolebaseId == x020057_g_MonsterId[2][1] then
                StoryAnimation(scene, x020057_g_CSParamAnimationID)
            end
            SetCopySceneParam(scene, x020057_g_CSParamIdxStage, curStage + 1)
            SetCopySceneParam(scene, x020057_g_CSParamIdxCurSubStage, 0)
        end
    end
end

function x020057_CreateMonsterOnStage(scene, stage)
    local monsters = x020057_g_MonsterId[stage]
    local pos = x020057_g_MonsterPos[stage]
    for i = 1, #monsters do
        CreateMonster(scene, monsters[i], pos[i][3], pos[i][1], pos[i][2])
    end
end

function x020057_OnCopySceneTimeOut(scene)
    x020057_EndCopyScene(scene, false)
end

function x020057_EndCopyScene(scene, win)
    ChangeJobCopyEnd(scene, win)
    if win then
        SetCopySceneSuccess(scene)
    else
        SetCopySceneFail(scene)
    end
end

function x020057_OnStoryEventEnd(scene, nStoryId, nAnimationId)
    if nAnimationId == x020057_g_CSParamAnimationID then
        x020057_EndCopyScene(scene, true)
    end
end