x020056_g_scriptId = 020056

x020056_g_MonsterId = {}
x020056_g_MonsterId[1] = { 480002, 480001, 480002 }
x020056_g_MonsterId[2] = { 480003 }
x020056_g_MonsterId[3] = { 480005 }
x020056_g_MonsterPos = {}
x020056_g_MonsterPos[1] = {{67.88,73.6,-1.57},{62.58,71.46,-1.57},{57.27,73.21,-1.57}}
x020056_g_MonsterPos[2] = { { 62.73, 79.11, -1.57 } }
x020056_g_MonsterPos[3] = { { 62.73, 79.11, -1.57 } }

x020056_g_CSParamIdxStage = 0
x020056_g_CSParamIdxCurSubStage = 1           --小阶段

x020056_g_CSParamAnimationID = 1002           --mov动画ID
x020056_g_CSParamAnimation2ID = 1005          --mov动画ID

x020056_g_MovMaxTime1 = 15 --第一个mov时长
x020056_g_MovMaxTime2 = 15--第二个mov时长


function x020056_OnCopySceneOpen(scene)
    x020056_CreateMonsterOnStage(scene, 1)
    SetCopySceneParam(scene, x020056_g_CSParamIdxStage, 1)
    SetCopySceneParam(scene, x020056_g_CSParamIdxCurSubStage, 0)
end

function x020056_OnCopySceneTick(scene, tickCount)
    local curStage = GetCopySceneParam(scene, x020056_g_CSParamIdxStage)
    local curSubStage = GetCopySceneParam(scene, x020056_g_CSParamIdxCurSubStage)
    SetCopySceneParam(scene, x020056_g_CSParamIdxCurSubStage, curSubStage + 1)
    if curStage == 3 and GetHostileMonsterCount(scene) == 0 and curSubStage == x020056_g_MovMaxTime1 then
        x020056_CreateMonsterOnStage(scene, curStage)
    elseif curStage == 4 and GetHostileMonsterCount(scene) == 0 and curSubStage == x020056_g_MovMaxTime2 then
        x020056_EndCopyScene(scene, true)
    end
end

function x020056_OnObjEnter(scene, objId)
    AutoCombat(scene, objId, true)
end

function x020056_OnObjDie(scene, objId, rolebaseId, killerId)
    if objId == GetUserObjIdByIdx(scene, 0) then
        x020056_EndCopyScene(scene, false)
    else
        local curStage = GetCopySceneParam(scene, x020056_g_CSParamIdxStage)
        local count = GetHostileMonsterCount(scene)
        if count == 0 then
            if curStage == 1 then
                x020056_CreateMonsterOnStage(scene, curStage + 1)
            elseif rolebaseId == x020056_g_MonsterId[2][1] then
                StoryAnimation(scene, x020056_g_CSParamAnimationID)
            elseif rolebaseId == x020056_g_MonsterId[3][1] then
                StoryAnimation(scene, x020056_g_CSParamAnimation2ID)
            end
            SetCopySceneParam(scene, x020056_g_CSParamIdxStage, curStage + 1)
            SetCopySceneParam(scene, x020056_g_CSParamIdxCurSubStage, 0)
        end
    end
end

function x020056_CreateMonsterOnStage(scene, stage)
    local monsters = x020056_g_MonsterId[stage]
    local pos = x020056_g_MonsterPos[stage]
    for i = 1, #monsters do
        CreateMonster(scene, monsters[i], pos[i][3], pos[i][1], pos[i][2])
    end
end

function x020056_OnStoryEventEnd(scene, nStoryId, nAnimationId)
    if nAnimationId == x020056_g_CSParamAnimationID then
        local curStage = GetCopySceneParam(scene, x020056_g_CSParamIdxStage)
        x020056_CreateMonsterOnStage(scene, curStage)
        TellPlayerAutoCombat(scene, true)
    end
    if nAnimationId == x020056_g_CSParamAnimation2ID then
        x020056_EndCopyScene(scene, true)
    end
end

function x020056_OnCopySceneTimeOut(scene)
    x020056_EndCopyScene(scene, false)
end

function x020056_EndCopyScene(scene, win)
    ChangeJobCopyEnd(scene, win)
    if win then
        SetCopySceneSuccess(scene)
    else
        SetCopySceneFail(scene)
    end
end