x020076_g_scriptId=020076

x020076_g_BossId = {} 
x020076_g_BossId[1] = {101, 102, 103, 104, 105, 106, 107, 108}
x020076_g_BossId[2] = {201, 202, 203, 204, 205, 206, 207, 208}
x020076_g_BossId[3] = {301, 302, 303, 304, 305, 306, 307, 308}
x020076_g_BossId[4] = {401, 402, 403, 404, 405, 406, 407, 408}

x020076_g_BossRoleBaseId = {} --BOSS
x020076_g_BossRoleBaseId[1] = {720001, 720002, 720003, 720004, 720005, 720006, 720007, 720008}
x020076_g_BossRoleBaseId[2] = {720101, 720102, 720103, 720104, 720105, 720106, 720107, 720108}
x020076_g_BossRoleBaseId[3] = {720201, 720202, 720203, 720204, 720205, 720206, 720207, 720208}
x020076_g_BossRoleBaseId[4] = {720301, 720302, 720303, 720304, 720305, 720306, 720307, 720308}

x020076_g_NPCRoleBaseId = {} --ģ
x020076_g_NPCRoleBaseId[1] = {721001, 721002, 721003, 721004, 721005, 721006, 721007, 721008}
x020076_g_NPCRoleBaseId[2] = {721101, 721102, 721103, 721104, 721105, 721106, 721107, 721108}
x020076_g_NPCRoleBaseId[3] = {721201, 721202, 721203, 721204, 721205, 721206, 721207, 721208}
x020076_g_NPCRoleBaseId[4] = {721301, 721302, 721303, 721304, 721305, 721306, 721307, 721308}

x020076_BossTip = {}
x020076_BossTip[1] = 16021
x020076_BossTip[2] = 16022
x020076_BossTip[3] = 16023
x020076_BossTip[4] = 16024

x020076_g_BossFakeObj = {}
x020076_g_BossFakeObj[1] = {60301, 60302, 60303, 60304, 60305, 60306, 60307, 60308}
x020076_g_BossFakeObj[2] = {60301, 60302, 60303, 60304, 60305, 60306, 60307, 60308}
x020076_g_BossFakeObj[3] = {60301, 60302, 60303, 60304, 60305, 60306, 60307, 60308}
x020076_g_BossFakeObj[4] = {60301, 60302, 60303, 60304, 60305, 60306, 60307, 60308}

x020076_g_Position = {} --ģص
x020076_g_Position[1] = {36.76, 60.8, -0.22}
x020076_g_Position[2] = {93.09, 72.02, 3.25}
x020076_g_Position[3] = {36.55, 72.02, -0.33}
x020076_g_Position[4] = {88.05, 82.32, 3.63}
x020076_g_Position[5] = {41.22, 82.39, -0.91}
x020076_g_Position[6] = {80.34, 89.73, 3.8}
x020076_g_Position[7] = {49.37, 89.87, -1.19}
x020076_g_Position[8] = {64.78, 94.69, 4.5}

x020076_g_BossPosition = {} --
x020076_g_BossPosition[1] = {}
x020076_g_BossPosition[1][1] = {65.31, 70.41, 4.4}
x020076_g_BossPosition[2] = {}
x020076_g_BossPosition[2][1] = {70.8, 69.45,4.4}
x020076_g_BossPosition[2][2] = {59.6, 70.48, 4.4}
x020076_g_BossPosition[3] = {}
x020076_g_BossPosition[3][1] = {54.44, 66.74, -0.81}
x020076_g_BossPosition[3][2] = {64.66, 73.31, 4.4}
x020076_g_BossPosition[3][3] = {74.55, 66.88, 3.66}
x020076_g_BossPosition[4] = {}
x020076_g_BossPosition[4][1] = {54.66, 65.99, -1.36}
x020076_g_BossPosition[4][2] = {69.6, 73.94, 3.89}
x020076_g_BossPosition[4][3] = {74.89, 65.86, 3.83}
x020076_g_BossPosition[4][4] = {59.45, 74.27, -1.12}

x020076_g_Impact = {5101001, 5101002, 5101003}

x020076_g_SelectMaxCount = 5

x020076_State = 0
x020076_BossType = 1
x020076_SelectBossDieState = {2,3,4,5,6}

function x020076_OnCopySceneOpen(scene)
	SetCopySceneParam(scene, x020076_State, 0)
	SetCopySceneParam(scene, x020076_BossType, 0)
	for i=1,#x020076_SelectBossDieState do 
		SetCopySceneParam(scene, x020076_SelectBossDieState[i], 0)
	end
	RefreshXingShouTaiBossType(scene)
	x020076_Init(scene)
end

function x020076_OnCopySceneTick(scene, tickCount)
	local state = GetCopySceneParam(scene, x020076_State)
	if state == 0 then
		x020076_RefreshBoss(scene)
		TellPlayerAutoCombat(scene, true)
	end
end

function x020076_OnObjDie(scene, objId, rolebaseId, killerId)
	local nUserCount = GetSceneUserCount(scene)
	for i = 0, x020076_g_SelectMaxCount - 1 do
		local id = GetXingShouTaiSelectBoss(scene, i)
		if id > 0 then
			if x020076_GetRoleBaseId(scene, id) == rolebaseId then
				SetCopySceneParam(scene, x020076_SelectBossDieState[i + 1], 1)
				for j=0,nUserCount-1 do   
					local nUserObjId = GetUserObjIdByIdx(scene,j)   
					SynCsStageData(scene, nUserObjId)
				end
			end
		end
	end

	local count = GetXingShouTaiSelectBossCount(scene)
	local killCount = 0;
	for i = 1, #x020076_SelectBossDieState do
		if GetCopySceneParam(scene, x020076_SelectBossDieState[i]) == 1 then
			killCount = killCount + 1
		end
	end

	if killCount >= count then
		x020076_EndCopyScene(scene, 1)
	end
end

function x020076_GetRoleBaseId(scene, id)
	local index = GetCopySceneParam(scene, x020076_BossType)
		for i = 1, #x020076_g_BossId[index] do
		if x020076_g_BossId[index][i] == id then
			return x020076_g_BossRoleBaseId[index][i]
		end
	end

	return -1
end

function x020076_OnCopySceneTimeOut(scene)
	x020076_EndCopyScene(scene, 0)
end

function x020076_Init(scene)
	local index = GetCopySceneParam(scene, x020076_BossType)
	local posIndex = 1
	for i = 1, #x020076_g_BossId[index] do
		local find = 0; 
		for j = 0, x020076_g_SelectMaxCount - 1 do
			local id = GetXingShouTaiSelectBoss(scene, j)
			if id > 0 then
				if x020076_g_BossId[index][i] == id then
					find = 1;
					break;
				end
			end
		end

		if find ~= 1 then 
			CreateMonster(scene, x020076_g_NPCRoleBaseId[index][i], x020076_g_Position[i][3], x020076_g_Position[i][1], x020076_g_Position[i][2])
		end
	end
end

function x020076_RefreshBoss(scene)
	local index = GetCopySceneParam(scene, x020076_BossType)
	local count = GetXingShouTaiSelectBossCount(scene)
	local posIndex = 1
	local random = -1
	for i = 1, #x020076_g_BossId[index] do
		local find = 0; 
		local pos = x020076_g_Position
		for j = 0, x020076_g_SelectMaxCount - 1 do
			local id = GetXingShouTaiSelectBoss(scene, j)
			if id > 0 then
				if x020076_g_BossId[index][i] == id then
					find = 1;
					break;
				end
			end
		end

		local idx = i
		if find == 1 then
			if random < 0 then
				random = i
			else
				local ran = RandomMon(1,3)
				if ran == 1 then
					random = i
				end
			end

			pos = x020076_g_BossPosition[count]
			idx = posIndex
			posIndex = posIndex	 + 1
			local objid = CreateMonster(scene, x020076_g_BossRoleBaseId[index][i], pos[idx][3], pos[idx][1], pos[idx][2])
			if idx > 1 then
				SendImpactToUnit(scene, objid, x020076_g_Impact[idx - 1])
			end
		end


	end
	
	BroadCastBossTips(scene, x020076_g_BossFakeObj[index][random], x020076_BossTip[count], x020076_g_BossRoleBaseId[index][random], 4)
	SetCopySceneParam(scene, x020076_State, 1)
end

function x020076_EndCopyScene(scene, win)
	XingShouTaiCopySceneEnd(scene, win)
	if win == 1 then
		AccoutByCopyScene(scene)
		SetCopySceneSuccess(scene)
	else
		SetCopySceneFail(scene)	
	end

	for i=1,#x020076_g_BossRoleBaseId do
		for j=1,#x020076_g_BossRoleBaseId[i] do
			DeleMonsterByRoleId(scene, x020076_g_BossRoleBaseId[i][j])
		end
	end

	for i=1,#x020076_g_NPCRoleBaseId do
		for j=1,#x020076_g_NPCRoleBaseId[i] do
			DeleMonsterByRoleId(scene, x020076_g_NPCRoleBaseId[i][j])
		end
	end
end