x020067_g_scriptId = 020067

x020067_g_PlayerKillScore = 100 -- 击杀玩家获得积分
x020067_g_MonsterKillScore = 50 -- 击杀怪物获得积分

x020067_g_PlayerStartPos = {} -- 玩家出生点(x,z,faceDir)
x020067_g_PlayerStartPos[1] = {{35.23,57.54,-1.51},{48.3,57.42,-1.51},{61.31,57.13,-2.6},{49,45.06,-1.51},{61.85,32.72,-4},{34.27,44.15,-0.08},{62.87,45.45,-2.6},{34.45,33.2,1.01},{53.74,32.63,-4.68},{42.96,32.12,1.43}}
x020067_g_MonsterStartPos = {} -- 怪物出生点(x,z,faceDir)
x020067_g_MonsterStartPos[1] = {{37.77,45.64,0.82},{39.35,46.34,0.67}}
x020067_g_MonsterStartPos[2] = {{55.15,53.06,-3.25},{56.57,51.52,-4}}
x020067_g_MonsterStartPos[3] = {{52.92,36.07,-3.25},{54.34,34.53,-4}}
x020067_g_BuffPos = {} -- Buff生成点
x020067_g_BuffPos[1] = {{46.66,49.3,1.57},{53.77,44.88,1.57},{45.6,40.59,1.57}}
x020067_g_BuffId = {} -- GroupPointId
x020067_g_BuffId[1] = {801,802,803}

x020067_g_MonsterId = 520000 -- 怪物起始ID
x020067_g_MonsterReliveTime = 10 -- 怪物重生时间 单位秒

x020067_g_StageScore = {} -- 每个阶段积分
x020067_g_StageScore[1] = {100,300,600,1000,1600,2400}

-- CopySceneParam
x020067_g_PScore = 1 -- 击杀玩家获得积分
x020067_g_MScore = 2 -- 击杀怪物获得积分
x020067_g_MId = 3 -- 怪物起始ID
x020067_g_MReliveTime = 4 -- 怪物复活时间
x020067_g_Ticks = 9 -- 持续时间

function x020067_OnCopySceneInit(scene)	

	ClearBrawlStageScore(scene)
	-- 初始化副本常量
	SetCopySceneParam(scene,x020067_g_PScore,x020067_g_PlayerKillScore)
	SetCopySceneParam(scene,x020067_g_MScore,x020067_g_MonsterKillScore)
	SetCopySceneParam(scene,x020067_g_MReliveTime,x020067_g_MonsterReliveTime)
	local countStage = #x020067_g_StageScore[1]
	for i = 1, countStage do
		InitBrawlStageScore(scene,x020067_g_StageScore[1][i])
	end
end

function x020067_OnCopySceneTimeOut(scene)
	x020067_Succeed(scene)
end

function x020067_OnCopySceneTick(scene,tickCount)
	local realTime = tickCount
	if (realTime < 0) then
		return
	end
	
	if (GetCopySceneStatus(scene) > 2) then
		return
	end
	
	-- 根据副本平均等级生成对应等级怪物
	local level = GetRealTimeAdaptLvl(scene)
	if level > 1000 then
		level = 1000
	end
	local monsterRealId = x020067_g_MonsterId + level - level % 10
	-- 活动开始
	if (realTime == 0) then
		for i = 1, 3 do
			local countMonsterPos = #x020067_g_MonsterStartPos[i]
			for j = 1, countMonsterPos do
				CreateMonster(scene,monsterRealId,x020067_g_MonsterStartPos[i][j][3],x020067_g_MonsterStartPos[i][j][1],x020067_g_MonsterStartPos[i][j][2])
			end
		end
		
		-- 生成Buff点
		local countBuffPos = #x020067_g_BuffPos[1]
		for i = 1, countBuffPos do
			CreateGroupPoint(scene,x020067_g_BuffId[1][i],x020067_g_BuffPos[1][i][1],x020067_g_BuffPos[1][i][2],x020067_g_BuffPos[1][i][3])
		end
	end
	 
	-- 检查怪物复活
	CheckMonsterRelive(scene,GetCopySceneParam(scene,x020067_g_Ticks),monsterRealId)
	-- 检查踢出玩家
	CheckBrawlCSLeave(scene)
end

function x020067_OnObjEnter(scene,objId)	
	local ran = RandomMon(1,#x020067_g_PlayerStartPos[1] + 1)
	SetPos(scene,objId,x020067_g_PlayerStartPos[1][ran][1],x020067_g_PlayerStartPos[1][ran][2],x020067_g_PlayerStartPos[1][ran][3])
	RecordBrawlCSRelivePos(scene,objId,x020067_g_PlayerStartPos[1][ran][1],0,x020067_g_PlayerStartPos[1][ran][2],x020067_g_PlayerStartPos[1][ran][3])
	SendBrawlCSData(scene,objId)
	AutoCombat(scene,objId,true)
	-- OpBrawlCSUI(scene,objId,true)
end

function x020067_OnObjLeave(scene,objId)
	AutoCombat(scene,objId,false)
	-- OpBrawlCSUI(scene,objId,false)
end

function x020067_OnObjDie(scene,objId,rolebaseId,killerId)
	CalBrawlCSData(scene,objId,killerId)
end

function x020067_Succeed(scene)
	DeleHostileMonster(scene)
	LuanZhanEnd(scene)
	SetCopySceneSuccess(scene)
end

