x020070_g_scriptId = 020070

-- 玩家坐标
x020070_g_HostPos = {12.44,34.85, -0.03}
x020070_g_GuestPos = {58.44,35.02, 3.07}

-- 定身Buff 用于控制玩家开场时间内无法移动 30秒定身效果
x020070_g_StunBuff=20254

-- CopySceneParam
x020070_g_State = 3 -- 开始标识
x020070_g_Host = 1 -- 主玩家ObjId
x020070_g_Guest = 2 -- 客玩家ObjId
x020070_g_RoundTime = 4 -- 副本倒计时
x020070_g_winTime = 5--连胜次数 2次以后不需要round3
x020070_g_winObjId = 6--单局获胜玩家id
x020070_g_HostWinCount =  10 --每一场host的胜局 用来判断胜利结果
x020070_g_GuestWinCount = 11 --每一场guest的胜局  用来判断胜利结果
x020070_g_IsWait = 12
x020070_g_LadderState = 13 --跨服副本状态(0没人进，1是有一个人，2是正常开始)
x020070_g_CountDownTime = 14

x020070_g_OneRoundDuration = 90
x020070_g_NextTime = 5
x020070_g_WaitTime = 10

function x020070_OnCopySceneOpen(scene)
	SetCopySceneParam(scene,x020070_g_State,0)
	SetCopySceneParam(scene,x020070_g_Host,0)
	SetCopySceneParam(scene,x020070_g_Guest,0)
	SetCopySceneParam(scene,x020070_g_HostWinCount,0)
	SetCopySceneParam(scene,x020070_g_GuestWinCount,0)
	SetCopySceneParam(scene,x020070_g_LadderState,0)
	SetCopySceneParam(scene,x020070_g_CountDownTime,0)
end

function x020070_OnObjEnter(scene,objId)

	if IsLadderUser(scene, objId) then
		SetCopySceneParam(scene, x020070_g_Host, objId)
		if GetCopySceneParam(scene, x020070_g_Guest) > 0 then
			--给主场发客场
			SendGuestHpToHost(scene, objId, GetCopySceneParam(scene, x020070_g_Guest))
			--选择客场为目标
			LadderSelectTarget(scene, objId, GetCopySceneParam(scene, x020070_g_Guest))
		end
		local time = GetCopySceneParam(scene, x020070_g_RoundTime)
		--LadderRoundCountTime(scene, GetCopySceneParam(scene, x020070_g_Host), 1, x020070_g_OneRoundDuration + x020070_g_WaitTime - time)
	else
		SetCopySceneParam(scene, x020070_g_Guest, objId)

		if GetCopySceneParam(scene, x020070_g_Host) > 0 then
			--给主场发客场
			SendGuestHpToHost(scene, GetCopySceneParam(scene, x020070_g_Host), objId)
			--选择主场为目标
			LadderSelectTarget(scene, objId, GetCopySceneParam(scene, x020070_g_Host))
		end
	end

	--玩家初始化
	x020070_ResetPlayerState(scene, objId)
	RemoveUserAllCdTime(scene,objId)

	local ladderstate = GetCopySceneParam(scene, x020070_g_LadderState)
	if ladderstate == 0 then
		SetCopySceneParam(scene, x020070_g_LadderState, ladderstate + 1)

		--todo 发送给客户端倒计时30秒
		SendLadder30CountTime(scene, objId)
		SetCopySceneParam(scene, x020070_g_CountDownTime, 0)
	elseif ladderstate == 1 then
		SetCopySceneParam(scene, x020070_g_LadderState, ladderstate + 1)
		SetCopySceneParam(scene, x020070_g_State, 0)
		SetCopySceneParam(scene, x020070_g_RoundTime, 0)

		--关闭30倒计时 开始第一场开始倒计时和特效
		local host = GetCopySceneParam(scene, x020070_g_Host)
		local guest = GetCopySceneParam(scene, x020070_g_Guest)
		CloseLadder30CountTime(scene, host)
		CloseLadder30CountTime(scene, guest)
		LadderRoundCountTime(scene, GetCopySceneParam(scene, x020070_g_Host), 1)
	end
end

function x020070_RoundCountTime(scene, index)
	LadderRoundCountTime(scene, GetCopySceneParam(scene, x020070_g_Host), index)
	LadderRoundCountTime(scene, GetCopySceneParam(scene, x020070_g_Guest), index)
end

function x020070_ShowRoundEffect(scene, index, time)
	ShowLadderRoundEffect(scene, GetCopySceneParam(scene, x020070_g_Host), index, time)
	ShowLadderRoundEffect(scene, GetCopySceneParam(scene, x020070_g_Guest), index, time)
end

--服务器调用 TickScript 倒计时90秒
function x020070_OnCopySceneTick(scene, tickCount)

	if tickCount == 10  then
		if LadderIsConnected(scene, x020070_g_Host) then
			x020070_ConnectedLadderEnd(scene, 2)
			return
		end

		if LadderIsConnected(scene, x020070_g_Guest) then
			x020070_ConnectedLadderEnd(scene, 1)
			return
		end
	end

	local ladder = GetCopySceneParam(scene, x020070_g_LadderState)
	if ladder == 1 then 
		local count = GetCopySceneParam(scene, x020070_g_CountDownTime)
		count = count + 1
		if count > 30 then
			if GetCopySceneParam(scene, x020070_g_Host) > 0 then
				x020070_LadderEnd(scene, 1)
				--主场直接胜利
				local host = GetCopySceneParam(scene, x020070_g_Host)
				PassLadderToWin(scene,host)
			else
				x020070_LadderEnd(scene, 2)
				--客场直接胜利
				local guest = GetCopySceneParam(scene, x020070_g_Guest)
				PassLadderToWin(scene,guest)
			end
		end
	elseif ladder == 2 then
		local time = GetCopySceneParam(scene, x020070_g_RoundTime)
		time = time + 1
		SetCopySceneParam(scene, x020070_g_RoundTime, time)

		local state = GetCopySceneParam(scene, x020070_g_State)

		if state == 0 and time > x020070_g_NextTime then
			x020070_StartRound(scene)
    		--x020070_ShowRoundEffect(scene, 2, x020070_g_OneRoundDuration + x020070_g_WaitTime - time)
    	elseif state == 1 and time > x020070_g_OneRoundDuration then
        	x020070_SetRoundEnd(scene, -1)
    	elseif state == 2 and time > x020070_g_NextTime and GetCopySceneParam(scene, x020070_g_IsWait) == 0 then
			x020070_WaitStartBattle(scene)
			x020070_RoundCountTime(scene, 2)
    		SetCopySceneParam(scene, x020070_g_IsWait, 1)
    	elseif state == 2 and time > x020070_g_WaitTime  then
    		x020070_StartRound(scene)
    		x020070_ShowRoundEffect(scene, 2, x020070_g_OneRoundDuration + x020070_g_WaitTime - time)
    	elseif state == 3 and time > x020070_g_OneRoundDuration then
        	x020070_SetRoundEnd(scene, -1)
    	elseif state == 4 and time > x020070_g_NextTime and GetCopySceneParam(scene, x020070_g_IsWait) == 0 then
			x020070_WaitStartBattle(scene)
			x020070_RoundCountTime(scene, 3)
    		SetCopySceneParam(scene, x020070_g_IsWait, 1)
    	elseif state == 4 and time > x020070_g_WaitTime then
    		x020070_StartRound(scene)
    		x020070_ShowRoundEffect(scene, 3,  x020070_g_OneRoundDuration + x020070_g_WaitTime - time)
    	elseif state == 5 and time > x020070_g_OneRoundDuration then
        	x020070_SetRoundEnd(scene, -1)
    	end
	end
end

function x020070_OnObjLeave(scene,objId,rolebaseId)

	if GetCopySceneParam(scene, x020070_g_LadderState) == 3 then
		return
	end

	if GetCopySceneParam(scene, x020070_g_Host) == objId then
		x020070_LadderEnd(scene, 2)
		--客场直接胜利
		local guest = GetCopySceneParam(scene, x020070_g_Guest)
		PassLadderToWin(scene,guest)
	else
		x020070_LadderEnd(scene, 1)
		--主场直接胜利
		local host = GetCopySceneParam(scene, x020070_g_Host)
		PassLadderToWin(scene,host)
	end
	--x020070_SetRoundEnd(scene, objId)
end
	
function x020070_OnObjDie(scene,objId,rolebaseId,killerId)
	local state = GetCopySceneParam(scene, x020070_g_State)
	if state == 1 or state == 3 or state == 5 then
		x020070_SetRoundEnd(scene, objId)
	end
end


--进入副本后开始进入战斗 一场战斗有三局
function x020070_WaitStartBattle(scene)
	local state = GetCopySceneParam(scene, x020070_g_State)
	if state < 1 or state > 5 then
		return
	end

	x020070_ResetPlayerState(scene, GetCopySceneParam(scene, x020070_g_Host))
	x020070_ResetPlayerState(scene, GetCopySceneParam(scene, x020070_g_Guest))
end

function x020070_ResetPlayerState(scene, objId)
	SendImpactToUnit(scene,objId,x020070_g_StunBuff)
	TestFullHp(scene,objId)
	RemoveCDTime(scene,objId)
	AutoCombat(scene,objId,true)
	FullLingGang(scene, objId)
	
	if objId == GetCopySceneParam(scene, x020070_g_Host) then
		SetScenePos(scene, objId, x020070_g_HostPos[1], x020070_g_HostPos[2], x020070_g_HostPos[3])
	else
		SetScenePos(scene, objId, x020070_g_GuestPos[1], x020070_g_GuestPos[2], x020070_g_GuestPos[3])
	end
end

function x020070_StartRound(scene)
	RemoveImpact(scene, GetCopySceneParam(scene, x020070_g_Host), x020070_g_StunBuff)	
	RemoveImpact(scene, GetCopySceneParam(scene, x020070_g_Guest), x020070_g_StunBuff)

	local state = GetCopySceneParam(scene, x020070_g_State)
	SetCopySceneParam(scene, x020070_g_State, state + 1)
	SetCopySceneParam(scene, x020070_g_RoundTime, 0)
end

function x020070_SetRoundEnd(scene, objId)
	local state = GetCopySceneParam(scene, x020070_g_State)
	if state < 1 or state > 5 then
		return
	end

	local host = GetCopySceneParam(scene, x020070_g_Host)
	local guest = GetCopySceneParam(scene, x020070_g_Guest)

	if objId == host then
		x020070_SetRoundWinCount(scene, 2)
	elseif objId == guest then
		x020070_SetRoundWinCount(scene, 1)
	else
		x020070_SetRoundWinCount(scene, -1)
	end

	LadderOneRoundEnd(scene, objId)

	local hostwin = GetCopySceneParam(scene, x020070_g_HostWinCount)
	local guestwin = GetCopySceneParam(scene, x020070_g_GuestWinCount)

	if hostwin > 1 then
		SetCopySceneParam(scene, x020070_g_State, 0)
		x020070_LadderEnd(scene, 1)
	elseif guestwin > 1 then
		SetCopySceneParam(scene, x020070_g_State, 0)
		x020070_LadderEnd(scene, 2)
	elseif state == 5 then
		TestFullHp(scene,x020070_g_Host)
		TestFullHp(scene,x020070_g_Guest)
		RemoveImpact(scene, GetCopySceneParam(scene, x020070_g_Host), x020070_g_StunBuff)	
	    RemoveImpact(scene, GetCopySceneParam(scene, x020070_g_Guest), x020070_g_StunBuff)
		if hostwin > guestwin then
			SetCopySceneParam(scene, x020070_g_State, 0)
			x020070_LadderEnd(scene, 1)
		elseif guestwin > hostwin then
			SetCopySceneParam(scene, x020070_g_State, 0)
			x020070_LadderEnd(scene, 2)
		else
			SetCopySceneParam(scene, x020070_g_State, 0)
			x020070_LadderEnd(scene, 0)
		end
		
		
		
	else
		SetCopySceneParam(scene, x020070_g_State, state + 1)
	end

    SetCopySceneParam(scene, x020070_g_RoundTime, 0)
    SetCopySceneParam(scene, x020070_g_IsWait, 0)
end

function x020070_SetRoundWinCount(scene, win)
	if win == 1 then
		local count = GetCopySceneParam(scene, x020070_g_HostWinCount)
		SetCopySceneParam(scene, x020070_g_HostWinCount, count + 1)
	elseif win == 2 then
		local count = GetCopySceneParam(scene, x020070_g_GuestWinCount)
		SetCopySceneParam(scene, x020070_g_GuestWinCount, count + 1)
	end
end

function x020070_LadderEnd(scene, objid)
  

	Ladder1v1End(scene, objid)
	SetCopySceneSuccess(scene)
	SetCopySceneParam(scene, x020070_g_LadderState, 3)
end

function x020070_ConnectedLadderEnd(scene, objid)

	Ladder1v1End(scene, objid, 1)
	SetCopySceneSuccess(scene)
	SetCopySceneParam(scene, x020070_g_LadderState, 3)
end