x020054_g_scriptId = 020054

x020054_g_MonsterId = {} -- 每波怪物的起始ID
x020054_g_MonsterId[1] = {450001,451001,452001}

x020054_g_MonsterNum = {} -- 每波怪物的数量
x020054_g_MonsterNum[1] = {20,20,20}

x020054_g_MonsterPos = {} -- 每波怪物的出生位置
x020054_g_MonsterPos[1] = {{48.13,36.87,1.57},{48.03,47.16,-1.61},{52.42,42.31,-3.1},{44.11,49.44,-0.71},{38.59,42.03,0},{58.05,41.84,-3.13},{51.67,32.7,-4.16},{40.43,38.48,0.68},{56.21,33.26,-4.26},{56.3,49.71,-2.28},{40.79,47.74,-0.51},{40.89,34.66,0.85},{44.88,34.56,0.72},{55.86,45.22,-2.52},{55.35,38.21,-3.68},{52.44,36.36,-4.11},{52.61,47.17,-2.45},{43.1,37.29,0.57},{43.36,46.47,-0.71},{42.7,41.86,-0.02}}
x020054_g_MonsterPos[2] = {{48.13,36.87,1.57},{48.03,47.16,-1.61},{52.42,42.31,-3.1},{44.11,49.44,-0.71},{38.59,42.03,0},{58.05,41.84,-3.13},{51.67,32.7,-4.16},{40.43,38.48,0.68},{56.21,33.26,-4.26},{56.3,49.71,-2.28},{40.79,47.74,-0.51},{40.89,34.66,0.85},{44.88,34.56,0.72},{55.86,45.22,-2.52},{55.35,38.21,-3.68},{52.44,36.36,-4.11},{52.61,47.17,-2.45},{43.1,37.29,0.57},{43.36,46.47,-0.71},{42.7,41.86,-0.02}}
x020054_g_MonsterPos[3] = {{48.13,36.87,1.57},{48.03,47.16,-1.61},{52.42,42.31,-3.1},{44.11,49.44,-0.71},{38.59,42.03,0},{58.05,41.84,-3.13},{51.67,32.7,-4.16},{40.43,38.48,0.68},{56.21,33.26,-4.26},{56.3,49.71,-2.28},{40.79,47.74,-0.51},{40.89,34.66,0.85},{44.88,34.56,0.72},{55.86,45.22,-2.52},{55.35,38.21,-3.68},{52.44,36.36,-4.11},{52.61,47.17,-2.45},{43.1,37.29,0.57},{43.36,46.47,-0.71},{42.7,41.86,-0.02}}

x020054_g_EveryStageTime = 50 -- 每阶段时间 单位秒
x020054_g_TotleTime = 150 -- 副本总时间 单位秒

x020054_g_MonsterReliveTime = 2 -- 怪物重生时间 单位秒
x020054_g_LevelMax = 1000 -- 玩家最高等级

x020054_g_EncouragementBuffId = 99999 -- 鼓舞BuffId

x020054_g_ActivtyType = {} -- 对应ActivtyBonus中的列
x020054_g_ActivtyType[1] = {6,34,35}
x020054_g_YuanShenExpIndex = {5, 6, 7}
-- CopySceneParam
x020054_g_Stage = 0				-- 阶段
x020054_g_MonsterKilledNum = 1	-- 杀怪数
x020054_g_Exp = 2				-- 获得经验
x020054_g_Buff = 3				-- 鼓舞BuffId
x020054_g_StageTime = 4			-- 每阶段时间
x020054_g_WaitStartTime = 5		-- 副本开始时间
x020054_g_ShouHuExpRate = 6		-- 守护经验找回比例
x020054_g_Ticks = 9				-- 持续时间


x020054_g_LevelAddBuff = {}
x020054_g_LevelAddBuff[1] = { -1, 120200001, 120200002, 120200002, 120200002 }

function x020054_OnCopySceneOpen(scene)
	SetCopySceneParam(scene,x020054_g_Stage,1)
	SetCopySceneParam(scene,x020054_g_MonsterKilledNum,0)
	SetCopySceneParam(scene,x020054_g_Exp,0)
	SetCopySceneParam(scene,x020054_g_Buff,x020054_g_EncouragementBuffId)
	SetCopySceneParam(scene,x020054_g_StageTime,x020054_g_EveryStageTime)
	SetCopySceneParam(scene,x020054_g_WaitStartTime,GetWaitStartTime(scene) / 1000)
	InitShouHuExpRate(scene,x020054_g_ShouHuExpRate)

	ClearExp(scene)
end

function x020054_OnCopySceneTimeOut(scene)
	x020054_Succeed(scene)
end

function x020054_OnCopySceneTick(scene,tickCount)
	local realTime = tickCount
	if (realTime < 0) then
		return
	end
	-- 20秒时候 给没使用鼓舞的玩家自动鼓舞
	local nUserCount = GetSceneUserCount(scene)
    if tickCount == 20 then
        for i = 0, nUserCount - 1 do		
			local ObjId = GetUserObjIdByIdx(scene,i)
			AutoInspire(scene,ObjId)
		end
    end
    local stage = GetCopySceneParam(scene,x020054_g_Stage)
	if (GetCopySceneStatus(scene) > 2 and realTime < x020054_g_EveryStageTime) then
		return
	end

	-- local level = GetRealTimeAdaptLvl(scene)
	local level = GetExpCSAdaptLvl(scene)
	local offset
	if (level <= 200) then
		offset = level - 1
	else
		offset = 199 + (((((level - 201) - ((level - 201) % 10)) / 10) + 1) * 10)
	end
	if nUserCount < 1 then
        nUserCount = 1
    end
	if (realTime % x020054_g_EveryStageTime == 0) then
		SetCopySceneParam(scene,x020054_g_Stage,realTime / x020054_g_EveryStageTime + 1)
		--BroadcastExpCSData(scene)
		-- 一阶段怪物直接刷新 二三阶段生成对应阶段的怪物 并将数量补满
		if (stage > #x020054_g_MonsterNum[1]) then
			return
		end
		-- 根据等级计算出怪的roleBaseId和实际经验
		local monsterRealId = x020054_g_MonsterId[1][stage] + offset
		local MonId
		local countMonster
		if (stage == 1) then
			countMonster = x020054_g_MonsterNum[1][stage]
			for i = 1, countMonster do
				-- CreateMonster(scene,monsterRealId,x020054_g_MonsterPos[stage][i][3],x020054_g_MonsterPos[stage][i][1],x020054_g_MonsterPos[stage][i][2],level,x020054_g_ActivtyType[1][stage])
				MonId = CreateMonster(scene,monsterRealId,x020054_g_MonsterPos[stage][i][3],x020054_g_MonsterPos[stage][i][1],x020054_g_MonsterPos[stage][i][2])
				SendImpactToUnit(scene, MonId, x020054_g_LevelAddBuff[1][nUserCount])
				SetHpFull(scene, MonId)
			    UpdateObjHpMax(scene,MonId)
			end
		else
			countMonster = x020054_g_MonsterNum[1][stage] - GetHostileMonsterCount(scene)
			for i = 1, countMonster do
				-- CreateMonster(scene,monsterRealId,x020054_g_MonsterPos[stage][i][3],x020054_g_MonsterPos[stage][i][1],x020054_g_MonsterPos[stage][i][2],level,x020054_g_ActivtyType[1][stage])
				MonId = CreateMonster(scene,monsterRealId,x020054_g_MonsterPos[stage][i][3],x020054_g_MonsterPos[stage][i][1],x020054_g_MonsterPos[stage][i][2])
				SendImpactToUnit(scene, MonId, x020054_g_LevelAddBuff[1][nUserCount])
				SetHpFull(scene, MonId)
			    UpdateObjHpMax(scene,MonId)
			end
		end
	end

	if (GetCopySceneParam(scene,x020054_g_Stage) <= #x020054_g_MonsterId[1]) then
		CheckMonsterRelive(scene,GetCopySceneParam(scene,x020054_g_Ticks),
				x020054_g_MonsterId[1][GetCopySceneParam(scene,x020054_g_Stage)] + offset,
				x020054_g_LevelAddBuff[1][nUserCount])
	end

	CheckExpCSLost(scene)
end

function x020054_OnObjEnter(scene,objId)
	BroadcastExpCSData(scene)
	AutoCombat(scene,objId,true)
	OpExpCSUI(scene,objId,1,true)
	OpExpCSUI(scene,objId,2,true)
	OpExpCSBuff(scene,objId,true)
end

function x020054_OnObjLeave(scene,objId)
	AutoCombat(scene,objId,false)
	OpExpCSUI(scene,objId,1,false)
	OpExpCSUI(scene,objId,2,false)
	OpExpCSBuff(scene,objId,false)
end

function x020054_OnObjDie(scene,objId,rolebaseId,killerId)
	if (rolebaseId < 5) then
		return
	end

	-- 获取死亡的怪物类型
	local monsterType = 1
	local countMonsterType = #x020054_g_MonsterId[1]
	for i = 1, countMonsterType do
		if (rolebaseId >= x020054_g_MonsterId[1][i]) and (rolebaseId < x020054_g_MonsterId[1][i] + x020054_g_LevelMax) then
			monsterType = i
			break
		end
	end

	local ran

	-- 判断该怪物是否是本阶段的怪物 如果不是 生成一只本阶段怪物
	local stage = GetCopySceneParam(scene,x020054_g_Stage)
	if (stage > #x020054_g_MonsterNum[1]) then
		return
	end
	local MonId
	local nUserCount = GetSceneUserCount(scene)
    if nUserCount < 1 then
        nUserCount = 1
    end
	-- local level = GetRealTimeAdaptLvl(scene)
	local level = GetExpCSAdaptLvl(scene)
	if (monsterType ~= stage) then
		local monsterRealId
		if (level <= 200) then
			monsterRealId = x020054_g_MonsterId[1][stage] + level - 1
		else
			monsterRealId = x020054_g_MonsterId[1][stage] + 199 + (((((level - 201) - ((level - 201) % 10)) / 10) + 1) * 10)
		end
		ran = RandomMon(1,#x020054_g_MonsterPos[stage])
		-- CreateMonster(scene,monsterRealId,x020054_g_MonsterPos[stage][ran][3],x020054_g_MonsterPos[stage][ran][1],x020054_g_MonsterPos[stage][ran][2],level,x020054_g_ActivtyType[1][stage])
		MonId = CreateMonster(scene,monsterRealId,x020054_g_MonsterPos[stage][ran][3],x020054_g_MonsterPos[stage][ran][1],x020054_g_MonsterPos[stage][ran][2])
		SendImpactToUnit(scene, MonId, x020054_g_LevelAddBuff[1][nUserCount])
		SetHpFull(scene, MonId)
	    UpdateObjHpMax(scene,MonId)
	end

	-- 判断该怪物的复活时间是否会在下一阶段
	if (GetCopySceneParam(scene,x020054_g_Ticks) < x020054_g_EveryStageTime * monsterType - x020054_g_MonsterReliveTime) then
		ran = RandomMon(1,#x020054_g_MonsterPos[monsterType])
		SetMonsterRelive(scene,rolebaseId,x020054_g_MonsterId[1][monsterType],GetCopySceneParam(scene,x020054_g_Ticks) + x020054_g_MonsterReliveTime,x020054_g_MonsterPos[monsterType][ran][3],x020054_g_MonsterPos[monsterType][ran][1],x020054_g_MonsterPos[monsterType][ran][2],0,x020054_g_ActivtyType[1][monsterType])
	end

	SetCopySceneParam(scene,x020054_g_MonsterKilledNum,GetCopySceneParam(scene,x020054_g_MonsterKilledNum) + 1)
	-- RecordExp(scene,rolebaseId)
	RecordExpByLevel(scene,objId,x020054_g_ActivtyType[1][stage],x020054_g_YuanShenExpIndex[stage])
	BroadcastExpCSData(scene)
end

function x020054_Succeed(scene)
	DeleHostileMonster(scene)
	EndExpCS(scene)
	AccoutByCopyScene(scene)
	SetCopySceneSuccess(scene)
end

