x020031_g_scriptId = 020031

x020031_g_Position = {}
x020031_g_Position[1] = { 49.54, 250.32, -0.87 }             --红方出生地(x,y,f)(f为朝向)
x020031_g_Position[2] = { 248.36, 52.57, 2.4}             --蓝方出生地(x,y,f)

x020031_g_BaseRolebase = {260001, 260100}

x020031_g_BaseId = {}
x020031_g_BaseId[1] = 99998
x020031_g_BaseId[2] = 99999


x020031_g_BasePosition = {}
x020031_g_BasePosition[1] = { 82.49, 218.06, 0 }          --红方水晶(rolebaseId,x,y,f)
x020031_g_BasePosition[2] = { 218.02, 82.32, 0 }          --蓝方水晶(rolebaseId,x,y,f)

x003013_g_WaitExp = 0
x020031_g_ReadyGetExpTime = 0   --每几秒获得一次经验

x020031_g_RedGroupPoint = {}
x020031_g_RedGroupPoint[1] = { 4001, 99.74, 200.26, 0}  --红方传送点1(采集点Id，X坐标，Z坐标，朝向)
x020031_g_RedGroupPoint[2] = { 4003, 118.71, 181.25, 0 }  --红方传送点2(采集点Id，X坐标，Z坐标，朝向)

x020031_g_BlueGroupPoint = {}
x020031_g_BlueGroupPoint[1] = { 4002, 200.66, 99.95, 0 } --蓝方传送点1(采集点Id，X坐标，Z坐标，朝向)
x020031_g_BlueGroupPoint[2] = { 4004, 181.17, 118.82, 0 } --蓝方传送点2(采集点Id，X坐标，Z坐标，朝向)

x020031_g_FlagGroupPoint = {}
x020031_g_FlagGroupPoint[1] = { 4010, 101.77, 222.05, 1.57 } --旗子1(红方家)(采集点Id，X坐标，Z坐标，朝向)
x020031_g_FlagGroupPoint[2] = { 4011, 199.78, 76.87, 1.57 } --旗子2(蓝方家)(采集点Id，X坐标，Z坐标，朝向)
x020031_g_FlagGroupPoint[3] = { 4012, 192.53, 192.41, 2.35 } --旗子3(中立)(采集点Id，X坐标，Z坐标，朝向)
x020031_g_FlagGroupPoint[4] = { 4013, 149.97, 150.06, 2.35 } --旗子4(中立)(采集点Id，X坐标，Z坐标，朝向)
x020031_g_FlagGroupPoint[5] = { 4014, 107.54, 107.48, 1.57} --旗子5(中立)(采集点Id，X坐标，Z坐标，朝向)

x020031_g_RedCamp = 1
x020031_g_BlueCamp = 2

x020031_g_FlagPoint = 1      --1个旗子1秒获得的点数
x020031_g_UserPoint = 0      --杀死玩家获得的点数
x020031_g_PointMax = 2000      --总点数

x020031_g_InvincibleImpact = 600010    --无敌buff
x020031_g_LeagueImpact = {}
x020031_g_LeagueImpact[0] = 30702   --S级
x020031_g_LeagueImpact[2] = 30703   --B级
x020031_g_LeagueImpact[3] = 30704   --C级
x020031_g_LeagueImpact[4] = 30705   --D级
x020031_g_PlayerImpact = 30706
x020031_g_FinalsImpact = 30701

x020031_g_WinRewardId = 3       --胜利奖励(邮件表Id)
x020031_g_LoseRewardId = 4      --失败奖励(邮件表Id)

x020031_g_ParamRedBaseHp = 0
x020031_g_ParamBlueBaseHp = 1
x020031_g_ParamRedPoint = 2
x020031_g_ParamBluePoint = 3
x020031_g_ParamWinnerId = 4
x020031_g_ParamMaxPoint = 5
x020031_g_ParamWinRewardId = 6
x020031_g_ParamLoseRewardId = 7
x020031_g_RedState = 8          -- 0为抢旗阶段，1为打水晶阶段，2水晶爆破输了
x020031_g_BlueState = 9
x020031_g_SceneState = 10
x020031_g_WinCount = 11

--服务器调用 HandleTask(RequestGuildBattleScene vTask)
function x020031_OnCopySceneOpen ( scene )
    local level = GetServerLevel(scene)
    local rolebase = x003013_GetMonsterRoleBaseId(x020031_g_BaseRolebase, level)
    local redFlag = CreateMonster (scene, x020031_g_BaseId[1], x020031_g_BasePosition[1][3], x020031_g_BasePosition[1][1], x020031_g_BasePosition[1][2], level, -1, rolebase)
    SendImpactToUnit (scene, redFlag, x020031_g_InvincibleImpact)
    local league = GetGuildBattleLeagueLevel(scene)
    if league ~= 1 then 
        SendImpactToUnit(scene, redFlag, x020031_g_LeagueImpact[league])
        SetHpFull(scene, redFlag)
    end

    local blueFlag = CreateMonster (scene, x020031_g_BaseId[2], x020031_g_BasePosition[2][3], x020031_g_BasePosition[2][1], x020031_g_BasePosition[2][2], level, -1, rolebase)
    SendImpactToUnit (scene, blueFlag, x020031_g_InvincibleImpact)
    if league ~= 1 then     
        SendImpactToUnit(scene, blueFlag, x020031_g_LeagueImpact[league])
        SetHpFull(scene, blueFlag) 
    end

    SetGuildBattleParam (scene, x020031_g_PointMax, x020031_g_ParamMaxPoint)
    SetGuildBattleParam (scene, x020031_g_WinRewardId, x020031_g_ParamWinRewardId)
    SetGuildBattleParam (scene, x020031_g_LoseRewardId, x020031_g_ParamLoseRewardId)
    SetGuildBattleParam (scene, 0, x020031_g_RedState)
    SetGuildBattleParam (scene, 0, x020031_g_BlueState)
    SetGuildBattleParam (scene, 0, x020031_g_SceneState)
    SetGuildBattleParam (scene, 100, x020031_g_ParamRedBaseHp)
    SetGuildBattleParam (scene, 100, x020031_g_ParamBlueBaseHp)
end

--服务器调用 OnObjEnter
function x020031_OnObjEnter (scene, objId)
    local camp = GuildBattleGetUserCamp (scene, objId)
    if camp == x020031_g_RedCamp then
        GuildBattleTeleMoveUser (scene, objId, x020031_g_Position[1][1], x020031_g_Position[1][2], x020031_g_Position[1][3])
        local red = GetGuildBattleParam(scene, x020031_g_RedState)
        if red ~= 2 and CanAddBaseHp(scene, objId) then
            SendImpactToUnitByRBID(scene, x020031_g_BaseId[1], x020031_g_PlayerImpact)
            FullHpByRBID(scene, x020031_g_BaseId[1])
        end
    elseif camp == x020031_g_BlueCamp then
        GuildBattleTeleMoveUser (scene, objId, x020031_g_Position[2][1], x020031_g_Position[2][2], x020031_g_Position[2][3])
        local blue = GetGuildBattleParam(scene, x020031_g_BlueState)
        if blue ~= 2 and CanAddBaseHp(scene, objId) then
            SendImpactToUnitByRBID(scene, x020031_g_BaseId[2], x020031_g_PlayerImpact)
            FullHpByRBID(scene, x020031_g_BaseId[2])
        end
    end

    GuildBattleAddImpact(scene, objId, x020031_g_FinalsImpact)
    TestFullHp(scene, objId)
end

function x020031_OnObjFlee(scene, objId)
    local camp = GuildBattleGetUserCamp (scene, objId)
    if camp == x020031_g_RedCamp then
        GuildBattleTeleMoveUser (scene, objId, x020031_g_Position[1][1], x020031_g_Position[1][2], x020031_g_Position[1][3])
    elseif camp == x020031_g_BlueCamp then
        GuildBattleTeleMoveUser (scene, objId, x020031_g_Position[2][1], x020031_g_Position[2][2], x020031_g_Position[2][3])
    end
end

--服务器调用 TickScript
function x020031_OnCopySceneTick (scene, tickCount)
    if tickCount == 0 then
        x020031_StartBattle (scene)
    end

    GuildBattleUpdatePoint (scene)
    local sceneState = GetGuildBattleParam (scene, x020031_g_SceneState)
    if sceneState == 0 then
        local red = GetGuildBattleParam (scene, x020031_g_ParamRedPoint)
        local blue = GetGuildBattleParam (scene, x020031_g_ParamBluePoint)
        if red >= x020031_g_PointMax and blue >= x020031_g_PointMax then
            SetGuildBattleParam (scene, 1, x020031_g_SceneState)
        end
    end

    local redState = GetGuildBattleParam (scene, x020031_g_RedState)
    if redState == 0 then
        x020031_UpdateCampState0 (scene, x020031_g_RedCamp)
    elseif redState == 1 then
        x020031_UpdateCampState1 (scene, x020031_g_RedCamp)
    elseif redState == 2 then
        x020031_UpdateCampState2(scene, x020031_g_RedCamp)
    end

    local blueState = GetGuildBattleParam (scene, x020031_g_BlueState)
    if blueState == 0 then
        x020031_UpdateCampState0 (scene, x020031_g_BlueCamp)
    elseif blueState == 1 then
        x020031_UpdateCampState1 (scene, x020031_g_BlueCamp)
    elseif blueState == 2 then
        x020031_UpdateCampState2 (scene, x020031_g_BlueCamp)
    end
end

--服务器调用 在势力战准备阶段
function x020031_OnGuildBattleOpening(scene, tickCount)
    if((tickCount % x020031_g_ReadyGetExpTime) == 0) then
        GainExpByLevel(scene, x003013_g_WaitExp)
    end
end

--服务器调用 OnObjDie
function  x020031_OnObjDie (scene, objId, rolebaseId, killerId)
    local killcamp = GuildBattleGetUserCamp (scene, killerId)
    if rolebaseId == x020031_g_BaseId[1] then
        GuildBattleSetWinner(scene, x020031_g_BlueCamp)
    elseif rolebaseId == x020031_g_BaseId[2] then
        GuildBattleSetWinner(scene, x020031_g_RedCamp)
    elseif GuildBattleGetUserCamp (scene, objId) == x020031_g_RedCamp then
        if killcamp == x020031_g_BlueCamp then
            x020031_AddPoint (scene, x020031_g_BlueCamp, x020031_g_UserPoint)
        end   
    elseif GuildBattleGetUserCamp (scene, objId) == x020031_g_BlueCamp then
        if killcamp == x020031_g_RedCamp then
            x020031_AddPoint (scene, x020031_g_RedCamp, x020031_g_UserPoint)
        end
    end
end

--服务器调用 OnObjRelife
function x020031_OnObjRelife(scene, objId, goHome)
    if goHome == true then
        local camp = GuildBattleGetUserCamp (scene, objId)
        if camp == x020031_g_RedCamp then
            GuildBattleTeleMoveUser (scene, objId, x020031_g_Position[1][1], x020031_g_Position[1][2], x020031_g_Position[1][3])
        elseif camp == x020031_g_BlueCamp then
            GuildBattleTeleMoveUser (scene, objId, x020031_g_Position[2][1], x020031_g_Position[2][2], x020031_g_Position[2][3])
        end
    end
end

--服务器调用 OnObjLeave
function x020031_OnObjLeave (scene, objId)
    if IsObjDie(scene, objId) then
    	TestFullHp(scene, objId)
    end

    RemoveImpact(scene, objId, x020031_g_FinalsImpact)
end

--开始势力战，创建传送门
function x020031_StartBattle (scene)
    for i=1, #x020031_g_FlagGroupPoint do
        SetSceneBuff (scene, x020031_g_FlagGroupPoint[i][1], x020031_g_FlagGroupPoint[i][2], x020031_g_FlagGroupPoint[i][3], x020031_g_FlagGroupPoint[i][4])
    end
	
    for i=1, 2 do
        SetSceneBuff (scene, x020031_g_RedGroupPoint[i][1], x020031_g_RedGroupPoint[i][2], x020031_g_RedGroupPoint[i][3], x020031_g_RedGroupPoint[i][4])
    end

    for i=1, 2 do
        SetSceneBuff (scene, x020031_g_BlueGroupPoint[i][1], x020031_g_BlueGroupPoint[i][2], x020031_g_BlueGroupPoint[i][3], x020031_g_BlueGroupPoint[i][4])
    end
end

--得分阶段
function x020031_UpdateCampState0 (scene, camp)
    local flagcount = GetGuildBattleFlagCount (scene, camp)
    local rate = 1
    if flagcount >= 5 then
        rate = 2
    end
    local point = flagcount * x020031_g_FlagPoint * rate
    x020031_AddPoint (scene, camp, point)
end

--加点
function x020031_AddPoint (scene, camp, value)
    local index = x020031_g_ParamRedPoint
    if camp==x020031_g_BlueCamp then
        index = x020031_g_ParamBluePoint
    end

    local point = value + GetGuildBattleParam (scene, index)
    if point > x020031_g_PointMax then
        if camp == x020031_g_RedCamp then
            SetGuildBattleParam (scene, 1, x020031_g_RedState)
        elseif camp == x020031_g_BlueCamp then
            SetGuildBattleParam (scene, 1, x020031_g_BlueState)
        end
        point = x020031_g_PointMax
    end
    SetGuildBattleParam (scene, point, index)
end

--打水晶创建传送门阶段
function x020031_UpdateCampState1 (scene, camp)
    if camp == x020031_g_RedCamp then
        SetGuildBattleParam (scene, 2, x020031_g_RedState)

        RemoveImpactByBRId (scene, x020031_g_BaseId[2], x020031_g_InvincibleImpact)

    elseif camp == x020031_g_BlueCamp then
        SetGuildBattleParam (scene, 2, x020031_g_BlueState)

        RemoveImpactByBRId (scene, x020031_g_BaseId[1], x020031_g_InvincibleImpact)
    end
end

function x020031_UpdateCampState2 (scene, camp)
    if camp == x020031_g_RedCamp then
        local hp = CalculatePercenHpByRBId (scene, x020031_g_BaseId[2])
        local last = GetGuildBattleParam(scene, x020031_g_ParamBlueBaseHp)
        SetGuildBattleParam (scene, hp, x020031_g_ParamBlueBaseHp)

        if hp ~= last then
            UpdateGuildBattleBaseHp(scene, x020031_g_BlueCamp, hp)
        end
    elseif camp== x020031_g_BlueCamp then
        local hp = CalculatePercenHpByRBId (scene, x020031_g_BaseId[1])
        local last = GetGuildBattleParam(scene, x020031_g_ParamRedBaseHp)
        SetGuildBattleParam (scene, hp, x020031_g_ParamRedBaseHp)

        if hp ~= last then
            UpdateGuildBattleBaseHp(scene, x020031_g_RedCamp, hp)
        end
    end

end

function x003013_GetMonsterRoleBaseId(rolebase, level)
    local id = math.floor((level - 1) / 10) + rolebase[1]

    if id < rolebase[1] then
        id = rolebase[1]
    end

    if id > rolebase[2] then
        id = rolebase[2]
    end

    return id
end