x020036_g_scriptId = 020036

x020036_g_CSParamIdxCurStage = 0			  --副本参数	
x020036_g_CSParamIdxCurSubStage = 1
x020036_g_CSParamIdxMonsterIndex = 2
x020036_g_CSParamIdxStoryIndex = 3
x020036_g_CSParamIdxAnimationIndex = 4

x020036_g_BossNumEnumId = 987  --  存储MdId  不用改

--副本任务
function x020036_OnCopySceneOpen( scene )
	AddCSMissionByStiry(scene)
end     

--创建怪物
function x020036_CreateMonster( scene,idx,camp)							
	local nMonsterIndex = GetCopySceneParam(scene,x020036_g_CSParamIdxMonsterIndex)
	CreateMonsterByStory(scene, nMonsterIndex)
	SetCopySceneParam(scene,x020036_g_CSParamIdxMonsterIndex,nMonsterIndex+1)
end

--剧情对话
function x020036_StartClienStory(scene)
	local nStoryIndex = GetCopySceneParam(scene,x020036_g_CSParamIdxStoryIndex)
	StartClientStoryByStory(scene, nStoryIndex);
	SetCopySceneParam(scene,x020036_g_CSParamIdxStoryIndex, nStoryIndex+1)
end

--剧情动画
function x020036_StartStoryAnimation(scene)
	local nAnimationIndex = GetCopySceneParam(scene,x020036_g_CSParamIdxAnimationIndex)
	StartStoryAnimationByStory(scene, nAnimationIndex)
	SetCopySceneParam(scene,x020036_g_CSParamIdxAnimationIndex, nAnimationIndex+1)
end

--剧情回调
function x020036_OnStoryEventEnd(scene,storyId,animationId)

end

--奖励结算
function x020036_CheckMissionMD(scene ,objId, type)
	local nLastData = GetMissionMD(scene, objId, 4, type)
	local nNewData = CheckRefreshTime(scene, nLastData, objId, 0)
	if math.floor(nLastData/100) ~= nNewData then
		SetMissionMD(scene, objId, 4, type, nNewData*100)
	end
end
--奖励结算
function x020036_Succeed(scene)
	local nUserCount = GetSceneUserCount(scene)
	for i=0,nUserCount-1 do		
		local nUserObjId = GetUserObjIdByIdx(scene,i)
		AddActivtyNum(scene, nUserObjId, 40)
		x020036_CheckMissionMD(scene,nUserObjId,x020036_g_BossNumEnumId)
		local oldTime = GetMissionMD(scene, nUserObjId, 4, x020036_g_BossNumEnumId)
		SetMissionMD(scene, nUserObjId, 4, x020036_g_BossNumEnumId, oldTime+1)
	end
	AccoutByStory(scene)
end


--死亡回调
function x020036_OnObjDie( scene,objId,rolebaseId,killerId )
	local MonCount = GetHostileMonsterCount(scene)
	if(MonCount == 0) then
		local nCurStage = GetCopySceneParam(scene,x020036_g_CSParamIdxCurStage)
		SetCopySceneParam(scene,x020036_g_CSParamIdxCurStage,nCurStage+1)
		SetCopySceneParam(scene,x020036_g_CSParamIdxCurSubStage,0)
	end
end

--副本Tick
function x020036_OnCopySceneTick(scene,tickCount)
	local curStage = GetCopySceneParam(scene,x020036_g_CSParamIdxCurStage)
	local curSubStage = GetCopySceneParam(scene,x020036_g_CSParamIdxCurSubStage)
	SetCopySceneParam(scene, x020036_g_CSParamIdxCurSubStage, curSubStage + 1)
	if curStage == 0 then  
		x020036_Stage_0(scene, curStage, curSubStage)
	elseif curStage == 1 then
		x020036_Stage_1(scene, curStage, curSubStage)
	elseif curStage == 2 then
		x020036_Stage_2(scene, curStage, curSubStage)
	elseif curStage == 3 then 
		x020036_Stage_3(scene, curStage, curSubStage)
	elseif curStage == 4 then
		x020036_Stage_4(scene, curStage, curSubStage)
	elseif curStage == 5 then 
		x020036_Stage_5(scene, curStage, curSubStage)
	elseif curStage == 6 then
		x020036_Stage_6(scene, curStage, curSubStage)
	elseif curStage == 7 then 
		x020036_Stage_7(scene, curStage, curSubStage)
	elseif curStage == 8 then
		x020036_Stage_End(scene, curStage, curSubStage)
	elseif curStage == 9 then
		SetCopySceneSuccess(scene)
	end
end

--第0阶段
function x020036_Stage_0(scene, stage, substage)
	if substage == 0 then
		x020036_StartStoryAnimation(scene)
	elseif substage == 10 then
		OnCSMissionStage(scene,stage)
		x020036_CreateMonster(scene,stage,1)
	end
end

--第1阶段
function x020036_Stage_1(scene, stage, substage)
	if substage == 0 then
		x020036_StartClienStory(scene)
	elseif substage == 3 then
		OnCSMissionStage(scene,stage)
		x020036_CreateMonster(scene,stage,1)
	end
end

--第2阶段
function x020036_Stage_2(scene, stage, substage)
	if substage == 0 then
		OnCSMissionStage(scene,stage)
		x020036_CreateMonster(scene,stage,1)
	end
end

--第3阶段
function x020036_Stage_3(scene, stage, substage)
	if substage == 0 then
		OnCSMissionStage(scene,stage)
		x020036_CreateMonster(scene,stage,1)
	end
end

--第4阶段
function x020036_Stage_4(scene, stage, substage)
	if substage == 0 then
		x020036_StartClienStory(scene)
	elseif substage == 3 then
		OnCSMissionStage(scene,stage)
		x020036_CreateMonster(scene,stage,1)
	end
end

--第5阶段
function x020036_Stage_5(scene, stage, substage)
	if substage == 0 then
		OnCSMissionStage(scene,stage)
		x020036_CreateMonster(scene,stage,1)
	end
end

--第6阶段
function x020036_Stage_6(scene, stage, substage)
	if substage == 0 then
		x020036_StartClienStory(scene)
	elseif substage == 3 then
		x020036_StartStoryAnimation(scene)
	elseif substage == 5 then 
		SetCopySceneParam(scene,x020036_g_CSParamIdxCurStage,stage+1)
		SetCopySceneParam(scene,x020036_g_CSParamIdxCurSubStage,0)
	end
end

--第7阶段
function x020036_Stage_7(scene, stage, substage)
	if substage == 0 then
		OnCSMissionStage(scene,stage-1)
		x020036_CreateMonster(scene,stage,1)
	end
end

--最后阶段
function x020036_Stage_End(scene, stage, substage)
	if substage == 1 then
		x020036_StartStoryAnimation(scene)
	elseif substage == 5 then
		x020036_Succeed(scene)
		SetCopySceneParam(scene,x020036_g_CSParamIdxCurStage,stage+1)
		SetCopySceneParam(scene,x020036_g_CSParamIdxCurSubStage,0)

		local nUserCount = GetSceneUserCount(scene)
		for i=0,nUserCount-1 do	
			local nUserObjId = GetUserObjIdByIdx(scene,i)	
			AddActivtyNum(scene, nUserObjId, 9)
		end
	end
end