x020037_g_scriptId = 020037

x020037_g_CSParamIdxCurStage = 0			  --副本参数	
x020037_g_CSParamIdxCurSubStage = 1
x020037_g_CSParamIdxMonsterIndex = 2
x020037_g_CSParamIdxStoryIndex = 3
x020037_g_CSParamIdxAnimationIndex = 4

x020037_g_Stage2_BossId = 801
x020037_g_Stage2_BossTipId = 50008
x020037_g_Stage5_BossId = 801
x020037_g_Stage5_BossTipId = 50009

x020037_g_GroupPointPos ={}
x020037_g_GroupPointPos[1]= {118.12,379.82}    --  临时buff采集点坐标
x020037_g_GroupPointId = 4501	

x020037_g_BossNumEnumId = 987  --  存储MdId  不用改

--副本任务
function x020037_OnCopySceneOpen( scene )
	AddCSMissionByStiry(scene)
end     

--创建怪物
function x020037_CreateMonster( scene,idx,camp)							
	local nMonsterIndex = GetCopySceneParam(scene,x020037_g_CSParamIdxMonsterIndex)
	CreateMonsterByStory(scene, nMonsterIndex)
	SetCopySceneParam(scene,x020037_g_CSParamIdxMonsterIndex,nMonsterIndex+1)
end

--剧情对话
function x020037_StartClienStory(scene)
	local nStoryIndex = GetCopySceneParam(scene,x020037_g_CSParamIdxStoryIndex)
	StartClientStoryByStory(scene, nStoryIndex);
	SetCopySceneParam(scene,x020037_g_CSParamIdxStoryIndex, nStoryIndex+1)
end

--剧情动画
function x020037_StartStoryAnimation(scene)
	local nAnimationIndex = GetCopySceneParam(scene,x020037_g_CSParamIdxAnimationIndex)
	StartStoryAnimationByStory(scene, nAnimationIndex)
	SetCopySceneParam(scene,x020037_g_CSParamIdxAnimationIndex, nAnimationIndex+1)
end

--剧情回调
function x020037_OnStoryEventEnd(scene,storyId,animationId)

end

--任务完成回调
function x020037_OnMissionComplete(scene, nObjId, nMissionId)
	local nCurStage = GetCopySceneParam(scene,x020037_g_CSParamIdxCurStage)
	if nCurStage == 4 then
		SetCopySceneParam(scene,x020037_g_CSParamIdxCurStage,nCurStage+1)
		SetCopySceneParam(scene,x020037_g_CSParamIdxCurSubStage,0)
	end
end

function x020037_CheckMissionMD(scene ,objId, type)
	local nLastData = GetMissionMD(scene, objId, 4, type)
	local nNewData = CheckRefreshTime(scene, nLastData, objId, 0)
	if math.floor(nLastData/100) ~= nNewData then
		SetMissionMD(scene, objId, 4, type, nNewData*100)
	end
end
--奖励结算
function x020037_Succeed(scene)
	AddActivtyNum(scene, nUserObjId, 40)
	local nUserCount = GetSceneUserCount(scene)
	for i=0,nUserCount-1 do		
		local nUserObjId = GetUserObjIdByIdx(scene,i)
		AddActivtyNum(scene, nUserObjId, 40)
		x020037_CheckMissionMD(scene,nUserObjId,x020037_g_BossNumEnumId)
		local oldTime = GetMissionMD(scene, nUserObjId, 4, x020037_g_BossNumEnumId)
		SetMissionMD(scene, nUserObjId, 4, x020037_g_BossNumEnumId, oldTime+1)
	end
	AccoutByStory(scene)
end
--死亡回调
function x020037_OnObjDie( scene,objId,rolebaseId,killerId )
	local MonCount = GetHostileMonsterCount(scene)
	if(MonCount == 0) then
		local nCurStage = GetCopySceneParam(scene,x020037_g_CSParamIdxCurStage)
		SetCopySceneParam(scene,x020037_g_CSParamIdxCurStage,nCurStage+1)
		SetCopySceneParam(scene,x020037_g_CSParamIdxCurSubStage,0)
	end
end

--副本Tick
function x020037_OnCopySceneTick(scene,tickCount)
	local curStage = GetCopySceneParam(scene,x020037_g_CSParamIdxCurStage)
	local curSubStage = GetCopySceneParam(scene,x020037_g_CSParamIdxCurSubStage)
	SetCopySceneParam(scene, x020037_g_CSParamIdxCurSubStage, curSubStage + 1)

	if curStage == 0 then  
		x020037_Stage_0(scene, curStage, curSubStage)
	elseif curStage == 1 then
		x020037_Stage_1(scene, curStage, curSubStage)
	elseif curStage == 2 then
		x020037_Stage_2(scene, curStage, curSubStage)
	elseif curStage == 3 then 
		x020037_Stage_3(scene, curStage, curSubStage)
	elseif curStage == 4 then
		x020037_Stage_4(scene, curStage, curSubStage)
	elseif curStage == 5 then 
		x020037_Stage_5(scene, curStage, curSubStage)
	elseif curStage == 6 then 
		x020037_Stage_End(scene, curStage, curSubStage)
	end
end

--阶段0
function x020037_Stage_0(scene ,stage,substage)
	if substage == 2 then
		x020037_StartClienStory(scene)
		OnCSMissionStage(scene,stage)
		x020037_CreateMonster(scene, stage, 1)		
	end
end

--阶段1
function x020037_Stage_1(scene ,stage,substage)
	if substage == 1 then
		x020037_StartClienStory(scene)
		OnCSMissionStage(scene,stage)
		x020037_CreateMonster(scene, stage, 1)		
	end
end

--阶段2
function x020037_Stage_2(scene ,stage,substage)
	if substage == 1 then
		OnCSMissionStage(scene,stage)
		x020037_CreateMonster(scene, stage, 1)		

		local nUserCount = GetSceneUserCount(scene)
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			ShowBossTips(scene, nUserObjId, x020037_g_Stage2_BossId, x020037_g_Stage2_BossTipId)
		end
	end
end

--阶段3
function x020037_Stage_3(scene ,stage,substage)
	if substage == 1 then
		OnCSMissionStage(scene,stage)
		x020037_CreateMonster(scene, stage, 1)		
		--SetSceneBuff(scene,x020037_g_GroupPointId,x020037_g_GroupPointPos[1][1],x020037_g_GroupPointPos[1][2],0)
	end
end

--阶段4
function x020037_Stage_4(scene ,stage,substage)
	if substage == 1 then
		OnCSMissionStage(scene,stage)
	end
end

--阶段5
function x020037_Stage_5(scene ,stage,substage)
	if substage == 1 then
		OnCSMissionStage(scene,stage)
		x020037_CreateMonster(scene, stage, 1)		

		local nUserCount = GetSceneUserCount(scene)
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			ShowBossTips(scene, nUserObjId, x020037_g_Stage5_BossId, x020037_g_Stage5_BossTipId)
		end
	end
end

--最后阶段
function x020037_Stage_End(scene, stage, substage)
	if substage == 1 then
		x020037_StartStoryAnimation(scene)
	elseif substage == 15 then
		x020037_Succeed(scene)

		local nUserCount = GetSceneUserCount(scene)
		for i=0,nUserCount-1 do	
			local nUserObjId = GetUserObjIdByIdx(scene,i)	
			AddActivtyNum(scene, nUserObjId, 9)
		end
		SetCopySceneSuccess(scene)
	end
end