x020055_g_scriptId = 020055

x020055_g_BossId = { 205000, 205001, 205002, 205003, 205004, 205005, 205006, 205007, 205008, 205009, 205010, 205011, 205012 }
x020055_g_BossPosition = { 69.67, 101.597, -1.57 }

--怪物第一波和第二波
x020055_g_MonsterId = { }
x020055_g_MonsterId[1] = { 204000, 204001, 204002, 204003, 204004, 204005, 204006, 204007, 204008, 204009, 204010, 204011, 204012 }
x020055_g_MonsterId[2] = { 204100, 204101, 204102, 204103, 204104, 204105, 204106, 204107, 204108, 204109, 204110, 204111, 204112 }

--第一波和第二波怪物位置
x020055_g_MonsterPos = {}
x020055_g_MonsterPos[1] = { { 67.4, 58.56, -1.4 }, { 69.45, 58.6, -1.4 }, { 71.45, 58.629, -1.4 }, { 65.524, 61.3, -1.4 }, { 69.418, 61.38, -1.4 }, { 73.4, 61.43, -1.4 } }
x020055_g_MonsterPos[2] = { { 69.41, 78.6, -1.57 }, { 73.41, 78.6, -1.57 }, { 65.6, 78.6, -1.57 }, { 65.6, 80.4, -1.57 }, { 69.46, 80.4, -1.57 }, { 73.36, 80.4, -1.57 } }

x020055_g_DropBoxId = { 214201, 214202, 214203, 214204, 214205, 214206, 214207, 214208, 214209, 214210, 214211, 214212, 214213 }

x020055_g_StoryAnimaId = { 2102, 2102, 2102, 2102, 2102, 2102, 2102, 2102, 2102, 2102, 2102, 2102, 2102 }
x020055_g_BossDuration = 5

x020055_State = 0
x020055_Win = 1
x020055_Killer = 2
x020055_BossTime = 3
x020055_IsBossActive = 4

x020055_g_MissionId = { 1650, 1651, 1652, 1653, 1654, 1655, 1656, 1657, 1658, 1659, 1660, 1661, 1662 }--任务完成完成一个采集任务

function x020055_OnCopySceneOpen(scene)
    --CopySceneNPC(scene,1001101,51001,6,111,1,"XXX")--场景、角色ID、CharModel表ID、势力、出现的场景SceneID、等级、名称
    SetCopySceneParam(scene, x020055_State, 0)
    SetCopySceneParam(scene, x020055_Win, 0)
    SetCopySceneParam(scene, x020055_Killer, 0)
    SetCopySceneParam(scene, x020055_IsBossActive, 0)
end

function x020055_OnCopySceneTick(scene, tickCount)
    local state = GetCopySceneParam(scene, x020055_State)
    if state == 0 then
        x020055_TickState0(scene, tickCount)
    elseif state == 1 then
        x020055_TickState1(scene, tickCount)
    elseif state == 2 then
        x020055_TickState2(scene, tickCount)
    elseif state == 3 then
        x020055_TickState3(scene, tickCount)
    elseif state == 4 then

    end
end

function x020055_OnMissionComplete(scene, nObjId, nMissionId)
    local misId = x020055_GetRoleId(scene, x020055_g_MissionId)
    if nMissionId == misId then
        x020055_EndCopyScene(scene)
    end
end

function x020055_OnStoryEventEnd(scene, nStoryId, nAnimationId)
    local animId = x020055_GetRoleId(scene, x020055_g_StoryAnimaId)
    if nAnimationId ~= animId then
        return
    end
    local active = GetCopySceneParam(scene, x020055_IsBossActive)
    if active == 1 then
        return
    end
    local id = x020055_GetRoleId(scene, x020055_g_BossId)
    CreateMonster(scene, id, x020055_g_BossPosition[3], x020055_g_BossPosition[1], x020055_g_BossPosition[2])
    SetCopySceneParam(scene, x020055_BossTime, -1)
    SetCopySceneParam(scene, x020055_IsBossActive, 1)
end

--死亡调用
function x020055_OnObjDie(scene, objId, rolebaseId, killerId)
    if rolebaseId == x020055_GetRoleId(scene, x020055_g_BossId) then
        local win = GetCopySceneParam(scene, x020055_Win)
        if win == 0 then
            SetCopySceneParam(scene, x020055_Win, 1)
            SetCopySceneParam(scene, x020055_Killer, killerId)
        end
        --增加任务
        local missionId = x020055_GetRoleId(scene, x020055_g_MissionId)
        AddCSMission(scene, missionId)
        OnCSMissionStage(scene, 0)
        SetCopySceneParam(scene, x020055_State, GetCopySceneParam(scene, x020055_State) + 1)
    elseif objId == GetUserObjIdByIdx(scene, 0) then
        local win = GetCopySceneParam(scene, x020055_Win)
        if win == 0 then
            SetCopySceneParam(scene, x020055_Win, 2)
            x020055_EndCopyScene(scene)
        end
    end
end

function x020055_OnCopySceneTimeOut(scene)
    local win = GetCopySceneParam(scene, x020055_Win)
    if win == 0 then
        SetCopySceneParam(scene, x020055_Win, 2)
        x020055_EndCopyScene(scene)
    end
end

function x020055_StartState1(scene)
    local id = x020055_GetRoleId(scene, x020055_g_MonsterId[1])
    local count = #x020055_g_MonsterPos[1]
    for i = 1, count do
        CreateMonster(scene, id, x020055_g_MonsterPos[1][i][3], x020055_g_MonsterPos[1][i][1], x020055_g_MonsterPos[1][i][2])
    end
end

function x020055_StartState2(scene, tickCount)
    local id = x020055_GetRoleId(scene, x020055_g_MonsterId[2])
    local count = #x020055_g_MonsterPos[2]
    for i = 1, count do
        CreateMonster(scene, id, x020055_g_MonsterPos[2][i][3], x020055_g_MonsterPos[2][i][1], x020055_g_MonsterPos[2][i][2])
    end
end

function x020055_StartState3(scene, tickCount)
    local animId = x020055_GetRoleId(scene, x020055_g_StoryAnimaId)
    StoryAnimation(scene, animId)
    SetCopySceneParam(scene, x020055_BossTime, x020055_g_BossDuration + tickCount)
end

function x020055_ChangeState(scene, state, tickCount)
    SetCopySceneParam(scene, x020055_State, state)
    if state == 1 then
        x020055_StartState1(scene, tickCount)
    elseif state == 2 then
        x020055_StartState2(scene, tickCount)
    elseif state == 3 then
        x020055_StartState3(scene, tickCount)
    end
end

function x020055_TickState0(scene, tickCount)
    x020055_ChangeState(scene, GetCopySceneParam(scene, x020055_State) + 1, tickCount)
end

function x020055_TickState1(scene, tickCount)
    local id = x020055_GetRoleId(scene, x020055_g_MonsterId[1])
    local count = GetAliveByRoleBaseNum(scene, id)
    if count <= 0 then
        x020055_ChangeState(scene, GetCopySceneParam(scene, x020055_State) + 1, tickCount)
    end
end

function x020055_TickState2(scene, tickCount)
    local id = x020055_GetRoleId(scene, x020055_g_MonsterId[2])
    local count = GetAliveMonsterCount(scene, id)
    if count <= 0 then
        x020055_ChangeState(scene, GetCopySceneParam(scene, x020055_State) + 1, tickCount)
    end
end

function x020055_TickState3(scene, tickCount)
    local time = GetCopySceneParam(scene, x020055_BossTime)
    if time > 0 then
        if time <= tickCount then
            local id = x020055_GetRoleId(scene, x020055_g_BossId)
            CreateMonster(scene, id, x020055_g_BossPosition[3], x020055_g_BossPosition[1], x020055_g_BossPosition[2])
            SetCopySceneParam(scene, x020055_BossTime, -1)
            SetCopySceneParam(scene, x020055_IsBossActive, 1)
        end
    end
end

function x020055_GetRoleId(scene, list)
    local index = GetArtifactIndex(scene)
    if index < 1 then
        index = 1
    elseif index > #list then
        index = #list
    end
    return list[index]
end

function x020055_EndCopyScene(scene)
    -- body
    local win = GetCopySceneParam(scene, x020055_Win)
    local id = x020055_GetRoleId(scene, x020055_g_BossId)
    local box = x020055_GetRoleId(scene, x020055_g_DropBoxId)
    SetArtifactCopySceneEnd(scene, win, box, id)
    if win == 1 then
        SetCopySceneSuccess(scene)
    else
        SetCopySceneFail(scene)
    end
    for i = 1, #x020055_g_BossId do
        DeleMonsterByRoleId(scene, x020055_g_BossId[i])
    end
end