--任务副本1
--进入副本→刷第一波小怪→击杀第一波小怪→播放MOV→刷BOSS→击杀BOSS→播放MOV→副本完成→传出副本

x040015_g_scriptId = 040015

--副本参数
x040015_g_CSParamIdxCurStage = 0              --大阶段
x040015_g_CSParamIdxCurSubStage = 1           --小阶段
x040015_g_CSParam1 = 2
x040015_g_CSParam2 = 3   -- 7为当前阶段
x040015_g_CSParamAnimationID = 1003           --mov动画ID
x040015_g_CSParamAnimation2ID = 1006           --mov动画ID


x040015_g_CommitMissionTick = 4                       -- 完成任务的tick
x040015_g_Alltick = 6                               -- 总tick
x040015_g_BloodTick = 8  -- 血脉提示留存时间

x040015_g_MonstorList = {}
x040015_g_MonstorList[1] = { 1001111, 1001111, 1001111, 1001111, 1001111, 1001111 }  --小怪
x040015_g_MonstorList[2] = { 1001110 }

x040015_g_TargetList = {}                      --目标
x040015_g_TargetList[1] = { 1001111 }  --第一阶段目标1
x040015_g_TargetList[2] = { 1001110 }  --第2阶段目标1
x040015_g_TargetList[3] = {}

x040015_g_Tickout = 7   -- 防止掉线的最小切换副本阶段时间戳，需要减2

x040015_g_FirstMissionId1 = 2001    -- 第一个任务
x040015_g_SecMissionId2 = 2004 -- 第2个任务

x040015_g_MonstorPosList = {}
x040015_g_MonstorPosList[1] = { { 18.16, 46.77, -1.57 }, { 20.24, 50.15, -1.57 }, { 16.59, 50.42, -1.57 }, { 17.97, 48.66, -1.57 }, { 21.98, 48.27, -1.57 }, { 14.47, 48.41, -1.57 } } --小怪坐标
x040015_g_MonstorPosList[2] = { { 18.84, 89.83, -1.57 } }

x040015_g_MovMaxTime1 = 20 -- 第一个mov最大时间
x040015_g_MovMaxTime2 = 20 -- 第二个mov最大时间

x040015_g_BossDieMov = 3 -- boss死亡多少秒以后在播放mov

x040015_g_BossStartAnimId = 2145

x040015_g_BossTips = {}
x040015_g_BossTips[1] = { 101004, 27, 1001110 } -- (StrDicId, FakeObjId,RoleBaseId)

function x040015_OnCopySceneTimeOut(scene)
    ClearPlayer(scene)
end

function x040015_OnCopySceneOpen(scene)
    AddCSMission(scene, x040015_g_FirstMissionId1)
    AddCSMission(scene, x040015_g_SecMissionId2)
end

function x040015_ClearAllMonster(scene)
    DeleHostileMonster(scene)
end
function x040015_StageControl(scene, nstage)
    SetCopySceneParam(scene, 2, 0)
    SetCopySceneParam(scene, 3, 0)
    SetCopySceneParam(scene, 4, 0)
    SetCopySceneParam(scene, 7, nstage)
    local nUserCount = GetSceneUserCount(scene)
    for j = 0, nUserCount - 1 do
        local nUserObjId = GetUserObjIdByIdx(scene, j)
        SynCsStageData(scene, nUserObjId)
    end
end
function x040015_OnObjEnter(scene, objId)
    CopySceneNPC(scene, 1001015, 1000001, 8, 251, 100, "長青素素")--场景、角色ID、CharModel表ID、势力、出现的场景SceneID、等级、名称
    SetCopySceneParam(scene, x040015_g_CSParamIdxCurStage, 0)
    SetCopySceneParam(scene, x040015_g_CSParamIdxCurSubStage, 0)
    SetCopySceneParam(scene, x040015_g_CSParam1, 0)
    SetCopySceneParam(scene, x040015_g_CSParam2, 0)
    x040015_ClearAllMonster(scene)
    SetCopySceneParam(scene, 7, 0)
    SynCsStageData(scene, objId, true)
end

function x040015_OnDieCountDown1(scene, rolebaseId, stage)
    local TargetId = x040015_g_TargetList[stage + 1][1]
    if (TargetId == rolebaseId) then
        local OldValue = GetCopySceneParam(scene, x040015_g_CSParam1)
        SetCopySceneParam(scene, x040015_g_CSParam1, OldValue + 1)
        local nUserCount = GetSceneUserCount(scene)
        for i = 0, nUserCount - 1 do
            local nUserObjId = GetUserObjIdByIdx(scene, i)
            SynCsStageData(scene, nUserObjId)
        end
    end
end
--死亡回调
function x040015_OnObjDie(scene, objId, rolebaseId, killerId)
    local nCurStage = GetCopySceneParam(scene, x040015_g_CSParamIdxCurStage)
    local MonCount = GetHostileMonsterCount(scene)
    local oldStage = GetCopySceneParam(scene, 7)
    x040015_OnDieCountDown1(scene, rolebaseId, oldStage)

    local nUserCount = GetSceneUserCount(scene)
    for j = 0, nUserCount - 1 do
        local nObjId = GetUserObjIdByIdx(scene, j)
        CopySceneLog(scene, nObjId, 2, nCurStage)
    end

    if MonCount == 0 then
        if (rolebaseId == x040015_g_MonstorList[1][1]) then
            x040015_Stage_1(scene)
        end
        SetCopySceneParam(scene, x040015_g_CSParamIdxCurStage, nCurStage + 1)
        SetCopySceneParam(scene, x040015_g_CSParamIdxCurSubStage, 0)
    end
end

--动画/对话回调
function x040015_OnStoryEventEnd(scene, nStoryId, nAnimationId)
    if nAnimationId == x040015_g_CSParamAnimationID then
        x040015_OnBloodSkill(scene)
    end
    if nAnimationId == x040015_g_CSParamAnimation2ID then
        SetCopySceneSuccess(scene)
        local nUserCount = GetSceneUserCount(scene)
        for j = 0, nUserCount - 1 do
            local nObjId = GetUserObjIdByIdx(scene, j)
            ChangeFlyState(scene, nObjId)
        end
    end
end

function x040015_OnBloodSkill(scene)
    local nCurStage = GetCopySceneParam(scene, x040015_g_CSParamIdxCurStage)
    x040015_StageControl(scene, nCurStage - 1)
    x040015_CreateMonster(scene, nCurStage)

    BroadCastBossTips(scene, x040015_g_BossTips[1][2], x040015_g_BossTips[1][1], x040015_g_BossTips[1][3])

    local nUserCount = GetSceneUserCount(scene)
    for j = 0, nUserCount - 1 do
        local nObjId = GetUserObjIdByIdx(scene, j)
        if not IsBloodAwaken(scene, nObjId) then
            local tick = GetCopySceneParam(scene, x040015_g_Alltick)
            RemoveBloodSkillCDTime(scene, nObjId)
            SetCopySceneParam(scene, x040015_g_CommitMissionTick, tick + x040015_g_BloodTick)
            ShowQuestion(scene, nObjId, 316)
        end
    end
    TellPlayerAutoCombat(scene, true)
end

--副本Tick
function x040015_OnCopySceneTick(scene, tickCount)
    SetCopySceneParam(scene, x040015_g_Alltick, tickCount)
    local curStage = GetCopySceneParam(scene, x040015_g_CSParamIdxCurStage)
    local curSubStage = GetCopySceneParam(scene, x040015_g_CSParamIdxCurSubStage)
    SetCopySceneParam(scene, x040015_g_CSParamIdxCurSubStage, curSubStage + 1)
    if curStage == 0 then
        SetCopySceneParam(scene, x040015_g_CSParamIdxCurStage, curStage + 1)
        SetCopySceneParam(scene, x040015_g_CSParamIdxCurSubStage, 0)
        x040015_Stage_0(scene, 1, 1)
        x040015_CreateMonster(scene, 1)
    end

    local LastBlood = GetCopySceneParam(scene, x040015_g_CommitMissionTick)
    if LastBlood ~= 0 and tickCount == LastBlood then
        local nUserCount = GetSceneUserCount(scene)
        for i = 0, nUserCount - 1 do
            local nUserObjId = GetUserObjIdByIdx(scene, i)
            ActiveBloodAwaken(scene, nUserObjId)
        end
        SetCopySceneParam(scene, x040015_g_CommitMissionTick, 0)
    end
    -- 第一个mov超时了直接刷怪
    if curStage == 2 and GetHostileMonsterCount(scene) == 0 and curSubStage == x040015_g_MovMaxTime1 then
        x040015_OnBloodSkill(scene)
    elseif curStage == 3 and curSubStage == x040015_g_BossDieMov then
        x040015_StageControl(scene, curStage - 1)
        x040015_Stage_3(scene)
        -- 第二个mov超时了直接完成副本
    elseif curStage == 3 and curSubStage == x040015_g_MovMaxTime2 then
        SetCopySceneSuccess(scene)
    end
end

function x040015_Stage_0(scene, stage, substage)
    if substage == 1 then
        OnCSMissionStage(scene, stage - 1)
        TellPlayerAutoCombat(scene)
        x040015_StageControl(scene, 0)
    end
end

function x040015_CreateMonster(scene, stage)
    local count = #x040015_g_MonstorList[stage]
    for i = 1, count do
        CreateMonster(scene, x040015_g_MonstorList[stage][i], x040015_g_MonstorPosList[stage][i][3], x040015_g_MonstorPosList[stage][i][1], x040015_g_MonstorPosList[stage][i][2])
    end
    if stage == 2 then
        MonsterPlayAnimaByRoleBaseId(scene, x040015_g_MonstorList[stage][1], x040015_g_BossStartAnimId)
    end
    local nUserCount = GetSceneUserCount(scene)
    for j = 0, nUserCount - 1 do
        local nObjId = GetUserObjIdByIdx(scene, j)
        CopySceneLog(scene, nObjId, 1, stage)
    end
end

--第1阶段 播放MOV
function x040015_Stage_1(scene)
    TellPlayerAutoCombat(scene, false)
    StoryAnimation(scene, x040015_g_CSParamAnimationID)
end

--第3阶段 播放MOV
function x040015_Stage_3(scene)
    StoryAnimation(scene, x040015_g_CSParamAnimation2ID)
end