x020071_g_scriptId=020071

x020071_g_CSParamIdxCurFloor=0
x020071_g_CSParamIdxCurSubStage=1
x020071_g_CSEndFlag = 2

x020071_g_FirstMonsterId = 1101701
x020071_g_buffid = 78704

x020071_g_Effect = {}
x020071_g_Effect[1] = { 970001, 970002, 970003, 970004, 970005, 970006, 970007 } --
x020071_g_Effect[2] = { 970011, 970012, 970013, 970014, 970015, 970016, 970017 }

function x020071_OnCopySceneOpen(scene)
	--print("進入聚靈副本")
	local nUserCount = GetSceneUserCount(scene)
	for j=0,nUserCount-1 do
		local nUserObjId = GetUserObjIdByIdx(scene,j)
		if IsAlive(scene,nUserObjId) == false then
			TestFullHp(scene, nUserObjId)
		end
		SetHpFull(scene, nUserObjId)
	end
end

function x020071_OnCopySceneTick(scene,tickCount)
	--副本阶段
	local nUserCount = GetSceneUserCount(scene)
	if tickCount == 0 then
		x020071_StageControl(scene, 0)
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			local is_effect = CheckJuLingEffect(scene)
			CreateMonByJuLingCs(scene, 0, nUserObjId)
			if(is_effect == true) then
            	ShowCopySceneGuideEffect(scene, x020071_g_Effect[1][1], x020071_g_Effect[1][2], x020071_g_Effect[1][3], x020071_g_Effect[1][4], x020071_g_Effect[1][5], x020071_g_Effect[1][6], x020071_g_Effect[1][7])
			end
		end
	end
	for j=0,nUserCount-1 do
		local nUserObjId = GetUserObjIdByIdx(scene,j)
		local PassTime = GetDefTimeLimit(scene, nUserObjId)
		local FlushTime = GetFlushTime(scene, nUserObjId)
		if PassTime > 0 then
			if tickCount >= PassTime then
				x020071_OnSuccess(scene, nUserObjId, true)
			end
		end
		if(FlushTime > 0) then
			x020071_CreateMonster(scene, FlushTime, tickCount)
		end		
	end

end

function x020071_OnObjEnter(scene,objId)
	TellPlayerAutoCombat(scene)
	SynCsStageData(scene, objId, true)
	--SendAlertTip(scene,objId,"通天塔內禁止使用血藥和血脈技能")
end

function  x020071_StageControl(scene,nstage)

	SetCopySceneParam(scene, 7, nstage)
	local nUserCount = GetSceneUserCount(scene)
	for j=0,nUserCount-1 do
		local nUserObjId = GetUserObjIdByIdx(scene,j)
		SynCsStageData(scene, nUserObjId)
	end
end

function x020071_OnObjDie( scene,objId,rolebaseId,killerId )

	local nUserCount = GetSceneUserCount(scene)
	if IsUser(objId) and IsJuLingDef(scene, objId)then

		--	OnTowerFail(scene,objId)
		--	SetCopySceneFail(scene)
		--	print("不完美通關")
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			x020071_OnSuccess(scene, nUserObjId, false)
		end
		return
	end
	local is_effect = CheckJuLingEffect(scene)
	local CurStage = GetCopySceneParam(scene, x020071_g_CSParamIdxCurSubStage)
	if GetHostileMonsterCount(scene) == 1 and  is_effect == true then
		for i=0,nUserCount-1 do
				local nUserObjId = GetUserObjIdByIdx(scene,i)
				local max_num = GetMonByJuLingCs(scene, nUserObjId)
				local min_num = GetMinByJuLingCs(scene, nUserObjId)
				if(is_effect == true and GetHostileMonsterCount(scene) == 1 and max_num ~= 0  and min_num == 7) then
					print("boss------------------", (max_num - 1) * 1000 + x020071_g_FirstMonsterId)
					RemoveImpactByBRId(scene, (max_num - 1) * 1000 + x020071_g_FirstMonsterId, x020071_g_buffid)
				end
			end
	end
	if GetHostileMonsterCount(scene) == 0 then
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			local bEnd = CheckJuLingCSEnd(scene, CurStage + 1, nUserObjId)
			local FlushTime = GetFlushTime(scene, nUserObjId)
			if (bEnd == false) and (FlushTime == -1) then
				print("階段轉換----------------", CurStage)
				x020071_StageControl(scene, CurStage+1)
				SetCopySceneParam(scene, x020071_g_CSParamIdxCurSubStage, CurStage+1)
				CreateMonByJuLingCs(scene, CurStage+1, nUserObjId)
				if (is_effect == true) then
					RemoveCopySceneGuideEffect(scene, x020071_g_Effect[1][1], x020071_g_Effect[1][2], x020071_g_Effect[1][3], x020071_g_Effect[1][4], x020071_g_Effect[1][5], x020071_g_Effect[1][6], x020071_g_Effect[1][7])
					ShowCopySceneGuideEffect(scene, x020071_g_Effect[2][1], x020071_g_Effect[2][2], x020071_g_Effect[2][3], x020071_g_Effect[2][4], x020071_g_Effect[2][5], x020071_g_Effect[2][6], x020071_g_Effect[2][7])
				end	
				return

			elseif (FlushTime > 0) then
				return
			end
		end
		for j=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,j)
			--	print(nUserObjId)
			if GetCSEvaluaion(scene) ~= 0 then
				--	print("不完美通關")
				x020071_OnSuccess(scene, nUserObjId, false)
			elseif GetCSEvaluaion(scene) == 0 then
				--	print("完美通關")
				print('------------------------ 通关 dddddddddddddddddddddd')
				x020071_OnSuccess(scene, nUserObjId, true)

			end
		end
		SetCopySceneSuccess(scene)
		--print("副本挑戰成功")
	end
end

function x020071_OnSuccess(scene, objId, IsPec)
	--print(objId)

	local OldValue = GetCopySceneParam(scene, x020071_g_CSEndFlag)
	if OldValue == 1 then
		if IsPec == false then
			DeleHostileMonster(scene)
			TestFullHp(scene, objId)
		end
		return
	end
	local is_effect = CheckJuLingEffect(scene)
	print("is_effect-----------", is_effect)
	if (is_effect == true) then
		RemoveCopySceneGuideEffect(scene, x020071_g_Effect[2][1], x020071_g_Effect[2][2], x020071_g_Effect[2][3], x020071_g_Effect[2][4], x020071_g_Effect[2][5], x020071_g_Effect[2][6], x020071_g_Effect[2][7])
	end
	SetCopySceneParam(scene, x020071_g_CSEndFlag, 1)
	JuLingSuccess(scene, objId, IsPec)

end


function x020071_CreateMonster(scene, FlushTime, tickCount)
	local CurStage = GetCopySceneParam(scene, x020071_g_CSParamIdxCurSubStage)
	local nUserCount = GetSceneUserCount(scene)
	if (tickCount % (FlushTime / 1000) == 0)  and (tickCount > 0) then
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			local bEnd = CheckJuLingCSEnd(scene, CurStage + 1, nUserObjId)
			if bEnd == false then
				x020071_StageControl(scene, CurStage+1)
				SetCopySceneParam(scene, x020071_g_CSParamIdxCurSubStage, CurStage+1)
				CreateMonByJuLingCs(scene, CurStage+1, nUserObjId)
				return
			elseif bEnd == true and (GetHostileMonsterCount(scene) == 0) then
				for j=0,nUserCount-1 do
					local nUserObjId = GetUserObjIdByIdx(scene,j)
					--	print(nUserObjId)
					if GetCSEvaluaion(scene) ~= 0 then
						--	print("不完美通關")
						x020071_OnSuccess(scene, nUserObjId, false)
					elseif GetCSEvaluaion(scene) == 0 then
						--	print("完美通關")
						x020071_OnSuccess(scene, nUserObjId, true)
					SetCopySceneSuccess(scene)
					end
				end
			end
		end
	end
end


function x020071_OnCopySceneTimeOut(scene)
	local nUserCount = GetSceneUserCount(scene)
	for j=0,nUserCount-1 do
		x020071_OnSuccess(scene, nUserObjId, false)
	end
end

function x020071_OnPrepareLeaveCopyScene(scene)
	local nUserCount = GetSceneUserCount(scene)
	for j=0,nUserCount-1 do
		local nUserObjId = GetUserObjIdByIdx(scene,j)
		AutoReChallengeJuLing(scene, nUserObjId)
	end
end

