x020080_g_scriptId = 020080

x020080_g_MonsterId = {} -- 每波怪物的起始ID
x020080_g_MonsterId[1] = {730001,732001,734001}

x020080_g_MonsterNum = {} -- 每波怪物的数量
x020080_g_MonsterNum[1] = {20,20,20}

x020080_g_AdapteLvl = 100

x020080_g_MonsterPos = {} -- 每波怪物的出生位置
x020080_g_MonsterPos[1] = {{61.95,31.58,-1.53},{64.79,31.04,-1.85},{67.35,29.79,-2.41},{69.18,27.72,-2.75},{70.16,25.26,-3.04},{70.11,22.9,-3.29},{69.74,20.8,-3.53},{68.76,19.01,-3.83},{67.28,17.58,-3.99},{65.51,16.55,-4.23},{63.18,15.95,-4.52},{60.97,16.17,1.31},{58.85,16.96,1.05},{57.07,18.44,0.79},{55.68,20.38,0.5},{54.99,22.56,-0.04},{54.99,24.96,0.09},{55.75,27.37,-0.57},{57.26,29.36,-0.83},{59.22,30.78,-1.22}}
x020080_g_MonsterPos[2] = {{61.95,31.58,-1.53},{64.79,31.04,-1.85},{67.35,29.79,-2.41},{69.18,27.72,-2.75},{70.16,25.26,-3.04},{70.11,22.9,-3.29},{69.74,20.8,-3.53},{68.76,19.01,-3.83},{67.28,17.58,-3.99},{65.51,16.55,-4.23},{63.18,15.95,-4.52},{60.97,16.17,1.31},{58.85,16.96,1.05},{57.07,18.44,0.79},{55.68,20.38,0.5},{54.99,22.56,-0.04},{54.99,24.96,0.09},{55.75,27.37,-0.57},{57.26,29.36,-0.83},{59.22,30.78,-1.22}}
x020080_g_MonsterPos[3] = {{61.95,31.58,-1.53},{64.79,31.04,-1.85},{67.35,29.79,-2.41},{69.18,27.72,-2.75},{70.16,25.26,-3.04},{70.11,22.9,-3.29},{69.74,20.8,-3.53},{68.76,19.01,-3.83},{67.28,17.58,-3.99},{65.51,16.55,-4.23},{63.18,15.95,-4.52},{60.97,16.17,1.31},{58.85,16.96,1.05},{57.07,18.44,0.79},{55.68,20.38,0.5},{54.99,22.56,-0.04},{54.99,24.96,0.09},{55.75,27.37,-0.57},{57.26,29.36,-0.83},{59.22,30.78,-1.22}}
x020080_g_BossId = {} -- 每波boss的起始ID
x020080_g_BossId[1] = {736000}

x020080_g_BossPosList = {}
x020080_g_BossPosList[1] = {{62.95,80.13,-1.57}}

x020080_g_EveryStageTime = 60 -- 每阶段时间 单位秒
x020080_g_TotleTime = 180 -- 副本总时间 单位秒

x020080_g_MonsterReliveTime = 2 -- 怪物重生时间 单位秒
x020080_g_LevelMax = 1000 -- 玩家最高等级

x020080_g_EncouragementBuffId = 99999 -- 鼓舞BuffId

x020080_g_Stage1TopStr = 16517

x020080_g_ExpRadio = 4
x020080_g_Stage2TopStr = 16518
x020080_g_Stage2BottomStr = 16519

x020080_g_ActivtyType = {} -- 对应ActivtyBonus中的列
x020080_g_ActivtyType[1] = {6,34,35}

-- CopySceneParam
x020080_g_Stage = 0				-- 阶段
x020080_g_MonsterKilledNum = 1	-- 杀怪数
x020080_g_Exp = 2				-- 获得经验
x020080_g_Buff = 3				-- 鼓舞BuffId
x020080_g_StageTime = 4			-- 每阶段时间
x020080_g_WaitStartTime = 5		-- 副本开始时间
x020080_g_ShouHuExpRate = 6		-- 守护经验找回比例
x020080_g_Ticks = 9				-- 持续时间
x020080_g_CSParamIdxCurSubStage = 12 -- 当前波数中的所处时间戳

function x020080_OnCopySceneOpen(scene)

	SetCopySceneParam(scene,x020080_g_Stage,1)
	SetCopySceneParam(scene,x020080_g_MonsterKilledNum,0)
	SetCopySceneParam(scene,x020080_g_Exp,0)
	SetCopySceneParam(scene,x020080_g_Buff,x020080_g_EncouragementBuffId)
	SetCopySceneParam(scene,x020080_g_StageTime,x020080_g_EveryStageTime)
	SetCopySceneParam(scene,x020080_g_WaitStartTime,GetWaitStartTime(scene) / 1000)
	InitShouHuExpRate(scene,x020080_g_ShouHuExpRate)
	
	ClearExp(scene)
end

function x020080_OnCopySceneTimeOut(scene)
	x020080_Succeed(scene)
end

function x020080_OnCopySceneTick(scene,tickCount)
	local realTime = tickCount
		local curSubStage = GetCopySceneParam(scene,x020080_g_CSParamIdxCurSubStage) +1
	SetCopySceneParam(scene,x020080_g_CSParamIdxCurSubStage,curSubStage)
	if (realTime < 0) then
		return
	end
	
	if (GetCopySceneStatus(scene) > 2) then
		return
	end
	local nAdaptedLvl = math.floor(GetAdaptLvl(scene)/10)
	if nAdaptedLvl > x020080_g_AdapteLvl then
		nAdaptedLvl = x020080_g_AdapteLvl
	end
	if tickCount <= #x020080_g_MonsterNum[1] * x020080_g_EveryStageTime then
		x020080_StageMonster(scene, tickCount)
	elseif GetCopySceneParam(scene, x020080_g_Stage) == 4 then

		x020080_StageBoss(scene, curSubStage, nAdaptedLvl)
	elseif GetCopySceneParam(scene, x020080_g_Stage) == 5 then
		x020080_Succeed(scene)
	end
	-- local level = GetRealTimeAdaptLvl(scene)
	
	
	CheckExpCSLost(scene)
end

function x020080_StageMonster(scene, tickCount)
	-- body
	local level = GetExpCSAdaptLvl(scene)
	local offset
	if (level <= 200) then
		offset = level - 1
	else
		offset = 199 + (((((level - 201) - ((level - 201) % 10)) / 10) + 1) * 10)
	end

	if (tickCount % x020080_g_EveryStageTime == 0) then
			SetCopySceneParam(scene,x020080_g_CSParamIdxCurSubStage,0)
		SetCopySceneParam(scene,x020080_g_Stage,tickCount / x020080_g_EveryStageTime + 1)
		--BroadcastExpCSData(scene)
		
		-- 一阶段怪物直接刷新 二三阶段生成对应阶段的怪物 并将数量补满
		local stage = GetCopySceneParam(scene,x020080_g_Stage)
		if (stage > #x020080_g_MonsterNum[1]) then
			return
		end
		
		-- 根据等级计算出怪的roleBaseId和实际经验
		local monsterRealId = x020080_g_MonsterId[1][stage] + offset
		
		local countMonster
		if (stage == 1) then
			countMonster = x020080_g_MonsterNum[1][stage]		
			for i = 1, countMonster do
				-- CreateMonster(scene,monsterRealId,x020080_g_MonsterPos[stage][i][3],x020080_g_MonsterPos[stage][i][1],x020080_g_MonsterPos[stage][i][2],level,x020080_g_ActivtyType[1][stage])
				CreateMonster(scene,monsterRealId,x020080_g_MonsterPos[stage][i][3],x020080_g_MonsterPos[stage][i][1],x020080_g_MonsterPos[stage][i][2],level)				
			end
		else
			countMonster = x020080_g_MonsterNum[1][stage] - GetHostileMonsterCount(scene)
			for i = 1, countMonster do
				-- CreateMonster(scene,monsterRealId,x020080_g_MonsterPos[stage][i][3],x020080_g_MonsterPos[stage][i][1],x020080_g_MonsterPos[stage][i][2],level,x020080_g_ActivtyType[1][stage])
				CreateMonster(scene,monsterRealId,x020080_g_MonsterPos[stage][i][3],x020080_g_MonsterPos[stage][i][1],x020080_g_MonsterPos[stage][i][2],level)				
			end
		end
	end
	
	if (GetCopySceneParam(scene,x020080_g_Stage) <= #x020080_g_MonsterId[1]) then 
		CheckMonsterRelive(scene,GetCopySceneParam(scene,x020080_g_Ticks),x020080_g_MonsterId[1][GetCopySceneParam(scene,x020080_g_Stage)] + offset)
	end
end
function x020080_StageBoss(scene ,substage, nlv)
	-- body
		if substage == 1 then
		DeleHostileMonster(scene)
		BroadcastTuPoCSData(scene, -1, x020080_g_Stage2TopStr, x020080_g_Stage2BottomStr)
		local objid = CreateMonster(scene, x020080_g_BossId[1][1] + 10 * (nlv), x020080_g_BossPosList[1][1][3], x020080_g_BossPosList[1][1][1],x020080_g_BossPosList[1][1][2])
		--SetNpcCampByObjId(scene,objid,1)
	end
end
function x020080_OnObjEnter(scene,objId)
	local stage = GetCopySceneParam(scene,x020080_g_Stage)
	AutoCombat(scene,objId,true)
	if stage > 3 then
		BroadcastTuPoCSData(scene, -1, x020080_g_Stage2TopStr, x020080_g_Stage2BottomStr)
	elseif stage <= 3 then
		BroadcastTuPoCSData(scene, x020080_g_Stage1TopStr)
	end
	--BroadcastTuPoCSData(scene)
	
	OpExpCSUI(scene,objId,1,true)
	OpExpCSUI(scene,objId,2,true)
	OpExpCSBuff(scene,objId,true)
end

function x020080_OnObjLeave(scene,objId)
	AutoCombat(scene,objId,false)
	OpExpCSUI(scene,objId,1,false)
	OpExpCSUI(scene,objId,2,false)
	OpExpCSBuff(scene,objId,false)
end

function x020080_OnObjDie(scene,objId,rolebaseId,killerId)
	if (rolebaseId < 5) then
		return
	end
	
	local nAdaptedLvl = math.floor(GetAdaptLvl(scene)/10)
	if nAdaptedLvl > x020080_g_AdapteLvl then
		nAdaptedLvl = x020080_g_AdapteLvl
	end


	-- 获取死亡的怪物类型
	local monsterType = -1
	local countMonsterType = #x020080_g_MonsterId[1]
	for i = 1, countMonsterType do
		if (rolebaseId >= x020080_g_MonsterId[1][i]) and (rolebaseId < x020080_g_MonsterId[1][i] + x020080_g_LevelMax) then
			monsterType = i
			break
		end
	end
	


	local ran
	
	-- 判断该怪物是否是本阶段的怪物 如果不是 生成一只本阶段怪物
	local stage = GetCopySceneParam(scene,x020080_g_Stage)

	if stage == 4 and monsterType == -1 and GetHostileMonsterCount(scene) == 0 then
		SetCopySceneParam(scene, x020080_g_Stage, 5)
		return
	end	


	if (stage > #x020080_g_MonsterNum[1]) then
		return
	end
	
	-- local level = GetRealTimeAdaptLvl(scene)
	local level = GetExpCSAdaptLvl(scene)
	if (monsterType ~= stage) then
		local monsterRealId
		if (level <= 200) then
			monsterRealId = x020080_g_MonsterId[1][stage] + level - 1
		else 
			monsterRealId = x020080_g_MonsterId[1][stage] + 199 + (((((level - 201) - ((level - 201) % 10)) / 10) + 1) * 10)
		end
		ran = RandomMon(1,#x020080_g_MonsterPos[stage])
		-- CreateMonster(scene,monsterRealId,x020080_g_MonsterPos[stage][ran][3],x020080_g_MonsterPos[stage][ran][1],x020080_g_MonsterPos[stage][ran][2],level,x020080_g_ActivtyType[1][stage])
		CreateMonster(scene,monsterRealId,x020080_g_MonsterPos[stage][ran][3],x020080_g_MonsterPos[stage][ran][1],x020080_g_MonsterPos[stage][ran][2],level)
	end
			
	-- 判断该怪物的复活时间是否会在下一阶段
	if (GetCopySceneParam(scene,x020080_g_Ticks) < x020080_g_EveryStageTime * monsterType - x020080_g_MonsterReliveTime) then
		ran = RandomMon(1,#x020080_g_MonsterPos[monsterType])
		SetMonsterRelive(scene,rolebaseId,x020080_g_MonsterId[1][monsterType],GetCopySceneParam(scene,x020080_g_Ticks) + x020080_g_MonsterReliveTime,x020080_g_MonsterPos[monsterType][ran][3],x020080_g_MonsterPos[monsterType][ran][1],x020080_g_MonsterPos[monsterType][ran][2],0,x020080_g_ActivtyType[1][monsterType])
	end
		
	SetCopySceneParam(scene,x020080_g_MonsterKilledNum,GetCopySceneParam(scene,x020080_g_MonsterKilledNum) + 1)
  --  RecordExp(scene,rolebaseId)
  --AddJuHunCSExp(scene, rolebaseId)
  RecordTuPoCSExp(scene,objId,x020080_g_ActivtyType[1][stage], x020080_g_ExpRadio)	
	--RecordExpByLevel(scene,objId,x020080_g_ActivtyType[1][stage])
	if stage > 3 then
		BroadcastTuPoCSData(scene, -1, x020080_g_Stage2TopStr, x020080_g_Stage2BottomStr)
	elseif stage <= 3 then
		BroadcastTuPoCSData(scene, x020080_g_Stage1TopStr)
	end
end

function x020080_Succeed(scene)
	DeleHostileMonster(scene)
	EndTuPoCS(scene)
	AccoutByCopyScene(scene)
	SetCopySceneSuccess(scene)
end

