--2.1.22.1.3封魔祭台

x020087_g_scriptId = 020087

x020087_g_CSParamIdxCurStage = 0                     -- 场景切换波数
x020087_g_CSParamIdxCurSubStage = 1                   -- 同一场景中的时间点
x020087_g_CSParamIdxrandtime = 2                       -- 记录击杀了几个第一只怪
x020087_g_CSParamIdBossId = 5                       -- 记录BossID

x020087_g_Movparm = 10

x020087_g_AdapteLvl = 60  --   每个怪物的自适应等级套数  必须随适应等级的变化而改变
--以上为波次刷怪的波次适应等级  编号1代表第一波怪的自适应等级    编号1里第一个中括号表示第一波第一个怪物的自适应等级套数  依次类推

x020087_g_BossId = {}
x020087_g_BossId[1] = { 468000, 468010, 468020, 468030, 468040, 468050, 468060, 468070, 468080, 468090, 468100, 468110, 468120, 468130, 468140, 468150, 468160, 468170, 468180, 468190, 468200, 468210, 468220, 468230, 468240, 468250, 468260, 468270, 468280, 468290, 468300, 468310, 468320, 468330, 468340, 468350, 468360, 468370, 468380, 468390, 468400, 468410, 468420, 468430, 468440, 468450, 468460, 468470, 468480, 468490, 468500, 468510, 468520, 468530, 468540, 468550, 468560, 468570, 468580, 468590 }    -- Boss编号   表示Boss的自适应等级套数
x020087_g_BossPosList = {}
x020087_g_BossPosList[1] = { { 61.36, 34.36, 0.6675 } }    --  Boss 坐标

x020087_g_SmallMonster = {} -- 辅助怪起始ID
x020087_g_SmallMonster[1] = { 464000, 465000, 466000, 467000 }

x020087_g_mallMonsterPosList = {}
x020087_g_mallMonsterPosList[1] = { { 67.97, 35.16, 2.66 }, { 64.47, 40.45, 4.7 }, { 63.6, 25.45, 1.62 }, { 53.83, 41.28, -0.46 } }    --  辅助怪 坐标

x020087_g_Effect = {}
x020087_g_Effect[1] = { 960011, 960012, 960013, 960014 } --
x020087_g_Effect[2] = { 960001, 960002, 960003, 960004 }

x020087_g_BossEffect = 960021

x020087_g_DamageDecImpact = 75201 -- 增加防御
--x020087_g_DelDamageDecImpact = 75202 -- 减防御

x020087_g_BossSilenceImpact = 63001 -- 定身

x020087_g_BossTips = {}
x020087_g_BossTips[1] = { 94034, 61001 } -- (StrDicId, FakeObjId)

function x020087_OnObjEnter(scene, objId)
    SynCsStageData(scene, objId, true)
    TestFullHp(scene,objId)
end

function x020087_OnCopySceneOpen(scene, objId)
    StoryAnimation(scene, 2200)
end

function x020087_OnCopySceneTick(scene, tickCount)
    if tickCount == 0 then
        CaluCSRound(scene)
    end
    local curStage = GetCopySceneParam(scene, x020087_g_CSParamIdxCurStage)
    local curSubStage = GetCopySceneParam(scene, x020087_g_CSParamIdxCurSubStage) + 1
    SetCopySceneParam(scene, x020087_g_CSParamIdxCurSubStage, curSubStage)
    if GetCopySceneStatus(scene) == 4 and curStage == 1 then
        curStage = 3
        DeleHostileMonster(scene)
        SetCopySceneParam(scene, x020087_g_CSParamIdxCurStage, 3)
        ShowSJCSEnd(scene, false)
    end
    local nAdaptedLvl = math.floor(GetAdaptLvl(scene) / 10)
    if nAdaptedLvl > x020087_g_AdapteLvl then
        nAdaptedLvl = x020087_g_AdapteLvl
    end
    if (tickCount == 20) then
        ChangeAllMonsterCamp(scene, 3)
    end
    if curStage == 0 then
        x020087_Stage_0(scene, curStage, curSubStage, nAdaptedLvl)
    elseif curStage == 1 then
        x020087_Stage_1(scene, curStage, curSubStage, nAdaptedLvl)
    elseif curStage == 2 then
        x020087_Stage_2(scene, curStage, curSubStage)
    end
end

function x020087_OnStoryEventEnd(scene, nStoryId, nAnimationId)
    local OldValue = GetCopySceneParam(scene, 13)
    if OldValue == 0 then
        SetCopySceneParam(scene, 13, 1)
    end
end

function x020087_Stage_2(scene, curStage, curSubStage)
    local nCurStage = GetCopySceneParam(scene, x020087_g_CSParamIdxCurStage)
    SetCopySceneParam(scene, x020087_g_CSParamIdxCurStage, nCurStage + 1)
    SetCopySceneParam(scene, x020087_g_CSParamIdxCurSubStage, 0)
    ShowSJCSEnd(scene, true)
    x020087_Success(scene)
end

function x020087_Success(scene)
    DeleHostileMonster(scene)
    AccoutByCopyScene(scene)
    SetCopySceneSuccess(scene)
end

function x020087_OnObjDie(scene, objId, rolebaseId, killerId)
    local MonCount = GetHostileMonsterCount(scene)
    local nCurStage = GetCopySceneParam(scene, x020087_g_CSParamIdxCurStage)
    local nAdaptedLvl = math.floor(GetAdaptLvl(scene) / 10)
    if nAdaptedLvl > x020087_g_AdapteLvl then
        nAdaptedLvl = x020087_g_AdapteLvl
    end
    local TargetId = x020087_g_BossId[1][nAdaptedLvl]
    if (TargetId == rolebaseId) then
        x020087_OnDieCountDown1(scene, rolebaseId, nAdaptedLvl)
        SetCopySceneParam(scene, x020087_g_CSParamIdxCurStage, nCurStage + 1)
        SetCopySceneParam(scene, x020087_g_CSParamIdxCurSubStage, 0)
        RemoveCopySceneGuideEffect(scene, x020087_g_BossEffect)
        for i = 1, #x020087_g_SmallMonster[1] do
            RemoveCopySceneGuideEffect(scene, x020087_g_Effect[1][i], x020087_g_Effect[2][i])
        end

    else
        if rolebaseId > 100 then
            local bossID = GetCopySceneParam(scene, x020087_g_CSParamIdBossId)
            RemoveImpact(scene, bossID, x020087_g_DamageDecImpact)
            if MonCount - 1 > 0 then
                for i = 1, MonCount - 1 do
                    SendImpactToUnit(scene, bossID, x020087_g_DamageDecImpact)
                end
            end

            --DelImpactOverLayCountById(scene, bossID, x020087_g_DamageDecImpact)
            for i = 1, #x020087_g_SmallMonster[1] do
                if rolebaseId - (nAdaptedLvl - 1) * 10 == x020087_g_SmallMonster[1][i] then
                    RemoveCopySceneGuideEffect(scene, x020087_g_Effect[1][i], x020087_g_Effect[2][i])
                end
            end
            if MonCount == 1 then
                RemoveCopySceneGuideEffect(scene, x020087_g_BossEffect)
                RemoveImpact(scene, bossID, x020087_g_BossSilenceImpact)
                BroadCastBossTips(scene, x020087_g_BossTips[1][2], x020087_g_BossTips[1][1], x020087_g_BossId[1][nAdaptedLvl])
            end
        end
    end
end

function x020087_OnDieCountDown1(scene, rolebaseId, nlv)
    if rolebaseId == x020087_g_BossId[1][nlv] then
        local OldValue = GetCopySceneParam(scene, x020087_g_CSParamIdxrandtime)
        SetCopySceneParam(scene, x020087_g_CSParamIdxrandtime, OldValue + 1)
        local nUserCount = GetSceneUserCount(scene)
        for i = 0, nUserCount - 1 do
            local nUserObjId = GetUserObjIdByIdx(scene, i)
            SynCsStageData(scene, nUserObjId)
        end
    end
end

function x020087_Stage_0(scene, stage, substage, nlv)
    if ((substage == x020087_g_Movparm and GetCopySceneParam(scene, 13) == 0) or GetCopySceneParam(scene, 13) == 1) then
        SetCopySceneParam(scene, 13, 2)
        SetCopySceneParam(scene, x020087_g_CSParamIdxCurStage, 1)
        SetCopySceneParam(scene, x020087_g_CSParamIdxCurSubStage, 0)
    end
end

function x020087_Stage_1(scene, stage, substage, nlv)
    if substage == 1 then
        TellPlayerAutoCombat(scene, true)
        local monsterId = CreateMonster(scene, x020087_g_BossId[1][nlv], x020087_g_BossPosList[1][1][3], x020087_g_BossPosList[1][1][1], x020087_g_BossPosList[1][1][2])
        SetCopySceneParam(scene, x020087_g_CSParamIdBossId, monsterId)
        SendImpactToUnit(scene, monsterId, x020087_g_BossSilenceImpact)
        ShowCopySceneGuideEffect(scene, x020087_g_BossEffect)

        for i = 1, #x020087_g_SmallMonster[1] do
            CreateMonster(scene, x020087_g_SmallMonster[1][i] + (nlv - 1) * 10, x020087_g_mallMonsterPosList[1][i][3], x020087_g_mallMonsterPosList[1][i][1], x020087_g_mallMonsterPosList[1][i][2])
            SendImpactToUnit(scene, monsterId, x020087_g_DamageDecImpact)
        end
        for i = 1, #x020087_g_Effect do
            ShowCopySceneGuideEffect(scene, x020087_g_Effect[i][1], x020087_g_Effect[i][2], x020087_g_Effect[i][3], x020087_g_Effect[i][4])
        end
    end
end