x020187_g_scriptId=020187

x020187_g_CSParamIdxCurFloor=0
x020187_g_CSParamIdxCurSubStage=1
x020187_g_CSEndFlag = 2
x020187_g_CSSettlementFlag = 4 -- 结算标识
x020187_g_CSBossType = 5 

x020187_g_FirstMonsterId = 1101701
x020187_g_buffid = 78704

x020187_g_SmallThreeStarTime = 90
x020187_g_SmallTwoStarTime = 120
x020187_g_SmallOneStarTime = 300

x020187_g_BossThreeStarTime = 60
x020187_g_BossTwoStarTime = 90
x020187_g_BossOneStarTime = 180

x020187_g_MoveOneId = 10101
x020187_g_MoveTwoId = 10102
x020187_g_MoveThreeId = 10103


function x020187_OnCopySceneOpen(scene)
	SetCopySceneParam(scene, x020187_g_CSEndFlag, 0)
	SetCopySceneParam(scene, x020187_g_CSSettlementFlag, 0)
	local nUserCount = GetSceneUserCount(scene)
	for j=0,nUserCount-1 do
		local nUserObjId = GetUserObjIdByIdx(scene,j)
		if IsAlive(scene,nUserObjId) == false then
			TestFullHp(scene, nUserObjId)
		end
		SetHpFull(scene, nUserObjId)
	end
end

function x020187_OnCopySceneTick(scene,tickCount)
	--副本阶段
	local nUserCount = GetSceneUserCount(scene)
	local nEndMark = GetCopySceneParam(scene, x020187_g_CSEndFlag)
	local nSettlementFlag = GetCopySceneParam(scene, x020187_g_CSSettlementFlag)
	local nBossType =  GetCopySceneParam(scene, x020187_g_CSBossType)
	if tickCount == 0 then
		x020187_StageControl(scene, 0)
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			CreateMonByCombatPetScene(scene, 0, nUserObjId)
		end
	end
	if nEndMark == 1 and nSettlementFlag == 0 and nBossType == 0 then
		SetCopySceneParam(scene, x020187_g_CSSettlementFlag, 1)
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			if tickCount <= x020187_g_SmallThreeStarTime then
				x020187_OnSuccess(scene, nUserObjId, true, 3)
			elseif tickCount <= x020187_g_SmallTwoStarTime then
				x020187_OnSuccess(scene, nUserObjId, true, 2)
			elseif tickCount < x020187_g_SmallOneStarTime then
				x020187_OnSuccess(scene, nUserObjId, true, 1)
			end
		end	
	end
	if nEndMark == 1 and nSettlementFlag == 0 and nBossType == 1 then
		SetCopySceneParam(scene, x020187_g_CSSettlementFlag, 1)
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			if tickCount <= x020187_g_BossThreeStarTime then
				x020187_OnSuccess(scene, nUserObjId, true, 3)
			elseif tickCount <= x020187_g_BossTwoStarTime then
				x020187_OnSuccess(scene, nUserObjId, true, 2)
			elseif tickCount < x020187_g_BossOneStarTime then
				x020187_OnSuccess(scene, nUserObjId, true, 1)
			end
		end	
	end
	for j=0,nUserCount-1 do
		local nUserObjId = GetUserObjIdByIdx(scene,j)
		local FlushTime = GetFlushTime(scene, nUserObjId)
		if(FlushTime > 0) then
			x020187_CreateMonster(scene, FlushTime, tickCount)
		end		
	end

end

function x020187_OnObjEnter(scene,objId)
	TellPlayerAutoCombat(scene)
	local nBossType = GetCombatPetBossType(scene,objId)
	SetCopySceneParam(scene, x020187_g_CSBossType, nBossType)
	SynCsStageData(scene, objId, true)
end

function  x020187_StageControl(scene,nstage)
	SetCopySceneParam(scene, 7, nstage)
	local nUserCount = GetSceneUserCount(scene)
	for j=0,nUserCount-1 do
		local nUserObjId = GetUserObjIdByIdx(scene,j)
		SynCsStageData(scene, nUserObjId)
	end
end

function x020187_OnObjDie( scene,objId,rolebaseId,killerId )
	local nUserCount = GetSceneUserCount(scene)
	local CurStage = GetCopySceneParam(scene, x020187_g_CSParamIdxCurSubStage)
	if GetHostileMonsterCount(scene) == 0 then
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			local bEnd = CheckCombatPetCSEnd(scene, CurStage + 1, nUserObjId)
			local ChallengeId = GetComBatPetChallengeId(scene, nUserObjId)
			if (bEnd == false) then
				x020187_StageControl(scene, CurStage+1)
				SetCopySceneParam(scene, x020187_g_CSParamIdxCurSubStage, CurStage+1)
				CreateMonByCombatPetScene(scene, CurStage+1, nUserObjId)
				return
			end
			if ChallengeId == 101006 then
				StoryAnimation(scene, x020187_g_MoveOneId)
			end
			if ChallengeId == 201009 then
				StoryAnimation(scene, x020187_g_MoveTwoId)
			end
			if ChallengeId == 301009 then
				StoryAnimation(scene, x020187_g_MoveThreeId)
			end
		end
		DeleAliveNpcFriendlyMonster(scene)
		SetCopySceneParam(scene, x020187_g_CSEndFlag, 1)
		SetCopySceneSuccess(scene)
	end
end

function x020187_OnSuccess(scene, objId, IsPec, starLevel)
	SetCopySceneParam(scene, x020187_g_CSEndFlag, 1)
	CombatPetSuccess(scene, objId, IsPec, starLevel)
	DeleHostileMonster(scene)
	TestFullHp(scene, objId)
end


function x020187_CreateMonster(scene, FlushTime, tickCount)
	local CurStage = GetCopySceneParam(scene, x020187_g_CSParamIdxCurSubStage)
	local nUserCount = GetSceneUserCount(scene)
	if (tickCount % (FlushTime / 1000) == 0)  and (tickCount > 0) then
		for i=0,nUserCount-1 do
			local nUserObjId = GetUserObjIdByIdx(scene,i)
			local bEnd = CheckCombatPetCSEnd(scene, CurStage + 1, nUserObjId)
			if bEnd == false then
				x020187_StageControl(scene, CurStage+1)
				SetCopySceneParam(scene, x020187_g_CSParamIdxCurSubStage, CurStage+1)
				CreateMonByCombatPetScene(scene, CurStage+1, nUserObjId)
				return
			elseif bEnd == true and (GetHostileMonsterCount(scene) == 0) then
				for j=0,nUserCount-1 do
					local nUserObjId = GetUserObjIdByIdx(scene,j)
					if GetCSEvaluaion(scene) ~= 0 then
						x020187_OnSuccess(scene, nUserObjId, false, 0)
					elseif GetCSEvaluaion(scene) == 0 then
						x020187_OnSuccess(scene, nUserObjId, true, 3)
					SetCopySceneSuccess(scene)
					end
				end
			end
		end
	end
end


function x020187_OnCopySceneTimeOut(scene)
	local nUserCount = GetSceneUserCount(scene)
	SetCopySceneParam(scene, x020187_g_CSSettlementFlag, 1)
	for j=0,nUserCount-1 do
		local nUserObjId = GetUserObjIdByIdx(scene,j)
		x020187_OnSuccess(scene, nUserObjId, false, 0)
	end
end

function x020187_OnPrepareLeaveCopyScene(scene)
	local nUserCount = GetSceneUserCount(scene)
	for j=0,nUserCount-1 do
		local nUserObjId = GetUserObjIdByIdx(scene,j)
		AutoReChallengeJuLing(scene, nUserObjId)
	end
end

