x003054_g_scriptId = 003054

x003054_g_AddExpIndex = 5
x003054_g_AddExpRate = 0.05
x003054_g_AddExpFlagRate = 0.

x003054_g_AddYuanShenExpIndex = 1
x003054_g_AddYuanShenExpRate = 0.05

x003054_g_RoleBornPosition = {}
x003054_g_RoleBornPosition[1] = {260,42, 1.57}
x003054_g_RoleBornPosition[2] = {84,150, 0.52}
x003054_g_RoleBornPosition[3] = {81,379, -0.52}
x003054_g_RoleBornPosition[4] = {260,488, -1.57}
x003054_g_RoleBornPosition[5] = {434,377, 3.66}
x003054_g_RoleBornPosition[6] = {437,153, 2.61}

x003054_g_Flag = {}
x003054_g_Flag[1] = {20001, 173, 440, 2.059}
x003054_g_Flag[2] = {20002, 83, 264.3, 0} 
x003054_g_Flag[3] = {20003, 174, 93, 1.256} 
x003054_g_Flag[4] = {20004, 262.06, 358.674, 1.57} 
x003054_g_Flag[5] = {20005, 273, 264, 4.712} 
x003054_g_Flag[6] = {20006, 247, 264, 1.57} 
x003054_g_Flag[7] = {20007, 261.05, 169.635, 4.712}
x003054_g_Flag[8] = {20008, 350, 440, 1.082} 
x003054_g_Flag[9] = {20009, 439.4, 264.27, 3.141} 
x003054_g_Flag[10] = {20010, 352, 87, 1.884} 


x003054_g_FlagPoint = 400
x003054_g_FirstFlagPoint = 800
x003054_g_KillPoint = 100
x003054_g_FengHaoKillPoint = 10
x003054_g_KillPeaceBoss = 200
x003054_g_KillBattleBoss = 400
x003054_g_DiePointPercent = 0.3

function x003054_RefreshFlag(scene, list)
	RefreshShenYuFlag(scene, x003054_g_Flag, list)
	-- body
end

function x003054_OnObjDie(scene, objId, rolebaseId, killerId)
	if IsUser(objId) then	
		AddShenYuKillRank(scene, killerId, objId)
	end
	
	print("x003054_OnObjDie objId=" .. objId)
	if CanAddShenYuKillPoint(scene, killerId, objId) then
		print("CanAddShenYuKillPoint true")
		x003054_AddKillUserPoint(scene, objId, killerId)
		AddShenYuKillCount(scene, killerId)
		SendShenYuKillPlayerSystemBroadCast(scene, objId, killerId)
	end

end

function x003054_OnObjRelife(scene, objId, type)
	if IsUser(objId) and type == true then
		x003054_RandomPosition(scene, objId)
	end
end

function x003054_OnObjEnter(scene, objId)
	--print("x003054_OnObjEnter objId=" .. objId)
	if IsUser(objId) then 
		UserEnterShenYuScene(scene, objId)
		x003054_RandomPosition(scene, objId)
		SyncShenYuFlagData(scene, objId)
	end
end

function x003054_OnObjReconnect(scene, objId)
	SyncShenYuFlagData(scene, objId)
end

function x003054_OnObjLeave(scene, objId)
	UserLeaveShenYuScene(scene, objId)
end

function x003054_OnAddExp(scene)
	--print("x003054_OnAddExp ")
	ShenYuSceneAddExp(scene, x003054_g_AddExpIndex, x003054_g_AddExpRate, x003054_g_AddExpFlagRate, x003054_g_AddYuanShenExpIndex, x003054_g_AddYuanShenExpRate)
end

function x003054_AddUserShenYuPoint(scene, type, objId)
	print("x003054_AddUserShenYuPoint type:" .. type .. ",objId:" .. objId)
	if type == 1 then		--旗子
		if IsFirstCaptureShenYuFlag(scene, objId) then
			AddUserShenYuPoint(scene, objId, type, x003054_g_FirstFlagPoint)
		else
			AddUserShenYuPoint(scene, objId, type, x003054_g_FlagPoint)
		end
		AddShenYuCaptureFlagCount(scene, objId)
	elseif type == 3 then	--和平boss
		AddUserShenYuPoint(scene, objId, type, x003054_g_KillPeaceBoss)
	elseif type == 4 then	--战争boss
		AddUserShenYuPoint(scene, objId, type, x003054_g_KillBattleBoss)
	else
	end
end

function x003054_AddKillUserPoint(scene, objId, killerId)
	-- body
	local killpoint = GetKillPoint(scene, objId, killerId, x003054_g_KillPoint, x003054_g_FengHaoKillPoint)
	local point = AddUserShenYuPoint(scene, killerId, 2, killpoint)
	print("x003054_AddKillUserPoint point:" .. point .. ",killpoint:" .. killpoint)
	if point > 0 then
		--OnDieDelShenYuPoint(scene, objId, math.floor(point * x003054_g_DiePointPercent))
	end
end

function x003054_RandomPosition(scene, objId)
	-- body
	local index = RandomMon(1, #x003054_g_RoleBornPosition + 1)
	print("x003054_RandomPosition index=" .. index)
	SetShenYuScenePos(scene, objId, x003054_g_RoleBornPosition[index][1], x003054_g_RoleBornPosition[index][2], x003054_g_RoleBornPosition[index][3], index)
end