x003050_g_scriptId = 003050

x003050_g_BigBossId = 526000
x003050_g_BigBossPos = { 198.52, 149.11, 0.17 }

x003050_g_NormalBossId = 526001
x003050_g_NormalBossPos = { { 174.1, 137.96, 1.57 }, { 186.49, 124.88, 0.78 }, { 184.4, 135.08, -2.2 }, { 174.3, 161.39, -0.79 }, { 187.38, 173.78, 0 }, { 184.5, 163.48, -3.78 }, { 210.81, 173.58, -2.36 }, { 223.2, 160.5, -1.57 }, { 213.04, 163.57, 0.94 }, { 223, 137.07, -3.93 }, { 209.92, 124.68, -3.14 }, { 212.99, 134.84, -0.63 }, { 225.06, 131.09, -0.68 }, { 213.45, 113.11, -4.28 }, { 234.3, 133.77, -3.93 }, { 225.41, 121.17, -3.84 }, { 215.81, 121.22, -0.68 }, { 180.51, 122.82, -2.25 }, { 162.53, 134.43, 0.43 }, { 183.19, 113.58, 0.78 }, { 170.59, 122.47, 0.88 }, { 170.64, 132.07, -2.25 }, { 216.79, 175.64, 0.89 }, { 234.77, 164.03, -2.71 }, { 214.11, 184.88, -2.36 }, { 226.71, 175.99, -2.26 }, { 226.66, 166.39, 0.89 }, { 163, 164.69, -0.79 }, { 172.24, 167.37, -3.82 }, { 171.89, 177.29, -0.69 }, { 183.85, 185.35, -1.14 } }

--采集Id
x003050_g_CollectionId = 9001

--刷新位置
x003050_g_CollectionPos = { { 176, 200.8, 1.57 }, { 133.2, 199.4, 1.57 }, { 160, 200.2, 1.57 }, { 156.8, 187, 1.57 }, { 126.7, 252.1, 1.57 }, { 117.7, 195.2, 1.57 }, { 119.6, 177.7, 1.57 }, { 109.8, 215.4, 1.57 }, { 264.7, 238, 1.57 }, { 126.5, 237.6, 1.57 }, { 285.1, 122.9, 1.57 }, { 217.4, 204.7, 1.57 }, { 247.6, 199.4, 1.57 }, { 266.4, 206.8, 1.57 }, { 273.9, 228, 1.57 }, { 230.6, 193, 1.57 }, { 284, 100.2, 1.57 }, { 266.3, 113.3, 1.57 }, { 272.5, 85, 1.57 }, { 284.3, 75.8, 1.57 }, { 290.5, 62.9, 1.57 }, { 268.9, 67.8, 1.57 }, { 276.14, 53.5, 1.57 }, { 247.2, 107.1, 1.57 }, { 227, 105.7, 1.57 }, { 227, 89.6, 1.57 }, { 161.7, 88.6, 1.57 }, { 162.2, 113.1, 1.57 }, { 110, 102.4, 1.57 }, { 130.6, 117.6, 1.57 }, { 110.2, 116, 1.57 }, { 105.4, 87.3, 1.57 }, { 122.98, 96.57, 1.57 }, { 119.4, 50.4, 1.57 }, { 117.1, 73.7, 1.57 }, { 97.9, 62.3, 1.57 } }

--活动采集Id
x003050_g_CollectionActId = {}
x003050_g_CollectionActId[1] = { 9003 } -- 红色
x003050_g_CollectionActId[2] = { 9002 } -- 蓝色

x003050_g_CollectionActPos = {}
x003050_g_CollectionActPos[1] = { { 236.02, 206.83, 1.57 }, { 239.09, 230.8, 1.57 }, { 251.42, 217.39, 1.57 }, { 165.88, 218.21, 1.57 }, { 148.39, 202.4, 1.57 } }
x003050_g_CollectionActPos[2] = { { 244.51, 92.7, 1.57 }, { 264.02, 82.71, 1.57 }, { 140.26, 67.35, 1.57 }, { 124.76, 82.18, 1.57 }, { 142.23, 96.11, 1.57 } }

--红蓝双方NPc
x003050_g_CampNpc = {}
x003050_g_CampNpc[1] = { 526030, 526040, 526020, 526010 } --红色
x003050_g_CampNpc[2] = { 526130, 526140, 526120, 526110 } -- 蓝色

x003050_g_CampNpcPos = {}
x003050_g_CampNpcPos[1] = { { 140.2, 52.61, 1.57 }, { 254.1, 51.2, 1.57 }, { 210.23, 75.26, 1.57 }, { 185.78, 74.71, 1.57 } }
x003050_g_CampNpcPos[2] = { { 243.4, 242.7, -1.22 }, { 145.9, 247.6, -1.22 }, { 190.3, 226.61, -1.22 }, { 209.86, 225.42, -1.22 } }

--阵营伤害排行榜采集
x003050_g_CampVictoryTreasureId = {}
x003050_g_CampVictoryTreasureId[1] = { 9010 }
x003050_g_CampVictoryTreasureId[2] = { 9011 }
x003050_g_CampVictoryTreasureId[3] = { 9012 }

x003050_g_CampVictoryTreasurePos = {}
x003050_g_CampVictoryTreasurePos[1] = { { 198.52, 149.11, 1.57 } }
x003050_g_CampVictoryTreasurePos[2] = { { 203.45, 160.22, 0.88 }, { 210.63, 147.8, -4.06 }, { 206.65, 141.72, -1.83 }, { 199.77, 137.94, -3.91 }, { 188.11, 143.7, -4.16 }, { 186.65, 151.62, -3.65 }, { 191.3, 158.11, 0.84 }, { 193.02, 139.53, -2.23 }, { 196.44, 160.34, -3.97 }, { 192.53, 152.08, 0.49 }, { 193.74, 144.44, 1.08 }, { 201.12, 143.64, -0.54 }, { 204.98, 151.68, 0.77 }, { 200.21, 156.1, -3.6 } }
x003050_g_CampVictoryTreasurePos[3] = { { 221.12, 140.95, -4.35 }, { 203.6, 190.7, -3.77 }, { 218.03, 135.23, -3.08 }, { 210.62, 128.55, -3.84 }, { 205.27, 122.73, -3.44 }, { 200.12, 119.58, -4.35 }, { 191.92, 124.45, -3.55 }, { 184.92, 127.85, -3.15 }, { 182, 135.1, -4.35 }, { 175.2, 140.6, -3.34 }, { 177.3, 149.6, -2.97 }, { 175.3, 159.7, -2.29 }, { 181.8, 166.2, -4.35 }, { 187.7, 173.6, -3.06 }, { 197.6, 177.7, -3.66 }, { 204.8, 175.1, -4.35 }, { 211.4, 167.3, -3.3 }, { 218.8, 166, -4.35 }, { 219.4, 158.3, -4.35 }, { 225, 150.9, -3.01 }, { 238.41, 146.33, -4.35 }, { 238.41, 154.2, 0.37 }, { 234.2, 161.3, -3.28 }, { 228.4, 163.7, -4.35 }, { 227.9, 172, -4.35 }, { 220.8, 175.8, 1.39 }, { 215.1, 183.4, -4.35 }, { 210.3, 181.7, 0.69 }, { 166.5, 161.8, -3.17 }, { 193, 192.11, -4.35 }, { 187.5, 186, -4.35 }, { 184.6, 180.3, -4.35 }, { 176.7, 179.8, 1.02 }, { 173.1, 172, -4.35 }, { 164.2, 165.6, -4.35 }, { 174.4, 122.5, -3.98 }, { 158.6, 154.3, 0.42 }, { 159.2, 146.5, -4.35 }, { 163.9, 138, -4.05 }, { 168.2, 130.9, 0.12 }, { 173.3, 127.4, -4.35 }, { 212.4, 115, -3.83 }, { 179.75, 116.9, 0.84 }, { 186.6, 118.2, -4.35 }, { 190.9, 112, -4.35 }, { 203.7, 106.7, -3.57 }, { 207.8, 112.1, -4.35 }, { 229.65, 135.38, 1.26 }, { 214.9, 120.3, -0.08 }, { 224.1, 121.5, 0.12 }, { 226, 129, -4.35 }, { 233.5, 133.6, 0.94 }, { 236.1, 141.2, -4.35 } }

--Boss血量百分比触发逻辑
x003050_g_BossTriggerPercenHp = { }
x003050_g_BossTriggerPercenHp[1] = { 90, 80, 70, 60, 50, 40, 30, 20, 10 } --到达百分之多少血量触发
x003050_g_BossTriggerPercenHp[2] = { 1, 2, 3, 1, 2, 3, 1, 2, 3 } -- 触发类型 1掉落包 2刷新小怪 3 触发技能
x003050_g_BossTriggerPercenHp[3] = { 440031, -1, 35200201, 440031, -1, 35200201, 440031, -1, 35200201 } -- 对应的配表ID

--Boss喊话
x003050_g_BossTips = {}
x003050_g_BossTips[1] = { 101004, 27, 526000 } -- (StrDicId, FakeObjId,RoleBaseId)
x003050_g_BossTips[2] = { 101004, 27, 526000 } -- (StrDicId, FakeObjId,RoleBaseId)
x003050_g_BossTips[3] = { 101004, 27, 526000 } -- (StrDicId, FakeObjId,RoleBaseId)
x003050_g_BossTips[4] = { 101004, 27, 526000 } -- (StrDicId, FakeObjId,RoleBaseId)
x003050_g_BossTips[5] = { 101004, 27, 526000 } -- (StrDicId, FakeObjId,RoleBaseId)
x003050_g_BossTips[6] = { 101004, 27, 526000 } -- (StrDicId, FakeObjId,RoleBaseId)
x003050_g_BossTips[7] = { 101004, 27, 526000 } -- (StrDicId, FakeObjId,RoleBaseId)
x003050_g_BossTips[8] = { 101004, 27, 526000 } -- (StrDicId, FakeObjId,RoleBaseId)
x003050_g_BossTips[9] = { 101004, 27, 526000 } -- (StrDicId, FakeObjId,RoleBaseId)


x003050_g_CampVictoryTreasureTime = 300000 -- 宝箱归属时间

x003050_g_CollectionType = 12 -- 活动结束删除采集类型

x003050_g_DropRange = 20 -- boss掉落范围

x003050_g_SceneState = 0
x003050_g_BigBossObjId = 1
x003050_g_NormalBossMaxCount = 2
x003050_g_RedKillNormalBossCount = 3
x003050_g_BlueKillNormalBossCount = 4
x003050_g_TriggerPercenHp = 5 -- Boss血量百分比触发逻辑下标


x003050_g_BroadCastId = {}  --广播id
x003050_g_BroadCastId[1] = 5306 -- 采集活动开启
x003050_g_BroadCastId[2] = 5307 -- 采集活动结束
x003050_g_BroadCastId[3] = 5300 -- boss活动开启
x003050_g_BroadCastId[4] = 5302 -- Boss 已被击杀
x003050_g_BroadCastId[5] = 5301 -- Boss 未被击杀
x003050_g_BroadCastId[6] = 5303 -- 被守卫杀死时
x003050_g_BroadCastId[7] = 5304 -- 守卫血量降低至50%/30%时
x003050_g_BroadCastId[8] = 5305 -- 守卫被击杀时

--场景采集任务提交NPC
x003050_g_SceneNpcId = { 526002, 526003 }
x003050_g_SceneNpcPos = { { 184.0, 50.27, 0.1 }, { 209.32, 249.05, 3.22 } }

--npc被动技能
x003050_g_NpcPassiveSkillId = 100005

function x003050_OnRefreshCollection(scene)

    for i = 1, #x003050_g_CollectionPos do
        SetSceneBuff(scene, x003050_g_CollectionId, x003050_g_CollectionPos[i][1], x003050_g_CollectionPos[i][2], x003050_g_CollectionPos[i][3])
    end

    for i = 1, #x003050_g_SceneNpcId do
        CreateMonster(scene, x003050_g_SceneNpcId[i], x003050_g_SceneNpcPos[i][3], x003050_g_SceneNpcPos[i][1], x003050_g_SceneNpcPos[i][2])
    end
end


--刷新NPC
function x003050_OnRefreshCampNpc(scene)

    UpdateBattlefieldCampNpc(3, 0, 0)

    for i = 1, #x003050_g_CampNpc do
        for j = 1, #x003050_g_CampNpc[i] do
            local objId = CreateBattlefieldCampNpc(scene, x003050_g_CampNpc[i][j], x003050_g_CampNpcPos[i][j][3],
                    x003050_g_CampNpcPos[i][j][1], x003050_g_CampNpcPos[i][j][2], i, x003050_g_NpcPassiveSkillId)

            SetObjCaredHpPercent(scene, objId, x003050_g_scriptId, 90)

        end
    end

    CreateSubMonster(scene, x003050_g_BigBossPos[3], x003050_g_BigBossPos[1], x003050_g_BigBossPos[2])
end

function x003050_OnActivityStart(scene, curTime, idx)

    if IsWorldServer(scene) then
        local param = GetActivityParam(scene, idx)

        if param == 1 or param == 2 then
            x003050_CollectionActivity(scene, param == 1)
        elseif param == 3 or param == 4 then
            x003050_BossActivity(scene, param == 3)
        end
    end
end

--采集活动开始或者关闭
function x003050_CollectionActivity(scene, IsStart)
    if IsStart then
        --
        GongChengSystemBroadCast(x003050_g_BroadCastId[1])

        for i = 1, #x003050_g_CollectionActPos do
            for j = 1, #x003050_g_CollectionActPos[i] do
                SetSceneBuffAndBattleCamp(scene, x003050_g_CollectionActId[i][1], x003050_g_CollectionActPos[i][j][1],
                        x003050_g_CollectionActPos[i][j][2], x003050_g_CollectionActPos[i][j][3], i)
            end
        end
    else
        --活动结束
        GongChengSystemBroadCast(x003050_g_BroadCastId[2])
        DeleteSceneBuff(scene, x003050_g_CollectionType)
    end
end

-- boss活动开启或者关闭
function x003050_BossActivity(scene, IsStart)
    if IsStart then
        GongChengSystemBroadCast(x003050_g_BroadCastId[3])
        -- 活动开始
        BattlefieActivityStart(scene)
        local objId = CreateBattlefieBoss(scene, 1, x003050_g_BigBossId, x003050_g_BigBossPos[3], x003050_g_BigBossPos[1], x003050_g_BigBossPos[2])

        SetGongChengParam(scene, x003050_g_BigBossObjId, objId)
        SetGongChengParam(scene, x003050_g_NormalBossMaxCount, #x003050_g_NormalBossPos)

        for i = 1, #x003050_g_NormalBossPos do
            CreateBattlefieBoss(scene, 2, x003050_g_NormalBossId, x003050_g_NormalBossPos[i][3],
                    x003050_g_NormalBossPos[i][1], x003050_g_NormalBossPos[i][2])
        end
    else
        --活动结束
        if IsAlive(scene, GetGongChengParam(scene, x003050_g_BigBossObjId)) then
            GongChengSystemBroadCast(x003050_g_BroadCastId[5])
        end

        DeleRespawnMonsterByRoleId(scene, x003050_g_NormalBossId)
        EndBattlefieActivity(scene, x003050_g_BigBossId, false)
    end
end

function x003050_OnActivityTick(scene, tickCount)

    local percenHp = SetBattleBossHp(scene, GetGongChengParam(scene, x003050_g_BigBossObjId), x003050_g_DropRange)

    if percenHp == -1 then
        return
    end

    local percenHpIndex = GetGongChengParam(scene, x003050_g_TriggerPercenHp) + 1

    if percenHpIndex <= #x003050_g_BossTriggerPercenHp[1] then

        if percenHp <= x003050_g_BossTriggerPercenHp[1][percenHpIndex] then

            -- BroadCastBossTips(scene, x003050_g_BossTips[percenHpIndex][2], x003050_g_BossTips[percenHpIndex][1], x003050_g_BossTips[percenHpIndex][3])

            SetGongChengParam(scene, x003050_g_TriggerPercenHp, percenHpIndex)

            x003050_BossTriggerPercenHp(scene, percenHpIndex)
        end
    end
end

function x003050_BossTriggerPercenHp(scene, percenHpIndex)

    local type = x003050_g_BossTriggerPercenHp[2][percenHpIndex]

    local finalEffect = x003050_g_BossTriggerPercenHp[3][percenHpIndex]

    if type == 1 then
        -- 给boss附近人掉落物品
        BossTriggerPercenHpDrop(scene, GetGongChengParam(scene, x003050_g_BigBossObjId), x003050_g_DropRange, finalEffect)

    elseif type == 2 then
        -- 复活小boss
        local RespawnCount = RespawnMonsterByRoleId(scene, x003050_g_NormalBossId)

        if RespawnCount > 0 then
            SetGongChengParam(scene, x003050_g_NormalBossMaxCount, GetGongChengParam(scene, x003050_g_NormalBossMaxCount) + RespawnCount)
        end

    elseif type == 3 then
        -- 给boss 发送送一个impact
        SendImpactToUnit(scene, GetGongChengParam(scene, x003050_g_BigBossObjId), finalEffect)
    end
end

function x003050_OnObjDie(scene, objId, rolebaseId, killerId)

    if rolebaseId <= 10 then

        local roleIBaseId = GetRoleBaseId(scene, killerId)

        for i = 1, #x003050_g_CampNpc do
            for j = 1, #x003050_g_CampNpc[i] do
                if roleIBaseId == x003050_g_CampNpc[i][j] then
                    SendSystemBroadCastBattleNpc(scene, 1, objId, i, x003050_g_BroadCastId[6], roleIBaseId)
                    break
                end
            end
        end
    end

    for i = 1, #x003050_g_CampNpc do
        for j = 1, #x003050_g_CampNpc[i] do

            if rolebaseId == x003050_g_CampNpc[i][j] then
                SendSystemBroadCastBattleNpc(scene, 3, i, rolebaseId, x003050_g_BroadCastId[8], rolebaseId)
                UpdateBattlefieldCampNpc(2, rolebaseId, i)
                break
            end
        end
    end

    if rolebaseId == x003050_g_BigBossId then

        GongChengSystemBroadCast(x003050_g_BroadCastId[4])

        local camp = GetDamageHighestCamp(scene)

        for i = 1, #x003050_g_CampVictoryTreasurePos do
            for j = 1, #x003050_g_CampVictoryTreasurePos[i] do
                SetSceneBuffAndBattleCamp(scene, x003050_g_CampVictoryTreasureId[i][1], x003050_g_CampVictoryTreasurePos[i][j][1],
                        x003050_g_CampVictoryTreasurePos[i][j][2], x003050_g_CampVictoryTreasurePos[i][j][3], camp, x003050_g_CampVictoryTreasureTime)
            end
        end

        EndBattlefieActivity(scene, x003050_g_BigBossId, true)
    end

    if rolebaseId == x003050_g_NormalBossId then

        local camp = GetObjBattleCamp(scene, killerId)

        if camp == 1 then
            SetGongChengParam(scene, x003050_g_RedKillNormalBossCount, GetGongChengParam(scene, x003050_g_RedKillNormalBossCount) + 1)
        elseif camp == 2 then
            SetGongChengParam(scene, x003050_g_BlueKillNormalBossCount, GetGongChengParam(scene, x003050_g_BlueKillNormalBossCount) + 1)
        end

        KillNormalBossReward(scene, killerId, objId, 440031)
    end
end

function x003050_OnObjEnter(scene, objId)
    SelectBattleCamp(scene, objId, GetGongChengParam(scene, x003050_g_BigBossObjId))

end

function x003050_OnObjReconnect(scene, objId)
    SelectBattleCamp(scene, objId, GetGongChengParam(scene, x003050_g_BigBossObjId))
    BattleCampChangePkModel(scene, objId)
end

function x003050_OnCaredHpPercent(scene, objId, hpPercent, attackerId)

    if hpPercent == 60 or hpPercent == 40 then
        SendSystemBroadCastBattleNpc(scene, 2, objId, attackerId, x003050_g_BroadCastId[7], 0)
    end

    SetObjCaredHpPercent(scene, objId, x003050_g_scriptId, hpPercent - 10)
end