x003039_g_scriptId = 003039

x003039_g_BigTreasureBox = {6021, 6023}
x003039_g_SmallTreasureBox = {6022, 6024}

x003039_g_BigTreasureBoxCount = 6
x003039_g_BigTreasureBoxPos = 5001

x003039_g_SmallTreasureBoxCount = 18
x003039_g_SmallTreasureBoxPos = 5002

x003039_g_JingYingMonsterId = {}
x003039_g_JingYingMonsterId[1] = {981002, 981003, 981004, 981005, 981006, 981007, 981008, 981009}
x003039_g_JingYingMonsterId[2] = {981019, 981020, 981021, 981022, 981023, 981024, 981025, 981026}

x003039_g_JingYingMonsterCount = {3, 3, 3, 3, 3, 3, 3, 3}
x003039_g_JingYingMonsterPos = {5004, 5005, 5006, 5007, 5008, 5009, 5010, 5011}
x003039_g_JingYingDir = 0

x003039_g_RandomBossId = {981010, 981027}
x003039_g_RandomBossPos = 5003
x003039_g_RandomBossMinCount = 2
x003039_g_RandomBossMaxCount = 3
x003039_g_RandomBossTotalCount = 15

x003039_g_TreasueBoxDir = 0
x003039_g_BossDir = 0
x003039_g_BigTreasueBoxRate = 3000

x003039_g_HpRecoverImpact = 600100

x003039_g_SceneId = {118, 119}

function x003039_OnSceneInit(scene)
	x003039_RefreshTreasureBox(scene)
	x003039_RefreshJingYing(scene)
	x003039_RefreshBoss(scene, x003039_g_HpRecoverImpact)
end

function x003039_OnActivityStart(scene, curTime, idx)
	-- body
	x003039_RefreshTreasureBox(scene)
	x003039_RefreshJingYing(scene)
	x003039_RefreshBoss(scene, x003039_g_HpRecoverImpact)
end

function x003039_OnUpdateTreasureBox(scene)
	UpdateTreasureBox(scene, GetId(x003039_g_BigTreasureBox, scene), GetId(x003039_g_SmallTreasureBox, scene), x003039_g_BigTreasureBoxCount + x003039_g_SmallTreasureBoxCount,x003039_g_BigTreasueBoxRate,x003039_g_BigTreasureBoxPos,x003039_g_SmallTreasureBoxPos,x003039_g_TreasueBoxDir)

	local count = GetRandomBossCount(scene);
	if count > 0 then
		SetRandomBossCount(scene, 0)
		CreateRandomBoss(scene, GetId(x003039_g_RandomBossId, scene), x003039_g_RandomBossPos, count, count, x003039_g_RandomBossTotalCount, x003039_g_BossDir)
	end
end

function x003039_RefreshTreasureBox(scene)
	RefreshTreasureBox(scene, GetId(x003039_g_BigTreasureBox, scene), x003039_g_BigTreasureBoxCount, GetId(x003039_g_SmallTreasureBox, scene), x003039_g_SmallTreasureBoxCount, x003039_g_BigTreasureBoxPos, x003039_g_SmallTreasureBoxPos, x003039_g_TreasueBoxDir)
end

function x003039_RefreshJingYing(scene)
	local count = 0
	local list = GetId(x003039_g_JingYingMonsterId, scene)
	for i=1,#list do
		RefreshPiaoMiaoJingYing(scene, list[i], x003039_g_JingYingMonsterCount[i], x003039_g_JingYingMonsterPos[i], x003039_g_JingYingDir)
		count = count + x003039_g_JingYingMonsterCount[i]
	end
	RefreshWorldBossCount(scene, list[1], count)
end

function x003039_RefreshBoss(scene, impactId)
	RefreshPiaoMiaoBoss(scene, impactId)
end

function x003039_OnCreateRandomBoss(scene, rolebaseId, isBoss)
	if not isBoss then
		return
	end

	if rolebaseId == GetId(x003039_g_RandomBossId, scene) then
		return
	end

	local count = GetAliveByRoleBaseNum(scene, GetId(x003039_g_RandomBossId, scene))
	if count >= x003039_g_RandomBossTotalCount then
		return
	end

	local can = GetCanCreateRandomBoss(scene)
	if can then
		CreateRandomBoss(scene, GetId(x003039_g_RandomBossId, scene), x003039_g_RandomBossPos, x003039_g_RandomBossMinCount, x003039_g_RandomBossMaxCount, x003039_g_RandomBossTotalCount, x003039_g_BossDir)
		SetCreateRandomBoss(scene, false)
	else
		SetCreateRandomBoss(scene, true)
	end

end

function GetId(param, scene)
	local sceneId = GetSceneId(scene)
	local index = 1
	for i=1,#x003039_g_SceneId do
		if x003039_g_SceneId[i] == sceneId then
			index = i
			break
		end
	end

	return param[index]
end