x003046_g_scriptId=003046

x003046_g_GroupPointId={} -- 采集点ID(Tab_GroupPoint)
x003046_g_GroupPointId[1]={6008,6009,6010}

x003046_g_GroupPointPos={} -- 采集点坐标(x,z,face)
x003046_g_GroupPointPos[1]={{182,248,0},{190,248,0},{198,230,0},{197,233,0},{209,231,0},{199,224,0},{191,216,0},{184,207,0},{183,219,0},{174,221,0},
{165,232,0},{179,238,0},{174,240,0},{175,245,0},{188,115,0},{186,230,0},{184,219,0},{186,219,0},{175,226,0},{191,240,0},
{187,173,0},{181,166,0},{170,151,0},{190,165,0},{178,151,0},{197,154,0},{187,146,0},{199,142,0},{167,139,0},{180,137,0},
{192,136,0},{200,126,0},{172,124,0},{211,138,0},{220,139,0},{246,139,0},{251,151,0},{261,151,0},{274,150,0},{271,140,0},
{269,133,0},{259,127,0},{249,129,0},{261,137,0},{253,129,0},{265,145,0},{254,142,0},{263,177,0},{267,184,0},{279,194,0},
{281,200,0},{287,205,0},{281,214,0},{258,232,0},{185,193,0},{287,221,0},{295,223,0},{290,232,0},{277,231,0},{229,231,0}}

x003046_g_ExpPos={} -- 经验奖励区域(矩形)
x003046_g_ExpPos[1]={{154,5.75,124},{299,5.75,124},{299,5.75,253},{154,5.75,253}} -- (x,y,z)

x003046_g_FlushTime=45 -- 每一波刷新的时间间隔(秒)
x003046_g_ExpFreq=10 --  -- 经验奖励频率(秒)

x003046_g_HintTime={} -- 炼气提示出现时间(秒)
x003046_g_HintTime[1]={300,600}

x003046_g_BroadCastId = {}  -- 势力炼气系统公告
x003046_g_BroadCastId[1] = 1474

x003046_g_HighMaxNum=5   -- 高级炼气数量
x003046_g_MiddMaxNum=10	 -- 中级炼气数量
x003046_g_LowMaxNum=15 	 -- 低级炼气数量

-- GuildSceneParam

--活动开始
function x003046_OnActivityStart(scene,curTime,idx)

	-- 初始化
	SetGuildActivity(scene,5,x003046_g_scriptId)
	
	-- 发送活动信息
	SendChannalMessage(scene,3,10300)
	
	local countExpPos = #x003046_g_ExpPos[1]
	for i = 1, countExpPos do
		SetGuildDinnerExpArea(scene,x003046_g_ExpPos[1][i][1],x003046_g_ExpPos[1][i][2],x003046_g_ExpPos[1][i][3])
	end
	BroadCastGuildGasRefiningState(scene, 1)
end

function x003046_OnActivityTick(scene,ticks)
	if (ticks % x003046_g_FlushTime == 0) then
		SendRefreshGuideCollection(scene)
		RemoveSceneAllBuff(scene)
		x003046_CreateRandomGasRefiningPoins(scene)
	end	
	if (ticks % x003046_g_ExpFreq == 0) and (GetGuildActivity(scene,5)) then
		local countUser = GetSceneUserCount(scene)
		for i = 0, countUser - 1 do		
			local ObjId = GetUserObjIdByIdx(scene,i)
			GainGuildGasingExp(scene,ObjId)
		end
	end
	-- local countHint = #x003046_g_HintTime[1]
	-- for i = 1, countHint do
	-- 	if (ticks == x003046_g_HintTime[1][i]) then
	-- 		SendChannalMessage(scene, 3, 10274)
	-- 	end
	-- end
end

function x003046_CreateRandomGasRefiningPoins(scene)

	local high = math_randomEx(1, #x003046_g_GroupPointPos[1], x003046_g_HighMaxNum + x003046_g_MiddMaxNum + x003046_g_LowMaxNum)
	-- local mid  = math_randomEx(1, #x003046_g_GroupPointPos[2], x003046_g_MiddMaxNum)
	-- local low  = math_randomEx(1, #x003046_g_GroupPointPos[3], x003046_g_LowMaxNum)

	for i = 1, x003046_g_HighMaxNum do	
		CreateGroupPoint(scene,x003046_g_GroupPointId[1][1],x003046_g_GroupPointPos[1][high[i]][1],x003046_g_GroupPointPos[1][high[i]][2],x003046_g_GroupPointPos[1][high[i]][3])
	end
	for i = x003046_g_HighMaxNum+1, x003046_g_MiddMaxNum+x003046_g_HighMaxNum do
		CreateGroupPoint(scene,x003046_g_GroupPointId[1][2],x003046_g_GroupPointPos[1][high[i]][1],x003046_g_GroupPointPos[1][high[i]][2],x003046_g_GroupPointPos[1][high[i]][3])
	end
	for i = x003046_g_MiddMaxNum+x003046_g_HighMaxNum+1, x003046_g_LowMaxNum+x003046_g_MiddMaxNum+x003046_g_HighMaxNum do
		CreateGroupPoint(scene,x003046_g_GroupPointId[1][3],x003046_g_GroupPointPos[1][high[i]][1],x003046_g_GroupPointPos[1][high[i]][2],x003046_g_GroupPointPos[1][high[i]][3])
	end
end


function table_fillNum(m,n)
    local j,k
    if n then
       j=m
       k=n
    else
        j=1
        k=m
    end
    local t={}
    for i=j,k do
        table.insert(t,i)
    end
    return t
end

function math_randomEx(m,n,cnt) 
    local tmp=table_fillNum(m,n)
    if cnt>n-m+1 then
        return tmp
    end
    local x=0
    local t={}math.randomseed(os.time())
    while  cnt>0 do
       x=math.random(1,n-m+1) 
       table.insert(t,tmp[x])
       table.remove(tmp,x)
       cnt=cnt-1
       m=m+1
      
    end
    return t
end