x003016_g_scriptId=003016

x003016_g_GroupPointId={} -- 采集点ID(Tab_GroupPoint)
x003016_g_GroupPointId[1]={251,252,253}

x003016_g_GroupPointPos={} -- 采集点坐标(x,z,face)
x003016_g_GroupPointPos[1]={{62.8,129.2,0},{54.3,139.3,0},{62.8,149.2,0}}

x003016_g_ExpPos={} -- 经验奖励区域(矩形)
x003016_g_ExpPos[1]={{336,13.92865,376},{3.54,13.92865,376},{3.54,13.92865,1.8},{336,77.16,1.8}} -- (x,y,z)

x003016_g_ExpFreq=10 -- 经验奖励频率(秒)

x003016_g_TreasureBoxId={} -- 宝箱ID(Tab_GroupPoint)
x003016_g_TreasureBoxId[1]={371,372,373}
x003016_g_TreasureBoxNum=20 -- 宝箱数量

x003016_g_FirstQuestionTime=60 -- 第一题出现的时间(秒)
x003016_g_NextQuestionTime=20 -- 答对后下一题出现的时间(秒)

x003016_g_HintTime={} -- 晚宴提示出现时间(秒)
x003016_g_HintTime[1]={300,600}

-- GuildSceneParam

--活动开始
function x003016_OnActivityStart(scene,curTime,idx)

	-- 初始化
	SetGuildActivity(scene,0,x003016_g_scriptId)
	
	-- 发送活动信息
	SendChannalMessage(scene,3,10261)
	
	-- 设置挂机经验区域
	local countExpPos = #x003016_g_ExpPos[1]
	for i = 1, countExpPos do
		SetGuildDinnerExpArea(scene,x003016_g_ExpPos[1][i][1],x003016_g_ExpPos[1][i][2],x003016_g_ExpPos[1][i][3])
	end
	
	-- 生成采集点
	local countGroupPoint = #x003016_g_GroupPointId[1]
	for i = 1, countGroupPoint do
		CreateGroupPoint(scene,x003016_g_GroupPointId[1][i],x003016_g_GroupPointPos[1][i][1],x003016_g_GroupPointPos[1][i][2],x003016_g_GroupPointPos[1][i][3])
	end
end

function x003016_OnActivityTick(scene,ticks)
	if (ticks == x003016_g_FirstQuestionTime) then
		-- 生成题目
		BroadcastDinnerQuestion(scene)
	end
	
	local countHint = #x003016_g_HintTime[1]
	for i = 1, countHint do
		if (ticks == x003016_g_HintTime[1][i]) then
			SendChannalMessage(scene, 3, 10274)
		end
	end
	
	if (ticks % x003016_g_ExpFreq == 0) and (GetGuildActivity(scene,0)) then
		local countUser = GetSceneUserCount(scene)
		for i = 0, countUser - 1 do		
			local ObjId = GetUserObjIdByIdx(scene,i)
			GainGuildDinnerExp(scene,ObjId)
		end
	end
end


