x003013_g_scriptId = 003013

x003013_g_ActivityId = 2

x003013_g_ReadyGetExpTime = 10       --获得经验间隔
x003013_g_WaitTickCount = 120        --等待时间（单位秒）

x003013_g_State = 0
x003013_g_MonsterState = 1
x003013_g_Point = 2
x003013_g_LastTick = 3
x003013_g_SpecialMonster = 4
x003013_g_BossTick = 5
x003013_g_HitStartTime = 6
x003013_g_FlagFireMask = 7
x003013_g_Level = 8
x003013_g_SpecialTipTime = 9
x003013_g_ExpAddRate = 10
x003013_g_KillCount = 11
x003013_g_MonsterTime = 12
x003013_g_IsCheckBegin = 13

x003013_g_MonsterRefreshTime = 5   --一波中刷怪的间隔

x003013_g_ReadyToStartTips = 10401  --势力防守战准备公告
x003013_g_BeforeStartTips = 10402   --势力防守战倒计时公告
x003013_g_StartTips = 10403         --势力防守战开启公告

x003013_g_StateTips = 10408

--大本营和两个守护
x003013_g_BaseFlagRoleBase = {} 
x003013_g_BaseFlagRoleBase[1] = {224001, 224100}
x003013_g_BaseFlagRoleBase[2] = {225001, 225100}
x003013_g_BaseFlagRoleBase[3] = {225001, 225100}

x003013_g_BaseFlagId = {226027, 226025, 226026}

x003013_g_BaseFlagPos = {}
x003013_g_BaseFlagPos[1] = {185.96,323.13,-1.57}  --(x,z,f)
x003013_g_BaseFlagPos[2] = {193.02,245.56,-1.57}  --(x,z,f)
x003013_g_BaseFlagPos[3] = {178.59,245.51,-1.57}  --(x,z,f)

--小怪(rolebaseId)
x003013_g_MonsterRoleBase = {220001, 220100}
--小怪(CharModelId)
x003013_g_MonsterId = {} 
x003013_g_MonsterId[1] = {{226001, 4}, {226001, 5}} -- 第一波(第一小波, 第二小波)
x003013_g_MonsterId[2] = {{226002, 4}, {226002, 5}} -- 第二波(第一小波, 第二小波)
x003013_g_MonsterId[3] = {{226003, 4}, {226003, 5}} -- 第三波(第一小波, 第二小波)
x003013_g_MonsterId[4] = {{226004, 4}, {226004, 5}} -- 第四波(第一小波, 第二小波)
x003013_g_MonsterId[5] = {{226005, 4}, {226005, 5}} -- 第五波(第一小波, 第二小波)
x003013_g_MonsterId[6] = {{226006, 4}, {226006, 5}} -- 第六波(第一小波, 第二小波)
x003013_g_MonsterId[7] = {{226007, 4}, {226007, 5}} -- 第七波(第一小波, 第二小波)
x003013_g_MonsterId[8] = {{226008, 4}, {226008, 5}} -- 第八波(第一小波, 第二小波)

--精英(rolebaseId)
x003013_g_JingYingRoleBase = {221001, 221100}
--精英(CharModelId)
x003013_g_JingYingId = {} 
x003013_g_JingYingId[1] = {226009, 1} -- 第一波
x003013_g_JingYingId[2] = {226010, 1} -- 第二波
x003013_g_JingYingId[3] = {226011, 1} -- 第三波
x003013_g_JingYingId[4] = {226012, 1} -- 第四波
x003013_g_JingYingId[5] = {226013, 1} -- 第五波
x003013_g_JingYingId[6] = {226014, 1} -- 第六波
x003013_g_JingYingId[7] = {226015, 1} -- 第七波
x003013_g_JingYingId[8] = {226016, 1} -- 第八波

x003013_g_MonsterPosition = {}  -- 小怪位置(x,z,f)
x003013_g_MonsterPosition[1] = {{127.21,232.19,0},{124.77,236.9,0},{124.73,233.88,0},{124.73,230.51,0},{124.73,227.04,0},{123.15,236.9,0},{123.15,233.87,0},{123.15,230.54,0},{123.15,226.97,0},{121,235.54,0},{121,232.16,0},{121,228.71,0}}
x003013_g_MonsterPosition[2] = {{185.43,163.27,1.57},{179.09,160.02,1.57},{182.95,160.02,1.57},{187.51,160.02,1.57},{191.33,160.02,1.57},{179.09,157.14,1.57},{183.04,157.14,1.57},{187.41,157.14,1.57},{191.03,157.14,1.57},{180.94,154.92,1.57},{185.23,154.92,1.57},{189.03,154.92,1.57}}
x003013_g_MonsterPosition[3] = {{239.41,231.53,-3.14},{241,229.14,-3.14},{240.95,233.92,-3.14},{242.71,231.55,-3.14},{244.77,229.35,-3.14},{244.64,233.83,-3.14},{247.58,229.35,-3.14},{247.52,233.83,-3.14},{246.35,231.55,-3.14},{250.23,229.35,-3.14},{250.23,231.48,-3.14},{250.23,233.9,-3.14}}

x003013_g_MonsterPatrolPath = {}   --小怪巡逻路径
x003013_g_MonsterPatrolPath[1]= 501
x003013_g_MonsterPatrolPath[2]= 511
x003013_g_MonsterPatrolPath[3]= 521

 --BossRoleBaseId
x003013_g_BossRoleBase = {223001, 223100}
 --BossCharModelId
x003013_g_BossId = {}
x003013_g_BossId[1] = 226017
x003013_g_BossId[2] = 226018
x003013_g_BossId[3] = 226019
x003013_g_BossId[4] = 226020
x003013_g_BossId[5] = 226021
x003013_g_BossId[6] = 226022
x003013_g_BossId[7] = 226023
x003013_g_BossId[8] = 226024

x003013_g_BossPosition = {} --Boss位置
x003013_g_BossPosition[1] = {186.39, 214.49, 1.57}     -- (x, y, f)
x003013_g_BossPosition[2] = {186.39, 214.49, 1.57} 
x003013_g_BossPosition[3] = {186.39, 214.49, 1.57} 
x003013_g_BossPosition[4] = {186.39, 214.49, 1.57} 
x003013_g_BossPosition[5] = {186.39, 214.49, 1.57}
x003013_g_BossPosition[6] = {186.39, 214.49, 1.57}
x003013_g_BossPosition[7] = {186.39, 214.49, 1.57}
x003013_g_BossPosition[8] = {186.39, 214.49, 1.57}

x003013_g_MonsterYuanShenExp = 8    --小怪经验
x003013_g_JingYingYuanShenExp = 9
x003013_g_SpecialMonsterYuanShenExp = 10
x003013_g_BossYuanShenExp = 11

--Boss巡逻路径
x003013_g_BossPatrolPath = 514

--Boss出生时间
x003013_g_BossTime = 15

x003013_g_BossTips = {}
x003013_g_BossTips[1] = {10409, 60501} -- (StrDicId, FakeObjId)
x003013_g_BossTips[2] = {10410, 60502}
x003013_g_BossTips[3] = {10411, 60503}
x003013_g_BossTips[4] = {10412, 60504}
x003013_g_BossTips[5] = {10413, 60505}
x003013_g_BossTips[6] = {10430, 60506}
x003013_g_BossTips[7] = {10431, 60507}
x003013_g_BossTips[8] = {10432, 60508}

x003013_g_HitTipsTime = 5
x003013_g_HitTips = 10414

x003013_g_FlagFireEffectId = 600014

x003013_g_MonsterStartGroupPoint = 4600 --小怪出生点传送门
x003013_g_GroupPointPosition = {}  -- 小怪位置(x,z,f)
x003013_g_GroupPointPosition[1] = {70, 89, 0}
x003013_g_GroupPointPosition[2] = {113, 38, 0}
x003013_g_GroupPointPosition[3] = {169, 79, 0}


x003013_g_MonsterBornTime = 180  --每波怪出生间隔（单位秒）

--空降精英RoleBaseId
x003013_g_SpecialMonsterRoleBase = {222001, 222100}

--空降精英CharModelId
x003013_g_SpecialMonsterId = {{226028, 2}, {226028, 2}}   --(id1, num)

x003013_g_SpecialMonsterPosition = {}   --空降精英位置
x003013_g_SpecialMonsterPosition[1] = {{145.66, 335.37, 0}, {145.64, 337.22, 0}}
x003013_g_SpecialMonsterPosition[2] = {{228.13, 335.09, 3.14}, {228.2, 337.57, 3.14}}

x003013_g_SpecialMonsterPatrolPath = {} --空降精英巡逻路径
x003013_g_SpecialMonsterPatrolPath[1]= 531
x003013_g_SpecialMonsterPatrolPath[2]= 541

--空降精英出生前Tips
x003013_g_SpecialMonsterTips = {10405, 60500} --(StrDicId, FakeObjId)

x003013_g_SpecialMonsterTime = 180
x003013_g_SpecialMonsterTipTime = 10

x003013_g_MaxPoint = 100         	--势力防守战分数
x003013_g_BaseHpPoint = 5       	--旗子血量少于50减的分数
x003013_g_MainBaseHpPoint = 10   	--主旗子血量少于50减的分数
x003013_g_BaseDiePoint = 15    	 	--旗帜被破坏减少的分数
x003013_g_TimeOutPoint = 60    	 	--时间到没打完的分数

x003013_g_PointRate = {}            --分数加成
x003013_g_PointRate[1] = {90, 50}   --(分数，加成百分比（50表示50%）)
x003013_g_PointRate[2] = {80, 30}
x003013_g_PointRate[2] = {70, 10}
x003013_g_PointRate[3] = {60, 0}

x003013_g_RewardId = -1       --奖励Id
x003013_g_MailId = 5             --背包满了邮件Id
x003013_g_WaitExp = 5
x003013_g_MonsterExp = 7	--小怪经验
x003013_g_JingYingExp = 8
x003013_g_SpecialMonsterExp = 9
x003013_g_BossExp = 10
x003013_g_Money = 35000 -- 帮贡

x003013_g_KillBossTip = 10421
x003013_g_KillWinTip = 10423
x003013_g_TimeOutWinTip = 10423
x003013_g_LoseTip = 10425
x003013_g_SceneBuffTip = 10426
x003013_g_SceneSkillTip = 10427
x003013_g_FlagFireTip = {10428, 10433, 10433}

x003013_g_ChannalGuild = 3

x003013_g_DefaultExpAddRate = 60
x003013_g_DieMinusExpRate = 30

x003013_g_MinLevel = 160

function x003013_OnActivityStart(scene, curTime, idx)
    if CanOpenGuildDefence(scene) then
        return
    end
    if GetGuildActivity(scene,x003013_g_ActivityId) then
        return
    end
    SetGuildActivity(scene, x003013_g_ActivityId, x003013_g_scriptId)
	SetGuildParam(scene, x003013_g_State, 0)
	SetGuildParam(scene, x003013_g_MonsterState, 0)
	SetGuildParam(scene, x003013_g_LastTick, 0)
	SetGuildParam(scene, x003013_g_SpecialMonster, 0)
    SetGuildParam(scene, x003013_g_SpecialTipTime, -1)
	SetGuildParam(scene, x003013_g_BossTick, 0)
	SetGuildParam(scene, x003013_g_HitStartTime, 0)
	SetGuildParam(scene, x003013_g_FlagFireMask, 0)
	SetGuildParam(scene, x003013_g_ExpAddRate, x003013_g_DefaultExpAddRate)
	SetGuildParam(scene, x003013_g_KillCount, 0)
	SetGuildParam(scene, x003013_g_MonsterTime, x003013_g_WaitTickCount)
    SetGuildParam(scene, x003013_g_IsCheckBegin, 0)
    for i = 1, #x003013_g_BaseFlagId do 
    	SetGuildFlagHp(scene, i - 1, 100)
    end
    local level = GetServerLevel(scene)
    SetGuildParam(scene, x003013_g_Level, level)
    GetGuildDefenceLevel(scene, x003013_g_scriptId)
    SetGuildParam(scene, x003013_g_Point, x003013_g_MaxPoint)
    local guid = GetGuildSceneGuildGuid(scene)
    SendChannalMessage(scene, x003013_g_ChannalGuild, x003013_g_ReadyToStartTips)
    BroadCastGuildDefenceState(scene, 1, 0, x003013_g_WaitTickCount + 1, x003013_g_MaxPoint, x003013_g_BaseFlagPos)
end

function x003013_OnGetGuildDefenceLevel(scene, level, param)
	SetGuildParam(scene, x003013_g_Level, level)
end

function x003013_OnActivityTick(scene, tickCount)
    local state = GetGuildParam(scene, x003013_g_State)
    if state == 0 then
        if (tickCount % x003013_g_ReadyGetExpTime) == 0 and tickCount <= x003013_g_WaitTickCount then
            GainExpByLevel(scene, x003013_g_WaitExp)
        end

        --local count = GetSceneUserCount(scene)
        --if count <= 0 then
        	--return
        --end

        if tickCount >= x003013_g_WaitTickCount then

            if not(CanBeginGuildDefenceBattle(scene, x003013_g_MinLevel)) then
                if GetGuildParam(scene, x003013_g_IsCheckBegin) == 0 then
                    SetGuildParam(scene, x003013_g_IsCheckBegin, 1)
                    GuildDefenceSetCheckBegin(scene, 1)
                end
                return
            end

    		local level = GetGuildParam(scene, x003013_g_Level)
            x003013_StartGuildDefence(scene, tickCount, level)
        end
    end

    if state > 0 then
    	local level = GetGuildParam(scene, x003013_g_Level)
    	x003013_TickState(scene, tickCount, level)
        x003013_TickMonster(scene, tickCount, level)
        x003013_TickSpecialEnimy(scene, tickCount, level)
        x003013_CreateBoss(scene, tickCount, level)
        x003013_UpdateHitTips(scene, tickCount, level)
        x003013_TickBaseHp(scene, level)
    end
end

function x003013_StartGuildDefence(scene, tickCount, level)
    x003013_CreateBaseFlag(scene, level)
    BroadCastTips(scene, x003013_g_StartTips)
    SetGuildParam(scene, x003013_g_SpecialMonster, tickCount + x003013_g_SpecialMonsterTime)
    SetGuildParam(scene, x003013_g_SpecialTipTime, tickCount + x003013_g_SpecialMonsterTime - x003013_g_SpecialMonsterTipTime)
    x003013_GotoNextState(scene, tickCount, level)
    BroadCastGuildDefenceSpecialTime(scene, x003013_g_SpecialMonsterTime)
    for i = 1, #x003013_g_GroupPointPosition do
    	SetSceneBuff(scene, x003013_g_MonsterStartGroupPoint, x003013_g_GroupPointPosition[i][1], x003013_g_GroupPointPosition[i][2], x003013_g_GroupPointPosition[i][3])
    end
    SetGuildParam(scene, x003013_g_IsCheckBegin, 0)
end

function x003013_TickState(scene, tickCount, level)
    local state = GetGuildParam(scene, x003013_g_State)
    local monstate = GetGuildParam(scene, x003013_g_MonsterState)
    local born = GetGuildParam(scene, x003013_g_MonsterTime)
    if state < 8 then
        if tickCount >= born then
            x003013_GotoNextState(scene, tickCount, level)
        end

        if monstate < 0 then
        	local time = GetGuildParam(scene, x003013_g_BossTick)
        	if time == 0 then 
        		if x003013_MonsterNotAlive(scene) then
        			x003013_GotoNextState(scene, tickCount, level)
        		end
        	end
        end
    else
    	if monstate < 0 then
        	local time = GetGuildParam(scene, x003013_g_BossTick)
        	if time == 0 then 
        		if x003013_MonsterNotAlive(scene) then
        			x003013_ActivityEnd(scene, 1, level)
        		end
        	end
        end
    end
end

function x003013_GotoNextState(scene, tickCount, level)
    local state = GetGuildParam(scene, x003013_g_State) + 1
    SetGuildParam(scene, x003013_g_State, state)
    SetGuildParam(scene, x003013_g_LastTick, tickCount)
    x003013_CreateMonster(scene, state, 1, level)
    SetGuildParam(scene, x003013_g_MonsterTime, tickCount + x003013_g_MonsterBornTime)
    if state > 1 then
    	BroadCastCSTipsParam(scene, x003013_g_StateTips, state)
    end

    SetGuildParam(scene, x003013_g_MonsterState, 1)
    local point = GetGuildParam(scene, x003013_g_Point)
    if state < 8 then
        BroadCastGuildDefenceState(scene, 0, state, x003013_g_MonsterBornTime + 1, point, 0)
    else
        BroadCastGuildDefenceState(scene, 0, state, -1, point, 0)
    end
end

function x003013_CreateBaseFlag(scene, level)
    for i=1,#x003013_g_BaseFlagId do
    	local rolebaseId = x003013_GetMonsterRoleBaseId(x003013_g_BaseFlagRoleBase[i], level)
        local objid = CreateMonster(scene, x003013_g_BaseFlagId[i], x003013_g_BaseFlagPos[i][3], x003013_g_BaseFlagPos[i][1], x003013_g_BaseFlagPos[i][2], level, -1, rolebaseId)
        local hp = CalculatePercenHp(scene, objid)
        SetGuildFlagHp(scene, i - 1, hp)
        BroadCastAddCareList(scene, x003013_g_BaseFlagId[i])
    end
end

function x003013_GetMonsterRoleBaseId(rolebase, level)
	local id = math.floor(level / 10) + rolebase[1]

	if id < rolebase[1] then
		id = rolebase[1]
	end

	if id > rolebase[2] then
		id = rolebase[2]
	end

	return id
end

function x003013_TickMonster(scene, tickCount, level)
    local last = GetGuildParam(scene, x003013_g_LastTick)
    if (tickCount - last) < x003013_g_MonsterRefreshTime then
        return
    end

    local monstate = GetGuildParam(scene, x003013_g_MonsterState)
    if monstate < 0 then
        return
    end

    SetGuildParam(scene, x003013_g_LastTick, tickCount)

    local state = GetGuildParam(scene, x003013_g_State)
    monstate = GetGuildParam(scene, x003013_g_MonsterState) + 1
    if monstate > #x003013_g_MonsterId[state] then
    	monstate = -1
    end

    SetGuildParam(scene, x003013_g_MonsterState, monstate)

    if monstate > 0 then
    	x003013_CreateMonster(scene, state, monstate, level)
    elseif monstate < 0 then
    	x003013_CreateJingYing(scene, state, level)
        x003013_ReadyCreateBoss(scene, tickCount)
    end
end

function x003013_CreateMonster(scene, state, monsterState, level)
    for i = 1, #x003013_g_MonsterPosition do
        for j = 1,x003013_g_MonsterId[state][monsterState][2] do
        	if j <= #x003013_g_MonsterPosition[i] then
            	local rolebaseId = x003013_GetMonsterRoleBaseId(x003013_g_MonsterRoleBase, level)
            	local objId = CreateMonster(scene, x003013_g_MonsterId[state][monsterState][1], x003013_g_MonsterPosition[i][j][3], x003013_g_MonsterPosition[i][j][1], x003013_g_MonsterPosition[i][j][2], level, -1, rolebaseId)
            	NpcStartPatrol(scene, objId, x003013_g_MonsterPatrolPath[i])
        	end
        end
    end
end

function x003013_CreateJingYing(scene, state, level)
	for i = 1, #x003013_g_MonsterPosition do
		for j = 1, x003013_g_JingYingId[i][2] do
			local rolebaseId = x003013_GetMonsterRoleBaseId(x003013_g_JingYingRoleBase, level)
			local objId = CreateMonster(scene, x003013_g_JingYingId[state][1], x003013_g_MonsterPosition[i][j][3], x003013_g_MonsterPosition[i][j][1], x003013_g_MonsterPosition[i][j][2], level, -1, rolebaseId)
			NpcStartPatrol(scene, objId, x003013_g_MonsterPatrolPath[i])
		end
	end
end

--创建空降精英
function x003013_TickSpecialEnimy(scene, tickCount, level)
    local time = GetGuildParam(scene, x003013_g_SpecialMonster)
    local tiptime = GetGuildParam(scene, x003013_g_SpecialTipTime)

    if tickCount >= tiptime and tiptime > 0 then
    	SetGuildParam(scene, x003013_g_SpecialTipTime, -1)
    	BroadCastBossTips(scene, x003013_g_SpecialMonsterTips[2], x003013_g_SpecialMonsterTips[1], x003013_g_SpecialMonsterId[1][1], x003013_g_ChannalGuild)
    end

    if tickCount < time then
        return
    end

    local state = GetGuildParam(scene, x003013_g_State)
    for i = 1, #x003013_g_SpecialMonsterPosition do
    	for j = 1, x003013_g_SpecialMonsterId[i][2] do
    		local rolebaseId = x003013_GetMonsterRoleBaseId(x003013_g_SpecialMonsterRoleBase, level)
    		local objId = CreateMonster(scene, x003013_g_SpecialMonsterId[i][1], x003013_g_SpecialMonsterPosition[i][j][3],x003013_g_SpecialMonsterPosition[i][j][1],x003013_g_SpecialMonsterPosition[i][j][2], level, -1, rolebaseId)
            NpcStartPatrol(scene, objId, x003013_g_SpecialMonsterPatrolPath[i])
    	end
    end

    SetGuildParam(scene, x003013_g_SpecialMonster, tickCount + x003013_g_SpecialMonsterTime)
    SetGuildParam(scene, x003013_g_SpecialTipTime, tickCount + x003013_g_SpecialMonsterTime - x003013_g_SpecialMonsterTipTime)
    BroadCastGuildDefenceSpecialTime(scene, x003013_g_SpecialMonsterTime)
end

--准备创建Boss
function x003013_ReadyCreateBoss(scene, tickCount)
    SetGuildParam(scene, x003013_g_BossTick, tickCount)
end

--创建Boss
function x003013_CreateBoss(scene, tickCount, level)
    local tick = GetGuildParam(scene, x003013_g_BossTick)
    if tick <= 0 or (tick + x003013_g_BossTime > tickCount) then
    	return
    end

    local state = GetGuildParam(scene, x003013_g_State)
    local rolebaseId = x003013_GetMonsterRoleBaseId(x003013_g_BossRoleBase, level)
    local objId = CreateMonster(scene, x003013_g_BossId[state], x003013_g_BossPosition[state][3], x003013_g_BossPosition[state][1], x003013_g_BossPosition[state][2], level, -1, rolebaseId)
    NpcStartPatrol(scene, objId, x003013_g_BossPatrolPath)
    BroadCastBossTips(scene, x003013_g_BossTips[state][2], x003013_g_BossTips[state][1], x003013_g_BossId[state], x003013_g_ChannalGuild)

    SetGuildParam(scene, x003013_g_BossTick, 0)
end

function x003013_UpdateHitTips(scene, tickCount, level)
    local show = 0
    local change = 0
    for i = 1, #x003013_g_BaseFlagId do
        local curHp = math.floor(CalculatePercenHpByRBId(scene, x003013_g_BaseFlagId[i]))
        local oldHp = GetGuildFlagHp(scene, i - 1)
        if curHp < oldHp then
        	if i == 1 then
            	show = 1
        	end
        	change = 1
        end
        SetGuildFlagHp(scene, i - 1, curHp)
    end

    if show == 1 then
        local time = GetGuildParam(scene, x003013_g_HitStartTime)
        if time <= 0 or time + x003013_g_HitTipsTime <= tickCount then
            BroadCastTips(scene, x003013_g_HitTips)
            SetGuildParam(scene, x003013_g_HitStartTime, tickCount)
        end
    end

    if change == 1 then
        BroadCastGuildDefenceFlagHp(scene)
    end
end

function x003013_TickBaseHp(scene, level)
    local param = 0
    for i = 1, #x003013_g_BaseFlagId do
        local mask = math.floor(GetGuildParam(scene, x003013_g_FlagFireMask) / math.pow(10, i - 1)) % 10
        if mask == 0 then
            if CalculatePercenHpByRBId(scene, x003013_g_BaseFlagId[i]) < 50 then
                param = param + 1 * math.pow(10, i - 1)
                if i == 1 then
                    local point = GetGuildParam(scene, x003013_g_Point) - x003013_g_MainBaseHpPoint
                    SetGuildParam(scene, x003013_g_Point, point)
                	SendImpactToAllByRBID(scene, x003013_g_BaseFlagId[i], x003013_g_FlagFireEffectId)
                else
                    local point = GetGuildParam(scene, x003013_g_Point) - x003013_g_BaseHpPoint
                    SetGuildParam(scene, x003013_g_Point, point)
                end

				local guid = GetGuildSceneGuildGuid(scene)
                SendChannalMessageMonsterName(scene, x003013_g_ChannalGuild, x003013_g_FlagFireTip[i], x003013_g_BaseFlagId[i], guid)

                local flagPoint = GetGuildParam(scene, x003013_g_Point)
                BroadCastGuildDefencePoint(scene, flagPoint)
            end
        elseif mask == 1 then
            param = param + 1 * math.pow(10, i - 1)
        end
    end
    SetGuildParam(scene, x003013_g_FlagFireMask, param)
end

function x003013_OnObjEnter(scene, tickCount, objId)
    local state = GetGuildParam(scene, x003013_g_State)
    local time = 0
    local special = GetGuildParam(scene, x003013_g_SpecialMonster)- tickCount
    if state == 0 then
        time = x003013_g_WaitTickCount - tickCount + 1
        special = -1
    elseif state <= 7 then
    	local born = GetGuildParam(scene, x003013_g_MonsterTime)
        time = born - tickCount + 1
    elseif state >= 8 then
        time = -1
    end

    if state > 0 then
        x003013_AddCareMonster(scene, objId)
    end
    
    local point = GetGuildParam(scene, x003013_g_Point)
    local killCount = GetGuildParam(scene, x003013_g_KillCount)
    local ischeck = GetGuildParam(scene, x003013_g_IsCheckBegin)
    SetUserGuildDefenceState(scene, objId, state, ischeck, time, special - tickCount + 1, point, killCount, x003013_g_BaseFlagPos)
end

function x003013_OnObjDie(scene, objId, rolebaseId, killerId)
	local level = GetGuildParam(scene, x003013_g_Level)
	local killCount = GetGuildParam(scene, x003013_g_KillCount)
	local nowKillCount = 0
    if rolebaseId == x003013_g_BaseFlagId[1] then
        SetGuildParam(scene, x003013_g_Point, 0)
        x003013_ActivityEnd(scene, 0, level)
    elseif rolebaseId == x003013_g_BaseFlagId[2] or rolebaseId == x003013_g_BaseFlagId[3] then
        local point = GetGuildParam(scene, x003013_g_Point) - x003013_g_BaseDiePoint
        SetGuildParam(scene, x003013_g_Point, point)
        BroadCastGuildDefencePoint(scene, point)
        local exp = GetGuildParam(scene, x003013_g_ExpAddRate) - x003013_g_DieMinusExpRate
        SetGuildParam(scene, x003013_g_ExpAddRate, exp) 
    elseif x003013_IsMonsterRolebase(rolebaseId, 1) then
		GainGuildBattleExpByLevel(scene, x003013_g_MonsterExp)
        AddGuildBattleYuanShenExpByLevel(scene, x003013_g_MonsterYuanShenExp)
		nowKillCount = killCount + 1
    elseif x003013_IsMonsterRolebase(rolebaseId, 2) then
    	GainGuildBattleExpByLevel(scene, x003013_g_JingYingExp)
        AddGuildBattleYuanShenExpByLevel(scene, x003013_g_JingYingYuanShenExp)
		nowKillCount = killCount + 1
    elseif x003013_IsMonsterRolebase(rolebaseId, 3) then
    	GainGuildBattleExpByLevel(scene, x003013_g_SpecialMonsterExp)
        AddGuildBattleYuanShenExpByLevel(scene, x003013_g_SpecialMonsterYuanShenExp)
		nowKillCount = killCount + 1
    elseif x003013_IsMonsterRolebase(rolebaseId, 4) then 
    	local guid = GetGuildSceneGuildGuid(scene)
        SendChannalMessageMonsterName(scene, x003013_g_ChannalGuild, x003013_g_KillBossTip, rolebaseId, guid)
        GainGuildBattleExpByLevel(scene, x003013_g_BossExp)
        AddGuildBattleYuanShenExpByLevel(scene, x003013_g_BossYuanShenExp)
		nowKillCount = killCount + 1
	end

    if nowKillCount > killCount then
    	SetGuildParam(scene, x003013_g_KillCount, nowKillCount)
    	BroadCastGuildDefenceKillCount(scene, nowKillCount)
    end
end

function x003013_IsMonsterRolebase(rolebaseId, index)
	if index == 1 then    
		for i = 1, #x003013_g_MonsterId do
        	for j = 1, #x003013_g_MonsterId[i] do
        		if rolebaseId == x003013_g_MonsterId[i][j][1] then
        			return true
        		end
        	end
    	end
    elseif index == 2 then
    	for i = 1, #x003013_g_JingYingId do
        	if rolebaseId == x003013_g_JingYingId[i][1] then
        		return true
        	end
    	end
    elseif index == 3 then
    	for i = 1, #x003013_g_SpecialMonsterId do
    		if rolebaseId == x003013_g_SpecialMonsterId[i][1] then
        		return true
        	end
    	end
    elseif index == 4 then
    	for i = 1, #x003013_g_BossId do
    		if rolebaseId == x003013_g_BossId[i] then
        		return true
        	end
    	end
	end
    return false
end

function x003013_OnObjLeave(scene, tickCount, objId)

end

function x003013_ActivityEnd(scene, win, level)
    if win == 0 then
        local guid = GetGuildSceneGuildGuid(scene)
        SendChannalMessage(scene, x003013_g_ChannalGuild, x003013_g_LoseTip, guid)
    else
        local guid = GetGuildSceneGuildGuid(scene)
        SendChannalMessage(scene, x003013_g_ChannalGuild, x003013_g_KillWinTip, guid)
    end

    local point = GetGuildParam(scene, x003013_g_Point)
    local rate = x003013_GetPointRate(point)
    SetGuildDefenceBattleEnd(scene, win, point, rate, x003013_g_Money, x003013_g_RewardId, x003013_g_MailId,102101204)
    x003013_ClearAllMonster(scene, level)
end

function x003013_GetPointRate(point)
    for i = 1 ,#x003013_g_PointRate do
        if point >= x003013_g_PointRate[i][1] then
            return x003013_g_PointRate[i][2]
        end
    end
    return 0
end

function x003013_ClearAllMonster(scene, level)
    for i=1,#x003013_g_BaseFlagId do 
        DeleMonsterByRoleId(scene, x003013_g_BaseFlagId[i])
    end

    for i = 1, #x003013_g_MonsterId do
        for j = 1, #x003013_g_MonsterId[i] do
        	DeleMonsterByRoleId(scene, x003013_g_MonsterId[i][j][1])
        end
    end

    for i = 1, #x003013_g_JingYingId do
        DeleMonsterByRoleId(scene, x003013_g_JingYingId[i][1])
    end

    for i = 1, #x003013_g_SpecialMonsterId do
        DeleMonsterByRoleId(scene, x003013_g_SpecialMonsterId[i][1])
    end

    for i = 1, #x003013_g_BossId do
        DeleMonsterByRoleId(scene, x003013_g_BossId[i])
    end

   	RemoveSceneBuffById(scene, x003013_g_MonsterStartGroupPoint)
end

function x003013_MonsterNotAlive(scene)
	local count = 0
	for i = 1, #x003013_g_MonsterId do
        for j = 1, #x003013_g_MonsterId[i] do
        	count = count + GetAliveMonsterCount(scene, x003013_g_MonsterId[i][j][1])
        end
    end

    for i = 1, #x003013_g_JingYingId do
        count = count + GetAliveMonsterCount(scene, x003013_g_JingYingId[i][1])
        
    end

    for i = 1, #x003013_g_BossId do
        count = count + GetAliveMonsterCount(scene, x003013_g_BossId[i])
    end

    return (count == 0)
end

function x003013_AddCareMonster(scene, objId)
    for i=1, #x003013_g_BaseFlagId do
        AddCareList(scene, objId, x003013_g_BaseFlagId[i])
    end
end