x003044_g_scriptId = 003044

x003044_g_BigBossId = 970037
x003044_g_BigBossRoleBaseId = {970037, 970100}
x003044_g_BigBossPos = {159.06, 164.69, 3.38}

x003044_g_NormalBossId = 971037
x003044_g_NormalBossRolebaseId = {971037, 971100}
x003044_g_NormalBossPos = {9001, 9002, 9003, 9004}--positionRandom的ID，
x003044_g_NormalBossFaceDir = {0, 90, 180, 270}

x003044_g_SmallBossId = 972037
x003044_g_SmallBossRoleBaseId = {972037, 972100}
x003044_g_SmallBossMinCount = 20
x003044_g_SmallBossMaxCount = 100
x003044_g_SmallBossPos = {9011, 9012, 9013, 9014, 9015}--positionRandom的ID，
x003044_g_SmallBossFaceDir = {0, 72, 144, 216, 288}

x003044_g_HpImpact = 98001   --dau相关的血量buff
x003044_g_HPImpactMaxCount = 80 --血量最高层数
x003044_g_DelDefenceImpact = 98002 --易伤buff

x003044_g_PlayerCount = 200 --最小玩家数量，用于计算怪物数量和buff

x003044_g_SceneState = 0
x003044_g_BigBossObjId = 1
x003044_g_ServerLevel = 2
x003044_g_HpState = 3
x003044_g_TickCount = 4

x003044_g_BroadCastId = {}  --广播id
x003044_g_BroadCastId[1] = 2201
x003044_g_BroadCastId[2] = 2202
x003044_g_BroadCastId[3] = 2203
x003044_g_BroadCastId[4] = 2204
x003044_g_BroadCastId[5] = 2205
x003044_g_BroadCastId[6] = 2206
x003044_g_BroadCastId[7] = 2207
x003044_g_BroadCastId[8] = 2208
x003044_g_BroadCastId[9] = 2209

x003044_g_EndTime = 1500  --结束时间
x003044_g_DelTime = 300  --删怪的时间，结束之后开始计时
--tiger表

function  x003044_OnActivityStart(scene, curTime, idx)
	-- body
	GongChengActivityStart(scene)
	local level = GetBossGongChengLevel()
	SetGongChengParam(scene, x003044_g_ServerLevel, level)
	local dau = GetOtherWorldDau(scene)
	local rolebaseId = x003044_GetMonsterRoleBaseId(x003044_g_BigBossRoleBaseId, level)
	local objid = CreateMonster(scene, x003044_g_BigBossId, x003044_g_BigBossPos[3], x003044_g_BigBossPos[1], x003044_g_BigBossPos[2], level, -1, rolebaseId)
	SetGongChengParam(scene, x003044_g_BigBossObjId, objid)
	local impactCount = x003044_GetCount(0, x003044_g_HPImpactMaxCount, dau)
	if impactCount > 0 then
		for i = 1, impactCount do
			SendImpactToUnit(scene, objid, x003044_g_HpImpact)
		end
	end
	SetHpFull(scene, objid)
	SetGongChengParam(scene, x003044_g_SceneState, 1)
	SetObjCaredHpPercent(scene, objid, x003044_g_scriptId, x003044_GetNextHpPercent(1))
	SetGongChengParam(scene, x003044_g_HpState, 1)

	local bossCount = x003044_GetCount(x003044_g_SmallBossMinCount, x003044_g_SmallBossMaxCount, dau)
	x003044_CreateGongChengSmallBoss(scene, bossCount)

	GongChengSystemBroadCast(x003044_g_BroadCastId[1])

	BossGongChengBossCountChange(scene, -1, x003044_g_SmallBossId, GetGongChengParam(scene, x003044_g_BigBossObjId), x003044_g_DelDefenceImpact, x003044_GetCountDownTime(scene))
end

function x003044_OnActivityTick(scene, tickCount)
	-- body
	x003044_TickState(scene, tickCount)
end

function x003044_OnCaredHpPercent(scene, objId, hpPercent, attackerId)
	local level = GetGongChengParam(scene, x003044_g_ServerLevel)
	CreatGongChengBossDropBox(scene, level, 0, attackerId, objId)
	local sceneState = GetGongChengParam(scene, x003044_g_SceneState)
	local hpState = GetGongChengParam(scene, x003044_g_HpState)
	if hpState >= sceneState then
		x003044_GotoNextState(scene, false)
	end
	SetGongChengParam(scene, x003044_g_HpState, hpState + 1)

	local bigBossObjId = GetGongChengParam(scene, x003044_g_BigBossObjId)
	local  percent = x003044_GetNextHpPercent(hpState + 1)
	if percent > 0 then

	end
	--drop
end

function x003044_OnObjDie(scene, objId, rolebaseId, killerId)
	local level = GetGongChengParam(scene, x003044_g_ServerLevel)
	if rolebaseId == x003044_g_BigBossId then
		CreatGongChengBossDropBox(scene, level, 3, killerId, objId)
		x003044_ActivityEnd(scene, false)
	elseif rolebaseId == x003044_g_SmallBossId then
		CreatGongChengBossDropBox(scene, level, 1, killerId, objId)
		SendImpactToUnit(scene, GetGongChengParam(scene, x003044_g_BigBossObjId), x003044_g_DelDefenceImpact)
		BossGongChengBossCountChange(scene, -1, x003044_g_SmallBossId, GetGongChengParam(scene, x003044_g_BigBossObjId), x003044_g_DelDefenceImpact, -1)
	elseif rolebaseId == x003044_g_NormalBossId then
		CreatGongChengBossDropBox(scene, level, 2, killerId, objId)
		BossGongChengBossCountChange(scene, x003044_g_NormalBossId, -1, GetGongChengParam(scene, x003044_g_BigBossObjId), x003044_g_DelDefenceImpact, -1)
	end
end

function  x003044_OnObjEnter(scene, objId)
	-- body
	InitBossGongCheng(scene, objId, x003044_g_NormalBossId, x003044_g_SmallBossId, GetGongChengParam(scene, x003044_g_BigBossObjId), x003044_g_DelDefenceImpact, x003044_GetCountDownTime(scene))
end

function x003044_OnObjReconnect(scene, objId)
	-- body
	InitBossGongCheng(scene, objId, x003044_g_NormalBossId, x003044_g_SmallBossId, GetGongChengParam(scene, x003044_g_BigBossObjId), x003044_g_DelDefenceImpact, x003044_GetCountDownTime(scene))
end

function x003044_GetMonsterRoleBaseId(rolebase, level)
	local id = math.floor((level - 370) / 10) + rolebase[1]

	if id < rolebase[1] then
		id = rolebase[1]
	end

	if id > rolebase[2] then
		id = rolebase[2]
	end

	return id
end

function x003044_CreateGongChengNormalBoss(scene, nBossCount)
	-- body
	x003044_CreateGongChengBoss(scene, x003044_g_NormalBossId, x003044_g_NormalBossPos, x003044_g_NormalBossFaceDir, x003044_g_NormalBossRolebaseId, nBossCount)
end

function x003044_CreateGongChengSmallBoss(scene, nBossCount)
	-- body
	x003044_CreateGongChengBoss(scene, x003044_g_SmallBossId, x003044_g_SmallBossPos, x003044_g_SmallBossFaceDir, x003044_g_SmallBossRoleBaseId, nBossCount)
end

function x003044_CreateGongChengBoss(scene, rolebaseId, pos, faceDir, attrId, nBossCount)
	-- body
	local bossCount = nBossCount
	local detal = math.ceil(bossCount / #pos)
	local level = GetGongChengParam(scene, x003044_g_ServerLevel)
	local attrRoleBaseId = x003044_GetMonsterRoleBaseId(attrId, level)
	for i=1, #pos do
		local count = math.min(bossCount, detal)
		CreateGongChengBoss(scene, rolebaseId, attrRoleBaseId, level, count, pos[i], faceDir[i])
		bossCount = bossCount - count
		if bossCount <= 0 then
			break
		end
	end
end

function x003044_GetCount(min, max, dau)
	-- body
	if dau > x003044_g_PlayerCount then
		local count = math.max(min + math.floor((dau - x003044_g_PlayerCount) / 20), max)
		return count
	end

	return min
end

function x003044_TickState(scene, tickCount)
	-- body
	SetGongChengParam(scene, x003044_g_TickCount, tickCount)
	local state = GetGongChengParam(scene, x003044_g_SceneState)
	local nextTime = x003044_GetNextTime(state)
	if nextTime > 0 and tickCount >= nextTime then
		x003044_GotoNextState(scene, true)
	end

	if state == 10 then
		if tickCount >= x003044_g_EndTime then
			x003044_ActivityEnd(scene, true)
		end
	elseif state == 11 then
		if tickCount >= x003044_g_DelTime then
			GongChengActivityNotBegin(scene)
			DeleAllMonster(scene)
		end
	end

	GongChengBossHp(scene, GetGongChengParam(scene, x003044_g_BigBossObjId))
end

function x003044_GetNextHpPercent(state)
	-- body
	if state < 1 or state > 9 then
		return -1
	else
		return 100 - state * 10
	end
end

function x003044_GetNextTime(state)
	-- body
	if state < 1 or state > 9 then
		return -1
	else
		return state * 2 * 60
	end
end

function x003044_GotoNextState(scene, isTimeOut)
	-- body
	local state = GetGongChengParam(scene, x003044_g_SceneState) + 1
	SetGongChengParam(scene, x003044_g_SceneState, state)

	local bigBossObjId = GetGongChengParam(scene, x003044_g_BigBossObjId)

	local dau = GetOtherWorldDau(scene)
	local bossCount = x003044_GetCount(x003044_g_SmallBossMinCount, x003044_g_SmallBossMaxCount, dau)
	local normalCount = 0
	if state == 10 then
		bossCount = math.floor(bossCount * 1.5)
	end	

	x003044_CreateGongChengSmallBoss(scene, bossCount)

	if not isTimeOut then
		if state == 4 or state == 7 or state == 10 then
			normalCount = math.floor(bossCount / 2)
		end
		RemoveImpact(scene, bigBossObjId, x003044_g_DelDefenceImpact)
	end

	if normalCount > 0 then
		x003044_CreateGongChengNormalBoss(scene, normalCount)
	end

	BossGongChengBossCountChange(scene, x003044_g_NormalBossId, x003044_g_SmallBossId, GetGongChengParam(scene, x003044_g_BigBossObjId), x003044_g_DelDefenceImpact, -1)

	if state == 4 or state == 7 then
		if isTimeOut then
			GongChengSystemBroadCast(x003044_g_BroadCastId[5])
		else
			GongChengSystemBroadCast(x003044_g_BroadCastId[4])
		end	
	elseif state == 10 then
		if isTimeOut then
			GongChengSystemBroadCast(x003044_g_BroadCastId[7])
		else
			GongChengSystemBroadCast(x003044_g_BroadCastId[6])
		end
	else
		if isTimeOut then
			GongChengSystemBroadCast(x003044_g_BroadCastId[3])
		else
			GongChengSystemBroadCast(x003044_g_BroadCastId[2])
		end	
	end
end

function x003044_ActivityEnd(scene, isTimeOut)
	-- body
	local level = GetGongChengParam(scene, x003044_g_ServerLevel)
	GongChengActivityEnd(scene, level, isTimeOut)
	if isTimeOut then
		DeleMonsterByObjId(scene, GetGongChengParam(scene, x003044_g_BigBossObjId))
		GongChengSystemBroadCast(x003044_g_BroadCastId[9])
	else
		GongChengSystemBroadCast(x003044_g_BroadCastId[8])
	end

	SetGongChengParam(scene, x003044_g_SceneState, 11)

	BossGongChengBossCountChange(scene, -1, -1, -1, -1, x003044_GetCountDownTime(scene))
end

function x003044_GetCountDownTime(scene)
	-- body
	local state = GetGongChengParam(scene, x003044_g_SceneState)
	local tickCount = GetGongChengParam(scene, x003044_g_TickCount)
	
	local time = -1
	if state == 0 then
		time = 0
	elseif state < 11 then
		time = x003044_g_EndTime - tickCount
	elseif state == 11 then
		time = x003044_g_DelTime - tickCount
	end
	return time
end
