package com.bingougame.tgsw;
import com.bingougame.sdk.utils.Utils;
import com.unity3d.player.*;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.PixelFormat;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;

import com.bingougame.sdk.BGGLog;
import com.bingougame.sdk.SdkFactory;
import com.bingougame.sdk.SdkManager;
import com.bingougame.sdk.plugins.PluginFactory;
import com.tencent.bugly.crashreport.CrashReport;
import com.unity3d.player.UnityPlayer;
import android.content.IntentFilter;
import android.widget.Toast;
import android.view.WindowManager;
import java.util.List;

public class UnityPlayerActivity extends Activity {
    protected MyUnityPlayer mUnityPlayer; // don't change the name of this variable; referenced from native code
    private PowerManager.WakeLock wakeLock = null;
    BatteryReceiver mReceiver;
    private int mIsBatteryChargeState;//1表示充电, 0表示不充电
    private int mBatteryPercent;
    private static UnityPlayerActivity mInstance;
    public static final String LOG_TAG = "tgsw";
    public static boolean mIsFromGameCenter;//是否是从oppo游戏中心过来
    private static  boolean mIsNotified = false;

    // Setup activity layout
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        super.onCreate(savedInstanceState);
        mInstance = this;
        Utils.init(this);
        Logger.d(LOG_TAG, "UnityPlayerActivity #1");
        getWindow().setFormat(PixelFormat.RGBX_8888); // <--- This makes xperia play happy
        Logger.d(LOG_TAG, "UnityPlayerActivity #2");
        Logger.d(LOG_TAG, "UnityPlayerActivity #3");
        if (isYSDKChannel())
            SdkFactory.CreateSdk(this);
        else {
            //不是UC或Oppo则在这里初始化SDK
            if (!(/*isUCChannel() || */UnityPlayerActivity.getInstance().isOppo() || isChuJianTouFang())) {
                Logger.d(LOG_TAG, "UnityPlayerActivity #3.5");
                SdkFactory.CreateSdk(this);
            }

            if( isOppo() )
            {
                UnityPlayerActivity.ShowOppoRewardTips(this);
            }
        }
        PluginFactory.RegisterPlugins();
        Logger.d(LOG_TAG, "UnityPlayerActivity #4-1");
        SdkManager.getInstance().init(this);
        Logger.d(LOG_TAG, "UnityPlayerActivity #4-2");
        SdkManager.getInstance().currentChannel.InitWithBundle(this, savedInstanceState);
        Logger.d(LOG_TAG, "UnityPlayerActivity #5");

        mUnityPlayer = new MyUnityPlayer(this);
        setContentView(mUnityPlayer);
        Logger.d(LOG_TAG, "UnityPlayerActivity #6");
        mUnityPlayer.requestFocus();
        Logger.d(LOG_TAG, "UnityPlayerActivity #7");
        if(!isTempShutDownGuoNeiSDK()) {
            //对泰国的特殊处理
            if (Tools.getPackageName(this).equals("com.firstmeetgame.agmthai.gp")) {
                CrashReport.initCrashReport(getApplicationContext(), "4fe9f3f716", true);
            } else {
                CrashReport.initCrashReport(getApplicationContext(), "69232b3774", true);
            }
        }
        Logger.d(LOG_TAG, "UnityPlayerActivity #8");

        IntentFilter filter = new IntentFilter(Intent.ACTION_BATTERY_CHANGED);
        mReceiver = new BatteryReceiver();
        Logger.d(LOG_TAG, "UnityPlayerActivity #9");
        registerReceiver(mReceiver, filter);
        Logger.d(LOG_TAG, "UnityPlayerActivity #10 versionName=" + getVersionName() + " versionCode=" + getVersionCode());
    }

    public static UnityPlayerActivity getInstance() {
        return mInstance;
    }

    public int getBatteryState() {
        return mIsBatteryChargeState;
    }

    public void setBatteryState(int state) {
        mIsBatteryChargeState = state;
    }

    public int getBatteryPercent() {
        BGGLog.getInstance().d("getBatteryPercent mBatteryPercent=" + mBatteryPercent);
        return mBatteryPercent;
    }

    public void setBatteryPercent(int percent) {
        mBatteryPercent = percent;
        BGGLog.getInstance().d("setBatteryPercent mBatteryPercent=" + mBatteryPercent);
    }

    // Quit Unity
    @Override
    protected void onDestroy() {

        SdkManager.getInstance().onDestroyBeforeGame();
        //销毁广播
        unregisterReceiver(mReceiver);

        mUnityPlayer.quit();
        super.onDestroy();

        SdkManager.getInstance().onDestroyAfterGame();

    }

    public void onActivityResult(
            int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        BGGLog.getInstance().d("UnityPlayerActivity onActivityResult");
        SdkManager.getInstance().onActivityResult(requestCode, resultCode, data);
    }

    public void onStart() {
        super.onStart();// ATTENTION: This was auto-generated to implement the App Indexing API.
// See https://g.co/AppIndexing/AndroidStudio for more information.
        BGGLog.getInstance().d("UnityPlayerActivity onStart");
        SdkManager.getInstance().onStart();
		mUnityPlayer.start();
        // ATTENTION: This was auto-generated to implement the App Indexing API.
        // See https://g.co/AppIndexing/AndroidStudio for more information.
    }

    public void onNewIntent(Intent newIntent) {
        super.onNewIntent(newIntent);
        BGGLog.getInstance().d("UnityPlayerActivity onNewIntent");
        SdkManager.getInstance().onNewIntent(newIntent);
    }

    public void onStop() {
        BGGLog.getInstance().d("UnityPlayerActivity onStop");
        super.onStop();// ATTENTION: This was auto-generated to implement the App Indexing API.
// See https://g.co/AppIndexing/AndroidStudio for more information.
        SdkManager.getInstance().onStop();
		mUnityPlayer.pause();
		mUnityPlayer.stop();
        // ATTENTION: This was auto-generated to implement the App Indexing API.
        // See https://g.co/AppIndexing/AndroidStudio for more information.
    }

    public void onRestart() {
        BGGLog.getInstance().d("UnityPlayerActivity onRestart");
        super.onRestart();
        SdkManager.getInstance().onRestart();    }

    @SuppressLint("Override")
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        SdkManager.getInstance().onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    // Pause Unity
    @Override
    protected void onPause() {
        BGGLog.getInstance().d("UnityPlayerActivity onPause");
        super.onPause();
        //mUnityPlayer.pause();

        SdkManager.getInstance().onPause();

        releaseWakeLock();
    }

    // Resume Unity
    @Override
    protected void onResume() {
        BGGLog.getInstance().d("UnityPlayerActivity onResume");
        super.onResume();
        mUnityPlayer.resume();

        SdkManager.getInstance().onResume();
        acquireWakeLock();
    }

    // This ensures the layout will be correct.
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        BGGLog.getInstance().d("UnityPlayerActivity onConfigurationChanged");
        super.onConfigurationChanged(newConfig);
        mUnityPlayer.configurationChanged(newConfig);

        SdkManager.getInstance().onConfigurationChanged(newConfig);

    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        // TODO Auto-generated method stub
        BGGLog.getInstance().d("UnityPlayerActivity onSaveInstanceState");
        super.onSaveInstanceState(outState);
        SdkManager.getInstance().onSaveInstanceState(outState);
    }

    // Notify Unity of the focus change.
    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        BGGLog.getInstance().d("UnityPlayerActivity onWindowFocusChanged");
        super.onWindowFocusChanged(hasFocus);
        mUnityPlayer.windowFocusChanged(hasFocus);

        SdkManager.getInstance().onWindowFocusChanged();

    }

    // For some reason the multiple keyevent type is not supported by the ndk.
    // Force event injection by overriding dispatchKeyEvent().
    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getAction() == KeyEvent.ACTION_MULTIPLE)
            return mUnityPlayer.injectEvent(event);
        return super.dispatchKeyEvent(event);
    }

    // Pass any events not handled by (unfocused) views straight to UnityPlayer
    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return mUnityPlayer.injectEvent(event);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return mUnityPlayer.injectEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return mUnityPlayer.injectEvent(event);
    }

    /*API12*/
    public boolean onGenericMotionEvent(MotionEvent event) {
        return mUnityPlayer.injectEvent(event);
    }


    //获取电源锁，保持该服务在屏幕熄灭时仍然获取CPU时，保持运行
    @SuppressLint("InvalidWakeLockTag")
    private void acquireWakeLock() {
        if (null == wakeLock) {
            PowerManager pm = (PowerManager) this.getSystemService(Context.POWER_SERVICE);
            wakeLock = pm.newWakeLock(PowerManager.SCREEN_BRIGHT_WAKE_LOCK, "PostLocationService");
            if (null != wakeLock) {
                wakeLock.acquire();
            }
        }
    }

    //释放设备电源锁  
    private void releaseWakeLock() {
        if (null != wakeLock) {
            wakeLock.release();
            wakeLock = null;
        }
    }


    //是否是应用宝渠道单接
    public boolean isYSDKChannel() {
        try {
            ApplicationInfo appInfo = getPackageManager().getApplicationInfo(Tools.getPackageName(this),
                    PackageManager.GET_META_DATA);

            int value = appInfo.metaData.getInt("IS_YSDK_CHANNEL");
            Log.d("Tag", "IS_YSDK_CHANNEL: " + value);  // Tag﹕ app key : AIzaSyBhBFOgVQclaa8p1JJeqaZHiCo2nfiyBBo、
            return value == 1;//1表示应用宝，0表示聚合SDK
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    //是否是应用宝通用渠道,因为这是两个工程公用的接口，应用宝单接那块没法调用初见SDK的接口，只能统一用包名判断
    public boolean isYSDKGeneral() {
        return Tools.getPackageName(this).equals("com.tencent.tmgp.bingougame.tgsw21");
    }

    //是否是UC渠道,因为这是两个工程公用的接口，应用宝单接那块没法调用初见SDK的接口，只能统一用包名判断
    public boolean isUCChannel() {
        return Tools.getPackageName(this).equals("com.bingougame.tgsw2.aligames");
    }

    //是否是oppo渠道,因为这是两个工程公用的接口，应用宝单接那块没法调用初见SDK的接口，只能统一用包名判断
    public boolean isOppo() {
        return Tools.getPackageName(this).equals("com.bingougame.tgsw2.nearme.gamecenter");
        //return Tools.getPackageName(this).equals("com.xunmeng.herolegend.nearme.gamecenter");//大乱斗包名，测试启动领奖
        //return ChuJianSDK.getInstance().getCurrChannel() == ChannelConst.CHAN_ID_OPPO;
    }

    public boolean isChuJianTouFang()
    {
        return false;
//        boolean bIsTouFang = Tools.getPackageName(this).equals("com.bingougame.tgsw2") ||
//                Tools.getPackageName(this).equals("com.bingougame.tgsw2.chujian200") ||
//                Tools.getPackageName(this).equals("com.bingougame.tgsw2.chujian201") ||
//                Tools.getPackageName(this).equals("com.bingougame.tgsw2.chujian202");
//        BGGLog.getInstance().d("isChuJianTouFang=" + bIsTouFang);
//        return bIsTouFang;
    }

    public static void ShowOppoRewardTips(Activity activity)
    {
        if( UnityPlayerActivity.mIsFromGameCenter)
        {
            if( !mIsNotified)
            {
                mIsNotified = true;
                //Toast.makeText(activity, "恭喜你，获得奖励启动礼包！", Toast.LENGTH_SHORT).show();
            }
        }
        else
        {
           // Toast.makeText(activity, "从游戏中心启动游戏可获得奖励", Toast.LENGTH_SHORT).show();
        }
    }

//    public String getPackageName()
//    {
//        String packageName = Tools.getPackageName(this);
//        //Toast.makeText(this, packageName, Toast.LENGTH_SHORT);
//        //BGGLog.getInstance().d("packageName=" + packageName);
//        return packageName;
//    }

    /**
     * * get App versionCode
     * * @param context
     * * @return
     * */
    public int getVersionCode()
    {
        PackageManager packageManager = this.getPackageManager();
        PackageInfo packageInfo;
        int versionCode = 0;
        try {
            packageInfo = packageManager.getPackageInfo(this.getPackageName(), 0);
            versionCode = packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e)
        {
            e.printStackTrace();
        }
        return versionCode;
    }

    /**
     * * get App versionName
     * * @param context
     * * @return
     * */
    public String getVersionName()
    {
        PackageManager packageManager = this.getPackageManager();
        PackageInfo packageInfo;
        String versionName="";
        try {
            packageInfo = packageManager.getPackageInfo(this.getPackageName(), 0);
            versionName = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e)
        {
            e.printStackTrace();
        }
        return versionName;
    }


    // Low Memory Unity
    @Override public void onLowMemory()
    {
        super.onLowMemory();
        mUnityPlayer.lowMemory();
    }

    // Trim Memory Unity
    @Override public void onTrimMemory(int level)
    {
        super.onTrimMemory(level);
        if (level == TRIM_MEMORY_RUNNING_CRITICAL)
        {
            mUnityPlayer.lowMemory();
        }
    }

    public String getSn() {
        return  "";
    }

    public String quit(){
        BGGLog.getInstance().d("new quit()");
        android.os.Process.killProcess(android.os.Process.myPid());
        return "";
    }

    public boolean isPermanetShutDownGuoNeiSDK()
    {
        return Tools.getPackageName(this).equals("com.gm99.tgsw") ||
                Tools.getPackageName(this).equals("com.firstmeetgame.agmthai.gp") ||
                Tools.getPackageName(this).startsWith("com.kr37.tgsw") ||
                Tools.getPackageName(this).startsWith("com.vtcmobile.thaicothanvuong");
    }

    public boolean isTempShutDownGuoNeiSDK()
    {
        return false;
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(newBase);
        SdkManager.getInstance().attachBaseContext(newBase);
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        SdkManager.getInstance().onBackPressed();
    }
}