package com.bingougame.tgsw;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.BatteryManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;

import com.unity3d.player.UnityPlayer;

public class BatteryReceiver extends BroadcastReceiver {

	@Override
	public void onReceive(Context context, Intent intent) {
		// TODO Auto-generated method stub
		int current = intent.getExtras().getInt("level");// 获得当前电量
		int total = intent.getExtras().getInt("scale");// 获得总电量
		int percent = current * 100 / total;
		
        UnityPlayerActivity.getInstance().setBatteryPercent(percent);
        
        String action =intent.getAction();
        if(Intent.ACTION_BATTERY_CHANGED.equals(action));
        {
            int status = intent.getIntExtra("status", BatteryManager.BATTERY_STATUS_UNKNOWN);
            if(status == BatteryManager.BATTERY_STATUS_CHARGING)
            {
                UnityPlayerActivity.getInstance().setBatteryState(1);
            }
            else
            {
                UnityPlayerActivity.getInstance().setBatteryState(0);
            }

            UnityPlayer.UnitySendMessage("GameManagerObject", "OnBatteryStateChange", UnityPlayerActivity.getInstance().getBatteryState() + "");
        }
        
	}

}
