package com.bingougame.sdk.plugins;

import android.Manifest;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.media.AudioFormat;
import android.os.Build;
import android.os.Handler;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Base64;
import android.util.Log;

import com.bingougame.sdk.BGGLog;
import com.bingougame.sdk.PluginInstance;
import com.bingougame.sdk.permission.PermissionConstants;
import com.bingougame.sdk.permission.PermissionHelper;
import com.bingougame.sdk.permission.PermissionUtils;
import com.bingougame.tgsw.Logger;

import java.util.HashMap;
import java.util.LinkedHashMap;
/**
 * Created by kai on 2017/2/16.
 */

public class PluginVoice extends PluginInstance{
    private static String TAG = PluginVoice.class.getSimpleName();
    // 语音听写对象
    private HashMap<String, String> mIatResults = new LinkedHashMap<String, String>();
    private int ret = 0; // 函数调用返回值
    private StringBuffer resultBuffer = new StringBuffer();
    private String MY_Speak;
    private AudioPlayer mAudioPlayer;
    private Handler mHandler;
    // 引擎类型
    //private String mEngineType = SpeechConstant.TYPE_CLOUD;
    //private SharedPreferences mSharedPreferences;
    // 引擎类型

    /**
     * 听写监听器。
     */


    @Override
    public void init(Context context) {
        super.init(context);
    }


    // 检查多个权限。返回true表示已完全启用权限，返回false表示未完全启用权限
    public static boolean checkPermission(Activity act, String[] permissions, int requestCode) {
        // Android 6.0 之后开始采用动态权限管理
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            int check = PackageManager.PERMISSION_GRANTED;
            for (String permission : permissions) {
                check = ContextCompat.checkSelfPermission(act, permission);
                if (check != PackageManager.PERMISSION_GRANTED) {
                    break;
                }
            }
            // 未开启该权限，则请求系统弹窗，好让用户选择是否立即开启权限
            if (check != PackageManager.PERMISSION_GRANTED) {
                ActivityCompat.requestPermissions(act, permissions, requestCode);
                return false;
            }
        }
        return true;
    }

    // 检查权限结果数组，返回true表示都已经获得授权。返回false表示至少有一个未获得授权
    public static boolean checkGrant(int[] grantResults) {
        if (grantResults != null) {
            // 遍历权限结果数组中的每条选择结果
            for (int grant : grantResults) {
                // 未获得授权
                if (grant != PackageManager.PERMISSION_GRANTED) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    //开始说话
    public boolean startSpeech() {
//        PermissionUtils init = PermissionUtils.permission(PermissionConstants.MICROPHONE);
//        init.test();
//        init = null;
        if (PermissionUtils.isGranted(Manifest.permission.RECORD_AUDIO)) {
            showTip( "startSpeech isGranted=true");
            return false;
        } else {
            showTip( "startSpeech isGranted=false");
            PermissionHelper.requestMicroPhone(false, new PermissionHelper.OnPermissionGrantedListener() {
                @Override
                public void onPermissionGranted() {
                    showTip("Granted RECORD_AUDIO permission.");
                }
            }, new PermissionHelper.OnPermissionDeniedListener() {
                @Override
                public void onPermissionDenied(boolean result) {
                    showTip("Denied RECORD_AUDIO permission.");
                }
            });
        }
        return false;
    }

    public boolean isRecordPermissionGranted()
    {
        BGGLog.getInstance().d("isRecordPermissionGranted #1");
        if (PermissionUtils.isGranted(Manifest.permission.RECORD_AUDIO)) {
            showTip( "startSpeech isGranted=true");
            BGGLog.getInstance().d("isRecordPermissionGranted #2");
            return true;
        } else {
            showTip( "startSpeech isGranted=false");
            BGGLog.getInstance().d("isRecordPermissionGranted #3");
            PermissionHelper.requestMicroPhone(false, new PermissionHelper.OnPermissionGrantedListener() {
                @Override
                public void onPermissionGranted() {
                    BGGLog.getInstance().d("isRecordPermissionGranted #4");
                    showTip("Granted RECORD_AUDIO permission.");
                }
            }, new PermissionHelper.OnPermissionDeniedListener() {
                @Override
                public void onPermissionDenied(boolean result) {
                    BGGLog.getInstance().d("isRecordPermissionGranted #5");
                    showTip("Denied RECORD_AUDIO permission.");
                }
            });

        }
        return false;
    }
    //停止识别
    public boolean stopSpeech() {
        return true;
    }
    //取消识别
    public boolean cancelSpeech()
    {
        return true;
    }
    public boolean playPcmAudioWithData(String pcmContentStr) {
        byte Data[] = android.util.Base64.decode(pcmContentStr, Base64.DEFAULT);


        // 获取音频数据
        mAudioPlayer.setDataSource(Data);

        // 音频源就绪
        mAudioPlayer.prepare();
        mAudioPlayer.play();
        return true;
    }
    /*
     * 获得PCM音频数据参数
     */
    public AudioParam getAudioParam()
    {
        AudioParam audioParam = new AudioParam();
        audioParam.mFrequency = 16000;
        audioParam.mChannel = AudioFormat.CHANNEL_OUT_MONO;
        audioParam.mSampBit = AudioFormat.ENCODING_PCM_16BIT;

        return audioParam;
    }
    public boolean playPcmAudioWithFilePath(String filePath)
    {
        Log.d(TAG,"PCMStop");
        return true;
    }
    public boolean setHighVolLimit(int highVol)
    {
        return true;
    }



    /**
     * 参数设置
     *
     *
     * @return
     */
    public void setParam() {

    }

    private void showTip(final String str) {
        Logger.d("tgsw", str);
    }
    public void play() {

    }
}
