package com.bingougame.sdk.plugins;

import android.Manifest;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.provider.MediaStore;

import com.bingougame.sdk.PluginInstance;
import com.bingougame.tgsw.UnityPlayerActivity;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
//import android.support.v4.content.ContextCompat;
//import android.support.v4.app.ActivityCompat;

/**
 * Created by Administrator on 2017/4/18.
 */

public class NewPhoto extends PluginInstance {
    public boolean SendPhoto(String FileName,String Path) {
        if(hasStoragePermission(UnityPlayerActivity.getInstance())) {
            try {
                MediaStore.Images.Media.insertImage(mContext.getContentResolver(),
                        Path, FileName, null);
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            // 最后通知图库更新
            mContext.sendBroadcast(new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, Uri.parse(Path)));
            return true;
        }else{
            applyStoragePermission(UnityPlayerActivity.getInstance());
            return false;

        }
    }
    // 判断是否需要动态申请权限，但是不进行权限申请操作
    public   boolean hasStoragePermission(Activity context) {
         String[] mPermissions = new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE,Manifest.permission.READ_EXTERNAL_STORAGE
        };
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
            //声明一个数组permissions，将需要的权限都放在里面
            List<String> permissionList = new ArrayList<>();
            int mRequestCode = 100;//权限请求码
            //逐个判断权限是否已经通过
//            for (int i = 0; i < mPermissions.length; i++) {
//                if (ContextCompat.checkSelfPermission(context, mPermissions[i]) != PackageManager.PERMISSION_GRANTED) {
//                    permissionList.add(mPermissions[i]);//添加还未授予的权限
//                }
//            }
            //申请未通过的权限权限
            if (permissionList.size() > 0) {
                return false;
            }
        }
        return true;
    }

    public   boolean applyStoragePermission(Activity context) {
        String[] mPermissions = new String[]{Manifest.permission.WRITE_EXTERNAL_STORAGE,Manifest.permission.READ_EXTERNAL_STORAGE
        };
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
            //声明一个数组permissions，将需要的权限都放在里面
            List<String> permissionList = new ArrayList<>();
            int mRequestCode = 100;//权限请求码
            //逐个判断权限是否已经通过
//            for (int i = 0; i < mPermissions.length; i++) {
//                if (ContextCompat.checkSelfPermission(context, mPermissions[i]) != PackageManager.PERMISSION_GRANTED) {
//                    permissionList.add(mPermissions[i]);//添加还未授予的权限
//                }
//            }
//            //申请未通过的权限权限
//            if (permissionList.size() > 0) {
//                ActivityCompat.requestPermissions(context, mPermissions, mRequestCode);
//                return true;
//            }
        }
        return false;
    }
}
