package com.bingougame.sdk.plugins;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Debug;
import android.util.Log;

import com.bingougame.sdk.PluginInstance;

import java.util.List;

import static android.app.ActivityManager.*;
import static android.content.ContentValues.TAG;
import static android.content.Context.ACTIVITY_SERVICE;

 /* Created by Administrator on 2017/3/11.
 */

public class GetMemory extends PluginInstance {
    private int getRunningAppProcessInfo() {
        ActivityManager mActivityManager=(ActivityManager) mContext.getSystemService(Context.ACTIVITY_SERVICE);
            // 通过调用ActivityManager的getRunningAppProcesses()方法获得系统里所有正在运行的进程
            List<ActivityManager.RunningAppProcessInfo> appProcessList = mActivityManager
                    .getRunningAppProcesses();
            int memoryTotal=0;

            for (RunningAppProcessInfo appProcessInfo : appProcessList) {
                // 进程ID号
                int pid = appProcessInfo.pid;
                // 用户ID 类似于Linux的权限不同，ID也就不同 比如 root等
                int uid = appProcessInfo.uid;
                // 进程名，默认是包名或者由属性android：process=""指定
                String processName = appProcessInfo.processName;
                // 获得该进程占用的内存
                int[] myMempid = new int[] { pid };
                // 此MemoryInfo位于android.os.Debug.MemoryInfo包中，用来统计进程的内存信息
                Debug.MemoryInfo[] memoryInfo = mActivityManager.getProcessMemoryInfo(myMempid);
                // 获取进程占内存用信息 kb单位nativeSharedDirty
                int memSize = memoryInfo[0].dalvikPrivateDirty;
                int memSizeds=memoryInfo[0].dalvikSharedDirty;
                int memSizeN = memoryInfo[0].nativePrivateDirty;
                int memSizeNs=memoryInfo[0].nativeSharedDirty;


            // 获得每个进程里运行的应用程序(包),即每个应用程序的包名
            String[] packageList = appProcessInfo.pkgList;
            for (String pkg : packageList) {
                if(pkg.equals(mContext.getPackageName()))
                {
                    memoryTotal+=memSize+memSizeds+memSizeN+memSizeNs;
                }
            }
        }
        return memoryTotal/1024;
    }
}
