package com.bingougame.sdk.plugins;

import android.net.Uri;
import android.provider.Settings;

import com.bingougame.sdk.BGGLog;
import com.bingougame.sdk.PluginInstance;

/**
 * Created by liwentian on 2018/5/9.
 */

public class Brightness extends PluginInstance {
    public int GetScreenBrightness() {
        int screenBrightness = -1;
        try {
            screenBrightness = Settings.System.getInt(mContext.getContentResolver(),
                    Settings.System.SCREEN_BRIGHTNESS);
        } catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        BGGLog.getInstance().d("GetScreenBrightness:" + screenBrightness);
        return screenBrightness;
    }
    public boolean SetScreenBrightness(float paramInt) {
        Settings.System.putInt(mContext.getContentResolver(),
                Settings.System.SCREEN_BRIGHTNESS, (int)(paramInt));
        Uri uri = Settings.System
                .getUriFor("screen_brightness");
        mContext.getContentResolver().notifyChange(uri, null);
        BGGLog.getInstance().d("SetScreenBrightness:" + paramInt);
        return true;
    }
}