package com.bingougame.sdk.permission;


import android.content.Context;
import android.os.Build;
import android.os.LocaleList;

import java.util.Locale;

import static android.Manifest.permission.WRITE_SETTINGS;
import static com.bingougame.sdk.permission.PermissionConstants.CALENDAR;
import static com.bingougame.sdk.permission.PermissionConstants.CAMERA;
import static com.bingougame.sdk.permission.PermissionConstants.CONTACTS;
import static com.bingougame.sdk.permission.PermissionConstants.LOCATION;
import static com.bingougame.sdk.permission.PermissionConstants.MICROPHONE;
import static com.bingougame.sdk.permission.PermissionConstants.PHONE;
import static com.bingougame.sdk.permission.PermissionConstants.SENSORS;
import static com.bingougame.sdk.permission.PermissionConstants.SMS;
import static com.bingougame.sdk.permission.PermissionConstants.STORAGE;

public class PermissionLang {

    private String titleText;
    private String permissionRequestText;
    private String confirmText;
    private String exitGameText;
    private String settingText;

    private String rationaleMsg;
    private String deniedMsg;
    private String deniedForeverMsg;


    public String getTitleText() {
        return titleText;
    }

    public String getPermissionRequestText() {
        return permissionRequestText;
    }

    public String getConfirmText() {
        return confirmText;
    }

    public String getExitGameText() {
        return exitGameText;
    }

    public String getSettingText() {
        return settingText;
    }

    public String getRationaleMsg() {
        return rationaleMsg;
    }

    public String getDeniedMsg() {
        return deniedMsg;
    }

    public String getDeniedForeverMsg() {
        return deniedForeverMsg;
    }

    static class cnLang extends PermissionLang {

        private String rationaleMsg;
        private String deniedMsg;
        private String deniedForeverMsg;

        private String getPermissionName(String permission) {
            switch (permission) {
                case CAMERA:
                    return "相机";
                case LOCATION:
                    return "位置";
                case MICROPHONE:
                    return "麦克风";
                case PHONE:
                    return "电话";
                case STORAGE:
                    return "存储";
                case CONTACTS:
                    return "通讯录";
                case SMS:
                    return "短信";
                case CALENDAR:
                    return "日历";
                case SENSORS:
                    return "传感器";
            }
            return "";
        }

       public cnLang(final String[] permissions){
           StringBuilder sb = new StringBuilder();
           if (permissions.length > 0) {
               for (String permission : permissions) {
                   sb.append(getPermissionName(permission));
                   sb.append(",");
               }
               sb.deleteCharAt(sb.length() - 1);
           } else {
               sb.append("存储");
           }

           deniedMsg = "非常抱歉!游戏运行需要使用" + sb.toString() + "权限,如果没有使用授权,游戏无法保证正常运行";
           deniedForeverMsg = "非常抱歉!游戏运行需要使用" + sb.toString() + "权限,缺失游戏可能无法正常运行,请前往系统设置授权";
       }

        @Override
        public String getTitleText() {
            return "权限申请";
        }
        @Override
        public String getPermissionRequestText() {
            return "申请权限";
        }
        @Override
        public String getConfirmText() {
            return "取消";
        }
        @Override
        public String getExitGameText() {
            return "退出游戏";
        }
        @Override
        public String getSettingText() {
            return "设置";
        }

        @Override
        public String getRationaleMsg() {
            return rationaleMsg;
        }

        @Override
        public String getDeniedMsg() {
            return deniedMsg;
        }

        @Override
        public String getDeniedForeverMsg() {
            return deniedForeverMsg;
        }

    }

    static class thaiLang extends PermissionLang {

        private String rationaleMsg;
        private String deniedMsg;
        private String deniedForeverMsg;

        public thaiLang(@PermissionConstants.Permission final String permissions){
            switch (permissions) {
                case CAMERA:
                    rationaleMsg="เพื่อให้ได้รับประสบการณ์การเล่นเกมที่ดี  คุณสามารถปรับแต่งโปรไฟล์รวมถึงข้อเสนอแนะของคุณ";
                    deniedMsg="ขออภัย! เราไม่สามารถให้บริการแก่คุณได้เนื่องจากคุณปฏิเสธที่จะให้สิทธิ์ในภาพถ่าย";
                    deniedForeverMsg="ขออภัย! เราไม่สามารถให้บริการนี้แก่คุณเนืองจากคุณปฏิเสธที่จะให้สิทธิ์ในภาพถ่ายกับเกม  หากต้องการใช้บริการนี้โปรดไปที่การตั้งค่า";
                    break;
                case LOCATION:
                    rationaleMsg="";
                    deniedMsg="";
                    deniedForeverMsg="";
                    break;
                case MICROPHONE:
                    rationaleMsg="เกมมีฟังก์ชั่นแปลงข้อความเสียงและข้อความเสียงในเกม  บริการนี้ต้องได้รับอนุญาตจากไมโครโฟนของคุณ";
                    deniedMsg="ขออภัยเราไม่สามารถให้บริการเสียงแก่คุณได้เนื่องจากคุณปฏิเสธที่จะให้สิทธิ์การเข้าถึงไมโครโฟนแก่เกม";
                    deniedForeverMsg="ขออภัยเราไม่สามารถให้บริการเสียงแก่คุณได้  เนื่องจากคุณปฏิเสธที่จะให้สิทธิ์การเข้าถึงไมโครโฟนแก่เกม  หากต้องการใช้บริการนี้โปรดไปที่การตั้งค่าระบบ";
                    break;
                case PHONE:
                    rationaleMsg="";
                    deniedMsg="";
                    deniedForeverMsg="";
                    break;
                case STORAGE:
                    rationaleMsg="เพื่อให้คุณได้รับประสบการณ์การเล่นเกมที่ดี  เกมจำเป็นต้องใช้การอนุญาตอุปกรณ์จัดเก็บข้อมูลเพื่อบันทึกความคืบหน้าและทรัพยากรของเกม";
                    deniedMsg="ขออภัย! การทำงานของเกมต้องใช้การอนุญาตจากอุปกรณ์เก็บข้อมูล หากไม่ได้รับสิทธิ์สำหรับอุปกรณ์เก็บข้อมูล  จะไม่สามารถรับประกันได้ว่าเกมจะทำงานได้ตามปกติ";
                    deniedForeverMsg="ขออภัย! การทำงานของเกมต้องใช้การอนุญาตจากอุปกรณ์เก็บข้อมูล  เกมที่ขาดหายไปอาจทำงานไม่ถูกต้อง  โปรดไปที่ระบบเพื่อตั้งค่าการอนุญาต";
                    break;
                case WRITE_SETTINGS:
                    rationaleMsg="ในเกมมีฟังก์ชั่นการแปลงข้อความเสียง ซึ่งจะต้องได้รับสิทธิ์ในแก้ไขการตั้งค่าก่อน";
                    deniedMsg="ขออภัย เกมจำต้องได้รับสิทธิ์ตั้งค่าการแก้ไข หากไม่แก้ไขสิทธิ์การใช้งานการตั้งค่า ข้อความเสียงไม่รับประกันว่าจะทำงานได้อย่างถูกต้อง ";
                    deniedForeverMsg="ขออภัย! เกมจำเป็นต้องได้รับสิทธิ์การตั้งค่าการแก้ไข หากเกมหายไปอาจทำงานได้ไม่ถูกต้อง โปรดไปที่ระบบเพื่อตั้งค่าการอนุญาต ";
                    break;
            }
        }

        @Override
        public String getTitleText() {
            return "แอปพลิเคชันอนุญาต";
        }
        @Override
        public String getPermissionRequestText() {
            return "อนุญาตแอปพลิเคชัน";
        }
        @Override
        public String getConfirmText() {
            return "ยืนยัน";
        }
        @Override
        public String getExitGameText() {
            return "ออกจากเกม";
        }
        @Override
        public String getSettingText() {
            return "ตั้งค่า";
        }

        @Override
        public String getRationaleMsg() {
            return rationaleMsg;
        }

        @Override
        public String getDeniedMsg() {
            return deniedMsg;
        }

        @Override
        public String getDeniedForeverMsg() {
            return deniedForeverMsg;
        }

    }

    static class twLang extends PermissionLang {

        private String rationaleMsg;
        private String deniedMsg;
        private String deniedForeverMsg;

        public twLang(@PermissionConstants.Permission final String permissions){
            switch (permissions) {
                case CAMERA:
                    rationaleMsg="為了您能夠獲得能好的遊戲體驗,遊戲內可以自定義個性頭像及問題反饋";
                    deniedMsg="非常抱歉!由於您拒絕授予遊戲提供拍攝權限,我們無法給您提供這項服務";
                    deniedForeverMsg="非常抱歉!由於您拒絕授予遊戲提供拍攝權限,我們無法給您提供這項服務.如需使用該服務請前往設置";
                    break;
                case LOCATION:
                    rationaleMsg="";
                    deniedMsg="";
                    deniedForeverMsg="";
                    break;
                case MICROPHONE:
                    rationaleMsg="遊戲內提供語音留言及語音文字轉換功能,該服務需要使用您的麥克風權限";
                    deniedMsg="非常抱歉!由於您拒絕授予遊戲提供麥克風權限,我們無法給您提供語音服務";
                    deniedForeverMsg="非常抱歉!由於您拒絕授予遊戲提供麥克風權限,我們無法給您提供語音服務.如需使用該服務請前往系統設置";
                    break;
                case PHONE:
                    rationaleMsg="";
                    deniedMsg="";
                    deniedForeverMsg="";
                    break;
                case STORAGE:
                    rationaleMsg="為了您能夠獲得能好的遊戲體驗,遊戲需要使用儲存設備權限用於保存您的遊戲進度與資源";
                    deniedMsg="非常抱歉!遊戲運行需要使用儲存設備權限,如果沒有儲存設備的使用授權,遊戲無法保證正常運行";
                    deniedForeverMsg="非常抱歉!遊戲運行需要使用儲存設備權限,缺失遊戲可能無法正常運行,請前往系統設置授權";
                    break;
                case WRITE_SETTINGS:
                    rationaleMsg="遊戲內提供語音留言及語音文字轉換功能,遊戲需要使用修改設置權限";
                    deniedMsg="非常抱歉!遊戲運行需要使用修改設置權限,如果沒有修改設置權限的使用授權,語音無法保證正常運行";
                    deniedForeverMsg="非常抱歉!遊戲運行需要使用修改設置權限,缺失遊戲可能無法正常運行,請前往系統設置授權";
                default:
                    break;
            }
        }

        @Override
        public String getTitleText() {
            return "權限申請";
        }
        @Override
        public String getPermissionRequestText() {
            return "申請權限";
        }
        @Override
        public String getConfirmText() {
            return "確定";
        }
        @Override
        public String getExitGameText() {
            return "退出遊戲";
        }
        @Override
        public String getSettingText() {
            return "設置";
        }

        @Override
        public String getRationaleMsg() {
            return rationaleMsg;
        }

        @Override
        public String getDeniedMsg() {
            return deniedMsg;
        }

        @Override
        public String getDeniedForeverMsg() {
            return deniedForeverMsg;
        }

    }


    static class enLang extends PermissionLang {

        private String rationaleMsg;
        private String deniedMsg;
        private String deniedForeverMsg;

        public enLang(@PermissionConstants.Permission final String permissions){
            switch (permissions) {
                case CAMERA:
                    rationaleMsg="You may customize your avatar and submit feedbacks.";
                    deniedMsg="You may customize your avatar and submit feedbacks.";
                    deniedForeverMsg="You have refused to grant access to the camera. The service is not available. Please grant camera access in settings.";
                    break;
                case LOCATION:
                    rationaleMsg="";
                    deniedMsg="";
                    deniedForeverMsg="";
                    break;
                case MICROPHONE:
                    rationaleMsg="Voice message and Voice-to-text function require access to the microphone";
                    deniedMsg="You have refused to grant access to the microphone. The service is not available.";
                    deniedForeverMsg="You have refused to grant access to the microphone. The service is not available. Please grant microphone access in settings.";
                    break;
                case PHONE:
                    rationaleMsg="";
                    deniedMsg="";
                    deniedForeverMsg="";
                    break;
                case STORAGE:
                    rationaleMsg="The app requires access to the device memory for storing progress and resources.";
                    deniedMsg="The app cannot run properly without access to device memory.";
                    deniedForeverMsg="The app cannot run properly without access to device memory. Please grant memory access in settings.";
                    break;
                case WRITE_SETTINGS:
                    rationaleMsg="The game provides voice message and voice text conversion function, the game needs to use the modify settings permission";
                    deniedMsg="You have refused to grant access to modify settings permission. The service is not available.";
                    deniedForeverMsg="You have refused to grant access to modify settings permission. The service is not available. Please grant modify settings permission in settings.";
                    break;
            }
        }

        @Override
        public String getTitleText() {
            return "Attention";
        }
        @Override
        public String getPermissionRequestText() {
            return "ASK FOR PERMISSION";
        }
        @Override
        public String getConfirmText() {
            return "Yes";
        }
        @Override
        public String getExitGameText() {
            return "Exit Game";
        }
        @Override
        public String getSettingText() {
            return "Setting";
        }

        @Override
        public String getRationaleMsg() {
            return rationaleMsg;
        }

        @Override
        public String getDeniedMsg() {
            return deniedMsg;
        }

        @Override
        public String getDeniedForeverMsg() {
            return deniedForeverMsg;
        }

    }



    public static PermissionLang getInstance(Context context, final String[] permissions){

        Locale locale;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            locale = LocaleList.getDefault().get(0);
        } else {
            locale = Locale.getDefault();
        }

        String curLocale = locale.toString();
        System.out.println("-------------"+curLocale);
        if("zh_CN".equalsIgnoreCase(curLocale)){
            return new cnLang(permissions);
        }else if(curLocale.contains("en")) {
            return new cnLang(permissions);
        }else{
            return new cnLang(permissions);
        }
    }
}
