package com.bingougame.sdk;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnKeyListener;
import android.content.res.Resources;
import android.graphics.drawable.AnimationDrawable;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;

import com.bingougame.ws.R;

/**
 * 
 * 功能描述：自定义WaitingDialog
 *
 * @author 叶东瓒(yedongzan)
 *
 * <p>修改历史：(修改人，修改时间，修改原因/内容)</p>
 */
public class WaitingDialog implements OnKeyListener{

	private Context mContext;
	private int mT;
	private MyDialogDismissListener mListener;
	private LayoutInflater mInfalter;
	private int TIME_OUT = BGGConfig.TIME_OUT;
	private MyDialog mDialog;
	private MyCountDown mCountDown;
	private TextView mTV;
	private ImageView mIV;
	private View mView;
	private boolean mCanCancelable;
	private boolean mIsPay;

	public WaitingDialog(Context context) {
		this.mContext = context;
		init();
	}
	
	public WaitingDialog(Context context, int theme) {
		this.mContext = context;
		init();
	}

	private void init(){
		mCanCancelable = true;
		mIsPay = false;
		mInfalter = (LayoutInflater)mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

		mView = mInfalter.inflate(R.layout.tgsw_waiting_dialog,null);
		this.mTV = (TextView)mView.findViewById(R.id.tgsw_waiting_dialog_tv);
		this.mIV = (ImageView)mView.findViewById(R.id.tgsw_waiting_dialog_iv);
		mDialog = new MyDialog(mContext, R.style.tgsw_loading_dialog);
	}

	public void setMessage(String msg){
		this.mTV.setText(msg);
	}
	
	private class MyDialog extends Dialog{
		public MyDialog(Context context, int theme) {
			super(context, theme);
			initDialog();
		}
		
		private void initDialog(){
			this.setCanceledOnTouchOutside(false);
			this.setOnKeyListener(WaitingDialog.this);
			if(mView == null){
				Log.e("tgsw", "mVewi is null");
				return;
			}
			this.setContentView(mView);
		}
	}

	public boolean IsPay()
	{
		return mIsPay;
	}

	public void SetIsPay(boolean bIsPay)
	{
		mIsPay = bIsPay;
	}
	@Override
	public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
		if( !mCanCancelable ) return true;
		return false;
	}
	
//	public static void showWaitingDialog(WaitingDialog waitingDialog){
//		if(waitingDialog!=null){
//			waitingDialog.show();
//		}
//	}
	
//	public static void DismissWaitingDialog(WaitingDialog waitingDialog){
//		if(waitingDialog!=null&& mDialog.isShowing()){
//			waitingDialog.dismiss();
//		}
//	}
//	
//	public static void DestroyWaitingDialog(WaitingDialog waitingDialog){
//		DismissWaitingDialog(waitingDialog);
//		waitingDialog=null;
//	}
	
	/**
	 * 设置是否可以用返回键返回
	 * @param canFlag
	 */
	public void setCancelable(boolean canFlag)
	{
		mCanCancelable = canFlag;
	}

	private void fullScreenImmersive(View view) {
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
			int uiOptions = View.SYSTEM_UI_FLAG_LAYOUT_STABLE
					| View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
					| View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
					| View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY
					| View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
					| View.SYSTEM_UI_FLAG_FULLSCREEN;
			view.setSystemUiVisibility(uiOptions);
		}
	}

	public void show() {
		try {
			mDialog.getWindow().setFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE, WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);
			mDialog.show();
			fullScreenImmersive(mDialog.getWindow().getDecorView());
			mDialog.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE);

			AnimationDrawable ad = (AnimationDrawable)mIV.getBackground();
			ad.start();
			mCountDown = new MyCountDown(TIME_OUT, 1000);
			mCountDown.start();
			
//			mT = TIME_OUT;
//			mTimer = new Timer();
//			mTimer.schedule(new TimerTask() {
//				
//				@Override
//				public void run() {
//					if(mT-- == 0){
//						mHandler.sendEmptyMessage(1);
//					};
//					
//				}
//			}, 0,1000);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	public void dismiss() {
		try {
			if( mDialog != null && mDialog.isShowing())
				mDialog.dismiss();
			if(mCountDown != null){
				mCountDown.cancel();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void cancel() {
		try {
			if( mDialog != null && mDialog.isShowing())
				mDialog.cancel();
			
			if(mCountDown != null){
				mCountDown.cancel();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
	public void destory(){
		try {
			if( mDialog != null && mDialog.isShowing())
				mDialog.dismiss();
			if(mCountDown != null){
				mCountDown.cancel();
				mCountDown = null;
			}
			mHandler = null;
			mListener = null;
			mDialog = null;
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public interface MyDialogDismissListener{
		public void onTimeOutDismiss();
	}
	
	public void setDismissListener(int timeout, MyDialogDismissListener listener){
		TIME_OUT = timeout + 2;
		this.mListener = listener;
	}
	
	public void setDismissListener(MyDialogDismissListener listener){
		//设置默认超时时间
		TIME_OUT = BGGConfig.TIME_OUT;
		this.mListener = listener;
	}
	
	private Handler mHandler = new Handler(){
		public void handleMessage(android.os.Message msg) {
			if(mListener != null){
				mListener.onTimeOutDismiss();
			}
			dismiss();
		};
	};
	
	private class MyCountDown extends CountDownTimer {
		public MyCountDown(long millisInFuture, long countDownInterval) {
			super(millisInFuture, countDownInterval);
			// TODO Auto-generated constructor stub
		}
		
		@Override
		public void onTick(long millisUntilFinished) {
			// TODO Auto-generated method stub
		}

		@Override
		public void onFinish() {
			if( !this.ismCancelled() && mHandler != null)
				mHandler.sendEmptyMessage(1);
		}
	}
}
