package com.bingougame.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;

import java.util.HashMap;

/**
 * Created by kai on 2017/2/16.
 */

public class SdkManager {

    private static SdkManager instance;

    public ChannelInstance currentChannel;
    private HashMap<String, PluginInstance> plugins = new HashMap<String, PluginInstance>();

    public static SdkManager getInstance() {

        if (instance == null) {
            instance = new SdkManager();
        }

        return instance;
    }


    public PluginInstance getPlugin(String name) {
        return plugins.get(name);
    }


    public void registerPlugin(String name, PluginInstance plugin) {
        if (!plugins.containsKey(name)) {
            plugins.put(name, plugin);
            plugin.setName(name);
        }
    }


    public void init(Context context) {

        if (currentChannel != null) {
            currentChannel.init(context);
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.init(context);
            }
        }
    }

    public void onPause() {
        if (currentChannel != null) {
            currentChannel.onPause();
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onPause();
            }
        }
    }

    public void onDestroyBeforeGame() {
        if (currentChannel != null) {
            currentChannel.onDestroyBeforeGame();
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onDestroyBeforeGame();
            }
        }
    }

    public void onDestroyAfterGame() {
        if (currentChannel != null) {
            currentChannel.onDestroyAfterGame();
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onDestroyAfterGame();
            }
        }
    }

    public void onResume() {
        if (currentChannel != null) {
            currentChannel.onResume();
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onResume();
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        if (currentChannel != null) {
            currentChannel.onConfigurationChanged(newConfig);
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onConfigurationChanged(newConfig);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        // TODO Auto-generated method stub
        if (currentChannel != null) {
            currentChannel.onSaveInstanceState(outState);
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onSaveInstanceState(outState);
            }
        }
    }

    public void onWindowFocusChanged() {
        if (currentChannel != null) {
            currentChannel.onWindowFocusChanged();
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onWindowFocusChanged();
            }
        }
    }

    public void onActivityResult(
            int requestCode, int resultCode, Intent data)
    {
        if (currentChannel != null) {
            currentChannel.onActivityResult(requestCode, resultCode, data);
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onActivityResult(requestCode, resultCode, data);
            }
        }
    }

    public void onStart()
    {
        if (currentChannel != null) {
            currentChannel.onStart();
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onStart();
            }
        }
    }

    public void onNewIntent(Intent newIntent)
    {
        if (currentChannel != null) {
            currentChannel.onNewIntent(newIntent);
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onNewIntent(newIntent);
            }
        }
    }

    public void onStop()
    {
        if (currentChannel != null) {
            currentChannel.onStop();
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onStop();
            }
        }
    }

    public void onRestart()
    {
        if (currentChannel != null) {
            currentChannel.onRestart();
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onRestart();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults)
    {
        if (currentChannel != null) {
            currentChannel.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
        for (PluginInstance plugin : plugins.values()) {
            if (plugin.isEnable()) {
                plugin.onRequestPermissionsResult(requestCode, permissions, grantResults);
            }
        }
    }
    public void attachBaseContext(Context newBase) {
        if (currentChannel != null) {
            currentChannel.attachBaseContext(newBase);
        }
    }
    public void onBackPressed() {

    }
}
