package com.bingougame.sdk;

import android.content.Context;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.RequestParams;

import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HTTP;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;

/**
 * 
 * 功能描述：网络请求统一出口 URL：http://loopj.com/android-async-http/
 * 
 * @author 叶东瓒(yedongzan)
 * @date 2013-12-20下午6:04:46
 */
public class MyHttpClient extends AsyncHttpClient {
	private Context mContext;
	private BGGLog log = BGGLog.getInstance();
	/**
	 * 
	 * 构造函数：
	 * 
	 * @autor xumengyang
	 */
	public MyHttpClient(Context context) {
		this.mContext = context;
		this.setTimeout(15 * 1000);
		//this.setSSLSocketFactory();
	}

//	private  static MySSLSocketFactory getSocketFactory(Context context) {
//		// TODO Auto-generated method stub
//		MySSLSocketFactory sslFactory = null;
//		try {
//			KeyStore keyStore = KeyStore.getInstance("PKCS12");
//			InputStream instream = context.getResources().openRawResource(
//					R.raw.server);//后台拿到的.p12证书
//			keyStore.load(instream, "后台拿到的.p12证书密码".toCharArray());
//			sslFactory = new MySSLSocketFactory(keyStore);
//		} catch (KeyStoreException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		} catch (NoSuchAlgorithmException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		} catch (CertificateException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		} catch (IOException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		} catch (UnrecoverableKeyException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		} catch (KeyManagementException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		return sslFactory;
//	}

	/**
	 * 
	 * 功能描述：增加默认参数
	 * 
	 * @author 叶东瓒(yedongzan)
	 * @param @param params
	 * @return void
	 * @date 2013-12-22 下午2:36:38
	 * 
	 */
	private void addDefaultParams(RequestParams params) {
		// TODO
	}

	/**
	 * 
	 * 功能描述：发送Get请求
	 * 
	 * @author 叶东瓒(yedongzan)
	 * @param @param url
	 * @param @param params
	 * @param @param handler
	 * @return void
	 * @date 2013-12-22 下午2:41:11
	 * 
	 */
	public void get(String url, RequestParams params, MyAsyncResponseHandler handler) {
		String sign = null;
		if (!StringUtils.isEmpty(url)) {
			log.d("ur:" + url);
			log.d("params:"+params.toString());
		}
		super.get(url, params, handler);
	}
	
	public void post(String url, RequestParams params, MyAsyncResponseHandler handler){
		String sign = null;
		if (!StringUtils.isEmpty(url)) {
			log.d("ur:" + url);
			log.d("params:"+params.toString());
		}
		super.post(url, params, handler);
	}

	/**
	 *
	 * 功能描述：发送Post请求
	 *
	 * @author 叶东瓒(yedongzan)
	 * @param @param url
	 * @param @param map
	 * @param @param handler
	 * @return void
	 * @date 2014-1-22 上午11:57:48
	 *
	 *       修改历史 ：(修改人，修改时间，修改原因/内容)
	 */
	public void post(String url, JSONObject jsonObject, MyAsyncResponseHandler handler) {
		StringEntity se = null;
		if (!StringUtils.isEmpty(url)) {
			log.d("url = " + url);

			log.d("params:"+jsonObject.toString());
			String resultStr = jsonObject.toString();//
			resultStr = resultStr.replace("\"{", "{").replace("}\"", "}");
			resultStr = resultStr.replace("\\", "");
			log.d("params after:"+resultStr);
			try {
				se = new StringEntity(resultStr, HTTP.UTF_8);
			} catch (UnsupportedEncodingException e) {
				log.e(e);
			}
		}
		super.post(mContext, url, se, "application/json;charset=UTF-8", handler);
	}
}
