package com.bingougame.sdk;

import android.util.Log;

public class BGGLog {
	private static String TAG = "tgsw";
	private static BGGLog log;
	
	private BGGLog(){
		
	}
	
	/**
	 * 
	 * @return
	 */
	public static BGGLog getInstance(){
		if(log == null){
			log = new BGGLog();
		}
//		TAG=getCurrentInfo();
		return log;
	}

	private void debug(Object obj) {
		String funName = getFunName();
		String info = (funName == null ? obj.toString() : (funName + ":" + obj.toString()));
		Log.d(TAG, "BGG: ###"+info);
	}
	/**
	 * 当前日志行号
	 * @return
	 */
//	private static String getCurrentInfo() {
//
//		StackTraceElement[] eles = Thread.currentThread().getStackTrace();
//		StackTraceElement targetEle = eles[5];
//		String info = "(" + targetEle.getClassName() + "."
//				+ targetEle.getMethodName() + ":" + targetEle.getLineNumber()
//				+ ")";
//		return info;
//	}

	private void error(Exception exception) {
		try {
			Log.e(TAG, "BGG:", exception);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void error(Object obj) {
		try {
			if (obj != null) {
				String funName = getFunName();
				String info = (funName == null ? obj.toString() : (funName+ ":" + obj.toString()));
				Log.e(TAG, "BGG:"+info);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}


	private String getFunName() {
		StackTraceElement[] sts = Thread.currentThread().getStackTrace();
		if (sts == null) {
			return null;
		}
		for (StackTraceElement st : sts) {
			if (st.isNativeMethod()) {
				continue;
			}
			if (st.getClassName().equals(Thread.class.getName())) {
				continue;
			}
			if (st.getClassName().equals(this.getClass().getName())) {
				continue;
			}
			return "[" + Thread.currentThread().getId() + ":"
					+ st.getFileName() + ":" + st.getLineNumber() + "]";
		}
		return null;
	}

//	private String getTimerFileName() {
//		SimpleDateFormat simpledateformat = new SimpleDateFormat(FORMAT);
//		StringBuffer stringbuffer = new StringBuffer();
//		stringbuffer.append(simpledateformat.format(new Date())).append(
//				"Timer.log");
//		return stringbuffer.toString();
//	}

	private synchronized void verbose(Object obj) {
		String funName = getFunName();
		String info = (funName == null ? obj.toString() : (funName + ":" + obj
				.toString()));
		Log.v(TAG, "QMMG:"+info);
	}

	private synchronized void warn(Object obj) {
		String funName = getFunName();
		String info = (funName == null ? obj.toString() : (funName + ":" + obj
				.toString()));
		Log.w(TAG, "QMMG:"+info);
	}

	public synchronized void d(Object obj) {
		if (BGGConfig.DEBUG){
			debug(obj);
		}
	}

	public synchronized void e(Exception exception) {
		if (BGGConfig.EXCEPTION){
			error(exception);
		}
	}

	public synchronized void e(Object obj) {
		if (BGGConfig.ERROR){
			error(obj);
		}
	}

	public synchronized void i(Object obj) {
		if(BGGConfig.DEBUG){
			String funName = getFunName();
			String info = (funName == null ? obj.toString() : (funName + ":" + obj
					.toString()));
			Log.i(TAG,"BGG:"+info);
		}
	}

	public synchronized void v(Object obj) {
		if (BGGConfig.DEBUG){
			verbose(obj);
		}
	}

	public synchronized void w(Object obj) {
		if (BGGConfig.WARNING){
			warn(obj);
		}
	}

}
