package com.bingougame.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.util.Log;

import com.bingougame.tgsw.ChannelConst;
import com.bingougame.tgsw.UnityPlayerActivity;
import com.unity3d.player.UnityPlayer;
import com.vtcmobile.gamesdk.callback.OnrateappListener;
import com.vtcmobile.gamesdk.common.SplayAction;
import com.vtcmobile.gamesdk.core.SplayGameSDK;
import com.vtcmobile.gamesdk.core.SplayReceiver;
import com.vtcmobile.gamesdk.models.SplaySession;
import com.vtcmobile.gamesdk.models.SplayTransResult;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;

import static com.unity3d.player.UnityPlayer.UnitySendMessage;

import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

//import com.chujian.sdk.PayParams;
//import com.qk.game.MainActivity;


public class ChannelVietnam extends ChannelInstance  {
    public static final String LOG_TAG = "tgsw";
    public static final String LOCAL_ACTION = "com.bingougame.tgsw";
    private WaitingDialog mWaitingDialog;

    private Activity mActivity;
    private static ChannelVietnam mInstance;
    private String mCurrentRoleId = null;
    private String mCurrentServerId = null;

    private String mUserName = null;//用户名
    private String mUserId = null;//用户ID
    private String mOrderId = null;
    private JSONObject mCurrentPayInfo = null;
    private String mCurrentProductId = null;   //游戏订单号
    private boolean isAcceptPrva = false;
    private int mUnderAge = 0;
    private boolean IsInitSucc=false;
    private boolean mIsSwitchAccount=false;
    private String mChannelId=null;
    private String mToken=null;
    private String mRoleCreateTime = null;

    public static final String apiKey = "dd8ebea2be7567610c6c6c66038c4392";
    private String sandboxApiKey = "dd8ebea2be7567610c6c6c66038c4392";

    public static ChannelVietnam getInstance(){
        return mInstance;
    }

    private SplayGameSDK mSdk;

    public MyReceiver receiver;

    @Override
    public void init(Context context){
        super.init(context);

        mActivity = (Activity)context;
        mInstance = this;

        // 设置横竖屏，游戏横屏为true，游戏竖屏为false(必接)
        // QuickSDK.getInstance().setIsLandScape(isLandscape);
        BGGLog.getInstance().d("CWChannel init #1");

        receiver = new MyReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(SplayAction.LOGIN_SUCCESS_ACTION);
        filter.addAction(SplayAction.LOGIN_ERROR_ACTION);
        filter.addAction(SplayAction.LOGOUT_SUCCESS_ACTION);
        filter.addAction(SplayAction.LOGIN_CANCEL_ACTION);
        filter.addAction(SplayAction.LOGOUT_ERROR_ACTION);
        filter.addAction(SplayAction.PURCHASE_FINISHED_ACTION);
        LocalBroadcastManager.getInstance(mActivity).registerReceiver(receiver,filter);
        mSdk = SplayGameSDK.init(mActivity,apiKey,sandboxApiKey);

        BGGLog.getInstance().d("CWChannel init #2");
    }

    @Override
    public void onWindowFocusChanged() {
        super.onWindowFocusChanged();
    }


//    @Override
//    public void onCreate(Bundle savedInstanceState)
//    {
//        super.onCreate(savedInstanceState);   //todo
//    }

    @Override
    public void onStart() {
        super.onStart();
    }
    @Override
    public void onRestart() {
        super.onRestart();
    }
    @Override
    public void onPause() {
        super.onPause();
    }
    @Override
    public void onResume() {
        super.onResume();
    }
    @Override
    public void onStop() {
        super.onStop();
    }

    @Override
    public void onDestroyBeforeGame() {
        super.onDestroyBeforeGame();
    }

    @Override
    public void onDestroyAfterGame() {
        Log.d(LOG_TAG, "onDestroy");
        LocalBroadcastManager.getInstance(mActivity).unregisterReceiver(receiver);
        super.onDestroyAfterGame();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    @Override
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
    }
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }
    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public void onFinishLoaded(long duration)//加载时长
    {
    }
    //手动登出
    public void manualLogout() {
        BGGLog.getInstance().d("onRoleLogout #2");
        mSdk.logout(false);
    }
    public void RecordDot(String eventCode)
    {
    }
    public String login() {
        //Toast.makeText(mActivity, "============login=======" , Toast.LENGTH_LONG).show();
        BGGLog.getInstance().d("login");
//        if(!IsInitSucc){
//            BGGLog.getInstance().d("初始化失败");
//            showToastTips("初始化失败");
//            return null;
//        }
        //切换账号成功后不需要调用登陆接口   直接返回登录成功
        if(mIsSwitchAccount){
            mIsSwitchAccount=false;
            HashMap<String,String> Map = new HashMap<String,String>();
            Map.put("userId", mUserId);
            Map.put("userName", mUserName);
            Map.put("token", mToken);
            // Map.put("channelCode", Extend.getInstance().getChannelType()+"");
            BGGLog.getInstance().d("切换账号成功后 登陆成功");
            String SendStr = JsonParser.simpleMapToJsonStr(Map);
            UnityPlayer.UnitySendMessage("GameManagerObject", "SDKLoginSuccess", SendStr);

            return null;
        }

        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mSdk.showLoginForm();
            }
        });


        return null;
    }
    public  void onSwitchUser()
    {
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mSdk.logout(true);
            }
        });

    }
    public void deleteAccount()
    {
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mSdk.deleteUser();
            }
        });
    }
    public void showButtonInGame()
    {
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mSdk.showIngameButtonActivity();
            }
        });
    }
    public  void showImageActivityWhenCall()
    {
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mSdk.showImageActivityWhenCall();
            }
        });
    }
    public  void showRatingApp()
    {
        mSdk.rateApp(mActivity, new OnrateappListener() {
            @Override
            public void onSuccess(@Nullable String s) {
                UnityPlayer.UnitySendMessage("GameManagerObject", "OnReateAppResult", "1");
            }

            @Override
            public void onError(@Nullable String s) {
                UnityPlayer.UnitySendMessage("GameManagerObject", "OnReateAppResult", "0");
            }
        });
    }
    public void showUserCenter()
    {
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                BGGLog.getInstance().d("showUserCenter #1");
                //TODO 个人中心参数配置

            }
        });
    }
    public void onSaved(String uId, String userName, String roleId, String roleName, int level, int gender, int age, String gameServer) {
    }


    public class  MyReceiver extends SplayReceiver{

        @Override
        public void onLoginCancel() {
            BGGLog.getInstance().d("==tg1===onLoginCancel======");
            UnitySendMessage("GameManagerObject", "SDKLoginFail", "");
        }

        @Override
        public void onLoginError(@Nullable String s) {
            BGGLog.getInstance().d("==tg1===onLoginError===error is==="+s);
            UnitySendMessage("GameManagerObject", "SDKLoginFail", "");
        }

        @Override
        public void onLoginSuccess(@Nullable SplaySession user) {

            if(user ==null){
                BGGLog.getInstance().d("==tg1===onLoginSuccess====user==is==null==");
                return;
            }
            BGGLog.getInstance().d("==tg1===开始登录==");

            mUserId = user.userId;
            mUserName = user.userName;
            mToken = user.accessToken;

            HashMap<String,String> Map = new HashMap<String,String >();
            Map.put("userId", user.userId);
            // Map.put("sdkUserId",userInfo.getUID());
            Map.put("userName",user.userName);
            Map.put("token",user.accessToken);
            // Map.put("channelCode", Extend.getInstance().getChannelType()+"");
            // Map.put("Age",userInfo.getAge());
            BGGLog.getInstance().d("登陆成功");
            //Toast.makeText(mActivity, "登陆成功" , Toast.LENGTH_LONG).show();

            String SendStr = JsonParser.simpleMapToJsonStr(Map);

            UnityPlayer.UnitySendMessage("GameManagerObject", "SDKLoginSuccess", SendStr);

            Log.d("LOGTAG", SendStr);
        }

        @Override
        public void onLogoutError(@Nullable String s) {
            BGGLog.getInstance().d("==tg1===onLogoutError===error is ====" + s);
        }

        @Override
        public void onLogoutSuccess() {

            BGGLog.getInstance().d("==tg1===onLogoutSuccess #1");
            UnityPlayer.UnitySendMessage("GameManagerObject", "AndroidBackToLogin","");
        }

        @Override
        public void onPurchaseFinished(@Nullable String s, @Nullable SplayTransResult splayTransResult) {

        }
    }

    public void exitGame(){
        BGGLog.getInstance().d("exitGame.ShowExitGameMsgBox");
        // 游戏调用自身的退出对话框，点击确定后，调用quick的exit接口
        UnityPlayer.UnitySendMessage("GameManagerObject", "ShowExitGameMsgBox", "");
    }

    public void submitExtraData(String jsonData) {
        JSONObject jsonObject = null;
        try {
//            BGGLog.getInstance().d("submitExtraData=" + jsonData);
            jsonObject = new JSONObject(jsonData);
            //Toast.makeText(mContext, "jsonData=" + jsonData, Toast.LENGTH_LONG).show();

            if (!jsonObject.has("dataType")) {
                //只处理DT_LoadOver、DT_SaveUserData、createRole、levelUp
                //场景 分别为进入服务器(enterServer)、玩家创建用户角色(createRole)、玩家升级(levelUp)
                return;
            }
            int dataType = (int) jsonObject.getInt("dataType");
//            BGGLog.getInstance().d("dataType====" + dataType + "======jsonData=======" + jsonData);
            //如果不是"角色创建/角色升级",则不处理
//            if( !(dataType == DT_CreateRole || dataType == DT_LevelUp || dataType ==DT_EnterGame) ){
//                return;
//            }

            String roleId = "";
            if (jsonObject.has("roleID"))
                roleId = jsonObject.getString("roleID");

            String roleName = "";
            if (jsonObject.has("roleName"))
                roleName = jsonObject.getString("roleName");

            String roleLevel = "";
            if (jsonObject.has("roleLevel"))
                roleLevel = jsonObject.getString("roleLevel");

            String severId = "";
            if (jsonObject.has("serverID"))
                severId = jsonObject.getString("serverID");

            String severName = "";
            if (jsonObject.has("serverName"))
                severName = jsonObject.getString("serverName");

            String balance = "";
            if (jsonObject.has("leftYuanBao"))
                balance = jsonObject.getString("leftYuanBao");

            String Vip = "";
            if (jsonObject.has("vipLevel"))
                Vip = jsonObject.getString("vipLevel");
            else{
//                BGGLog.getInstance().d("Vip=====null====");
                Vip = "0";
            }

            String partyName = "";
            if (jsonObject.has("partyName"))
                partyName = jsonObject.getString("partyName");

            String roleCTime = "";
            if (jsonObject.has("roleCreateTime"))
            {
                roleCTime = jsonObject.getString("roleCreateTime");

                mRoleCreateTime =roleCTime;
            }

//            if("" != severId) {
//                roleInfo.setServerID(severId);  //服务器ID（数字字符串）
//            }
//            if("" != severName) {
//                roleInfo.setServerName(severName); //服务器名称
//            }
//            if("" != roleName) {
//                roleInfo.setGameRoleName(roleName); //角色名称
//            }
//            if("" != roleId) {
//                roleInfo.setGameRoleID(roleId); //角色ID
//            }
//            roleInfo.setGameBalance(balance); //角色用户余额
//            if("" != Vip) {
//                roleInfo.setVipLevel(Vip); //VIP等级
//            }
//            roleInfo.setGameUserLevel(roleLevel); //角色用户等级
//            roleInfo.setRoleCreateTime(roleCTime); //角色创建时间 （10位数的unix timestamp时间戳）
//
//            roleInfo.setPartyName("partyName"); //公会社团
//            roleInfo.setPartyId("partyId"); //帮派ID
//            roleInfo.setGameRoleGender("roleSex"); //角色性别
//            roleInfo.setGameRolePower("rolePower"); //战力
//            roleInfo.setPartyRoleId("0"); //角色所在帮派中的ID
//            roleInfo.setPartyRoleName("0"); //角色在帮派中的名称
//            roleInfo.setPartyRoleId("0"); //角色职业ID
//            roleInfo.setProfession("0"); //角色职业名称
//            roleInfo.setFriendlist("0"); //好友关系列表

//            BGGLog.getInstance().d(dataType+"==================submitExtraData================" + roleInfo.getGameRoleID()+"=====" + roleInfo.getGameRoleName() + "=========="+severId +"======="+roleInfo.getServerID()+"======"+roleInfo.getVipLevel()+"========"+roleCTime+"===="+roleInfo.getRoleCreateTime());

            switch (dataType)
            {
                case ChannelConst.DT_LoadOver:
                {

                }
                break;
                case ChannelConst.DT_CreateRole:
                {
//                    BGGLog.getInstance().d("onRoleCreated");
                }
                break;
                case ChannelConst.DT_EnterGame:
                {
                    //角色登录，此时已经进入了场景
//                    BGGLog.getInstance().d("RoleLoggedinEvent");
                }
                break;
                case ChannelConst.DT_LevelUp:
//                    BGGLog.getInstance().d("GameLevelChangedEvent nowLevel=" + roleLevel);
                    break;
            }


        } catch (JSONException e) {
            e.printStackTrace();
            BGGLog.getInstance().d(jsonData+"   " + e.getMessage());
        }
    }



    /**
     * 支付
     */
    public String pay(String orderData) {
        try {
            //Toast.makeText(mActivity, "=====pay==orderData==="+orderData , Toast.LENGTH_LONG).show();
            JSONObject jsonObject = new JSONObject(orderData);
            mCurrentPayInfo = jsonObject;
            mCurrentProductId = jsonObject.getString("productId");
            requestOrderId();;
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    private  void requestPayParams(JSONObject jsonObject){
        if(jsonObject ==null){
            //Toast.makeText(mActivity, "jsonObject ==null" , Toast.LENGTH_LONG).show();
            return;
        }
        try {
            // Toast.makeText(mActivity, "========jrequestPayParams==========="+jsonObject , Toast.LENGTH_LONG).show();
//            BGGLog.getInstance().d("== pay=="+jsonObject);
            mCurrentProductId = jsonObject.getString("productId");
            String productName = jsonObject.getString("productName");
            int productCount = jsonObject.getInt("productCount");
            int price = jsonObject.getInt("price");
            String prodectDes = jsonObject.getString("productDesc");
            int leftCoinCount = jsonObject.getInt("leftCoinCount");
            String roleId = jsonObject.getString("roleId");
            int roleLevel = jsonObject.getInt("roleLevel");
            String roleName = jsonObject.getString("roleName");
            String serverId = jsonObject.getString("serverId");
            String serverName = jsonObject.getString("serverName");
            String vipLevel = jsonObject.getString("vipLevel");
            String platformProductId = jsonObject.getString("platformProductId");
//            String vouchNum = jsonObject.getString("vouchNum");
            //String createRoleTime = jsonObject.getString("createRoleTime");
            //String balance=jsonObject.getString("leftYuanBao");
            //String exteraParams  //透传参数，服务器发送异常异步通知时原样传回
            // serverID/roleId

            mSdk.buyInAppItem(platformProductId, mOrderId);
        } catch (Exception e) {
            e.printStackTrace();
            BGGLog.getInstance().d("productPay Excelption:" + e.getStackTrace());
        }
    }

    //请求订单号
    public void requestOrderId(){
        //向unity游戏发送订单号请求
        BGGLog.getInstance().d("requestOrderId");
        HashMap<String,String> Map = new HashMap<String,String >();
        Map.put("productId", mCurrentProductId);

        String SendStr = JsonParser.simpleMapToJsonStr(Map);
        UnitySendMessage("GameManagerObject", "OnRequestOrderId", SendStr);
    }
    //设置订单号
    public void setOrderId(String orderId) {

        try {
            //Toast.makeText(mActivity, "=====setOrderId====="+orderId , Toast.LENGTH_LONG).show();
            BGGLog.getInstance().d("=====setOrderId====="+orderId);
            if(orderId ==null || orderId.trim().length() <= 0){
                // Toast.makeText(mActivity, "=====请求订单号失败，请重试=====" , Toast.LENGTH_LONG).show();
                showToastTips("请求订单号失败，请重试");
                return;
            }

            this.mOrderId = orderId;
            requestPayParams();
        }catch (Exception e){
            e.printStackTrace();
            //Toast.makeText(mActivity, "=====setOrderId====="+orderId , Toast.LENGTH_LONG).show();
        }

//        BGGLog.getInstance().d("### setOrder:" + orderId);
//        this.mCurrentProductId = orderId;
//        requestPayParams(mCurrentPayInfo);  //产品订单编号从服务器GC生成
    }
    private void requestPayParams()
    {
        cjPay(mCurrentPayInfo);
    }
    private void cjPay(final JSONObject jsonObject){
        if( jsonObject == null) return;
        BGGLog.getInstance().d("Pay params1=" + jsonObject.toString());
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                requestPayParams(jsonObject);
            }
        });

    }

    //获取渠道类型
    public int getChannelType(){
        return 1001;//Extend.getInstance().getChannelType();
    }

    public void stopWaiting() {
        if (mActivity == null) return;
    }

    public void showToastTips(final String tips) {
        if (mActivity == null) return;

        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if( mContext != null && tips != null){
                    //Toast.makeText((Activity) mContext, tips, Toast.LENGTH_SHORT).show();
                    BGGLog.getInstance().d("mContext != null && tips != null==== + tips");
                }
                else
                {
                    if( mContext == null )
                        BGGLog.getInstance().d("showToastTips mContext==null");
                    if( tips == null )
                        BGGLog.getInstance().d("showToastTips tips==null");
                }
            }
        });
    }
    public void startWaiting(final String msg, final boolean bIsPay) {
        if (mActivity == null) return;

        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Log.d(LOG_TAG, "startWaiting");

            }
        });
    }

    //获取实名信息
    public void getRealNameInfo() {
        BGGLog.getInstance().d("getRealNameInfo start");
        startWaiting("正在请求实名信息...", false);
    }
    public void Dot(String jsonData) {
        JSONObject jsonObject = null;
        try{
            jsonObject = new JSONObject(jsonData);
            if (!jsonObject.has("event_type")) {
                //只处理DT_LoadOver、DT_SaveUserData、createRole、levelUp
                //场景 分别为进入服务器(enterServer)、玩家创建用户角色(createRole)、玩家升级(levelUp)
                return;
            }
            String event_type = jsonObject.getString("dataType");
            if( "UPDATE_RESOURCES_SUCCESS".equals(event_type) )
            {
                mSdk.trackEvent(mActivity, "vtc_complete_first_update");
                return;
            }
            if( "ACHIEVED_FIRST_LEVEL".equals(event_type))
            {
                mSdk.trackFirstCompleteLevel(mActivity, mUserId,true);
                return;
            }
            if( "COMPLETE_TUTORIAL".equals(event_type))
            {
                mSdk.trackCompleteTutorial(mActivity,mUserId,true);
                return;
            }
            if( "COMPLETE_OVER_TUTORIAL".equals(event_type))
            {
                mSdk.trackCompleteOverTutorial(mActivity,mUserId,true);
                return;
            }
            if( "COMPLETE_LOAD_SDK".equals(event_type))
            {
                mSdk.trackEvent(mActivity,"vtc_complete_extract_obb");
                return;
            }
            if( "COMPLETE_LOAD_SVR_LIST".equals(event_type))
            {
                mSdk.trackEvent(mActivity,"vtc_complete_load_server_list");
                return;
            }

            if( "COMPELETE_CREATE_ROLE".equals(event_type))
            {
                mSdk.trackEvent(mActivity,"vtc_complete_create_role");
                return;
            }
            if( "COMPELETE_LOAD_ROLE".equals(event_type))
            {
                mSdk.trackEvent(mActivity,"vtc_complete_load_role");
                return;
            }
            if( "LOGIN_EVENT".equals(event_type))
            {
                String ServerID = jsonObject.getString("ServerID");
                String roleID = jsonObject.getString("roleID");
                String roleName = jsonObject.getString("roleName");
                mSdk.trackRoleLogin(ServerID, roleID, roleName);
                return;
            }
            if( "LEVEL_ACHIEVED_EVENT".equals(event_type))
            {
                String level = jsonObject.getString("level");
                mSdk.trackLevelAchieved(Integer.parseInt(level));
                return;
            }
            if( "SPENT_VIRTUAL_EVENT".equals(event_type))
            {
                String money = jsonObject.getString("money");
                mSdk.trackSpentVirtualCurrency(Integer.parseInt(money),money);
                return;
            }
            if( "USER_GET_MONEY".equals(event_type))
            {
                String money = jsonObject.getString("money");
                mSdk.sendTotalMoneyPurchaseOfUser(Long.parseLong(money));
                return;
            }
            mSdk.trackEvent(mActivity, event_type);
        } catch (JSONException e) {
            e.printStackTrace();
            BGGLog.getInstance().d(jsonData+"   " + e.getMessage());
        }
    }

    //手动登录
    public void ysdkStartLogin(final int platformId) {

    }
    public String getCurrChannel()
    {
        return "1001";
    }

    public void getEventData(String jsonData)
    {
        try {
//            BGGLog.getInstance().d("getEventData=" + jsonData);
//            BGGLog.getInstance().d("getEventData=" + jsonData);
            JSONObject jsonObject = new JSONObject(jsonData);
            if( !jsonObject.has("event_type"))
            {
                return;
            }

            String dataType = jsonObject.getString("event_type");

            //打Log方法
            //若該事件無數值需要傳遞，只需傳入事件名稱即可：
            //logger.logEvent(NPEventConstants.EVENT_NAME_GAME_QUIT);
            //若事件有數值需要傳遞，將數值加入Bundle：
            //Bundle parameters = new Bundle();
            //parameters.putString(NPEventConstants.EVENT_PARAM_ROLE_CREATE_TYPE, "0");
            //logger.logEvent(NPEventConstants.EVENT_NAME_ROLE_CREATE, parameters);


            String SERVER_ID = "";
            String ROLE_ID = "";
            String ROLE_CREATE_TYPE = "";
            String MISSION_TYPE = "";
            String MISSION_STATUS = "";
            String MISSION_ID = "";
            String LEVEL_TYPE = "";
            String LEVEL_AMOUNT = "";
            String CHANNEL_TYPE = "";
            String CHANNEL_AMOUNT = "";
            String CURRENCY = "";
            String USER_LEVEL = "";
            double valueToSum = 0;
            String PURCHASE_COIN_TYPE = "";
            String PURCHASE_AMOUNT = "";
            String PURCHASE_ITEM_ID = "";
            String ITEM_AMOUNT = "";
            String SOURCE = "";
            String USE_ITEM_ID = "";
            String USE_ITEM_AMOUNT = "";
            String UID = "";
            String DAILY_CHECK_AMOUNT = "";
            String SKILL_ID = "";
            String SKIILL_LEVEL = "";
            String TEAM_ID = "";
            String ACTIVITY_ID = "";
            String USER_CP = "";
            String USER_VIPLEVEL = "";
            String USER_CASH_POINT = "";
            String USER_GAME_POINT = "";
            String GIFT_ITEM_ID = "";
            String STAGE_ID = "";
            String STAGE_STATUS = "";
            String PASS_NUM = "";
            String BUTTON_ID = "";
            String BUTTON_NAME = "";
            String BUTTON_CLASS = "";
            String ACTIVITY_NAME = "";
            String ACTIVITY_CLASS = "";
        }
        catch (JSONException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
            BGGLog.getInstance().d(e.getMessage());
        }
    }




    /// 访问资源服务器请求
    public void resourceServerVisit(String url, String resourceId)
    {
        BGGLog.getInstance().d("resourceServerVisit");
    }

    /// 版本号检查
    public void appVersionCheck(String version)
    {
        BGGLog.getInstance().d("appVersionCheck");
    }

    /// 资源加载
    public void resourceLoading(String resourceId)
    {
        BGGLog.getInstance().d("resourceLoading");
    }

    /// 资源升级开始
    public void resourceUpdateStart(String resourceId)
    {
        BGGLog.getInstance().d("resourceUpdateStart");
    }

    /// 资源升级结果
    public  void resourceUpdate(String resourceId, String result)
    {
        BGGLog.getInstance().d("resourceUpdateStart");
    }

    /// 服务列表拉取结果
    public void gameServerListed(String daquId, String qufuId, String result)
    {
        BGGLog.getInstance().d("gameServerListed");
    }

    /// 服务器登录
    public void gameServerLoggedin(String result)
    {
        BGGLog.getInstance().d("gameServerLoggedin");
    }

    /// 角色登录请求
    public void roleLoginRequested(String roleID, String serverID)
    {
        BGGLog.getInstance().d("RoleLoginRequested");
    }

    /// 角色加入公会
    public void joinUnion()
    {
        BGGLog.getInstance().d("joinUnion");
    }

    /// 任务完成节点
    public void gameTaskMoveEvent(String desc)
    {
        BGGLog.getInstance().d("gameTaskMoveEvent:" + desc);
    }

    public void getBindCheck(){
        BGGLog.getInstance().d("getBindCheck");
    }

    public void getPhoneAreaCode(){
        BGGLog.getInstance().d("getPhoneAreaCode");
    }
    public void getBindPhoneAccount( String areaCode, String phone, String smsCode){
        BGGLog.getInstance().d("getBindPhoneAccount");}

    public void getVerifyCodeCheck(String areaCode, String phone){
        BGGLog.getInstance().d("getVerifyCodeCheck");}
    public void ShowQuestion(){
        BGGLog.getInstance().d("ShowQuestion");
    }

    public void InitProduct(){
        BGGLog.getInstance().d("InitProduct");
    }
    public void setFiveStarDialogListener(String roleId, String serverId){
        BGGLog.getInstance().d("SetFiveStarDialogListener");
    }
    public void RequestRealNameInfo(){
        BGGLog.getInstance().d("RequestRealNameInfo");
    }
    public void closeHudTips(){
        BGGLog.getInstance().d("closeHudTips");
    }

    //启动oppo社区中心
    public void launchOppoForum()
    {
    }

    //启动vivo社区中心
    public void launchVivoForum()
    {
    }
    public boolean isFromOppoGameCenter()
    {
        return UnityPlayerActivity.mIsFromGameCenter;
    }
    public void requestOppoVipInfo()
    {
    }
    public void performFeature(final String type)
    {
    }
    public void onFirstPurchase()
    {
        BGGLog.getInstance().d("onFirstPurchase");
    }
    public void onBeginPlay() {
    }

    public void onChargeCallBack(String orderId, String iapId, int currencyAmount, String currencyType, double virtualCurrencyAmout, String paymentType, int state) {
    }

    public void onSelectRole(String roleName) {
    }
}
