package com.bingougame.sdk;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import com.bingougame.tgsw.UnityPlayerActivity;
import com.brsdk.android.core.BRSdkApi;

/**
 * Created by kai on 2017/2/9.
 */

public class SdkSplashActivity extends Activity {

    //TODO 选择java还是cpp
    private static String LOG_TAG = "tgsw SplashActivity";
    private static Activity mActivity;

    private boolean m_bEnteredGame = false;
    private boolean sdDenied = false;
    private static boolean m_bShowingTips = false;
    private boolean m_bForcePermissionGranted = false;
    private boolean m_bUseChujianPermissionTool = true;
//    private ResourceUtil m_resourceUtils;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        BGGLog.getInstance().d("onCreate");
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
//        setContentView(R.layout.splash_layout);
        // TODO GAME 游戏需自行检测自身是否重复, 检测到重复的Activity则要把自己finish掉
        // 注意：游戏需要加上去重判断以及finish重复的实例的逻辑，否则可能发生重复拉起游戏的问题。
        if (null != mActivity && !mActivity.equals(this)) {
            this.finish();
            return;
        }

        mActivity = this;
        ChannelLianyun.RegisterListener();//联运版本需要在sdk所有操作前执行

        if (!PermmisionUtil.applyPermission(this)) {
            ChannelLianyun.InitSdk();//成功后回调onInitSuccess
            StartGame();
            return;
        }
        ChannelLianyun.InitSdk();//成功后回调onInitSuccess
    }
    /*
    * sdk初始化成功
    * */
    public  static  void onInitSuccess()
    {
        if (!loadFlag()) {
            m_bShowingTips = true;
            BRSdkApi.getInstance().showProtocol();//成功后回调onProtocolSuccess
        }
    }
    /*
    * 同意隐私条款后的回调，可在该回调获取权限或者设备信息
    * */
    public static void onProtocolSuccess()
    {
        saveFlag(true);
        PermmisionUtil.ApplyPerm(mActivity);
    }
    public void StartGame() {
        if (!m_bEnteredGame) {
            m_bEnteredGame = true;
            Intent intent = new Intent();
            intent.setClass(SdkSplashActivity.this, UnityPlayerActivity.class);
            mActivity.startActivity(intent);
            SdkSplashActivity.this.finish();
//            Handler handler = new Handler();
//            handler.postDelayed(new Runnable() {
//                @Override
//                public void run() {
//                    Log.d("tgsw", "SdkSplashActivity.this.finish();");
//                    SdkSplashActivity.this.finish();
//                }
//            }, 3000);
        }

    }
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        BRSdkApi.getInstance().onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (PermmisionUtil.onRequestPermissionsResult(requestCode, permissions, grantResults, this)) {
            BGGLog.getInstance().d("onRequestPermissionsResult success.");
            StartGame();
        }
    }
    private static final String DATA_NAME = "data";
    private static final String FLAG_NAME = "warmprompt";
    private static void saveFlag(boolean isConfirm) {
        SharedPreferences.Editor edit = mActivity.getSharedPreferences(DATA_NAME, MODE_PRIVATE).edit();
        edit.putBoolean(FLAG_NAME, isConfirm);
        edit.apply();
    }
    private static boolean loadFlag() {
        SharedPreferences sp = mActivity.getSharedPreferences(DATA_NAME, MODE_PRIVATE);
        return sp.getBoolean(FLAG_NAME, false);
    }
}
