package com.bingougame.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.util.Log;
import com.bingougame.sdk.plugins.JsonParser;
import com.bingougame.tgsw.UnityPlayerActivity;
import com.brsdk.android.bean.BRSdkPay;
import com.brsdk.android.bean.BRSdkRole;
import com.brsdk.android.bean.BRSdkState;
import com.brsdk.android.bean.BRSdkUser;
import com.brsdk.android.core.BRSdkApi;
import com.brsdk.android.data.a;
import com.brsdk.android.event.BREventListener;
import com.brsdk.android.utils.BRUtils;
import com.loopj.android.http.AsyncHttpClient;
import com.unity3d.player.UnityPlayer;
import org.json.JSONException;
import org.json.JSONObject;
import java.util.HashMap;
import static com.unity3d.player.UnityPlayer.UnitySendMessage;

public class ChannelLianyun extends ChannelInstance {
    private AsyncHttpClient mHttpClient;
    public static final String LOG_TAG = "tgsw";
    public static final String LOCAL_ACTION = "com.bingougame.tgsw";
    private WaitingDialog mWaitingDialog;

    private Activity mActivity;
    private static ChannelLianyun mInstance;
    private String mCurrentRoleId = null;
    private String mCurrentServerId = null;

    private String mUserName = null;//用户名
    private String mUserId = null;//用户ID
    private String mOrderId = null;
    private JSONObject mCurrentPayInfo = null;
    private BRSdkRole  mRoleInfo = new BRSdkRole();
    private String mCurrentProductId = null;   //游戏订单号
    private boolean isAcceptPrva = false;
    private int mUnderAge = 0;
    private boolean IsInitSucc=false;
    private boolean mIsSwitchAccount=false;
    private String mToken=null;
    private String mRoleCreateTime = null;

    public static final String mProductCode = "85925103228334879295963797584312";
    private String mProductKey = "91542675";
    private int mChannelId = 0;

    public static ChannelLianyun getInstance(){
        return mInstance;
    }

    @Override
    public void init(Context context){
        super.init(context);
        QKDot.Instance().RecordDot("SDKInit");

        mActivity = (Activity)context;
        mInstance = this;
        InitChannelId();
    }
    void InitChannelId() {
        try {
            String configJson = BRUtils.readAssetsString(a.d);
            JSONObject jsonObject = new JSONObject(configJson);
            mChannelId = jsonObject.getInt("ChannelId");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        BGGLog.getInstance().d(String.format("### InitChannelId %s",mChannelId));
    }
    @Override
    public void onWindowFocusChanged() {
        super.onWindowFocusChanged();
    }


//    @Override
//    public void onCreate(Bundle savedInstanceState)
//    {
//        super.onCreate(savedInstanceState);   //todo
//    }

    @Override
    public void onStart() {
        super.onStart();
//        Sdk.getInstance().onStart(mActivity);
    }
    @Override
    public void onRestart() {
        super.onRestart();
//        Sdk.getInstance().onRestart(mActivity);
    }
    @Override
    public void onPause() {
        super.onPause();
//        Sdk.getInstance().onPause(mActivity);
    }
    @Override
    public void onResume() {
        super.onResume();
//        Sdk.getInstance().onResume(mActivity);
    }
    @Override
    public void onStop() {
        super.onStop();
//        Sdk.getInstance().onStop(mActivity);
    }

    @Override
    public void onDestroyBeforeGame() {
        super.onDestroyBeforeGame();
    }

    @Override
    public void onDestroyAfterGame() {
        Log.d(LOG_TAG, "onDestroy");

        super.onDestroyAfterGame();
//        com.quicksdk.Sdk.getInstance().onDestroy(mActivity);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    @Override
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
//        Sdk.getInstance().onNewIntent(intent);
    }
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        BRSdkApi.getInstance().onActivityResult(requestCode,resultCode,data);
    }
    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public void onFinishLoaded(long duration)//加载时长
    {
    }
    //手动登出
    public void logout() {
        BRSdkApi.getInstance().onLogout();
    }
    public void RecordDot(String eventCode)
    {
        QKDot.Instance().RecordDot(eventCode);
    }
    public String login() {
        //切换账号成功后不需要调用登陆接口   直接返回登录成功
        if(mIsSwitchAccount){
            mIsSwitchAccount=false;
            HashMap<String,String> Map = new HashMap<String,String>();
            Map.put("userId", mUserId);
//            Map.put("userName", mUserName);
            Map.put("token", mToken);
            Map.put("channelCode", this.getCurrChannel()+"");
            BGGLog.getInstance().d("切换账号成功后 登陆成功");
            String SendStr = JsonParser.simpleMapToJsonStr(Map);
            UnityPlayer.UnitySendMessage("GameManagerObject", "SDKLoginSuccess", SendStr);
            return null;
        }
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                BRSdkApi.getInstance().onLogin();
            }
        });


        return null;
    }

    public void showUserCenter()
    {
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                BGGLog.getInstance().d("showUserCenter #1");
                //TODO 个人中心参数配置

            }
        });
    }
    public void onSaved(String uId, String userName, String roleId, String roleName, int level, int gender, int age, String gameServer) {
    }
    /**
     * 设置通知，用于监听初始化，登录，注销，支付及退出功能的返回值
     */
    static  public  void InitSdk()
    {
        BRSdkApi.getInstance().onInit();
    }
    static public void RegisterListener() {
        BRSdkApi.getInstance().setEventListener(new BREventListener(){
            // 用户协议回调
            // 当调用BRSdkApi.getInstance().showProtocol();后才会触发
            @Override
            public void onProtocolEnd(BRSdkState state) {
                BGGLog.getInstance().d("### onProtocolEnd "+state.getCode());
                if (state.getCode() == BRSdkState.Code.success) {
                    SdkSplashActivity.onProtocolSuccess();
                    // 用户同意协议；开始进入游戏&初始化SDK
                    // 复制代码的时候注意这里有个初始化调用，请勿多次调用
//                    BRSdkApi.getInstance().onInit();
                } else {
                    // 用户拒绝协议；SDK内部会在这之后自动退出游戏
                }
            }
            // 初始化结束
            // 当调用BRSdkApi.getInstance().onInit();后才会触发
            @Override
            public void onInitFinished(BRSdkState state) {
                BGGLog.getInstance().d("### onInitFinished "+state.getCode());
                if (state.getCode() == BRSdkState.Code.success) {
                    SdkSplashActivity.onInitSuccess();
                } else {
                    // SDK初始化失败
                }
            }
            // 登录结束
            // 当调用BRSdkApi.getInstance().onLogin();后才会触发
            @Override
            public void onLoginFinished(BRSdkState state, BRSdkUser user) {
                BGGLog.getInstance().d("### onLoginFinished "+state.getCode());
                if (state.getCode() == BRSdkState.Code.success) {
                    ChannelLianyun.getInstance().mUserId = user.getUid();
                    ChannelLianyun.getInstance().mToken = user.getToken();
                    // SDK用户登录成功；登录成功之后进行游戏后续逻辑
                    HashMap<String,String> Map = new HashMap<String,String>();
                    Map.put("userId", user.getUid());
//                    Map.put("userName", mUserName);
                    Map.put("token", user.getToken());
                    Map.put("sessionId",user.getToken());
                    Map.put("channelCode", ChannelLianyun.getInstance().getCurrChannel());
                    String SendStr = JsonParser.simpleMapToJsonStr(Map);
                    UnityPlayer.UnitySendMessage("GameManagerObject", "SDKLoginSuccess", SendStr);
                } else {
                    ChannelLianyun.getInstance().mUserId = "";
                    ChannelLianyun.getInstance().mToken = "";
                    UnityPlayer.UnitySendMessage("GameManagerObject", "SDKLoginFail", "");
                }
            }
            // 支付结束
            // 当调用BRSdkApi.getInstance().onPay();后才会触发
            @Override
            public void onPayFinished(BRSdkState state, BRSdkPay pay) {
                BGGLog.getInstance().d("### onPayFinished "+state.getCode());
                if (state.getCode() == BRSdkState.Code.success) {
                    UnityPlayer.UnitySendMessage("GameManagerObject", "OnPayCallBack", pay.getProductId());
                    // 订单支付成功
                } else if (state.getCode() == BRSdkState.Code.cancel) {
                    // 订单支付取消
                } else {
                    // 订单支付失败
                }
            }
            // 上传角色结束
            // 当调用BRSdkApi.getInstance().onUpRole();后才会触发
            @Override
            public void onUpRoleFinished(BRSdkState state, BRSdkRole role) {
                if (state.getCode() == BRSdkState.Code.success) {
                    // 角色信息上传成功
                } else {
                    // 角色信息上传失败
                }
            }
            // 退出登录结束
            // 当调用BRSdkApi.getInstance().onLogout();后才会触发
            @Override
            public void onLogoutFinished(BRSdkState state) {
                BGGLog.getInstance().d("### onLogoutFinished "+state.getCode());
                if (state.getCode() == BRSdkState.Code.success) {
                    ChannelLianyun.getInstance().mUserId = "";
                    ChannelLianyun.getInstance().mToken = "";
                    // 用户账户退出成功；需要退出到入口游戏；并且再次拉起SDK登录
//                    BRSdkApi.getInstance().onLogin();
                    UnityPlayer.UnitySendMessage("GameManagerObject", "AndroidBackToLogin","");
                } else {
                    // 用户账户退出失败（一般不会失败）
                }
            }
            // 退出应用结束
            // 当调用BRSdkApi.getInstance().onExit();后才会触发
            @Override
            public void onExitFinished(BRSdkState state) {
                BGGLog.getInstance().d("### onExitFinished "+state.getCode());
                if (state.getCode() == BRSdkState.Code.success) {
                    // 退出应用成功；游戏可以在这里做相关数据保存；在这之后SDK自动退出游戏
                } else if (state.getCode() == BRSdkState.Code.cancel) {
                    // 取消退出应用
                } else {
                    // 应用退出失败（一般不会失败）
                }
            }
        });
    }

    public void exitGame(){
        BRSdkApi.getInstance().onExit();
    }
    public void vipLevelChange(String vipStr)
    {
        if(null != roleInfo) {
            roleInfo.setVipLevel(vipStr); //VIP等级
        }
    }
    BRSdkRole  roleInfo = new BRSdkRole ();

    /**
     * 支付
     */
    public String pay(String orderData) {
        try {
            //Toast.makeText(mActivity, "=====pay==orderData==="+orderData , Toast.LENGTH_LONG).show();
            JSONObject jsonObject = new JSONObject(orderData);
            mCurrentPayInfo = jsonObject;
            mCurrentProductId = jsonObject.getString("productId");
            requestOrderId();;
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    private  void requestPayParams(JSONObject jsonObject){
        if(jsonObject ==null){
            //Toast.makeText(mActivity, "jsonObject ==null" , Toast.LENGTH_LONG).show();
            return;
        }
        try {
           // Toast.makeText(mActivity, "========jrequestPayParams==========="+jsonObject , Toast.LENGTH_LONG).show();
//            BGGLog.getInstance().d("== pay=="+jsonObject);
            mCurrentProductId = jsonObject.getString("productId");
            String productName = jsonObject.getString("productName");
            int productCount = jsonObject.getInt("productCount");
            int price = jsonObject.getInt("price");
            String prodectDes = jsonObject.getString("productDesc");
            int leftCoinCount = jsonObject.getInt("leftCoinCount");
            String roleId = jsonObject.getString("roleId");
            int roleLevel = jsonObject.getInt("roleLevel");
            String roleName = jsonObject.getString("roleName");
            String serverId = jsonObject.getString("serverId");
            String serverName = jsonObject.getString("serverName");
            String vipLevel = jsonObject.getString("vipLevel");
            String platformProductId = jsonObject.getString("platformProductId");
//            String vouchNum = jsonObject.getString("vouchNum");
            //String createRoleTime = jsonObject.getString("createRoleTime");
            //String balance=jsonObject.getString("leftYuanBao");
            //String exteraParams  //透传参数，服务器发送异常异步通知时原样传回
            // serverID/roleId

            BRSdkPay pay = new BRSdkPay();
            pay.setProductId(platformProductId);
            pay.setProductName(productName);
            pay.setProductPrice(""+price);
            pay.setProductCount(""+productCount);
            pay.setProductDesc(prodectDes);

            pay.setServerId(serverId);
            pay.setServerName(serverName);
            pay.setRoleId(roleId);
            pay.setRoleName(roleName);
            pay.setRoleLevel(""+roleLevel);
            pay.setVipLevel(vipLevel);
            pay.setExtInfo(this.mOrderId+ "/"+this.getCurrChannel() + "/" + this.mCurrentProductId);
            BRSdkApi.getInstance().onPay(pay);
        } catch (Exception e) {
            e.printStackTrace();
            BGGLog.getInstance().d("productPay Excelption:" + e.getStackTrace());
        }
    }

    //请求订单号
    public void requestOrderId(){
        //向unity游戏发送订单号请求
        BGGLog.getInstance().d("requestOrderId");
        HashMap<String,String> Map = new HashMap<String,String >();
        Map.put("productId", mCurrentProductId);

        String SendStr = JsonParser.simpleMapToJsonStr(Map);
        UnitySendMessage("GameManagerObject", "OnRequestOrderId", SendStr);
    }
    //设置订单号
    public void setOrderId(String orderId) {

        try {
            //Toast.makeText(mActivity, "=====setOrderId====="+orderId , Toast.LENGTH_LONG).show();
            BGGLog.getInstance().d("=====setOrderId====="+orderId);
            if(orderId ==null || orderId.trim().length() <= 0){
               // Toast.makeText(mActivity, "=====请求订单号失败，请重试=====" , Toast.LENGTH_LONG).show();
                showToastTips("请求订单号失败，请重试");
                return;
            }

            this.mOrderId = orderId;
            requestPayParams();
        }catch (Exception e){
            e.printStackTrace();
            //Toast.makeText(mActivity, "=====setOrderId====="+orderId , Toast.LENGTH_LONG).show();
        }

//        BGGLog.getInstance().d("### setOrder:" + orderId);
//        this.mCurrentProductId = orderId;
//        requestPayParams(mCurrentPayInfo);  //产品订单编号从服务器GC生成
    }
    private void requestPayParams()
    {
        cjPay(mCurrentPayInfo);
    }
    private void cjPay(final JSONObject jsonObject){
        if( jsonObject == null) return;
        BGGLog.getInstance().d("Pay params1=" + jsonObject.toString());
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                requestPayParams(jsonObject);
            }
        });

    }

    //获取渠道类型
    public int getChannelType(){
        return mChannelId;
    }

    public void stopWaiting() {
        if (mActivity == null) return;
    }

    public void showToastTips(final String tips) {
        if (mActivity == null) return;

        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if( mContext != null && tips != null){
                    //Toast.makeText((Activity) mContext, tips, Toast.LENGTH_SHORT).show();
                    BGGLog.getInstance().d("mContext != null && tips != null==== + tips");
                }
                else
                {
                    if( mContext == null )
                        BGGLog.getInstance().d("showToastTips mContext==null");
                    if( tips == null )
                        BGGLog.getInstance().d("showToastTips tips==null");
                }
            }
        });
    }
    public void startWaiting(final String msg, final boolean bIsPay) {
        if (mActivity == null) return;

        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Log.d(LOG_TAG, "startWaiting");

            }
        });
    }

    //获取实名信息
    public void getRealNameInfo() {
        mUnderAge=0;
        UnityPlayer.UnitySendMessage("GameManagerObject", "onRequestRealNameInfo", mUnderAge + "");
    }


    //手动登录
    public void ysdkStartLogin(final int platformId) {

    }
    public String getCurrChannel()
    {
        return mChannelId + "";
    }

    public void getEventData(String jsonData)
    {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonData);

            if (!jsonObject.has("dataType")) {
                return;
            }
            String severId = "";
            if (jsonObject.has("serverID"))
                severId = jsonObject.getString("serverID");

            String severName = "";
            if (jsonObject.has("serverName"))
                severName = jsonObject.getString("serverName");

            String roleId = "";
            if (jsonObject.has("roleID"))
                roleId = jsonObject.getString("roleID");

            String roleName = "";
            if (jsonObject.has("roleName"))
                roleName = jsonObject.getString("roleName");

            String roleLevel = "";
            if (jsonObject.has("roleLevel"))
                roleLevel = jsonObject.getString("roleLevel");

            String roleCTime = "";
            if (jsonObject.has("roleCreateTime"))
            {
                roleCTime = jsonObject.getString("roleCreateTime");
            }
            String Vip = "";
            if (jsonObject.has("vipLevel"))
                Vip = jsonObject.getString("vipLevel");
            else {
                Vip = "0";
            }
            String balance = "";
            if (jsonObject.has("leftYuanBao"))
                balance = jsonObject.getString("leftYuanBao");
            String partyName = "";
            if (jsonObject.has("partyName")) {
                partyName = jsonObject.getString("partyName");
            }
            String sex = "";
            if (jsonObject.has("sex")) {
                sex = jsonObject.getString("sex");
            }
            if("" != severId) {
                roleInfo.setServerId(severId);  //服务器ID（数字字符串）
            }
            if("" != severName) {
                roleInfo.setServerName(severName); //服务器名称
            }
            if("" != roleName) {
                roleInfo.setRoleName(roleName); //角色名称
            }
            if("" != roleId) {
                roleInfo.setRoleId(roleId); //角色ID
            }
            if(""!= balance) {
                roleInfo.setBalance(balance); //角色用户余额
            }
            if("" != Vip) {
                roleInfo.setVipLevel(Vip); //VIP等级
            }
            roleInfo.setRoleLevel(roleLevel); //角色用户等级
            if("" != roleCTime) {
                roleInfo.setCreateTime(roleCTime); //角色创建时间 （10位数的unix timestamp时间戳）
            }
            if("" != Vip) {
                roleInfo.setVipLevel(Vip);
            }
            if("" != partyName) {
                roleInfo.setPartyName(partyName);
            }
            if("" != sex)
            {
                if(sex == "1")
                {
                    roleInfo.setGender(BRSdkRole.Gender.female);
                }
                else
                {
                    roleInfo.setGender(BRSdkRole.Gender.male);
                }
            }
//            roleInfo.setPartyId("partyId"); //帮派ID
//            roleInfo.setRolePower("rolePower"); //战力
//            roleInfo.setProfession("0"); //角色职业名称
//            roleInfo.setReincarnation("0"); //好友关系列表
            BRSdkApi.getInstance().onUpRole(roleInfo);
            mRoleInfo = roleInfo;

        } catch (JSONException e) {
            e.printStackTrace();
            BGGLog.getInstance().d(jsonData+"   " + e.getMessage());
        }
    }




    /// 访问资源服务器请求
    public void resourceServerVisit(String url, String resourceId)
    {
        BGGLog.getInstance().d("resourceServerVisit");
    }

    /// 版本号检查
    public void appVersionCheck(String version)
    {
        BGGLog.getInstance().d("appVersionCheck");
    }

    /// 资源加载
    public void resourceLoading(String resourceId)
    {
        BGGLog.getInstance().d("resourceLoading");
    }

    /// 资源升级开始
    public void resourceUpdateStart(String resourceId)
    {
        BGGLog.getInstance().d("resourceUpdateStart");
    }

    /// 资源升级结果
    public  void resourceUpdate(String resourceId, String result)
    {
        BGGLog.getInstance().d("resourceUpdateStart");
    }

    /// 服务列表拉取结果
    public void gameServerListed(String daquId, String qufuId, String result)
    {
        BGGLog.getInstance().d("gameServerListed");
    }

    /// 服务器登录
    public void gameServerLoggedin(String result)
    {
        BGGLog.getInstance().d("gameServerLoggedin");
    }

    /// 角色登录请求
    public void roleLoginRequested(String roleID, String serverID)
    {
        BGGLog.getInstance().d("RoleLoginRequested");
    }

    /// 角色加入公会
    public void joinUnion()
    {
        BGGLog.getInstance().d("joinUnion");
    }

    /// 任务完成节点
    public void gameTaskMoveEvent(String desc)
    {
        BGGLog.getInstance().d("gameTaskMoveEvent:" + desc);
    }

    public void getBindCheck(){
        BGGLog.getInstance().d("getBindCheck");
    }

    public void getPhoneAreaCode(){
        BGGLog.getInstance().d("getPhoneAreaCode");
    }
    public void getBindPhoneAccount( String areaCode, String phone, String smsCode){
        BGGLog.getInstance().d("getBindPhoneAccount");}

    public void getVerifyCodeCheck(String areaCode, String phone){
        BGGLog.getInstance().d("getVerifyCodeCheck");}
    public void ShowQuestion(){
        BGGLog.getInstance().d("ShowQuestion");
    }

    public void InitProduct(){
        BGGLog.getInstance().d("InitProduct");
    }
    public void setFiveStarDialogListener(String roleId, String serverId){
        BGGLog.getInstance().d("SetFiveStarDialogListener");
    }
    public void RequestRealNameInfo(){
        BGGLog.getInstance().d("RequestRealNameInfo");
    }
    public void closeHudTips(){
        BGGLog.getInstance().d("closeHudTips");
    }

    //启动oppo社区中心
    public void launchOppoForum()
    {
    }

    //启动vivo社区中心
    public void launchVivoForum()
    {
    }
    public boolean isFromOppoGameCenter()
    {
        return UnityPlayerActivity.mIsFromGameCenter;
    }
    public void requestOppoVipInfo()
    {
    }
    public void performFeature(final String type)
    {
    }
    public void onFirstPurchase()
    {
        BGGLog.getInstance().d("onFirstPurchase");
    }
    public void onBeginPlay() {
    }

    public void onChargeCallBack(String orderId, String iapId, int currencyAmount, String currencyType, double virtualCurrencyAmout, String paymentType, int state) {
    }

    public void onSelectRole(String roleName) {
    }
}
