package com.bingougame.sdk;

import static android.os.Process.killProcess;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.util.Log;

import com.bingougame.tgsw.ChannelConst;
import com.bingougame.tgsw.UnityPlayerActivity;
import com.loopj.android.http.AsyncHttpClient;
import com.thee.operate.api.TheeDataListener;
import com.thee.operate.api.TheeListener;
import com.thee.operate.api.TheeOperate;
import com.thee.operate.api.TheeOptions;
import com.thee.operate.api.TheeOrder;
import com.thee.operate.api.TheeRoleInfo;
import com.thee.operate.api.TheeUser;
import com.thee.operate.api.TheeUserListener;
import com.unity3d.player.UnityPlayer;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;

import static com.unity3d.player.UnityPlayer.UnitySendMessage;

//import com.chujian.sdk.PayParams;
//import com.qk.game.MainActivity;


public class Channel3387 extends ChannelInstance {
    private AsyncHttpClient mHttpClient;
    public static final String LOG_TAG = "tgsw";
    public static final String LOCAL_ACTION = "com.bingougame.tgsw";
    private WaitingDialog mWaitingDialog;

    private Activity mActivity;
    private static Channel3387 mInstance;
    private String mCurrentRoleId = null;
    private String mCurrentServerId = null;

    private String mUserName = null;//用户名
    private String mUserId = null;//用户ID
    private String mOrderId = null;
    private JSONObject mCurrentPayInfo = null;
    private String mCurrentProductId = null;   //游戏订单号
    private boolean isAcceptPrva = false;
    private int mUnderAge = 0;
    private boolean IsInitSucc=false;
    private boolean mIsSwitchAccount=false;
    private String mChannelId=null;
    private String mToken=null;
    private String mRoleCreateTime = null;

    public static final String mProductCode = "85925103228334879295963797584312";
    private String mProductKey = "91542675";

    public static Channel3387 getInstance(){
        return mInstance;
    }

    @Override
    public void init(Context context){
        super.init(context);
        QKDot.Instance().RecordDot("SDKInit");

        mActivity = (Activity)context;
        mInstance = this;
        // 设置横竖屏，游戏横屏为true，游戏竖屏为false(必接)
        // QuickSDK.getInstance().setIsLandScape(isLandscape);
        BGGLog.getInstance().d("CWChannel init #1");

       // requestPermission();
        initQkNotifiers();

        BGGLog.getInstance().d("CWChannel init #2");
        this.initSDK();
    }
    private void initSDK() {
        String gameId = "10343";
        TheeOptions options = new TheeOptions.Builder(mActivity)
                .setGameId(gameId)
                .build();

        TheeOperate.init(mActivity, options, new TheeListener() {
            @Override
            public void onResult(boolean success, int code, String message) {
                if (!success) {
                    BGGLog.getInstance().d(code + "  " + message);
                }
                IsInitSucc = success;
            }
        });

        // 设置账号全局回调，一般初始化后即可设置
        TheeOperate.setUserListener(new TheeUserListener() {
            // 帐号的回调，游戏一般应在此回到登录场景
            @Override
            public void onLogout() {
                // 登出，游戏应回到自己的登录或者选服页面
                mUserId = "";
                mToken = "";
            }
            // 切换帐号回调，游戏一般应在此回到选服或登录场景
            @Override
            public void onSwitch(TheeUser newUser) {
                // 切换账号，游戏应回到自己的登录或者选服页面
                mUserId = newUser.getAccount();
                mToken = newUser.getToken();
                mIsSwitchAccount = true;
            }
        });
    }

    //手动登出
    public void logout() {
        BGGLog.getInstance().d("onRoleLogout #2");
        TheeOperate.logout();
    }
    public void RecordDot(String eventCode)
    {
        QKDot.Instance().RecordDot(eventCode);
    }
    public  void SwitchAccount()
    {
        TheeOperate.changeUser(mActivity, new TheeDataListener<TheeUser>() {
            @Override
            public void onResult(boolean success, int code, String message, TheeUser theeUser) {
                if (success) {
                    // 切换成功，旧账号被覆盖
                    mUserId = theeUser.getAccount();
                    mToken = theeUser.getToken();
                } else {
                    // 切换失败，保持旧账号
                }
                mIsSwitchAccount = success;
            }
        });
    }
    public String login() {
        //Toast.makeText(mActivity, "============login=======" , Toast.LENGTH_LONG).show();
        BGGLog.getInstance().d("login");
        if(!IsInitSucc){
            BGGLog.getInstance().d("初始化失败");
            showToastTips("初始化失败");
            return null;
        }
        //切换账号成功后不需要调用登陆接口   直接返回登录成功
        if(TheeOperate.isLogin()){
            HashMap<String,String> Map = new HashMap<String,String>();
            Map.put("userId", TheeOperate.getUser().getAccount());
            Map.put("userName", mUserName);
            Map.put("token", TheeOperate.getUser().getToken());
            Map.put("channelCode", ""+this.getChannelType());
            BGGLog.getInstance().d("切换账号成功后 登陆成功");
            String SendStr = JsonParser.simpleMapToJsonStr(Map);
            UnityPlayer.UnitySendMessage("GameManagerObject", "SDKLoginSuccess", SendStr);

            return null;
        }
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                TheeOperate.login(mActivity, new TheeDataListener<TheeUser>() {
                    @Override
                    public void onResult(boolean success, int code, String message, TheeUser user) {
                        HashMap<String,String> Map = new HashMap<String,String>();
                        Map.put("userId", user.getAccount());
                        Map.put("userName", mUserName);
                        Map.put("token", user.getToken());
                        Map.put("channelCode", ""+ getChannelType());
                        BGGLog.getInstance().d("切换账号成功后 登陆成功");
                        String SendStr = JsonParser.simpleMapToJsonStr(Map);
                        UnityPlayer.UnitySendMessage("GameManagerObject", "SDKLoginSuccess", SendStr);
                    }
                });
            }
        });
        return null;
    }

    public void showUserCenter()
    {
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                BGGLog.getInstance().d("showUserCenter #1");
                //TODO 个人中心参数配置

            }
        });
    }
    public void onSaved(String uId, String userName, String roleId, String roleName, int level, int gender, int age, String gameServer) {
    }
    /**
     * 设置通知，用于监听初始化，登录，注销，支付及退出功能的返回值
     */
    private void initQkNotifiers() {
        BGGLog.getInstance().d("InitSdk #1");
        BGGLog.getInstance().d("InitSdk #5");
    }

    public void exitGame(){
//           UnityPlayer.UnitySendMessage("GameManagerObject", "ShowExitGameMsgBox", "");
        TheeOperate.shouldQuitGame(mActivity, new TheeOperate.OnQuitGameListener() {
            @Override
            public void onQuitGame(boolean shouldQuit) {
                if (shouldQuit) { // 确定退出
                    TheeOperate.destroy(mActivity);

                    // 游戏应再次调用自己的退出方法
                    mActivity.finish();
                    killProcess(android.os.Process.myPid());
                }
            }
        });
    }
    public void vipLevelChange(String vipStr)
    {

    }
    public void submitExtraData(String jsonData) {
        JSONObject jsonObject = null;
        try {
//            BGGLog.getInstance().d("submitExtraData=" + jsonData);
            jsonObject = new JSONObject(jsonData);
            //Toast.makeText(mContext, "jsonData=" + jsonData, Toast.LENGTH_LONG).show();

            if (!jsonObject.has("dataType")) {
                //只处理DT_LoadOver、DT_SaveUserData、createRole、levelUp
                //场景 分别为进入服务器(enterServer)、玩家创建用户角色(createRole)、玩家升级(levelUp)
                return;
            }
            int dataType = (int) jsonObject.getInt("dataType");
//            BGGLog.getInstance().d("dataType====" + dataType + "======jsonData=======" + jsonData);
            //如果不是"角色创建/角色升级",则不处理
//            if( !(dataType == DT_CreateRole || dataType == DT_LevelUp || dataType ==DT_EnterGame) ){
//                return;
//            }

            String roleId = "";
            if (jsonObject.has("roleID"))
                roleId = jsonObject.getString("roleID");

            String roleName = "";
            if (jsonObject.has("roleName"))
                roleName = jsonObject.getString("roleName");

            String roleLevel = "";
            if (jsonObject.has("roleLevel"))
                roleLevel = jsonObject.getString("roleLevel");

            String severId = "";
            if (jsonObject.has("serverID"))
                severId = jsonObject.getString("serverID");

            String severName = "";
            if (jsonObject.has("serverName"))
                severName = jsonObject.getString("serverName");

            String balance = "";
            if (jsonObject.has("leftYuanBao"))
                balance = jsonObject.getString("leftYuanBao");

            String Vip = "";
            if (jsonObject.has("vipLevel"))
                Vip = jsonObject.getString("vipLevel");
            else{
//                BGGLog.getInstance().d("Vip=====null====");
                Vip = "0";
            }

            String partyName = "";
            if (jsonObject.has("partyName"))
                partyName = jsonObject.getString("partyName");

            String roleCTime = "";
            if (jsonObject.has("roleCreateTime"))
            {
                roleCTime = jsonObject.getString("roleCreateTime");

                mRoleCreateTime =roleCTime;
            }
//            BGGLog.getInstance().d(dataType+"==================submitExtraData================" + roleInfo.getGameRoleID()+"=====" + roleInfo.getGameRoleName() + "=========="+severId +"======="+roleInfo.getServerID()+"======"+roleInfo.getVipLevel()+"========"+roleCTime+"===="+roleInfo.getRoleCreateTime());
            TheeRoleInfo ri = new TheeRoleInfo();
            ri.setRoleId(roleId);
            ri.setRoleName(roleName);
            ri.setServerName(severId);
            TheeOperate.sendRoleInfo(ri);
            switch (dataType)
            {
                case ChannelConst.DT_LoadOver:
                {

                }
                break;
                case ChannelConst.DT_CreateRole:
                {
//                    BGGLog.getInstance().d("onRoleCreated");
                }
                break;
                case ChannelConst.DT_EnterGame:
                {
                    //角色登录，此时已经进入了场景
//                    BGGLog.getInstance().d("RoleLoggedinEvent");
                }
                break;
                case ChannelConst.DT_LevelUp:
//                    BGGLog.getInstance().d("GameLevelChangedEvent nowLevel=" + roleLevel);
                break;
            }


        } catch (JSONException e) {
            e.printStackTrace();
            BGGLog.getInstance().d(jsonData+"   " + e.getMessage());
        }
    }



    /**
     * 支付
     */
    public String pay(String orderData) {
        try {
            //Toast.makeText(mActivity, "=====pay==orderData==="+orderData , Toast.LENGTH_LONG).show();
            JSONObject jsonObject = new JSONObject(orderData);
            mCurrentPayInfo = jsonObject;
            mCurrentProductId = jsonObject.getString("productId");
            requestOrderId();;
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    private  void requestPayParams(JSONObject jsonObject){
        if(jsonObject ==null){
            //Toast.makeText(mActivity, "jsonObject ==null" , Toast.LENGTH_LONG).show();
            return;
        }
        try {
           // Toast.makeText(mActivity, "========jrequestPayParams==========="+jsonObject , Toast.LENGTH_LONG).show();
//            BGGLog.getInstance().d("== pay=="+jsonObject);
            mCurrentProductId = jsonObject.getString("productId");
            String productName = jsonObject.getString("productName");
            int productCount = jsonObject.getInt("productCount");
            int price = jsonObject.getInt("price");
            String prodectDes = jsonObject.getString("productDesc");
            int leftCoinCount = jsonObject.getInt("leftCoinCount");
            String roleId = jsonObject.getString("roleId");
            int roleLevel = jsonObject.getInt("roleLevel");
            String roleName = jsonObject.getString("roleName");
            String serverId = jsonObject.getString("serverId");
            String serverName = jsonObject.getString("serverName");
            String vipLevel = jsonObject.getString("vipLevel");
            String platformProductId = jsonObject.getString("platformProductId");
            String vouchNum = jsonObject.getString("vouchNum");
            //String createRoleTime = jsonObject.getString("createRoleTime");
            //String balance=jsonObject.getString("leftYuanBao");
            //String exteraParams  //透传参数，服务器发送异常异步通知时原样传回
            // serverID/roleId
            // 充值
            TheeOperate.recharge(mActivity,
                    // 充值金额，浮点数，最多支持2位小数，单位元
                    // mark, 游戏订单，字符串，支持字母、数字和字符‘-’，‘_’，‘|’，最长32位，非空、唯一
                    // 商品名称，必须，最长 32 个中文字符长度
                    new TheeOrder(price, mOrderId, productName),
                    new TheeListener() {
                        @Override
                        public void onResult(boolean success, int code, String message) {
                            BGGLog.getInstance().d(success + " " + code + " "+message);
                        }
                    });

        } catch (Exception e) {
            e.printStackTrace();
            BGGLog.getInstance().d("productPay Excelption:" + e.getStackTrace());
        }
    }

    //请求订单号
    public void requestOrderId(){
        //向unity游戏发送订单号请求
        BGGLog.getInstance().d("requestOrderId");
        HashMap<String,String> Map = new HashMap<String,String >();
        Map.put("productId", mCurrentProductId);

        String SendStr = JsonParser.simpleMapToJsonStr(Map);
        UnitySendMessage("GameManagerObject", "OnRequestOrderId", SendStr);
    }
    //设置订单号
    public void setOrderId(String orderId) {

        try {
            //Toast.makeText(mActivity, "=====setOrderId====="+orderId , Toast.LENGTH_LONG).show();
            BGGLog.getInstance().d("=====setOrderId====="+orderId);
            if(orderId ==null || orderId.trim().length() <= 0){
               // Toast.makeText(mActivity, "=====请求订单号失败，请重试=====" , Toast.LENGTH_LONG).show();
                showToastTips("请求订单号失败，请重试");
                return;
            }

            this.mOrderId = orderId;
            requestPayParams();
        }catch (Exception e){
            e.printStackTrace();
            //Toast.makeText(mActivity, "=====setOrderId====="+orderId , Toast.LENGTH_LONG).show();
        }

//        BGGLog.getInstance().d("### setOrder:" + orderId);
//        this.mCurrentProductId = orderId;
//        requestPayParams(mCurrentPayInfo);  //产品订单编号从服务器GC生成
    }
    private void requestPayParams()
    {
        cjPay(mCurrentPayInfo);
    }
    private void cjPay(final JSONObject jsonObject){
        if( jsonObject == null) return;
        BGGLog.getInstance().d("Pay params1=" + jsonObject.toString());
        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                requestPayParams(jsonObject);
            }
        });

    }

    //获取渠道类型
    public int getChannelType(){
        return 1000;
    }

    public void stopWaiting() {
        if (mActivity == null) return;
    }

    public void showToastTips(final String tips) {
        if (mActivity == null) return;

        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if( mContext != null && tips != null){
                    //Toast.makeText((Activity) mContext, tips, Toast.LENGTH_SHORT).show();
                    BGGLog.getInstance().d("mContext != null && tips != null==== + tips");
                }
                else
                {
                    if( mContext == null )
                        BGGLog.getInstance().d("showToastTips mContext==null");
                    if( tips == null )
                        BGGLog.getInstance().d("showToastTips tips==null");
                }
            }
        });
    }
    public void startWaiting(final String msg, final boolean bIsPay) {
        if (mActivity == null) return;

        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Log.d(LOG_TAG, "startWaiting");

            }
        });
    }

    //获取实名信息
    public void getRealNameInfo() {
        BGGLog.getInstance().d("getRealNameInfo start");
        startWaiting("正在请求实名信息...", false);


        mActivity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                UnityPlayer.UnitySendMessage("GameManagerObject", "onRequestRealNameInfo", mUnderAge + "");
            }
        });
    }


    //手动登录
    public void ysdkStartLogin(final int platformId) {

    }
    public String getCurrChannel()
    {
        return "3387";
    }

    public void getEventData(String jsonData)
    {
        try {
//            BGGLog.getInstance().d("getEventData=" + jsonData);
//            BGGLog.getInstance().d("getEventData=" + jsonData);
            JSONObject jsonObject = new JSONObject(jsonData);
            if( !jsonObject.has("event_type"))
            {
                return;
            }

            String dataType = jsonObject.getString("event_type");

            //打Log方法
            //若該事件無數值需要傳遞，只需傳入事件名稱即可：
            //logger.logEvent(NPEventConstants.EVENT_NAME_GAME_QUIT);
            //若事件有數值需要傳遞，將數值加入Bundle：
            //Bundle parameters = new Bundle();
            //parameters.putString(NPEventConstants.EVENT_PARAM_ROLE_CREATE_TYPE, "0");
            //logger.logEvent(NPEventConstants.EVENT_NAME_ROLE_CREATE, parameters);


            String SERVER_ID = "";
            String ROLE_ID = "";
            String ROLE_CREATE_TYPE = "";
            String MISSION_TYPE = "";
            String MISSION_STATUS = "";
            String MISSION_ID = "";
            String LEVEL_TYPE = "";
            String LEVEL_AMOUNT = "";
            String CHANNEL_TYPE = "";
            String CHANNEL_AMOUNT = "";
            String CURRENCY = "";
            String USER_LEVEL = "";
            double valueToSum = 0;
            String PURCHASE_COIN_TYPE = "";
            String PURCHASE_AMOUNT = "";
            String PURCHASE_ITEM_ID = "";
            String ITEM_AMOUNT = "";
            String SOURCE = "";
            String USE_ITEM_ID = "";
            String USE_ITEM_AMOUNT = "";
            String UID = "";
            String DAILY_CHECK_AMOUNT = "";
            String SKILL_ID = "";
            String SKIILL_LEVEL = "";
            String TEAM_ID = "";
            String ACTIVITY_ID = "";
            String USER_CP = "";
            String USER_VIPLEVEL = "";
            String USER_CASH_POINT = "";
            String USER_GAME_POINT = "";
            String GIFT_ITEM_ID = "";
            String STAGE_ID = "";
            String STAGE_STATUS = "";
            String PASS_NUM = "";
            String BUTTON_ID = "";
            String BUTTON_NAME = "";
            String BUTTON_CLASS = "";
            String ACTIVITY_NAME = "";
            String ACTIVITY_CLASS = "";
        }
        catch (JSONException e)
        {
            // TODO Auto-generated catch block
            e.printStackTrace();
            BGGLog.getInstance().d(e.getMessage());
        }
    }




    /// 访问资源服务器请求
    public void resourceServerVisit(String url, String resourceId)
    {
        BGGLog.getInstance().d("resourceServerVisit");
    }

    /// 版本号检查
    public void appVersionCheck(String version)
    {
        BGGLog.getInstance().d("appVersionCheck");
    }

    /// 资源加载
    public void resourceLoading(String resourceId)
    {
        BGGLog.getInstance().d("resourceLoading");
    }

    /// 资源升级开始
    public void resourceUpdateStart(String resourceId)
    {
        BGGLog.getInstance().d("resourceUpdateStart");
    }

    /// 资源升级结果
    public  void resourceUpdate(String resourceId, String result)
    {
        BGGLog.getInstance().d("resourceUpdateStart");
    }

    /// 服务列表拉取结果
    public void gameServerListed(String daquId, String qufuId, String result)
    {
        BGGLog.getInstance().d("gameServerListed");
    }

    /// 服务器登录
    public void gameServerLoggedin(String result)
    {
        BGGLog.getInstance().d("gameServerLoggedin");
    }

    /// 角色登录请求
    public void roleLoginRequested(String roleID, String serverID)
    {
        BGGLog.getInstance().d("RoleLoginRequested");
    }

    /// 角色加入公会
    public void joinUnion()
    {
        BGGLog.getInstance().d("joinUnion");
    }

    /// 任务完成节点
    public void gameTaskMoveEvent(String desc)
    {
        BGGLog.getInstance().d("gameTaskMoveEvent:" + desc);
    }

    public void getBindCheck(){
        BGGLog.getInstance().d("getBindCheck");
    }

    public void getPhoneAreaCode(){
        BGGLog.getInstance().d("getPhoneAreaCode");
    }
    public void getBindPhoneAccount( String areaCode, String phone, String smsCode){
        BGGLog.getInstance().d("getBindPhoneAccount");}

    public void getVerifyCodeCheck(String areaCode, String phone){
        BGGLog.getInstance().d("getVerifyCodeCheck");}
    public void ShowQuestion(){
        BGGLog.getInstance().d("ShowQuestion");
    }

    public void InitProduct(){
        BGGLog.getInstance().d("InitProduct");
    }
    public void setFiveStarDialogListener(String roleId, String serverId){
        BGGLog.getInstance().d("SetFiveStarDialogListener");
    }
    public void RequestRealNameInfo(){
        BGGLog.getInstance().d("RequestRealNameInfo");
    }
    public void closeHudTips(){
        BGGLog.getInstance().d("closeHudTips");
    }

    //启动oppo社区中心
    public void launchOppoForum()
    {
    }

    //启动vivo社区中心
    public void launchVivoForum()
    {
    }
    public boolean isFromOppoGameCenter()
    {
        return UnityPlayerActivity.mIsFromGameCenter;
    }
    public void requestOppoVipInfo()
    {
    }
    public void performFeature(final String type)
    {
    }
    public void onFirstPurchase()
    {
        BGGLog.getInstance().d("onFirstPurchase");
    }
    public void onBeginPlay() {
    }

    public void onChargeCallBack(String orderId, String iapId, int currencyAmount, String currencyType, double virtualCurrencyAmout, String paymentType, int state) {
    }

    public void onSelectRole(String roleName) {
    }

    @Override
    public void onWindowFocusChanged() {
        super.onWindowFocusChanged();
    }


//    @Override
//    public void onCreate(Bundle savedInstanceState)
//    {
//        super.onCreate(savedInstanceState);   //todo
//    }

    @Override
    public void onStart() {
        super.onStart();
    }
    @Override
    public void onRestart() {
        super.onRestart();
    }
    @Override
    public void onPause() {
        super.onPause();
    }
    @Override
    public void onResume() {
        super.onResume();
    }
    @Override
    public void onStop() {
        super.onStop();
    }

    @Override
    public void onDestroyBeforeGame() {
        super.onDestroyBeforeGame();
    }

    @Override
    public void onDestroyAfterGame() {
        Log.d(LOG_TAG, "onDestroy");

        super.onDestroyAfterGame();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    @Override
    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
    }
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }
    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public void onFinishLoaded(long duration)//加载时长
    {
    }
}
