package com.bingougame.sdk;

import static android.content.Context.MODE_PRIVATE;

import android.content.Context;
import android.content.SharedPreferences;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;

public class QKDot{
    class  DotInfo
    {
        public String productCode;
        public String deviceId;
        public String channelCode;
        public String quickDotURL;
        public String dotUrl;
        public String eventCode;
        public DotInfo(String productCode, String deviceId, String channelCode, String quickDotURL, String dotUrl, String eventCode) {
            this.productCode = productCode;
            this.deviceId = deviceId;
            this.channelCode = channelCode;
            this.quickDotURL = quickDotURL;
            this.dotUrl = dotUrl;
            this.eventCode = eventCode;
        }
    }
    class DotThread implements Runnable
    {
        @Override
        public void run() {
            while (!mQueue.isEmpty()) {
                try {
                    DotInfo curDot =  mQueue.poll();
                    Map<String, String> map = new HashMap<>();
                    map.put("product_code", curDot.productCode);
                    map.put("device_id", curDot.deviceId);
                    map.put("channel_code", curDot.channelCode);
                    map.put("eventCode", curDot.eventCode);
                    boolean result = submitDataByDoPost(map, curDot.quickDotURL);
                    BGGLog.getInstance().d(String.format("### QKDot upload  result:%s eventCode:%s", result,curDot.eventCode));
                    Thread.sleep(1000);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
    private static QKDot _Instance;
    public static QKDot Instance()
    {
        if(null == _Instance)
        {
            _Instance = new QKDot();
        }
        return _Instance;
    }
    private  String productCode;
    private  String deviceId;
    private  String channelCode;
    private String quickDotURL = "http://sdkreport.quicksdk.net/msg/p";
    private Queue<DotInfo> mQueue = new LinkedList<DotInfo>();
    Thread t;
    public void Init(String productCode, String deviceId, String channelCode) {
//        this.productCode = productCode;
//        this.deviceId = deviceId;
//        this.channelCode = channelCode;
//        BGGLog.getInstance().d(String.format("### QKDot init  deviceId:%s channelCode:%s", this.deviceId, this.channelCode));
//        this.RecordDot("AppOnCreate");
    }
    /*
    * 打点接口
    * */
    public void RecordDot(String eventCode) {
//        mQueue.add(new DotInfo(productCode, deviceId, channelCode, quickDotURL,quickDotURL,eventCode));
//        if(null == t || !t.isAlive()) {
//            Thread t = new Thread(new DotThread());
//            t.start();
//        }
    }
    /*
    * 向Web服务器提交打点数据
    * */
    private Boolean submitDataByDoPost(Map<String, String> map, String path) throws Exception {
        // 注意Post地址中是不带参数的，所以newURL的时候要注意不能加上后面的参数
        URL Url = new URL(path);
        // Post方式提交的时候参数和URL是分开提交的，参数形式是这样子的：name=y&age=6
        StringBuilder sb = new StringBuilder();
        // sb.append("?");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            sb.append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        String str = sb.toString();

        HttpURLConnection HttpConn = (HttpURLConnection) Url.openConnection();
        HttpConn.setRequestMethod("POST");
        HttpConn.setReadTimeout(5000);
        HttpConn.setDoOutput(true);
        HttpConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        HttpConn.setRequestProperty("Content-Length", String.valueOf(str.getBytes().length));
        OutputStream os = HttpConn.getOutputStream();
        os.write(str.getBytes());
        if (HttpConn.getResponseCode() == HttpURLConnection.HTTP_OK) {
            return true;
        }
        return false;
    }
    /*
    * 返回unix时间戳 (1970年至今的Tick)
    * */
    public static long getUnixStamp(){
        return System.currentTimeMillis();
    }
    /*
    * 根据字符串计算md5
    * */
    public String md5(String s) {
        try {
            final MessageDigest digest = MessageDigest.getInstance("md5");
            digest.update(s.getBytes());
            final byte[] bytes = digest.digest();
            final StringBuilder sb = new StringBuilder();
            for (int i = 0; i < bytes.length; i++) {
                sb.append(String.format("%02X", bytes[i]));
            }
            return sb.toString().toLowerCase();
        } catch (Exception exc) {
            return "ex_"+s;
        }
    }
/*
*  获取自定义生成的唯一标识符
* */
    public  String GetDeviceId(Context ctx)
    {
        String deviceId = getUnixStamp() + "";
        try {
            SharedPreferences preferences = ctx.getSharedPreferences("custom_id", MODE_PRIVATE);
            deviceId = preferences.getString("customDeviceId", "");
            if (deviceId.length() <= 0) {
                deviceId = md5(deviceId);
                SharedPreferences.Editor editor = preferences.edit();
                //存储数据时选用对应类型的方法
                editor.putString("customDeviceId", deviceId);
                //提交保存数据
                editor.commit();
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        return  deviceId;
    }
}
