package com.bingougame.sdk;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.Window;

import com.quicksdk.BaseCallBack;
import com.quicksdk.Sdk;

public class ApplyPrivAndPerm extends Activity {
    public static int mRequestCode = 100;//权限请求码
    private static Activity mActivity = null;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        super.onCreate(savedInstanceState);
        QKDot.Instance().RecordDot("ShowPrivacy");
        if (null != mActivity && !mActivity.equals(this)) {
            BGGLog.getInstance().d("Warning!Reduplicate game activity was detected.Activity will finish immediately.");
            this.finish();
            return;
        }
        mActivity = this;
        if(!PermmisionUtil.applyPermission(this)){
            BGGLog.getInstance().d( "granted=============");
            Intent intent = new Intent(ApplyPrivAndPerm.this, SdkSplashActivity.class);
            startActivity(intent);
            ApplyPrivAndPerm.this.finish();
            return;
        }

        Sdk.getInstance().showPrivace(this, new BaseCallBack() {
            @Override
            public void onSuccess(Object... objects) {
//                PermmisionUtil.ApplyPerm(ApplyPrivAndPerm.this);
                Intent intent = new Intent(ApplyPrivAndPerm.this, SdkSplashActivity.class);
                startActivity(intent);
                ApplyPrivAndPerm.this.finish();
            }

            @Override
            public void onFailed(Object... objects) {
                //Toast.makeText(mActivity, "拒绝隐私协议，退出游戏" , Toast.LENGTH_LONG).show();
                ApplyPrivAndPerm.this.finish();
                System.exit(0);
            }
        });
    }


    private void requestWindowPermission(){
        Intent intent = new Intent(Settings.ACTION_MANAGE_OVERLAY_PERMISSION);
        intent.setData(Uri.parse("package:"+getPackageName()));
        startActivityForResult(intent,mRequestCode);
    }

    @RequiresApi(api = Build.VERSION_CODES.M)
    @Override
    protected void onActivityResult(int requestCode,int resultCode,Intent data){
        super.onActivityResult(requestCode,resultCode,data);
        if(requestCode == mRequestCode){
            if(Settings.canDrawOverlays(this)){
                Log.e("p","onActivityResult granted：");
            }
        }
            }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if(requestCode == PermmisionUtil.mRequestCode){
            for (int i = 0; i < grantResults.length; i++) {
                if (grantResults[i] != PackageManager.PERMISSION_GRANTED) {
                    Log.e("p","拒绝的权限名称：" + permissions[i]);
                    Log.e("p","拒绝的权限结果：" + grantResults[i]);
                    Log.e("p","有权限未授权，可以弹框出来，让客户去手机设置界面授权。。。");
                }else {
                    Log.e("p","授权的权限名称：" + permissions[i]);
                    Log.e("p","授权的权限结果：" + grantResults[i]);
                }
            }
        }


        Intent intent = new Intent(ApplyPrivAndPerm.this, SdkSplashActivity.class);
        startActivity(intent);
        ApplyPrivAndPerm.this.finish();
    }
}
